/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.security.dsig;

import com.ibm.trl.util.Logger;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignatureException;
import com.ibm.xml.soap.security.util.CertificateUtil;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertSelector;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.w3c.dom.Element;

final class PKIXChecker {
    private final PKIXBuilderParameters template;

    PKIXChecker(KeyStore keyStore) throws SOAPException {
        try {
            X509CertSelector x509CertSelector = new X509CertSelector();
            this.template = new PKIXBuilderParameters(keyStore, (CertSelector)x509CertSelector);
            this.template.setDate(null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid KeyStore", invalidAlgorithmParameterException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid KeyStore", keyStoreException);
        }
    }

    PKIXChecker(Set set) throws SOAPException {
        try {
            Object object;
            Iterator iterator = set.iterator();
            HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>();
            while (iterator.hasNext()) {
                object = (X509Certificate)iterator.next();
                TrustAnchor trustAnchor = new TrustAnchor((X509Certificate)object, null);
                hashSet.add(trustAnchor);
            }
            object = new X509CertSelector();
            this.template = new PKIXBuilderParameters(hashSet, (CertSelector)object);
            this.template.setDate(null);
        }
        catch (ClassCastException classCastException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Unexpected class", classCastException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid algorithm parameter", invalidAlgorithmParameterException);
        }
    }

    Key check(Element element) throws SOAPException {
        Exception exception = null;
        try {
            PKIXBuilderParameters pKIXBuilderParameters = (PKIXBuilderParameters)this.template.clone();
            CertificateUtil.X509DataUtil[] x509DataUtilArray = CertificateUtil.getX509Data(element);
            Logger.normal("Calling CertificateUtil.verify()...", 0);
            for (int i = 0; i < x509DataUtilArray.length; ++i) {
                try {
                    return this.check(element, pKIXBuilderParameters, x509DataUtilArray[i]);
                }
                catch (XSignatureException xSignatureException) {
                    exception = xSignatureException.getException();
                    continue;
                }
                catch (IOException iOException) {
                    exception = iOException;
                }
            }
        }
        catch (XSignatureException xSignatureException) {
            exception = xSignatureException.getException();
        }
        Logger.normal("CertificateUtil.verify() Done.", 0);
        throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid certpath", exception);
    }

    Key check(Element element, PKIXBuilderParameters pKIXBuilderParameters, CertificateUtil.X509DataUtil x509DataUtil) throws XSignatureException, IOException {
        X509CertSelector x509CertSelector = x509DataUtil.createSelector();
        Date date = new Date();
        x509CertSelector.setCertificateValid(date);
        pKIXBuilderParameters.setDate(date);
        pKIXBuilderParameters.setTargetCertConstraints(x509CertSelector);
        return x509DataUtil.validate(pKIXBuilderParameters);
    }

    PKIXBuilderParameters getTemplate() {
        return this.template;
    }
}

