/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContext;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.NonceUtil;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.PropertyCallback;
import com.ibm.wsspi.wssecurity.auth.token.TokenId;
import com.ibm.wsspi.wssecurity.auth.token.UsernameToken;
import com.ibm.wsspi.wssecurity.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.token.TokenGeneratorComponent;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UsernameTokenGenerator
implements TokenGeneratorComponent {
    private static final TraceComponent tc = Tr.register((Class)UsernameTokenGenerator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = UsernameTokenGenerator.class.getName();
    private boolean _initialized = false;
    private static final WSSecurityPlatformContext _contextManager = WSSecurityPlatformContextFactory.getInstance();
    private static final String WSSECURITY_SEND_REALM = "com.ibm.wsspi.wssecurity.token.IDAssertion.sendRealm";

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Document document, Element element, Map map) throws SoapSecurityException {
        boolean bl;
        Object object;
        Iterator iterator;
        Object object2;
        QName qName;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Document doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)element) + "]," + "Map context)"));
        }
        TokenGeneratorConfig tokenGeneratorConfig = (TokenGeneratorConfig)map.remove("com.ibm.wsspi.wssecurity.config.tokenGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TokenGeneratorConfig [" + tokenGeneratorConfig + "]."));
        }
        if (!com.ibm.ws.webservices.wssecurity.Constants.UNTOKEN.equals(qName = tokenGeneratorConfig.getType())) {
            throw new SoapSecurityException("Unsupported value type: " + qName);
        }
        NonceManager nonceManager = (NonceManager)map.remove(NonceManager.class);
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
        int n = 0;
        Object object3 = null;
        object3 = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (object3 != null && object3 instanceof Integer) {
            n = (Integer)object3;
        }
        String string = com.ibm.ws.webservices.wssecurity.Constants.NAMESPACES[0][n];
        String string2 = com.ibm.ws.webservices.wssecurity.Constants.NAMESPACES[1][n];
        boolean bl2 = tokenGeneratorConfig.isStandAlone();
        CallbackHandlerConfig callbackHandlerConfig = tokenGeneratorConfig.getCallbackHandler();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CallbackHandlerConfig [" + tokenGeneratorConfig + "]."));
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (callbackHandlerConfig != null) {
            object3 = callbackHandlerConfig.getProperties().get(Constants.WSSECURITY_USE_IDASSERTION);
            if (object3 != null) {
                bl3 = ConfigUtil.isTrue((String)object3.toString());
            }
            if ((object3 = callbackHandlerConfig.getProperties().get(Constants.WSSECURITY_USE_RUNASIDENTITY)) != null) {
                bl4 = ConfigUtil.isTrue((String)object3.toString());
            }
            if ((object3 = callbackHandlerConfig.getProperties().get(WSSECURITY_SEND_REALM)) != null) {
                bl5 = ConfigUtil.isTrue((String)object3.toString());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("identityAssertion is [" + bl3 + "]."));
            Tr.debug((TraceComponent)tc, (String)("useRunAsSubject is [" + bl4 + "]."));
            Tr.debug((TraceComponent)tc, (String)("sendRealm is [" + bl5 + "]."));
        }
        String string3 = null;
        char[] cArray = null;
        if (bl4) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting the RunAs identity...");
            }
            string3 = TokenManager.getRunAsIdentity(bl5);
        }
        if (string3 == null && bl3) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Checking the identifier of initial sender...");
            }
            if (sOAPMessageContext != null && (object3 = sOAPMessageContext.getProperty("com.ibm.wsspi.wssecurity.username.initialSenderId")) != null && object3 instanceof UsernameToken) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The identifier of initial sender is used.");
                }
                object2 = (UsernameToken)object3;
                string3 = ((UsernameToken)object2).getUsername();
                iterator = object2;
                cArray = (char[])AccessController.doPrivileged(new PrivilegedAction((UsernameToken)((Object)iterator)){
                    private final /* synthetic */ UsernameToken val$tokenPriv;
                    {
                        this.val$tokenPriv = usernameToken;
                    }

                    public Object run() {
                        return this.val$tokenPriv.getPassword();
                    }
                });
            }
        }
        if (string3 == null && !bl3) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Checking the cached username token...");
            }
            if (sOAPMessageContext != null && !_contextManager.isServer() && (object3 = sOAPMessageContext.getProperty("com.ibm.wsspi.wssecurity.username.basicAuthToken")) != null && object3 instanceof UsernameToken) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The cached username token is used.");
                }
                object2 = (UsernameToken)object3;
                string3 = ((UsernameToken)object2).getUsername();
                iterator = object2;
                cArray = (char[])AccessController.doPrivileged(new PrivilegedAction((UsernameToken)((Object)iterator)){
                    private final /* synthetic */ UsernameToken val$tokenPriv;
                    {
                        this.val$tokenPriv = usernameToken;
                    }

                    public Object run() {
                        return this.val$tokenPriv.getPassword();
                    }
                });
            }
        }
        if (string3 == null && callbackHandlerConfig != null) {
            Serializable serializable;
            Object object4;
            Callback[] callbackArray;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invoking callback handler...");
            }
            object2 = new HashMap();
            iterator = callbackHandlerConfig.getClassName();
            object = callbackHandlerConfig.getInstance();
            if (object == null) {
                block49: {
                    try {
                        callbackArray = callbackHandlerConfig.getUserId();
                        char[] cArray2 = callbackHandlerConfig.getUserPassword();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Default username is [" + (String)callbackArray + "]."));
                            Tr.debug((TraceComponent)tc, (String)"password is [XXXXXXXX].");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Instantiating the callback handler [" + (String)((Object)iterator) + "]..."));
                        }
                        object4 = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return Thread.currentThread().getContextClassLoader();
                            }
                        });
                        serializable = null;
                        if (CallbackHandler.class.isAssignableFrom((Class<?>)(serializable = object4 != null ? ((ClassLoader)object4).loadClass((String)((Object)iterator)) : Class.forName((String)((Object)iterator))))) {
                            object2.put("com.ibm.wsspi.wssecurity.config.callbackHandler.configKey", callbackHandlerConfig);
                            Constructor<?> constructor = ((Class)serializable).getConstructor(String.class, [C.class, Map.class);
                            object = (CallbackHandler)constructor.newInstance(callbackArray, cArray2, object2);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Succeeded to Instantiate the callback handler [" + iterator + "]."));
                            }
                            break block49;
                        }
                        throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s17", iterator, CallbackHandler.class.getName());
                    }
                    catch (SoapSecurityException soapSecurityException) {
                        throw soapSecurityException;
                    }
                    catch (Exception exception) {
                        Tr.processException((Throwable)exception, (String)(clsName + ".invoke"), (String)"357");
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.X509TokenGenerator.s01", (Object)new Object[]{iterator, exception});
                        throw SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s01", (String)((Object)iterator), (Throwable)exception);
                    }
                }
                callbackHandlerConfig.setInstance((CallbackHandler)object);
            }
            object2 = new HashMap();
            if (sOAPMessageContext != null) {
                object2.put("com.ibm.wsspi.wssecurity.core.messageContext", sOAPMessageContext);
            }
            callbackArray = new Callback[]{new NameCallback(ConfigUtil.getMessage((String)"security.wssecurity.SenderLogin.token29")), new PasswordCallback(ConfigUtil.getMessage((String)"security.wssecurity.SenderLogin.token30"), false), new PropertyCallback((Map)object2)};
            try {
                object.handle(callbackArray);
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                Tr.processException((Throwable)unsupportedCallbackException, (String)(clsName + ".invoke"), (String)"393");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.X509TokenGenerator.s02", (Object)new Object[]{iterator, unsupportedCallbackException});
                object4 = SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s02", iterator, (Throwable)unsupportedCallbackException);
                ((Throwable)object4).initCause(unsupportedCallbackException);
                throw object4;
            }
            catch (IOException iOException) {
                object4 = iOException;
                if (iOException.getCause() != null) {
                    object4 = iOException.getCause();
                }
                Tr.processException((Throwable)iOException, (String)(clsName + ".invoke"), (String)"402");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.X509TokenGenerator.s02", (Object)new Object[]{iterator, object4});
                serializable = SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s02", iterator, (Throwable)object4);
                ((Throwable)serializable).initCause(iOException);
                throw serializable;
            }
            string3 = ((NameCallback)callbackArray[0]).getName();
            cArray = ((PasswordCallback)callbackArray[1]).getPassword();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Succeeded to invoke the callback handler [" + iterator + "]."));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Acquired username is [" + string3 + "]."));
            Tr.debug((TraceComponent)tc, (String)("Acuqired password is [" + (cArray == null ? "null" : "XXXXXXXX") + "]."));
        }
        if (string3 == null || string3.length() == 0) {
            throw SoapSecurityException.format("security.wssecurity.WSEC5199E");
        }
        map.remove(Constants.WSSECURITY_KEY_EMBID);
        map.remove(Constants.WSSECURITY_KEY_REFERENCE);
        map.remove(Constants.WSSECURITY_KEY_ID);
        map.remove(Constants.WSSECURITY_KEY_NAME);
        map.remove(Constants.WSSECURITY_KEY_ISSUERNAME);
        map.remove(Constants.WSSECURITY_KEY_ISSUERSERIAL);
        object2 = null;
        if (bl2 && sOAPMessageContext != null && (object3 = sOAPMessageContext.getProperty(Constants.WSSECURITY_TOKEN_PROPERGATION)) != null && object3 instanceof Set) {
            iterator = ((Set)object3).iterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                if (!(object3 instanceof TokenId)) continue;
                object = (TokenId)object3;
                if (!tokenGeneratorConfig.getType().equals(((TokenId)object).getType())) continue;
                if (object2 == null) {
                    object2 = ((TokenId)object).getId();
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("More than one TokenId objects are found. Since the runtime tentatively uses the first identifier + \"" + (String)object2 + "\"," + " it neglects the identifier \"" + ((TokenId)object).getId() + "\"."));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TokenIdentifier [" + (String)object2 + "]."));
        }
        if (!(bl = UsernameTokenGenerator.checkToken(map, tokenGeneratorConfig, string3, cArray))) {
            cArray = bl3 ? null : cArray;
            object = UsernameTokenGenerator.createTokenElement(document, element, string3, cArray, (String)object2, n, string, string2);
            boolean bl6 = false;
            boolean bl7 = false;
            object3 = tokenGeneratorConfig.getProperties().get(Constants.WSSECURITY_ADD_TIMESTAMP);
            if (object3 != null) {
                bl6 = ConfigUtil.isTrue((String)object3.toString());
            }
            if ((object3 = tokenGeneratorConfig.getProperties().get(Constants.WSSECURITY_ADD_NONCE)) != null) {
                bl7 = ConfigUtil.isTrue((String)object3.toString());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isTimestampRequired is [" + bl6 + "]."));
                Tr.debug((TraceComponent)tc, (String)("isNonceRequired [" + bl7 + "]."));
            }
            if (bl6) {
                NonceUtil.addCreated(document, (Element)object, string2);
            }
            if (bl7) {
                NonceUtil.createNonce(document, (Element)object, string, nonceManager, null);
            }
            object = (Element)element.insertBefore((Node)object, element.getFirstChild());
            UsernameTokenGenerator.setTokenToSubject(sOAPMessageContext, map, tokenGeneratorConfig, string3, cArray, (String)object2, (Element)object, bl3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Document doc,Element parent,Map context)");
        }
    }

    private static boolean checkToken(Map map, TokenGeneratorConfig tokenGeneratorConfig, String string, char[] cArray) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkToken(Map context,TokenGeneratorConfig config,String username[" + string + "]," + "char[] password[XXXXXXXX])"));
        }
        boolean bl = false;
        Set set = TokenManager.getTokens(map);
        if (set != null && set.size() > 0) {
            int n = string.hashCode();
            if (cArray != null) {
                n += new String(cArray).hashCode();
            }
            String string2 = String.valueOf(n);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                UsernameToken usernameToken;
                Object e = iterator.next();
                if (!(e instanceof UsernameToken) || !(usernameToken = (UsernameToken)e).getUsedTokenGenerator().equals(tokenGeneratorConfig) || !usernameToken.getUniqueID().equals(string2)) continue;
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkToken(Map context,TokenGeneratorConfig config,String username,char[] password[XXXXXXXX]) returns boolean[" + bl + "]"));
        }
        return bl;
    }

    private static Element createTokenElement(Document document, Element element, String string, char[] cArray, String string2, int n, String string3, String string4) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createTokenElement(Document doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)element) + "]," + "String username[" + string + "]," + "char[] password[" + (cArray == null ? "null" : "XXXXXXXX") + "]," + "String id[" + string2 + "]," + "int wssVersion[" + n + "]," + "String nsWsse[" + string3 + "]," + "String nsWsu[" + string4 + "])"));
        }
        boolean bl = false;
        String string5 = DOMUtil.getNamespacePrefix((Element)element, (String)string3);
        if (string5 == null) {
            bl = true;
            string5 = "wsse:";
        } else if (string5.length() > 0) {
            string5 = string5 + ":";
        }
        Element element2 = document.createElementNS(string3, string5 + "UsernameToken");
        if (bl) {
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", string3);
        }
        if (string2 != null) {
            bl = false;
            object = DOMUtil.getNamespacePrefix((Element)element, (String)string4);
            if (object == null) {
                bl = true;
                object = "wsu:";
            } else if (string5.length() > 0) {
                object = (String)object + ":";
            }
            if (bl) {
                element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", string4);
            }
            element2.setAttributeNS(com.ibm.ws.webservices.wssecurity.Constants.NS_WSU, (String)object + "Id", string2);
        }
        object = document.createElementNS(com.ibm.ws.webservices.wssecurity.Constants.NS_WSSE, string5 + "Username");
        object.appendChild(document.createTextNode(string));
        object = (Element)element2.appendChild((Node)object);
        if (cArray != null && cArray.length > 0) {
            Element element3 = document.createElementNS(com.ibm.ws.webservices.wssecurity.Constants.NS_WSSE, string5 + "Password");
            DOMUtil.setQNameAttr(element3, null, "Type", com.ibm.ws.webservices.wssecurity.Constants.PASSWORD_TEXT, n);
            element3.appendChild(document.createTextNode(new String(cArray)));
            element3 = (Element)element2.appendChild(element3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createTokenElement(Document doc,Element parent,String username,char[] password,String id,int wssVersion,String nsWsse,String nsWsu) returns Element[" + DOMUtil.getDisplayName((Node)element2) + "]"));
        }
        return element2;
    }

    private static void setTokenToSubject(SOAPMessageContext sOAPMessageContext, Map map, TokenGeneratorConfig tokenGeneratorConfig, String string, char[] cArray, String string2, Element element, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setTokenToSubject(SOAPMessageContext mcontext,Map context,TokenGeneratorConfig config,String username[" + string + "]," + "char[] password," + "String id[" + string2 + "]," + "Element elem[" + DOMUtil.getDisplayName((Node)element) + "]," + "boolean identityAssertion[" + bl + "])"));
        }
        UsernameToken usernameToken = new UsernameToken(string2, string, cArray);
        usernameToken.setElement(element);
        usernameToken.setReferenced(!tokenGeneratorConfig.isStandAlone());
        usernameToken.setUsedTokenGenerator(tokenGeneratorConfig);
        TokenManager.setToken(map, usernameToken);
        if (sOAPMessageContext != null && !bl) {
            sOAPMessageContext.setProperty("com.ibm.wsspi.wssecurity.username.basicAuthToken", (Object)usernameToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTokenToSubject(SOAPMessageContext mcontext,Map context,TokenGeneratorConfig config,String username,char[] password,String id,Element elem)boolean identityAssertion");
        }
    }
}

