/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.UsernameToken;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.wsspi.wssecurity.token.UsernameTokenConsumer;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IDAssertionUsernameTokenConsumer
implements TokenConsumerComponent {
    private static final TraceComponent tc = Tr.register((Class)IDAssertionUsernameTokenConsumer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = IDAssertionUsernameTokenConsumer.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Node node, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Node target[" + DOMUtil.getDisplayName((Node)node) + "], " + "Map context)"));
        }
        TokenConsumerConfig tokenConsumerConfig = (TokenConsumerConfig)map.remove("com.ibm.wsspi.wssecurity.config.tokenConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TokenConsumerConfig [" + tokenConsumerConfig + "]."));
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
        int n = 0;
        Object v = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        String string = Constants.NAMESPACES[0][n];
        String string2 = Constants.NAMESPACES[1][n];
        NonceManager nonceManager = (NonceManager)map.remove(NonceManager.class);
        if (node.getNodeType() == 1) {
            UsernameToken usernameToken;
            Element element = (Element)node;
            String string3 = null;
            String string4 = IdUtil.getInstance().getIdAttributeName(element);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The identifier attribute of the target element is [" + string4 + "]."));
            }
            if (string4 != null) {
                string3 = element.getAttribute(string4);
            }
            final UsernameToken usernameToken2 = usernameToken = new UsernameToken(string3, null, null, element);
            final TokenConsumerConfig tokenConsumerConfig2 = tokenConsumerConfig;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    usernameToken2.setUsedTokenConsumer(tokenConsumerConfig2);
                    return null;
                }
            });
            IDAssertionUsernameTokenConsumer.setTokenToSubject(map, usernameToken);
            Element element2 = DOMUtil.getOneElement((Element)element, (String)string, (String)"Username");
            String string5 = null;
            if (element2 != null) {
                string5 = DOMUtil.getStringValue((Node)element2);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Username [" + string5 + "]."));
                Tr.debug((TraceComponent)tc, (String)("isCallerRequired [" + tokenConsumerConfig.isCallerRequired() + "]."));
            }
            if (!tokenConsumerConfig.isCallerRequired()) {
                throw SoapSecurityException.format("security.wssecurity.IDAssertionUsernameTokenConsumer.s01", "isCalerRequired()=false");
            }
            element2 = DOMUtil.getZeroOrOneElement((Element)element, (String)string, (String)"Password");
            if (element2 != null) {
                throw SoapSecurityException.format("security.wssecurity.IDAssertionUsernameTokenConsumer.s02", "<wsse:Password> != null.");
            }
            Date date = UsernameTokenConsumer.checkNonce(element, tokenConsumerConfig, string, string2, nonceManager);
            usernameToken.setDate(date);
            UsernameToken usernameToken3 = UsernameTokenConsumer.invokeLoginModule(tokenConsumerConfig, string5, null, sOAPMessageContext, map);
            if (usernameToken3 != null) {
                string5 = usernameToken3.getUsername();
            }
            final UsernameToken usernameToken4 = usernameToken;
            final String string6 = string5;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    usernameToken4.setUsername(string6);
                    return null;
                }
            });
            if (tokenConsumerConfig.getTrustedIDEvaluator() != null) {
                final boolean bl = tokenConsumerConfig.getTrustedIDEvaluator().evaluate(string5);
                final UsernameToken usernameToken5 = usernameToken;
                if (!bl) {
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.UsernameTokenConsumer.s02", (Object)new Object[]{string5});
                }
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        usernameToken5.setTrusted(bl);
                        return null;
                    }
                });
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Acquired token is [" + usernameToken + "]."));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WARNING: Unsupported node type: " + node.getNodeName()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Element target, Map context)");
        }
    }

    private static void setTokenToSubject(Map map, UsernameToken usernameToken) {
        TokenManager.setToken(map, usernameToken);
    }
}

