/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.keyinfo;

import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.auth.token.X509BSToken;
import com.ibm.wsspi.wssecurity.keyinfo.KeyLocator;
import com.ibm.wsspi.wssecurity.keyinfo.KeyStoreKeyLocator;
import com.ibm.wsspi.wssecurity.keyinfo.X509TokenKeyLocator;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Hex;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.xml.namespace.QName;

public class SignerCertKeyLocator
implements KeyLocator {
    private static final TraceComponent tc = Tr.register((Class)SignerCertKeyLocator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = X509TokenKeyLocator.class.getName();
    private static final int ITSHA1_OCTETS = 20;
    private static final int IT60SHA1_OCTETS = 8;
    private static final String OID_KEYIDENTIFIER = "2.5.29.14";
    private static final byte BER_SEQUENCE = 48;
    private static final byte BER_BITSTRING = 3;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public Key getKey(Map map, Map map2) throws SoapSecurityException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getKey(Map type,Map context)");
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)map2.get("com.ibm.wsspi.wssecurity.core.messageContext");
        String string = (String)map.get(Constants.WSSECURITY_KEYINFO_TYPE);
        if (string == null) {
            bl5 = false;
            bl4 = false;
            bl3 = false;
            bl2 = false;
            bl = false;
        } else {
            bl = ConfigUtil.isKeyInfoKeyname((String)string);
            bl2 = ConfigUtil.isKeyInfoKeyid((String)string);
            bl3 = ConfigUtil.isKeyInfoStrref((String)string);
            bl4 = ConfigUtil.isKeyInfoEmb((String)string);
            bl5 = ConfigUtil.isKeyInfoX509issuer((String)string);
        }
        String string2 = (String)map.get(Constants.WSSECURITY_KEY_TYPE);
        boolean bl6 = "EncryptingKey".equals(string2);
        Key key = null;
        if (!bl6) {
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getKey02", string2);
        }
        key = this.getPublicKey(bl, bl2, bl3, bl4, bl5, sOAPMessageContext, map, map2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKey(Map type, Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    private Key getPublicKey(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, SOAPMessageContext sOAPMessageContext, Map map, Map map2) throws SoapSecurityException {
        Token token;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getPublicKey(boolean isKeyName[" + bl + "]," + "boolean isKeyId[" + bl2 + "]," + "boolean isStrref[" + bl3 + "]," + "boolean isEmb[" + bl4 + "]," + "boolean isX509[" + bl5 + "]," + "SOAPMessageContext messageContext," + "Map type," + "Map context)"));
        }
        PublicKey publicKey = null;
        X509Certificate x509Certificate = this.getCertInRequest(sOAPMessageContext);
        if (x509Certificate != null) {
            publicKey = x509Certificate.getPublicKey();
            map2.put(publicKey, x509Certificate);
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"(key, certificate) from request put in context");
            }
        }
        if ((token = KeyStoreKeyLocator.getToken(bl, bl2, bl3, bl4, bl5, map, map2)) == null) {
            SignerCertKeyLocator.setInfo(bl, bl2, bl3, bl4, bl5, x509Certificate, map2);
        } else if (token instanceof X509BSToken && x509Certificate == null && (x509Certificate = ((X509BSToken)token).getCert()) != null && (publicKey = x509Certificate.getPublicKey()) != null) {
            map2.put(publicKey, x509Certificate);
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"(key, certificate) from token put in context");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getPublicKey(boolean isKeyName,boolean isKeyId,boolean isStrref,boolean isEmb,boolean isX509,SOAPMessageContext messageContext,Map context) returns Key[" + publicKey + "]"));
        }
        return publicKey;
    }

    private X509Certificate getCertInRequest(SOAPMessageContext sOAPMessageContext) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCertInRequest(SOAPMessageContext messageContext)");
        }
        if (sOAPMessageContext == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
        }
        X509Certificate x509Certificate = null;
        Object object = sOAPMessageContext.getProperty("com.ibm.xml.soapsec.RequestCert");
        if (!(object instanceof X509Certificate)) {
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.setCertToSubject01");
        }
        x509Certificate = (X509Certificate)object;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCertInRequest(SOAPMessageContext messageContext) returns X509Certificate[" + x509Certificate + "]"));
        }
        return x509Certificate;
    }

    private static void setInfo(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, X509Certificate x509Certificate, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setInfo(boolean isKeyName[" + bl + "]," + "boolean isKeyId[" + bl2 + "]," + "boolean isStrref[" + bl3 + "]," + "boolean isEmb[" + bl4 + "]," + "boolean isX509[" + bl5 + "]," + "X509Certificate cert," + "Map context)"));
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (bl) {
            string = KeyInfo.X509Data.encodeDName((String)x509Certificate.getSubjectDN().getName());
        } else if (bl2) {
            try {
                QName qName = (QName)map.remove(Constants.WSSECURITY_KEY_ENCODING);
                QName qName2 = (QName)map.remove(Constants.WSSECURITY_KEY_IDTYPE);
                if (com.ibm.ws.webservices.wssecurity.Constants.HEX_BINARY.equals(qName)) {
                    if (com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1.equals(qName2)) {
                        string2 = Hex.encode((byte[])SignerCertKeyLocator.makeIdentifier(x509Certificate, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1));
                    }
                    string2 = Hex.encode((byte[])SignerCertKeyLocator.makeIdentifier(x509Certificate, null));
                }
                if (com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1.equals(qName2)) {
                    string2 = Base64.encode((byte[])SignerCertKeyLocator.makeIdentifier(x509Certificate, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1));
                }
                string2 = Base64.encode((byte[])SignerCertKeyLocator.makeIdentifier(x509Certificate, null));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Tr.processException((Throwable)noSuchAlgorithmException, (String)(clsName + ".doInit"), (String)"284");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", (Object)new Object[]{noSuchAlgorithmException});
                throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", noSuchAlgorithmException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                Tr.processException((Throwable)invalidAlgorithmParameterException, (String)(clsName + ".doInit"), (String)"288");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", (Object)new Object[]{invalidAlgorithmParameterException});
                throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", invalidAlgorithmParameterException);
            }
        } else if (bl3) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WARNING: TokenGenerator is responsible to set a X509 token to the Subject in case of STRREF.");
            }
        } else if (bl4) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WARNING: TokenGenerator is responsible to set a X509 token to the Subject in case of EMB.");
            }
        } else if (bl5) {
            string3 = KeyInfo.X509Data.encodeDName((String)x509Certificate.getIssuerDN().getName());
            string4 = x509Certificate.getSerialNumber().toString();
        }
        if (string != null) {
            map.put(Constants.WSSECURITY_KEY_NAME, string);
        } else {
            map.remove(Constants.WSSECURITY_KEY_NAME);
        }
        if (string2 != null) {
            map.put(Constants.WSSECURITY_KEY_ID, string2);
        } else {
            map.remove(Constants.WSSECURITY_KEY_ID);
        }
        if (string3 != null) {
            map.put(Constants.WSSECURITY_KEY_ISSUERNAME, string3);
        } else {
            map.remove(Constants.WSSECURITY_KEY_ISSUERNAME);
        }
        if (string4 != null) {
            map.put(Constants.WSSECURITY_KEY_ISSUERSERIAL, string4);
        } else {
            map.remove(Constants.WSSECURITY_KEY_ISSUERSERIAL);
        }
        map.remove(Constants.WSSECURITY_KEY_EMBID);
        map.remove(Constants.WSSECURITY_KEY_REFERENCE);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setInfo(boolean isKeyName,boolean isKeyId,boolean isStrref,boolean isEmb,boolean isX509,X509Certificate cert,Map context)");
        }
    }

    private static byte[] makeIdentifier(Certificate certificate, QName qName) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("makeIdentifier(Certificate cert,QName idty[" + qName + "])"));
        }
        byte[] byArray = null;
        if (certificate != null && ((byArray = SignerCertKeyLocator.certToIdentifier(certificate)) == null || qName != null)) {
            if (qName == null || NamespaceUtil.equals((QName)qName, (QName)com.ibm.ws.webservices.wssecurity.Constants.ITSHA1)) {
                if (byArray == null || byArray.length != 20) {
                    byArray = SignerCertKeyLocator.pubkeyToIdentifier(certificate, qName);
                }
            } else if (NamespaceUtil.equals((QName)qName, (QName)com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) {
                if (byArray == null || byArray.length != 8) {
                    byArray = SignerCertKeyLocator.pubkeyToIdentifier(certificate, qName);
                }
            } else {
                throw new IllegalArgumentException("Internal Error: " + qName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"makeIdentifier(Certificate cert,QName idty)");
        }
        return byArray;
    }

    private static byte[] certToIdentifier(Certificate certificate) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("certToIdentifier(Certificate cert[" + certificate + "])"));
        }
        if (!(certificate instanceof X509Certificate)) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"certToIdentifier(Certificate cert)");
            }
            return null;
        }
        byte[] byArray = ((X509Certificate)certificate).getExtensionValue(OID_KEYIDENTIFIER);
        if (byArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"certToIdentifier(Certificate cert)");
            }
            return null;
        }
        byte[] byArray2 = new byte[byArray.length - 4];
        System.arraycopy(byArray, 4, byArray2, 0, byArray.length - 4);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"certToIdentifier(Certificate cert)");
        }
        return byArray2;
    }

    private static byte[] pubkeyToIdentifier(Certificate certificate, QName qName) throws NoSuchAlgorithmException {
        byte[] byArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("pubkeyToIdentifier(Certificate cert[" + certificate + "]," + "QName idty[" + qName + "])"));
        }
        byte[] byArray2 = certificate.getPublicKey().getEncoded();
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        if (byArray2[0] != 48) {
            throw new RuntimeException("Unknown encoded key: " + Hex.encode((byte[])byArray2));
        }
        int n = byArray2[1] & 0xFF;
        int n2 = (n & 0x80) == 0 ? 2 : 2 + (n & 0x7F);
        n = byArray2[n2 + 1] & 0xFF;
        if ((n & 0x80) == 0) {
            n2 += 2;
        } else {
            int n3 = n2 + 2;
            n2 += 2 + (n & 0x7F);
            switch (n & 0x7F) {
                case 1: {
                    n = byArray2[n3] & 0xFF;
                    break;
                }
                case 2: {
                    n = ((byArray2[n3] & 0xFF) << 8) + (byArray2[n3 + 1] & 0xFF);
                    break;
                }
                case 3: {
                    n = ((byArray2[n3] & 0xFF) << 16) + ((byArray2[n3 + 1] & 0xFF) << 8) + (byArray2[n3 + 2] & 0xFF);
                    break;
                }
                case 4: {
                    n = ((byArray2[n3] & 0xFF) << 24) + ((byArray2[n3 + 1] & 0xFF) << 16) + ((byArray2[n3 + 2] & 0xFF) << 8) + (byArray2[n3 + 3] & 0xFF);
                    break;
                }
                default: {
                    throw new RuntimeException("Integer overflow: " + Hex.encode((byte[])byArray2));
                }
            }
        }
        if (byArray2[n2 += n] != 3) {
            throw new RuntimeException("Non BIT STRING: 0x" + Integer.toString(byArray2[n2] & 0xFF, 16));
        }
        n2 += ((n = byArray2[n2 + 1] & 0xFF) & 0x80) == 0 ? 3 : 3 + (n & 0x7F);
        if (NamespaceUtil.equals((QName)qName, (QName)com.ibm.ws.webservices.wssecurity.Constants.ITSHA1) || qName == null) {
            messageDigest.update(byArray2, n2, byArray2.length - n2);
            byArray = messageDigest.digest();
        } else if (NamespaceUtil.equals((QName)qName, (QName)com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) {
            messageDigest.update(byArray2, n2, byArray2.length - n2);
            byte[] byArray3 = messageDigest.digest();
            byArray = new byte[8];
            byArray[0] = (byte)(64 + (byArray3[byArray3.length - 8] & 0xF));
            System.arraycopy(byArray3, byArray3.length - 8 + 1, byArray, 1, byArray.length - 1);
        } else {
            throw new IllegalArgumentException("Internal Error: " + qName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"pubkeyToIdentifier(Certificate cert,QName idty)");
        }
        return byArray;
    }
}

