/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.auth.token.LTPAToken;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LTPATokenWrapper
extends LTPAToken {
    private static final TraceComponent tc = Tr.register(LTPATokenWrapper.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String compName = "security.wssecurity";
    private static final String getCredentialPermission = "wssecurity.LTPATokenWrapper.getWSCredential";
    private WSCredential _wsCred = null;
    private WSPrincipal _wsPrinc = null;
    private QName DEFAULT_VALUE_TYPE;
    private static final WebSphereRuntimePermission GETWSCREDENTIAL_PERM = new WebSphereRuntimePermission("wssecurity.LTPATokenWrapper.getWSCredential");

    public LTPATokenWrapper(String string, byte[] byArray, String string2, char[] cArray, Element element) {
        super(string, byArray, string2, cArray, element);
        this._vtype = this.DEFAULT_VALUE_TYPE = Constants.LTPA_TOKEN_PROPAGATION;
    }

    public LTPATokenWrapper(String string, byte[] byArray) {
        this(string, byArray, null, null, null);
    }

    public LTPATokenWrapper(String string, byte[] byArray, WSCredential wSCredential, WSPrincipal wSPrincipal) {
        super(string, byArray);
        this.DEFAULT_VALUE_TYPE = Constants.LTPA_TOKEN_PROPAGATION;
        this._wsCred = wSCredential;
        this._wsPrinc = wSPrincipal;
        this._vtype = this.DEFAULT_VALUE_TYPE;
    }

    public WSCredential getWSCredential() {
        Tr.entry(tc, "getWSCredential");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GETWSCREDENTIAL_PERM.toString());
            }
            securityManager.checkPermission(GETWSCREDENTIAL_PERM);
        }
        Tr.exit(tc, "getWSCredential");
        return this._wsCred;
    }

    public WSPrincipal getWSPrincipal() {
        return this._wsPrinc;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LTPATokenWrapper[tokenId=[").append(this._tokenId);
        stringBuffer.append("], element=[").append(DOMUtil.getDisplayName((Node)this._tokenelem));
        stringBuffer.append("], username=[").append(this.getPrincipal());
        stringBuffer.append("], WSPrincipal=[").append(this._wsPrinc);
        stringBuffer.append("], WSCredential=[").append(this._wsCred);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

