/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.module;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.wsspi.wssecurity.auth.callback.PropertyCallback;
import com.ibm.wsspi.wssecurity.auth.module.WSSecurityMappingModule;
import com.ibm.xml.soapsec.util.Tr;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class SignatureLoginModule
extends WSSecurityMappingModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private String username = null;
    private boolean debug = false;
    private boolean disableURCheck = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private Map properties = null;
    private static final String _LOGINUSERNAME = "LoginUsername";
    private static final String _DISABLE_REGISTRY_CHECK = "com.ibm.wsspi.wssecurity.auth.module.SignatureLoginModule.disableUserRegistryCheck";
    private static final String clsName = SignatureLoginModule.class.getName();
    private static final TraceComponent tc = com.ibm.ejs.ras.Tr.register(SignatureLoginModule.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final WebSphereRuntimePermission PERM = new WebSphereRuntimePermission("wssecurity.SignatureLoginModule.login");

    public SignatureLoginModule() {
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.entry(tc, "SignatureLoginModule()");
        }
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit(tc, "SignatureLoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        super.initialize(subject, callbackHandler, map, map2);
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.entry(tc, "initialize()", new Object[]{subject, callbackHandler, map, map2});
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        this.disableURCheck = "true".equalsIgnoreCase((String)this.options.get(_DISABLE_REGISTRY_CHECK));
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit(tc, "initialize()");
        }
    }

    public boolean login() throws LoginException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.entry(tc, "login()");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(PERM);
        }
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler available to garner authentication information from the user.");
        }
        this.succeeded = false;
        this.username = null;
        this.properties = null;
        Callback[] callbackArray = new Callback[]{new NameCallback("Username: "), new PropertyCallback(null)};
        try {
            this.callbackHandler.handle(callbackArray);
            String string = (String)this.sharedState.get("com.ibm.wsspi.wssecurity.Constants.DN");
            if (string != null && (string = string.trim()).length() != 0) {
                if (this.debug || tc.isDebugEnabled()) {
                    com.ibm.ejs.ras.Tr.debug(tc, "The identity is overrided by user in the shared state");
                }
                this.username = string;
            }
            if (this.username == null) {
                this.username = ((NameCallback)callbackArray[0]).getName();
            }
            if (this.debug || tc.isDebugEnabled()) {
                com.ibm.ejs.ras.Tr.debug(tc, "login() - username is " + this.username);
            }
            this.properties = ((PropertyCallback)callbackArray[1]).getProperties();
            if (this.debug || tc.isDebugEnabled()) {
                com.ibm.ejs.ras.Tr.debug(tc, "login() - properties are " + this.properties);
            }
        }
        catch (IOException iOException) {
            Tr.processException((Throwable)iOException, (String)(clsName + ".login"), (String)"127", (Object)this);
            throw new LoginException(iOException.toString());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            Tr.processException((Throwable)unsupportedCallbackException, (String)(clsName + ".login"), (String)"130", (Object)this);
            throw new LoginException("Error: " + unsupportedCallbackException.getCallback().toString() + " not available to garner authentication" + " information from the user");
        }
        this.succeeded = this.disableURCheck ? true : this._login(this.username);
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit(tc, "login() returns " + this.succeeded + ", username is " + this.username);
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.entry(tc, "commit()");
        }
        this.commitSucceeded = false;
        if (!this.succeeded) {
            if (this.debug || tc.isDebugEnabled()) {
                com.ibm.ejs.ras.Tr.debug(tc, "Do not commit() because login() failed.");
            }
        } else {
            if (this.debug || tc.isDebugEnabled()) {
                com.ibm.ejs.ras.Tr.debug(tc, "Starting to commit changes to subject.");
            }
            if (this.properties == null) {
                if (tc.isDebugEnabled()) {
                    com.ibm.ejs.ras.Tr.debug(tc, "WARNING: Can't return username because properties parameter is null.");
                }
            } else {
                this.properties.put(_LOGINUSERNAME, this.username);
                if (this.debug || tc.isDebugEnabled()) {
                    com.ibm.ejs.ras.Tr.debug(tc, "Commit succeeded!");
                }
                this.commitSucceeded = true;
            }
        }
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit(tc, "commit() returns " + this.commitSucceeded);
        }
        return this.commitSucceeded;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.entry(tc, "abort()");
        }
        this.cleanup();
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.entry(tc, "logout()");
        }
        this.cleanup();
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit(tc, "logout()");
        }
        return true;
    }

    private void cleanup() {
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.entry(tc, "cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        this.username = null;
        if (this.properties != null) {
            this.properties.remove(_LOGINUSERNAME);
            this.properties = null;
        }
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit(tc, "cleanup()");
        }
    }
}

