/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.callback;

import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.auth.callback.BinaryTokenCallback;
import com.ibm.wsspi.wssecurity.auth.callback.PropertyCallback;
import com.ibm.wsspi.wssecurity.auth.callback.X509BSCallback;
import com.ibm.wsspi.wssecurity.auth.callback.XMLTokenConsumerCallback;
import com.ibm.wsspi.wssecurity.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.config.KeyLocatorConfig;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public abstract class BSTokenCallbackHandler
implements CallbackHandler {
    private static final TraceComponent tc = Tr.register((Class)BSTokenCallbackHandler.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = BSTokenCallbackHandler.class.getName();
    private final CallbackHandlerConfig _config;
    private final Set _keyInformationList;

    protected BSTokenCallbackHandler(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BSTokenCallbackHandler(Map properties)");
        }
        if (map == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WARNING: The properties parameter is null.");
            }
            this._config = null;
            this._keyInformationList = null;
        } else {
            this._config = (CallbackHandlerConfig)map.get("com.ibm.wsspi.wssecurity.config.callbackHandler.configKey");
            if (this._config == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WARNING: The configuration of callback handler is null.");
                }
                this._keyInformationList = null;
            } else {
                this._keyInformationList = this._config.getKeyInformationList();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CallbackHandlerConfig [" + this._config + "]."));
            Tr.debug((TraceComponent)tc, (String)("KeyInformationList is [" + this._keyInformationList + "]."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"BSTokenCallbackHandler(Map properties)");
        }
    }

    public TokenInformation _handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        TokenInformation tokenInformation;
        String string;
        SOAPMessageContext sOAPMessageContext;
        Map map;
        X509BSCallback x509BSCallback;
        block17: {
            Iterator iterator;
            String string2;
            block16: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"handle(Callback[] callbacks)");
                }
                if (callbackArray == null || callbackArray.length == 0) {
                    throw new UnsupportedCallbackException(null, "There is no callback.");
                }
                x509BSCallback = null;
                map = null;
                sOAPMessageContext = null;
                string = null;
                string2 = null;
                for (int i = 0; i < callbackArray.length; ++i) {
                    if (callbackArray[i] instanceof X509BSCallback) {
                        x509BSCallback = (X509BSCallback)callbackArray[i];
                        continue;
                    }
                    if (callbackArray[i] instanceof PropertyCallback) {
                        if (map == null) {
                            map = ((PropertyCallback)callbackArray[i]).getProperties();
                        }
                        if (map == null) continue;
                        sOAPMessageContext = (SOAPMessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
                        string2 = (String)map.get(Constants.WSSECURITY_KEY_NAMEREF);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("KeyName is [" + string2 + "]."));
                        continue;
                    }
                    if (callbackArray[i] instanceof BinaryTokenCallback || callbackArray[i] instanceof XMLTokenConsumerCallback) continue;
                    throw new UnsupportedCallbackException(callbackArray[i], "Unsupported callback");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Succeeded to get necessary information through the callbacks.");
                }
                tokenInformation = null;
                if (this._keyInformationList == null) {
                    throw new IOException(ConfigUtil.getMessage((String)"security.wssecurity.BSTokenCallbackHandler.s01"));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Configuration of the this callback handler found.");
                }
                iterator = this._keyInformationList.iterator();
                if (!"com.ibm.wsspi.wssecurity.token.standAlone".equals(string2)) break block16;
                if (!iterator.hasNext()) break block17;
                KeyLocatorConfig.KeyInformationConfig keyInformationConfig = (KeyLocatorConfig.KeyInformationConfig)iterator.next();
                if (iterator.hasNext() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Multiple key information are found.  But since there is no way to select one of them, the first one is used.");
                }
                string = keyInformationConfig.getAlias();
                break block17;
            }
            while (iterator.hasNext()) {
                KeyLocatorConfig.KeyInformationConfig keyInformationConfig = (KeyLocatorConfig.KeyInformationConfig)iterator.next();
                String string3 = KeyInfo.X509Data.encodeDName((String)keyInformationConfig.getName());
                if (string3 == null || string3.length() == 0) {
                    string3 = keyInformationConfig.getName();
                }
                if (!string3.equals(string2)) continue;
                string = keyInformationConfig.getAlias();
                break;
            }
        }
        if (tc.isDebugEnabled()) {
            if (string == null) {
                Tr.debug((TraceComponent)tc, (String)"Alias not found.");
            } else {
                Tr.debug((TraceComponent)tc, (String)("Alias is [" + string + "]."));
            }
        }
        tokenInformation = new TokenInformation();
        tokenInformation._config = this._config;
        tokenInformation._messageContext = sOAPMessageContext;
        tokenInformation._properties = map;
        tokenInformation._alias = string;
        tokenInformation._bsCallback = x509BSCallback;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("handle(Callback[] callbacks) returns TokenInformation[" + tokenInformation + "]"));
        }
        return tokenInformation;
    }

    IOException processError(TokenInformation tokenInformation) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processError(TokenInformation tinfo)");
        }
        IOException iOException = null;
        String string = null;
        if (tokenInformation._properties != null && !tokenInformation._properties.isEmpty()) {
            string = (String)tokenInformation._properties.get(Constants.WSSECURITY_KEY_NAMEREF);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyName is [" + string + "]."));
        }
        if (string != null && string.length() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._keyInformationList != null) {
                Iterator iterator = this._keyInformationList.iterator();
                if ("com.ibm.wsspi.wssecurity.token.standAlone".equals(string)) {
                    if (iterator.hasNext()) {
                        KeyLocatorConfig.KeyInformationConfig keyInformationConfig = (KeyLocatorConfig.KeyInformationConfig)iterator.next();
                        stringBuffer.append(KeyInfo.X509Data.encodeDName((String)keyInformationConfig.getName()));
                    }
                } else {
                    while (iterator.hasNext()) {
                        KeyLocatorConfig.KeyInformationConfig keyInformationConfig = (KeyLocatorConfig.KeyInformationConfig)iterator.next();
                        stringBuffer.append(KeyInfo.X509Data.encodeDName((String)keyInformationConfig.getName()));
                        if (!iterator.hasNext()) continue;
                        stringBuffer.append(", ");
                    }
                }
                iOException = new IOException(ConfigUtil.getMessage((String)"security.wssecurity.WSEC6730E", (String[])new String[]{string, stringBuffer.toString(), tokenInformation._alias}));
            } else {
                iOException = new IOException(ConfigUtil.getMessage((String)"security.wssecurity.WSEC6730E", (String[])new String[]{string, "", tokenInformation._alias}));
            }
        } else {
            iOException = new IOException(ConfigUtil.getMessage((String)"security.wssecurity.KeyStoreKeyLocator.generateIdentifier04", (String[])new String[]{tokenInformation._alias}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processError(TokenInformation tinfo)", (Object)iOException);
        }
        return iOException;
    }

    protected static class TokenInformation {
        protected CallbackHandlerConfig _config = null;
        protected SOAPMessageContext _messageContext = null;
        protected Map _properties = null;
        protected String _alias = null;
        protected X509BSCallback _bsCallback = null;

        protected TokenInformation() {
        }
    }
}

