/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.pmi.factory;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.ws.pmi.factory.StatsFactoryUtil;
import com.ibm.ws.pmi.factory.StatsGroupImpl;
import com.ibm.ws.pmi.factory.StatsInstanceImpl;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.wsspi.pmi.factory.StatisticActionListener;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.factory.StatsTemplateLookup;
import javax.management.ObjectName;

public class StatsFactory {
    private static final TraceComponent tc = Tr.register(StatsFactory.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.pmi.properties.PMIMessages");

    public static boolean isPMIEnabled() {
        return !PmiRegistry.isDisabled();
    }

    public static StatsGroup createStatsGroup(String string, String string2, ObjectName objectName) throws StatsFactoryException {
        StatsGroup statsGroup;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStatsGroup:name=" + string + ";template=" + string2 + ";mBean=" + (objectName == null ? null : objectName.toString()));
        }
        StatsFactory.checkPMIService(string);
        try {
            statsGroup = StatsGroupImpl.createGroup(string, string2, objectName, false);
        }
        catch (StatsFactoryException statsFactoryException) {
            if (tc.isDebugEnabled()) {
                statsFactoryException.printStackTrace();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatsGroup");
            }
            throw statsFactoryException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsGroup");
        }
        return statsGroup;
    }

    public static StatsGroup createStatsGroup(String string, String string2, StatsGroup statsGroup, ObjectName objectName) throws StatsFactoryException {
        StatsGroup statsGroup2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStatsGroup:name=" + string + ";parent group=" + statsGroup.getName() + ";template=" + string2 + ";mBean=" + (objectName == null ? null : objectName.toString()));
        }
        StatsFactory.checkPMIService(string);
        try {
            statsGroup2 = StatsGroupImpl.createGroup(string, statsGroup, string2, objectName, false);
        }
        catch (StatsFactoryException statsFactoryException) {
            if (tc.isDebugEnabled()) {
                statsFactoryException.printStackTrace();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatsGroup");
            }
            throw statsFactoryException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsGroup");
        }
        return statsGroup2;
    }

    public static StatsGroup createStatsGroup(String string, String string2, StatsInstance statsInstance, ObjectName objectName) throws StatsFactoryException {
        StatsGroup statsGroup;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStatsGroup:name=" + string + ";parent instance=" + statsInstance.getName() + ";template=" + string2 + ";mBean=" + (objectName == null ? null : objectName.toString()));
        }
        StatsFactory.checkPMIService(string);
        try {
            statsGroup = StatsGroupImpl.createGroup(string, statsInstance, string2, objectName, false);
        }
        catch (StatsFactoryException statsFactoryException) {
            if (tc.isDebugEnabled()) {
                statsFactoryException.printStackTrace();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatsGroup");
            }
            throw statsFactoryException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsGroup");
        }
        return statsGroup;
    }

    public static StatsInstance createStatsInstance(String string, String string2, ObjectName objectName, StatisticActionListener statisticActionListener) throws StatsFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStatsInstance:name=" + string + ";template=" + string2 + ";mBean=" + (objectName == null ? null : objectName.toString()));
        }
        StatsInstance statsInstance = StatsFactory.createStatsInstance(string, string2, objectName, new StatisticActions(statisticActionListener));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsInstance");
        }
        return statsInstance;
    }

    public static StatsInstance createStatsInstance(String string, String string2, ObjectName objectName, StatisticActions statisticActions) throws StatsFactoryException {
        StatsInstanceImpl statsInstanceImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStatsInstance:name=" + string + ";template=" + string2 + ";mBean=" + (objectName == null ? null : objectName.toString()));
        }
        StatsFactory.checkPMIService(string);
        try {
            statsInstanceImpl = StatsInstanceImpl.createInstance(string, string2, objectName, false, statisticActions);
        }
        catch (StatsFactoryException statsFactoryException) {
            if (tc.isDebugEnabled()) {
                statsFactoryException.printStackTrace();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatsInstance");
            }
            throw statsFactoryException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsInstance");
        }
        return statsInstanceImpl;
    }

    public static StatsInstance createStatsInstance(String string, StatsGroup statsGroup, ObjectName objectName, StatisticActionListener statisticActionListener) throws StatsFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStatsInstance:name=" + string + ";parent name=" + statsGroup.getName() + ";mBean=" + (objectName == null ? null : objectName.toString()));
        }
        StatsInstance statsInstance = StatsFactory.createStatsInstance(string, statsGroup, objectName, new StatisticActions(statisticActionListener));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsInstance");
        }
        return statsInstance;
    }

    public static StatsInstance createStatsInstance(String string, StatsGroup statsGroup, ObjectName objectName, StatisticActions statisticActions) throws StatsFactoryException {
        StatsInstanceImpl statsInstanceImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStatsInstance:name=" + string + ";parent name=" + statsGroup.getName() + ";mBean=" + (objectName == null ? null : objectName.toString()));
        }
        StatsFactory.checkPMIService(string);
        try {
            statsInstanceImpl = StatsInstanceImpl.createGroupInstance(string, statsGroup, objectName, false, statisticActions);
        }
        catch (StatsFactoryException statsFactoryException) {
            if (tc.isDebugEnabled()) {
                statsFactoryException.printStackTrace();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatsInstance");
            }
            throw statsFactoryException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsInstance");
        }
        return statsInstanceImpl;
    }

    public static StatsInstance createStatsInstance(String string, String string2, StatsGroup statsGroup, ObjectName objectName, StatisticActionListener statisticActionListener) throws StatsFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStatsInstance:name=" + string + ";template=" + string2 + ";parent name=" + statsGroup.getName() + ";mBean=" + (objectName == null ? null : objectName.toString()));
        }
        StatsInstance statsInstance = StatsFactory.createStatsInstance(string, string2, statsGroup, objectName, new StatisticActions(statisticActionListener));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsInstance");
        }
        return statsInstance;
    }

    public static StatsInstance createStatsInstance(String string, String string2, StatsGroup statsGroup, ObjectName objectName, StatisticActions statisticActions) throws StatsFactoryException {
        StatsInstanceImpl statsInstanceImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStatsInstance:name=" + string + ";template=" + string2 + ";parent name=" + statsGroup.getName() + ";mBean=" + (objectName == null ? null : objectName.toString()));
        }
        StatsFactory.checkPMIService(string);
        try {
            statsInstanceImpl = StatsInstanceImpl.createGroupInstance(string, statsGroup, string2, objectName, false, statisticActions);
        }
        catch (StatsFactoryException statsFactoryException) {
            if (tc.isDebugEnabled()) {
                statsFactoryException.printStackTrace();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStatsInstance");
            }
            throw statsFactoryException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatsInstance");
        }
        return statsInstanceImpl;
    }

    public static void removeStatsInstance(StatsInstance statsInstance) throws StatsFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeStatsInstance:name=" + statsInstance.getName());
        }
        StatsFactoryUtil.unRegisterStats((PmiModule)((Object)statsInstance), statsInstance.getMBean());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeStatsInstance");
        }
    }

    public static void removeStatsGroup(StatsGroup statsGroup) throws StatsFactoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeStatsGroup:name=" + statsGroup.getName());
        }
        StatsFactoryUtil.unRegisterStats((PmiModule)((Object)statsGroup), statsGroup.getMBean());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeStatsGroup");
        }
    }

    public static void registerStatsTemplateLookup(StatsTemplateLookup statsTemplateLookup) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerStatsTemplateLookup: " + statsTemplateLookup.getClass().getName());
        }
        PerfModules.registerTemplateLookupClass(statsTemplateLookup);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerStatsTemplateLookup");
        }
    }

    public static StatsGroup getStatsGroup(String[] stringArray) {
        StatsGroup statsGroup = null;
        if (stringArray != null) {
            PmiModule pmiModule;
            ModuleItem moduleItem;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getStatsGroup: " + StatsFactory._arrayToString(stringArray));
            }
            if ((moduleItem = PmiRegistry.findModuleItem(stringArray)) != null && (pmiModule = moduleItem.getInstance()) instanceof StatsGroupImpl) {
                statsGroup = (StatsGroup)((Object)pmiModule);
            }
        } else if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsGroup: path is null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsGroup");
        }
        return statsGroup;
    }

    public static StatsInstance getStatsInstance(String[] stringArray) {
        StatsInstance statsInstance = null;
        if (stringArray != null) {
            PmiModule pmiModule;
            ModuleItem moduleItem;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getStatsInstance: " + StatsFactory._arrayToString(stringArray));
            }
            if ((moduleItem = PmiRegistry.findModuleItem(stringArray)) != null && (pmiModule = moduleItem.getInstance()) instanceof StatsInstanceImpl) {
                statsInstance = (StatsInstance)((Object)pmiModule);
            }
        } else if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsInstance: path is null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsInstance");
        }
        return statsInstance;
    }

    private static String _arrayToString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append("/").append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private static void checkPMIService(String string) throws StatsFactoryException {
        if (!StatsFactory.isPMIEnabled()) {
            Tr.warning(tc, "PMI0107W", string);
            throw new StatsFactoryException(nls.getFormattedMessage("PMI0107W", new Object[]{string}, "PMI0107W: Unable to register custom PMI module since the PMI service is not enabled: {0}"));
        }
    }
}

