/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.xml;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.extensions.PopulatedExtensionRegistry;
import com.ibm.wsdl.spi.AttributeExtensible;
import com.ibm.wsdl.spi.extensions.lightweightschema.LightWeightSchema;
import com.ibm.wsdl.spi.extensions.lightweightschema.SchemaReference;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import com.ibm.wsdl.util.xml.QNameUtils;
import com.ibm.wsdl.util.xml.XPathUtils;
import com.ibm.wsdl.xml.EntityResolverAdapter;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class WSDLReaderImpl
implements WSDLReader {
    private static final List STYLE_ONE_WAY = Arrays.asList("input");
    private static final List STYLE_REQUEST_RESPONSE = Arrays.asList("input", "output");
    private static final List STYLE_SOLICIT_RESPONSE = Arrays.asList("output", "input");
    private static final List STYLE_NOTIFICATION = Arrays.asList("output");
    protected boolean verbose = true;
    protected boolean importDocuments = true;
    protected boolean useWSDLLocatorAsEntityResolver = false;
    protected ExtensionRegistry extReg = null;
    protected String factoryImplName = null;
    protected WSDLLocator loc = null;
    protected WSDLFactory factory = null;
    private final Map allSchemas = new Hashtable();

    public WSDLReaderImpl() {
    }

    public WSDLReaderImpl(WSDLFactory wSDLFactory) {
        this.factory = wSDLFactory;
    }

    public void setFeature(String string, boolean bl) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Feature name must not be null.");
        }
        if (string.equals("javax.wsdl.verbose")) {
            this.verbose = bl;
        } else if (string.equals("javax.wsdl.importDocuments")) {
            this.importDocuments = bl;
        } else if (string.equals("com.ibm.wsdl.useWSDLLocatorAsEntityResolver")) {
            this.useWSDLLocatorAsEntityResolver = bl;
        } else {
            throw new IllegalArgumentException("Feature name '" + string + "' not recognized.");
        }
    }

    public boolean getFeature(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Feature name must not be null.");
        }
        if (string.equals("javax.wsdl.verbose")) {
            return this.verbose;
        }
        if (string.equals("javax.wsdl.importDocuments")) {
            return this.importDocuments;
        }
        if (string.equals("com.ibm.wsdl.useWSDLLocatorAsEntityResolver")) {
            return this.useWSDLLocatorAsEntityResolver;
        }
        throw new IllegalArgumentException("Feature name '" + string + "' not recognized.");
    }

    public void setExtensionRegistry(ExtensionRegistry extensionRegistry) {
        this.extReg = extensionRegistry;
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.extReg;
    }

    protected WSDLFactory getWSDLFactory() throws WSDLException {
        if (this.factory == null) {
            this.factory = this.factoryImplName != null ? WSDLFactory.newInstance(this.factoryImplName) : WSDLFactory.newInstance();
        }
        return this.factory;
    }

    public void setFactoryImplName(String string) throws UnsupportedOperationException {
        this.factory = null;
        this.factoryImplName = string;
    }

    public String getFactoryImplName() {
        return this.factoryImplName;
    }

    protected Definition parseDefinitions(String string, Element element, Map hashtable) throws WSDLException {
        WSDLReaderImpl.checkElementName(element, Constants.Q_ELEM_DEFINITIONS);
        WSDLFactory wSDLFactory = this.getWSDLFactory();
        Definition definition = wSDLFactory.newDefinition();
        if (this.extReg != null) {
            definition.setExtensionRegistry(this.extReg);
        }
        String string2 = DOMUtils.getAttribute(element, "name");
        String string3 = DOMUtils.getAttribute(element, "targetNamespace");
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (string != null) {
            definition.setDocumentBaseURI(string);
        }
        if (string2 != null) {
            definition.setQName(new QName(string3, string2));
        }
        if (string3 != null) {
            definition.setTargetNamespace(string3);
        }
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            String string4 = attr.getNamespaceURI();
            String string5 = attr.getLocalName();
            String string6 = attr.getValue();
            if (string4 == null || !string4.equals("http://www.w3.org/2000/xmlns/")) continue;
            if (string5 != null && !string5.equals("xmlns")) {
                definition.addNamespace(string5, string6);
                continue;
            }
            definition.addNamespace(null, string6);
        }
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_IMPORT, element2)) {
                if (hashtable == null) {
                    hashtable = new Hashtable<String, Definition>();
                }
                if (string != null) {
                    hashtable.put(string, definition);
                }
                definition.addImport(this.parseImport(element2, definition, hashtable));
            } else if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                definition.setDocumentationElement(element2);
            } else if (QNameUtils.matches(Constants.Q_ELEM_TYPES, element2)) {
                definition.setTypes(this.parseTypes(element2, definition));
            } else if (QNameUtils.matches(Constants.Q_ELEM_MESSAGE, element2)) {
                definition.addMessage(this.parseMessage(element2, definition));
            } else if (QNameUtils.matches(Constants.Q_ELEM_PORT_TYPE, element2)) {
                definition.addPortType(this.parsePortType(element2, definition));
            } else if (QNameUtils.matches(Constants.Q_ELEM_BINDING, element2)) {
                definition.addBinding(this.parseBinding(element2, definition));
            } else if (QNameUtils.matches(Constants.Q_ELEM_SERVICE, element2)) {
                definition.addService(this.parseService(element2, definition));
            } else {
                definition.addExtensibilityElement(this.parseExtensibilityElement(Definition.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        return definition;
    }

    protected Import parseImport(Element element, Definition definition, Map map) throws WSDLException {
        Object object;
        Import import_ = definition.createImport();
        String string = DOMUtils.getAttribute(element, "namespace");
        String string2 = DOMUtils.getAttribute(element, "location");
        if (string != null) {
            import_.setNamespaceURI(string);
        }
        if (string2 != null) {
            import_.setLocationURI(string2);
            if (this.importDocuments) {
                try {
                    Object object2;
                    object = definition.getDocumentBaseURI();
                    Definition definition2 = null;
                    InputStream inputStream = null;
                    InputSource inputSource = null;
                    URL uRL = null;
                    if (this.loc != null) {
                        inputSource = this.loc.getImportInputSource((String)object, string2);
                        object2 = this.loc.getLatestImportURI();
                        definition2 = (Definition)map.get(object2);
                    } else {
                        object2 = object != null ? StringUtils.getURL(null, (String)object) : null;
                        uRL = StringUtils.getURL((URL)object2, string2);
                        definition2 = (Definition)map.get(uRL.toString());
                        if (definition2 == null && (inputStream = StringUtils.getContentAsInputStream(uRL)) != null) {
                            inputSource = new InputSource(inputStream);
                        }
                    }
                    if (definition2 == null) {
                        Object object3;
                        Element element2;
                        if (inputSource == null) {
                            throw new WSDLException("OTHER_ERROR", "Unable to locate imported document at '" + string2 + "'" + (object == null ? "." : ", relative to '" + (String)object + "'."));
                        }
                        object2 = this.getDocument(inputSource, string2);
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (QNameUtils.matches(Constants.Q_ELEM_DEFINITIONS, element2 = object2.getDocumentElement())) {
                            if (this.verbose) {
                                System.out.println("Retrieving document at '" + string2 + "'" + (object == null ? "." : ", relative to '" + (String)object + "'."));
                            }
                            object3 = this.loc != null ? this.loc.getLatestImportURI() : (uRL != null ? uRL.toString() : string2);
                            definition2 = this.readWSDL((String)object3, element2, map);
                        } else {
                            object3 = QNameUtils.newQName(element2);
                            if (Constants.XSD_QNAME_LIST.contains(object3)) {
                                WSDLFactory wSDLFactory = this.getWSDLFactory();
                                definition2 = wSDLFactory.newDefinition();
                                if (this.extReg != null) {
                                    definition2.setExtensionRegistry(this.extReg);
                                }
                                String string3 = this.loc != null ? this.loc.getLatestImportURI() : (uRL != null ? uRL.toString() : string2);
                                definition2.setDocumentBaseURI(string3);
                                Types types2 = definition2.createTypes();
                                types2.addExtensibilityElement(this.parseSchema(Types.class, element2, definition2));
                                definition2.setTypes(types2);
                            }
                        }
                    }
                    if (definition2 != null) {
                        import_.setDefinition(definition2);
                    }
                }
                catch (WSDLException wSDLException) {
                    wSDLException.setLocation(XPathUtils.getXPathExprFromNode(element));
                    throw wSDLException;
                }
                catch (Throwable throwable) {
                    throw new WSDLException("OTHER_ERROR", "Unable to resolve imported document at '" + string2 + "'.", throwable);
                }
            }
        }
        object = DOMUtils.getFirstChildElement(element);
        while (object != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, (Node)object)) {
                import_.setDocumentationElement((Element)object);
            } else {
                DOMUtils.throwWSDLException((Element)object);
            }
            object = DOMUtils.getNextSiblingElement((Element)object);
        }
        if (import_ instanceof AttributeExtensible) {
            this.parseExtensibilityAttributes(element, Import.class, (AttributeExtensible)((Object)import_), definition);
        }
        return import_;
    }

    protected Types parseTypes(Element element, Definition definition) throws WSDLException {
        Types types2 = definition.createTypes();
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            QName qName = QNameUtils.newQName(element2);
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                types2.setDocumentationElement(element2);
            } else if (Constants.XSD_QNAME_LIST.contains(qName)) {
                types2.addExtensibilityElement(this.parseSchema(Types.class, element2, definition));
            } else {
                types2.addExtensibilityElement(this.parseExtensibilityElement(Types.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        if (types2 instanceof AttributeExtensible) {
            this.parseExtensibilityAttributes(element, Types.class, (AttributeExtensible)((Object)types2), definition);
        }
        return types2;
    }

    protected ExtensibilityElement parseSchema(Class clazz, Element element, Definition definition) throws WSDLException {
        Object var4_4 = null;
        ExtensionRegistry extensionRegistry = null;
        try {
            extensionRegistry = definition.getExtensionRegistry();
            if (extensionRegistry == null) {
                throw new WSDLException("CONFIGURATION_ERROR", "No ExtensionRegistry set for this Definition, so unable to deserialize a '" + var4_4 + "' element in the " + "context of a '" + clazz.getName() + "'.");
            }
            return this.parseSchema(clazz, element, definition, extensionRegistry);
        }
        catch (WSDLException wSDLException) {
            if (wSDLException.getLocation() == null) {
                wSDLException.setLocation(XPathUtils.getXPathExprFromNode(element));
            }
            throw wSDLException;
        }
    }

    protected ExtensibilityElement parseSchema(Class clazz, Element element, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        LightWeightSchema lightWeightSchema = null;
        SchemaReference schemaReference = null;
        try {
            QName qName = QNameUtils.newQName(element);
            ExtensionDeserializer extensionDeserializer = extensionRegistry.queryDeserializer(clazz, qName);
            ExtensibilityElement extensibilityElement = extensionDeserializer.unmarshall(clazz, qName, element, definition, extensionRegistry);
            if (!(extensibilityElement instanceof LightWeightSchema)) {
                return extensibilityElement;
            }
            lightWeightSchema = (LightWeightSchema)extensibilityElement;
            this.allSchemas.put(lightWeightSchema.getDocumentBaseURI(), lightWeightSchema);
            ArrayList arrayList = new ArrayList();
            Collection collection = lightWeightSchema.getImports().values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                arrayList.addAll((Collection)iterator.next());
            }
            arrayList.addAll(lightWeightSchema.getIncludes());
            arrayList.addAll(lightWeightSchema.getRedefines());
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                try {
                    Serializable serializable;
                    Object object;
                    Object object2;
                    schemaReference = (SchemaReference)listIterator.next();
                    if (schemaReference.getSchemaLocationURI() == null) continue;
                    InputStream inputStream = null;
                    InputSource inputSource = null;
                    LightWeightSchema lightWeightSchema2 = null;
                    String string = null;
                    if (this.loc != null) {
                        inputSource = this.loc.getImportInputSource(lightWeightSchema.getDocumentBaseURI(), schemaReference.getSchemaLocationURI());
                        if (inputSource == null) {
                            throw new WSDLException("OTHER_ERROR", "Unable to locate with a locator the schema referenced at '" + schemaReference.getSchemaLocationURI() + "' relative to document base '" + lightWeightSchema.getDocumentBaseURI() + "'");
                        }
                        string = this.loc.getLatestImportURI();
                        lightWeightSchema2 = (LightWeightSchema)this.allSchemas.get(string);
                    } else {
                        object2 = lightWeightSchema.getDocumentBaseURI();
                        object = object2 != null ? StringUtils.getURL(null, (String)object2) : null;
                        serializable = StringUtils.getURL((URL)object, schemaReference.getSchemaLocationURI());
                        string = serializable.toExternalForm();
                        lightWeightSchema2 = (LightWeightSchema)this.allSchemas.get(string);
                        if (lightWeightSchema2 == null) {
                            inputStream = StringUtils.getContentAsInputStream(serializable);
                            if (inputStream != null) {
                                inputSource = new InputSource(inputStream);
                            }
                            if (inputSource == null) {
                                throw new WSDLException("OTHER_ERROR", "Unable to locate with a url the document referenced at '" + schemaReference.getSchemaLocationURI() + "'" + (object2 == null ? "." : ", relative to '" + (String)object2 + "'."));
                            }
                        }
                    }
                    if (lightWeightSchema2 == null) {
                        object2 = this.getDocument(inputSource, schemaReference.getSchemaLocationURI());
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (Constants.XSD_QNAME_LIST.contains(serializable = QNameUtils.newQName((Node)(object = object2.getDocumentElement())))) {
                            WSDLFactory wSDLFactory = this.getWSDLFactory();
                            Definition definition2 = wSDLFactory.newDefinition();
                            definition2.setDocumentBaseURI(string);
                            definition2.setExtensionRegistry(extensionRegistry);
                            lightWeightSchema2 = (LightWeightSchema)this.parseSchema(clazz, (Element)object, definition2, extensionRegistry);
                        }
                    }
                    schemaReference.setReferencedSchema(lightWeightSchema2);
                }
                catch (WSDLException wSDLException) {
                    throw wSDLException;
                }
                catch (Throwable throwable) {
                    throw new WSDLException("OTHER_ERROR", "An error occurred trying to resolve schema referenced at '" + schemaReference.getSchemaLocationURI() + "'" + (lightWeightSchema.getDocumentBaseURI() == null ? "." : ", relative to '" + lightWeightSchema.getDocumentBaseURI() + "'."), throwable);
                }
            }
            return lightWeightSchema;
        }
        catch (WSDLException wSDLException) {
            if (wSDLException.getLocation() == null) {
                wSDLException.setLocation(XPathUtils.getXPathExprFromNode(element));
            } else {
                String string = XPathUtils.getXPathExprFromNode(element) + wSDLException.getLocation();
                wSDLException.setLocation(string);
            }
            throw wSDLException;
        }
    }

    protected Binding parseBinding(Element element, Definition definition) throws WSDLException {
        Object object;
        Binding binding = null;
        String string = DOMUtils.getAttribute(element, "name");
        QName qName = WSDLReaderImpl.getQualifiedAttributeValue(element, "type", "binding", definition);
        PortType portType = null;
        if (string != null) {
            object = new QName(definition.getTargetNamespace(), string);
            binding = definition.getBinding((QName)object);
            if (binding == null) {
                binding = definition.createBinding();
                binding.setQName((QName)object);
            }
        } else {
            binding = definition.createBinding();
        }
        binding.setUndefined(false);
        if (qName != null) {
            portType = definition.getPortType(qName);
            if (portType == null) {
                portType = definition.createPortType();
                portType.setQName(qName);
                definition.addPortType(portType);
            }
            binding.setPortType(portType);
        }
        object = DOMUtils.getFirstChildElement(element);
        while (object != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, (Node)object)) {
                binding.setDocumentationElement((Element)object);
            } else if (QNameUtils.matches(Constants.Q_ELEM_OPERATION, (Node)object)) {
                binding.addBindingOperation(this.parseBindingOperation((Element)object, portType, definition));
            } else {
                binding.addExtensibilityElement(this.parseExtensibilityElement(Binding.class, (Element)object, definition));
            }
            object = DOMUtils.getNextSiblingElement((Element)object);
        }
        if (binding instanceof AttributeExtensible) {
            this.parseExtensibilityAttributes(element, Binding.class, (AttributeExtensible)((Object)binding), definition);
        }
        return binding;
    }

    protected BindingOperation parseBindingOperation(Element element, PortType portType, Definition definition) throws WSDLException {
        BindingOperation bindingOperation = definition.createBindingOperation();
        String string = DOMUtils.getAttribute(element, "name");
        if (string != null) {
            bindingOperation.setName(string);
        }
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                bindingOperation.setDocumentationElement(element2);
            } else if (QNameUtils.matches(Constants.Q_ELEM_INPUT, element2)) {
                bindingOperation.setBindingInput(this.parseBindingInput(element2, definition));
            } else if (QNameUtils.matches(Constants.Q_ELEM_OUTPUT, element2)) {
                bindingOperation.setBindingOutput(this.parseBindingOutput(element2, definition));
            } else if (QNameUtils.matches(Constants.Q_ELEM_FAULT, element2)) {
                bindingOperation.addBindingFault(this.parseBindingFault(element2, definition));
            } else {
                bindingOperation.addExtensibilityElement(this.parseExtensibilityElement(BindingOperation.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        if (portType != null) {
            BindingOutput bindingOutput;
            String string2;
            BindingInput bindingInput = bindingOperation.getBindingInput();
            String string3 = bindingInput != null ? bindingInput.getName() : null;
            Operation operation = portType.getOperation(string, string3, string2 = (bindingOutput = bindingOperation.getBindingOutput()) != null ? bindingOutput.getName() : null);
            if (operation == null) {
                Input input = definition.createInput();
                Output output = definition.createOutput();
                operation = definition.createOperation();
                operation.setName(string);
                input.setName(string3);
                output.setName(string2);
                operation.setInput(input);
                operation.setOutput(output);
                portType.addOperation(operation);
            }
            bindingOperation.setOperation(operation);
        }
        if (bindingOperation instanceof AttributeExtensible) {
            this.parseExtensibilityAttributes(element, BindingOperation.class, (AttributeExtensible)((Object)bindingOperation), definition);
        }
        return bindingOperation;
    }

    protected BindingInput parseBindingInput(Element element, Definition definition) throws WSDLException {
        BindingInput bindingInput = definition.createBindingInput();
        String string = DOMUtils.getAttribute(element, "name");
        if (string != null) {
            bindingInput.setName(string);
        }
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                bindingInput.setDocumentationElement(element2);
            } else {
                bindingInput.addExtensibilityElement(this.parseExtensibilityElement(BindingInput.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        if (bindingInput instanceof AttributeExtensible) {
            this.parseExtensibilityAttributes(element, BindingInput.class, (AttributeExtensible)((Object)bindingInput), definition);
        }
        return bindingInput;
    }

    protected BindingOutput parseBindingOutput(Element element, Definition definition) throws WSDLException {
        BindingOutput bindingOutput = definition.createBindingOutput();
        String string = DOMUtils.getAttribute(element, "name");
        if (string != null) {
            bindingOutput.setName(string);
        }
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                bindingOutput.setDocumentationElement(element2);
            } else {
                bindingOutput.addExtensibilityElement(this.parseExtensibilityElement(BindingOutput.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        if (bindingOutput instanceof AttributeExtensible) {
            this.parseExtensibilityAttributes(element, BindingOutput.class, (AttributeExtensible)((Object)bindingOutput), definition);
        }
        return bindingOutput;
    }

    protected BindingFault parseBindingFault(Element element, Definition definition) throws WSDLException {
        BindingFault bindingFault = definition.createBindingFault();
        String string = DOMUtils.getAttribute(element, "name");
        if (string != null) {
            bindingFault.setName(string);
        }
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                bindingFault.setDocumentationElement(element2);
            } else {
                bindingFault.addExtensibilityElement(this.parseExtensibilityElement(BindingFault.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        if (bindingFault instanceof AttributeExtensible) {
            this.parseExtensibilityAttributes(element, BindingFault.class, (AttributeExtensible)((Object)bindingFault), definition);
        }
        return bindingFault;
    }

    protected Message parseMessage(Element element, Definition definition) throws WSDLException {
        Object object;
        Message message = null;
        String string = DOMUtils.getAttribute(element, "name");
        if (string != null) {
            object = new QName(definition.getTargetNamespace(), string);
            message = definition.getMessage((QName)object);
            if (message == null) {
                message = definition.createMessage();
                message.setQName((QName)object);
            }
        } else {
            message = definition.createMessage();
        }
        message.setUndefined(false);
        object = DOMUtils.getFirstChildElement(element);
        while (object != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, (Node)object)) {
                message.setDocumentationElement((Element)object);
            } else if (QNameUtils.matches(Constants.Q_ELEM_PART, (Node)object)) {
                message.addPart(this.parsePart((Element)object, definition));
            } else {
                DOMUtils.throwWSDLException((Element)object);
            }
            object = DOMUtils.getNextSiblingElement((Element)object);
        }
        if (message instanceof AttributeExtensible) {
            this.parseExtensibilityAttributes(element, Message.class, (AttributeExtensible)((Object)message), definition);
        }
        return message;
    }

    protected Part parsePart(Element element, Definition definition) throws WSDLException {
        Part part = definition.createPart();
        String string = DOMUtils.getAttribute(element, "name");
        QName qName = WSDLReaderImpl.getQualifiedAttributeValue(element, "element", "message", definition);
        QName qName2 = WSDLReaderImpl.getQualifiedAttributeValue(element, "type", "message", definition);
        if (string != null) {
            part.setName(string);
        }
        if (qName != null) {
            part.setElementName(qName);
        }
        if (qName2 != null) {
            part.setTypeName(qName2);
        }
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                part.setDocumentationElement(element2);
            } else {
                DOMUtils.throwWSDLException(element2);
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        if (part instanceof AttributeExtensible) {
            this.parseExtensibilityAttributes(element, Part.class, (AttributeExtensible)((Object)part), definition);
        }
        return part;
    }

    protected void parseExtensibilityAttributes(Element element, Class clazz, AttributeExtensible attributeExtensible, Definition definition) throws WSDLException {
        List list = attributeExtensible.getNativeAttributeNames();
        Map map = attributeExtensible.getExtensionAttributes();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Object object;
            Attr attr = (Attr)namedNodeMap.item(i);
            String string = attr.getLocalName();
            String string2 = attr.getNamespaceURI();
            String string3 = attr.getPrefix();
            QName qName = new QName(string2, string);
            if (string2 != null && !string2.equals("http://schemas.xmlsoap.org/wsdl/")) {
                if (string2.equals("http://www.w3.org/2000/xmlns/")) continue;
                DOMUtils.registerUniquePrefix(string3, string2, definition);
                object = attr.getValue();
                int n2 = -1;
                ExtensionRegistry extensionRegistry = definition.getExtensionRegistry();
                if (extensionRegistry != null) {
                    n2 = ((PopulatedExtensionRegistry)extensionRegistry).queryExtensionAttributeType(clazz, qName);
                }
                Object object2 = this.parseExtensibilityAttribute(element, n2, (String)object, definition);
                map.put(qName, object2);
                continue;
            }
            if (list.contains(string)) continue;
            object = new WSDLException("INVALID_WSDL", "Encountered illegal extension attribute '" + qName + "'. Extension " + "attributes must be in " + "a namespace other than " + "WSDL's.");
            ((WSDLException)object).setLocation(XPathUtils.getXPathExprFromNode(element));
            throw object;
        }
    }

    protected Object parseExtensibilityAttribute(Element element, int n, String string, Definition definition) throws WSDLException {
        if (n == 1) {
            return DOMUtils.getQName(string, element, definition);
        }
        if (n == 2) {
            return StringUtils.parseNMTokens(string);
        }
        if (n == 3) {
            List list = StringUtils.parseNMTokens(string);
            int n2 = list.size();
            Vector<QName> vector = new Vector<QName>(n2);
            for (int i = 0; i < n2; ++i) {
                String string2 = (String)list.get(i);
                QName qName = DOMUtils.getQName(string2, element, definition);
                vector.add(qName);
            }
            return vector;
        }
        if (n == 0) {
            return string;
        }
        QName qName = null;
        try {
            qName = DOMUtils.getQName(string, element, definition);
        }
        catch (WSDLException wSDLException) {
            qName = new QName(string);
        }
        return qName;
    }

    protected PortType parsePortType(Element element, Definition definition) throws WSDLException {
        Object object;
        PortType portType = null;
        String string = DOMUtils.getAttribute(element, "name");
        if (string != null) {
            object = new QName(definition.getTargetNamespace(), string);
            portType = definition.getPortType((QName)object);
            if (portType == null) {
                portType = definition.createPortType();
                portType.setQName((QName)object);
            }
        } else {
            portType = definition.createPortType();
        }
        portType.setUndefined(false);
        object = DOMUtils.getFirstChildElement(element);
        while (object != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, (Node)object)) {
                portType.setDocumentationElement((Element)object);
            } else if (QNameUtils.matches(Constants.Q_ELEM_OPERATION, (Node)object)) {
                Operation operation = this.parseOperation((Element)object, portType, definition);
                if (operation != null) {
                    portType.addOperation(operation);
                }
            } else {
                DOMUtils.throwWSDLException((Element)object);
            }
            object = DOMUtils.getNextSiblingElement((Element)object);
        }
        if (portType instanceof AttributeExtensible) {
            this.parseExtensibilityAttributes(element, PortType.class, (AttributeExtensible)((Object)portType), definition);
        }
        return portType;
    }

    protected Operation parseOperation(Element element, PortType portType, Definition definition) throws WSDLException {
        Object object;
        Operation operation = null;
        String string = DOMUtils.getAttribute(element, "name");
        String string2 = DOMUtils.getAttribute(element, "parameterOrder");
        Element element2 = DOMUtils.getFirstChildElement(element);
        Vector<String> vector = new Vector<String>();
        Element element3 = null;
        Input input = null;
        Output output = null;
        Vector<Fault> vector2 = new Vector<Fault>();
        boolean bl = true;
        while (element2 != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                element3 = element2;
            } else if (QNameUtils.matches(Constants.Q_ELEM_INPUT, element2)) {
                input = this.parseInput(element2, definition);
                vector.add("input");
            } else if (QNameUtils.matches(Constants.Q_ELEM_OUTPUT, element2)) {
                output = this.parseOutput(element2, definition);
                vector.add("output");
            } else if (QNameUtils.matches(Constants.Q_ELEM_FAULT, element2)) {
                vector2.add(this.parseFault(element2, definition));
            } else {
                DOMUtils.throwWSDLException(element2);
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        if (string != null) {
            Serializable serializable;
            String string3;
            object = input != null ? input.getName() : null;
            operation = portType.getOperation(string, (String)object, string3 = output != null ? output.getName() : null);
            if (operation != null && !operation.isUndefined()) {
                operation = null;
            }
            if (operation != null && object == null && (serializable = operation.getInput()) != null && serializable.getName() != null) {
                operation = null;
            }
            if (operation != null && string3 == null && (serializable = operation.getOutput()) != null && serializable.getName() != null) {
                operation = null;
            }
            if (operation == null) {
                operation = definition.createOperation();
                operation.setName(string);
                bl = false;
            }
        } else {
            operation = definition.createOperation();
            bl = false;
        }
        operation.setUndefined(false);
        if (string2 != null) {
            operation.setParameterOrdering(StringUtils.parseNMTokens(string2));
        }
        if (element3 != null) {
            operation.setDocumentationElement(element3);
        }
        if (input != null) {
            operation.setInput(input);
        }
        if (output != null) {
            operation.setOutput(output);
        }
        if (vector2.size() > 0) {
            object = vector2.iterator();
            while (object.hasNext()) {
                operation.addFault((Fault)object.next());
            }
        }
        object = null;
        if (((Object)vector).equals(STYLE_ONE_WAY)) {
            object = OperationType.ONE_WAY;
        } else if (((Object)vector).equals(STYLE_REQUEST_RESPONSE)) {
            object = OperationType.REQUEST_RESPONSE;
        } else if (((Object)vector).equals(STYLE_SOLICIT_RESPONSE)) {
            object = OperationType.SOLICIT_RESPONSE;
        } else if (((Object)vector).equals(STYLE_NOTIFICATION)) {
            object = OperationType.NOTIFICATION;
        }
        if (object != null) {
            operation.setStyle((OperationType)object);
        }
        if (bl) {
            operation = null;
        }
        if (operation instanceof AttributeExtensible) {
            this.parseExtensibilityAttributes(element, Operation.class, (AttributeExtensible)((Object)operation), definition);
        }
        return operation;
    }

    protected Service parseService(Element element, Definition definition) throws WSDLException {
        Service service = definition.createService();
        String string = DOMUtils.getAttribute(element, "name");
        if (string != null) {
            service.setQName(new QName(definition.getTargetNamespace(), string));
        }
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                service.setDocumentationElement(element2);
            } else if (QNameUtils.matches(Constants.Q_ELEM_PORT, element2)) {
                service.addPort(this.parsePort(element2, definition));
            } else {
                service.addExtensibilityElement(this.parseExtensibilityElement(Service.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        if (service instanceof AttributeExtensible) {
            this.parseExtensibilityAttributes(element, Service.class, (AttributeExtensible)((Object)service), definition);
        }
        return service;
    }

    protected Port parsePort(Element element, Definition definition) throws WSDLException {
        Object object;
        Port port = definition.createPort();
        String string = DOMUtils.getAttribute(element, "name");
        QName qName = WSDLReaderImpl.getQualifiedAttributeValue(element, "binding", "port", definition);
        if (string != null) {
            port.setName(string);
        }
        if (qName != null) {
            object = definition.getBinding(qName);
            if (object == null) {
                object = definition.createBinding();
                object.setQName(qName);
                definition.addBinding((Binding)object);
            }
            port.setBinding((Binding)object);
        }
        object = DOMUtils.getFirstChildElement(element);
        while (object != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, (Node)object)) {
                port.setDocumentationElement((Element)object);
            } else {
                port.addExtensibilityElement(this.parseExtensibilityElement(Port.class, (Element)object, definition));
            }
            object = DOMUtils.getNextSiblingElement((Element)object);
        }
        if (port instanceof AttributeExtensible) {
            this.parseExtensibilityAttributes(element, Port.class, (AttributeExtensible)((Object)port), definition);
        }
        return port;
    }

    protected ExtensibilityElement parseExtensibilityElement(Class clazz, Element element, Definition definition) throws WSDLException {
        QName qName = QNameUtils.newQName(element);
        try {
            ExtensionRegistry extensionRegistry = definition.getExtensionRegistry();
            if (extensionRegistry == null) {
                throw new WSDLException("CONFIGURATION_ERROR", "No ExtensionRegistry set for this Definition, so unable to deserialize a '" + qName + "' element in the " + "context of a '" + clazz.getName() + "'.");
            }
            ExtensionDeserializer extensionDeserializer = extensionRegistry.queryDeserializer(clazz, qName);
            return extensionDeserializer.unmarshall(clazz, qName, element, definition, extensionRegistry);
        }
        catch (WSDLException wSDLException) {
            if (wSDLException.getLocation() == null) {
                wSDLException.setLocation(XPathUtils.getXPathExprFromNode(element));
            }
            throw wSDLException;
        }
    }

    protected Input parseInput(Element element, Definition definition) throws WSDLException {
        Object object;
        Input input = definition.createInput();
        String string = DOMUtils.getAttribute(element, "name");
        QName qName = WSDLReaderImpl.getQualifiedAttributeValue(element, "message", "input", definition);
        if (string != null) {
            input.setName(string);
        }
        if (qName != null) {
            object = definition.getMessage(qName);
            if (object == null) {
                object = definition.createMessage();
                object.setQName(qName);
                definition.addMessage((Message)object);
            }
            input.setMessage((Message)object);
        }
        object = DOMUtils.getFirstChildElement(element);
        while (object != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, (Node)object)) {
                input.setDocumentationElement((Element)object);
            } else {
                DOMUtils.throwWSDLException((Element)object);
            }
            object = DOMUtils.getNextSiblingElement((Element)object);
        }
        if (input instanceof AttributeExtensible) {
            this.parseExtensibilityAttributes(element, Input.class, (AttributeExtensible)((Object)input), definition);
        }
        return input;
    }

    protected Output parseOutput(Element element, Definition definition) throws WSDLException {
        Object object;
        Output output = definition.createOutput();
        String string = DOMUtils.getAttribute(element, "name");
        QName qName = WSDLReaderImpl.getQualifiedAttributeValue(element, "message", "output", definition);
        if (string != null) {
            output.setName(string);
        }
        if (qName != null) {
            object = definition.getMessage(qName);
            if (object == null) {
                object = definition.createMessage();
                object.setQName(qName);
                definition.addMessage((Message)object);
            }
            output.setMessage((Message)object);
        }
        object = DOMUtils.getFirstChildElement(element);
        while (object != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, (Node)object)) {
                output.setDocumentationElement((Element)object);
            } else {
                DOMUtils.throwWSDLException((Element)object);
            }
            object = DOMUtils.getNextSiblingElement((Element)object);
        }
        if (output instanceof AttributeExtensible) {
            this.parseExtensibilityAttributes(element, Output.class, (AttributeExtensible)((Object)output), definition);
        }
        return output;
    }

    protected Fault parseFault(Element element, Definition definition) throws WSDLException {
        Object object;
        Fault fault = definition.createFault();
        String string = DOMUtils.getAttribute(element, "name");
        QName qName = WSDLReaderImpl.getQualifiedAttributeValue(element, "message", "fault", definition);
        if (string != null) {
            fault.setName(string);
        }
        if (qName != null) {
            object = definition.getMessage(qName);
            if (object == null) {
                object = definition.createMessage();
                object.setQName(qName);
                definition.addMessage((Message)object);
            }
            fault.setMessage((Message)object);
        }
        object = DOMUtils.getFirstChildElement(element);
        while (object != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, (Node)object)) {
                fault.setDocumentationElement((Element)object);
            } else {
                DOMUtils.throwWSDLException((Element)object);
            }
            object = DOMUtils.getNextSiblingElement((Element)object);
        }
        if (fault instanceof AttributeExtensible) {
            this.parseExtensibilityAttributes(element, Fault.class, (AttributeExtensible)((Object)fault), definition);
        }
        return fault;
    }

    private static QName getQualifiedAttributeValue(Element element, String string, String string2, Definition definition) throws WSDLException {
        try {
            return DOMUtils.getQualifiedAttributeValue(element, string, string2, false, definition);
        }
        catch (WSDLException wSDLException) {
            if (wSDLException.getFaultCode().equals("NO_PREFIX_SPECIFIED")) {
                String string3 = DOMUtils.getAttribute(element, string);
                return new QName(string3);
            }
            throw wSDLException;
        }
    }

    private static void checkElementName(Element element, QName qName) throws WSDLException {
        if (!QNameUtils.matches(qName, element)) {
            WSDLException wSDLException = new WSDLException("INVALID_WSDL", "Expected element '" + qName + "'.");
            wSDLException.setLocation(XPathUtils.getXPathExprFromNode(element));
            throw wSDLException;
        }
    }

    private Document getDocument(InputSource inputSource, String string) throws WSDLException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        try {
            Object object;
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (this.loc != null && this.getFeature("com.ibm.wsdl.useWSDLLocatorAsEntityResolver")) {
                object = inputSource.getSystemId();
                if (object == null) {
                    object = this.loc.getLatestImportURI();
                    inputSource.setSystemId((String)object);
                }
                EntityResolverAdapter entityResolverAdapter = new EntityResolverAdapter(this.loc, (String)object);
                documentBuilder.setEntityResolver(entityResolverAdapter);
            }
            object = documentBuilder.parse(inputSource);
            return object;
        }
        catch (Throwable throwable) {
            throw new WSDLException("PARSER_ERROR", "Problem parsing '" + string + "'.", throwable);
        }
    }

    public Definition readWSDL(String string) throws WSDLException {
        return this.readWSDL(null, string);
    }

    public Definition readWSDL(String string, String string2) throws WSDLException {
        try {
            if (this.verbose) {
                System.out.println("Retrieving document at '" + string2 + "'" + (string == null ? "." : ", relative to '" + string + "'."));
            }
            URL uRL = string != null ? StringUtils.getURL(null, string) : null;
            URL uRL2 = StringUtils.getURL(uRL, string2);
            InputStream inputStream = StringUtils.getContentAsInputStream(uRL2);
            InputSource inputSource = new InputSource(inputStream);
            Document document = this.getDocument(inputSource, string2);
            inputStream.close();
            Definition definition = this.readWSDL(uRL2.toString(), document);
            return definition;
        }
        catch (WSDLException wSDLException) {
            throw wSDLException;
        }
        catch (Throwable throwable) {
            throw new WSDLException("OTHER_ERROR", "Unable to resolve imported document at '" + string2 + "'.", throwable);
        }
    }

    public Definition readWSDL(String string, Element element) throws WSDLException {
        return this.readWSDL(string, element, null);
    }

    protected Definition readWSDL(String string, Element element, Map map) throws WSDLException {
        return this.parseDefinitions(string, element, map);
    }

    public Definition readWSDL(String string, Document document) throws WSDLException {
        return this.readWSDL(string, document.getDocumentElement());
    }

    public Definition readWSDL(String string, InputSource inputSource) throws WSDLException {
        return this.readWSDL(string, this.getDocument(inputSource, "- WSDL Document -"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition readWSDL(WSDLLocator wSDLLocator) throws WSDLException {
        InputSource inputSource = wSDLLocator.getBaseInputSource();
        String string = wSDLLocator.getBaseURI();
        if (inputSource == null) {
            throw new WSDLException("OTHER_ERROR", "Unable to locate document at '" + string + "'.");
        }
        this.loc = wSDLLocator;
        if (this.verbose) {
            System.out.println("Retrieving document at '" + string + "'.");
        }
        try {
            Definition definition;
            Definition definition2 = definition = this.readWSDL(string, inputSource);
            return definition2;
        }
        finally {
            this.loc = null;
        }
    }
}

