/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.extensions.mime;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.extensions.mime.MIMEConstants;
import com.ibm.wsdl.util.xml.DOMUtils;
import com.ibm.wsdl.util.xml.QNameUtils;
import com.ibm.wsdl.util.xml.XPathUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class MIMEMultipartRelatedSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    public static final long serialVersionUID = 1L;

    public void marshall(Class clazz, QName qName, ExtensibilityElement extensibilityElement, PrintWriter printWriter, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        MIMEMultipartRelated mIMEMultipartRelated = (MIMEMultipartRelated)extensibilityElement;
        if (mIMEMultipartRelated != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/mime/", "multipartRelated", definition);
            if (clazz != null && MIMEPart.class.isAssignableFrom(clazz)) {
                printWriter.print("    ");
            }
            printWriter.print("        <" + string);
            Boolean bl = mIMEMultipartRelated.getRequired();
            if (bl != null) {
                DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, bl.toString(), definition, printWriter);
            }
            printWriter.println('>');
            this.printMIMEParts(mIMEMultipartRelated.getMIMEParts(), printWriter, definition, extensionRegistry);
            if (clazz != null && MIMEPart.class.isAssignableFrom(clazz)) {
                printWriter.print("    ");
            }
            printWriter.println("        </" + string + '>');
        }
    }

    private void printMIMEParts(List list, PrintWriter printWriter, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        if (list != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/mime/", "part", definition);
            for (MIMEPart mIMEPart : list) {
                if (mIMEPart == null) continue;
                printWriter.print("          <" + string);
                Boolean bl = mIMEPart.getRequired();
                if (bl != null) {
                    DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, bl.toString(), definition, printWriter);
                }
                printWriter.println('>');
                List list2 = mIMEPart.getExtensibilityElements();
                if (list2 != null) {
                    for (ExtensibilityElement extensibilityElement : list2) {
                        QName qName = extensibilityElement.getElementType();
                        ExtensionSerializer extensionSerializer = extensionRegistry.querySerializer(MIMEPart.class, qName);
                        extensionSerializer.marshall(MIMEPart.class, qName, extensibilityElement, printWriter, definition, extensionRegistry);
                    }
                }
                printWriter.println("          </" + string + '>');
            }
        }
    }

    public ExtensibilityElement unmarshall(Class clazz, QName qName, Element element, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        MIMEMultipartRelated mIMEMultipartRelated = (MIMEMultipartRelated)extensionRegistry.createExtension(clazz, qName);
        String string = DOMUtils.getAttributeNS(element, "http://schemas.xmlsoap.org/wsdl/", "required");
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches(MIMEConstants.Q_ELEM_MIME_PART, element2)) {
                mIMEMultipartRelated.addMIMEPart(this.parseMIMEPart(MIMEMultipartRelated.class, MIMEConstants.Q_ELEM_MIME_PART, element2, definition, extensionRegistry));
            } else {
                DOMUtils.throwWSDLException(element2);
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        if (string != null) {
            mIMEMultipartRelated.setRequired(new Boolean(string));
        }
        return mIMEMultipartRelated;
    }

    private MIMEPart parseMIMEPart(Class clazz, QName qName, Element element, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        MIMEPart mIMEPart = (MIMEPart)extensionRegistry.createExtension(clazz, qName);
        String string = DOMUtils.getAttributeNS(element, "http://schemas.xmlsoap.org/wsdl/", "required");
        if (string != null) {
            mIMEPart.setRequired(new Boolean(string));
        }
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            try {
                QName qName2 = QNameUtils.newQName(element2);
                ExtensionDeserializer extensionDeserializer = extensionRegistry.queryDeserializer(MIMEPart.class, qName2);
                ExtensibilityElement extensibilityElement = extensionDeserializer.unmarshall(MIMEPart.class, qName2, element2, definition, extensionRegistry);
                mIMEPart.addExtensibilityElement(extensibilityElement);
            }
            catch (WSDLException wSDLException) {
                if (wSDLException.getLocation() == null) {
                    wSDLException.setLocation(XPathUtils.getXPathExprFromNode(element2));
                }
                throw wSDLException;
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        return mIMEPart;
    }
}

