/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.sm.smf;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.Traceable;
import com.ibm.ws390.sm.smf.SmfJActivity;
import com.ibm.ws390.sm.smf.SmfProperty;
import com.ibm.ws390.sm.smf.SmfPropertyVector;
import com.ibm.ws390.sm.smf.SmfWebContainerCookie;
import com.ibm.ws390.sm.smf.SmfWebContainerCookieTable;
import com.ibm.ws390.sm.smf.SmfWebContainerDataCollector;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class SmfWebContainerDataCollectorImpl
implements SmfWebContainerDataCollector,
Traceable {
    private static final int s_initialCapacity = 29;
    private static SmfWebContainerDataCollectorImpl s_instance = null;
    private boolean m_activityRecordingEnabled = SmfJActivity.isContainerActivityRecordingEnabled();
    private boolean m_intervalRecordingEnabled = SmfJActivity.isContainerIntervalRecordingEnabled();
    private Map m_intervalCookieMap = Collections.synchronizedMap(new HashMap(29));
    private int m_liveSessionCount = 0;
    private int m_activeSessionCount = 0;
    private static TraceComponent m_tc = Tr.register("com.ibm.ws390.sm.smf.SmfWebContainerDataCollectorImpl", null, "com.ibm.ws390.sm.smf.SmfWebContainer");

    private SmfWebContainerDataCollectorImpl() {
    }

    protected SmfWebContainerDataCollectorImpl(boolean bl, boolean bl2) {
        this();
        this.m_activityRecordingEnabled = bl;
        this.m_intervalRecordingEnabled = bl2;
    }

    public void activeSessionCount(int n) {
        if (this.m_intervalRecordingEnabled) {
            if (m_tc.isEntryEnabled()) {
                Tr.entry(m_tc, "activeSessionCount", new Integer(n));
            }
            this.m_activeSessionCount = n;
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "activeSessionCount");
            }
        }
    }

    private SmfWebContainerCookie findCurrentCookie() {
        return SmfWebContainerCookieTable.getInstance().findCookie();
    }

    private SmfWebContainerCookie findIntervalCookie(String string) {
        return (SmfWebContainerCookie)this.m_intervalCookieMap.get(string);
    }

    private SmfWebContainerCookie findOrCreateIntervalCookie(String string) {
        SmfWebContainerCookie smfWebContainerCookie = this.findIntervalCookie(string);
        if (smfWebContainerCookie == null) {
            smfWebContainerCookie = new SmfWebContainerCookie(string);
            this.m_intervalCookieMap.put(string, smfWebContainerCookie);
        }
        return smfWebContainerCookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.m_intervalRecordingEnabled) {
            if (m_tc.isEntryEnabled()) {
                Tr.entry(m_tc, "flush");
            }
            SmfPropertyVector smfPropertyVector = new SmfPropertyVector();
            SmfProperty smfProperty = new SmfProperty(0, 7);
            smfPropertyVector.addElement(smfProperty);
            if (this.m_activeSessionCount > 0) {
                smfProperty = new SmfProperty(1, this.m_activeSessionCount);
                smfPropertyVector.addElement(smfProperty);
            }
            if (this.m_liveSessionCount > 0) {
                smfProperty = new SmfProperty(5, this.m_liveSessionCount);
                smfPropertyVector.addElement(smfProperty);
            }
            Map map = this.m_intervalCookieMap;
            synchronized (map) {
                Iterator iterator = this.m_intervalCookieMap.values().iterator();
                SmfWebContainerCookie smfWebContainerCookie = null;
                while (iterator.hasNext()) {
                    smfWebContainerCookie = (SmfWebContainerCookie)iterator.next();
                    while (!smfWebContainerCookie.addTo(smfPropertyVector) || smfPropertyVector.size() > 1) {
                        SmfJActivity smfJActivity = new SmfJActivity();
                        smfJActivity.addGenericEvent(7, smfPropertyVector.toByteArray());
                        smfProperty = new SmfProperty(0, 7);
                        smfPropertyVector.addElement(smfProperty);
                    }
                }
            }
            if (smfPropertyVector.size() > 1 && m_tc.isEventEnabled()) {
                Tr.event(m_tc, "flush internal error: unable to flush all data");
            }
            this.m_activeSessionCount = 0;
            this.m_liveSessionCount = 0;
            this.m_intervalCookieMap.clear();
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "flush");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SmfWebContainerDataCollector getInstance() {
        if (s_instance == null) {
            Class clazz = SmfWebContainerDataCollectorImpl.class;
            synchronized (clazz) {
                if (s_instance == null) {
                    s_instance = new SmfWebContainerDataCollectorImpl();
                }
            }
        }
        return s_instance;
    }

    public void httpSessionCreated() {
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled) {
            SmfWebContainerCookie smfWebContainerCookie;
            if (m_tc.isEntryEnabled()) {
                Tr.entry(m_tc, "httpSessionCreated");
            }
            if ((smfWebContainerCookie = this.findCurrentCookie()) != null) {
                smfWebContainerCookie.incrementHttpSessionCreateCount();
            } else {
                this.traceUnableToFindServlet("httpSessionCreated");
            }
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "httpSessionCreated");
            }
        }
    }

    public void httpSessionFinalized() {
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled) {
            SmfWebContainerCookie smfWebContainerCookie;
            if (m_tc.isEntryEnabled()) {
                Tr.entry(m_tc, "httpSessionFinalized");
            }
            if ((smfWebContainerCookie = this.findCurrentCookie()) != null) {
                smfWebContainerCookie.incrementHttpSessionFinalizeCount();
            } else {
                this.traceUnableToFindServlet("httpSessionFinalized");
            }
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "httpSessionFinalized");
            }
        }
    }

    public void httpSessionInvalidated() {
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled) {
            SmfWebContainerCookie smfWebContainerCookie;
            if (m_tc.isEntryEnabled()) {
                Tr.entry(m_tc, "httpSessionInvalidated");
            }
            if ((smfWebContainerCookie = this.findCurrentCookie()) != null) {
                smfWebContainerCookie.incrementHttpSessionInvalidateCount();
            } else {
                this.traceUnableToFindServlet("httpSessionInvalidated");
            }
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "httpSessionInvalidated");
            }
        }
    }

    public void httpSessionInvalidateTime(int n) {
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled) {
            SmfWebContainerCookie smfWebContainerCookie;
            if (m_tc.isEntryEnabled()) {
                Tr.entry(m_tc, "httpSessionInvalidateTime", new Integer(n));
            }
            if ((smfWebContainerCookie = this.findCurrentCookie()) != null) {
                smfWebContainerCookie.setHttpSessionInvalidateTime(n);
            } else {
                this.traceUnableToFindServlet("httpSessionInvalidateTime");
            }
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "httpSessionInvalidateTime");
            }
        }
    }

    public void httpSessionLifeTime(int n) {
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled) {
            SmfWebContainerCookie smfWebContainerCookie;
            if (m_tc.isEntryEnabled()) {
                Tr.entry(m_tc, "httpSessionLifeTime", new Integer(n));
            }
            if ((smfWebContainerCookie = this.findCurrentCookie()) != null) {
                smfWebContainerCookie.setHttpSessionLifeTime(n);
            } else {
                this.traceUnableToFindServlet("httpSessionLifeTime");
            }
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "httpSessionLifeTime");
            }
        }
    }

    public boolean isSmfRecordingEnabled() {
        return this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled;
    }

    public void liveSessionCount(int n) {
        if (this.m_intervalRecordingEnabled) {
            if (m_tc.isEntryEnabled()) {
                Tr.entry(m_tc, "liveSessionCount", new Integer(n));
            }
            this.m_liveSessionCount = n;
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "liveSessionCount");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void print() {
        System.out.println("SmfWebContainerDataCollector.print:");
        System.out.println("   activityRecordingEnabled: " + this.m_activityRecordingEnabled);
        System.out.println("   intervalRecordingEnabled: " + this.m_intervalRecordingEnabled);
        System.out.println("   activeSessionCount: " + this.m_activeSessionCount);
        System.out.println("   liveSessionCount:   " + this.m_liveSessionCount);
        System.out.println("Interval-related cookies:");
        Map map = this.m_intervalCookieMap;
        synchronized (map) {
            Iterator iterator = this.m_intervalCookieMap.values().iterator();
            SmfWebContainerCookie smfWebContainerCookie = null;
            while (iterator.hasNext()) {
                smfWebContainerCookie = (SmfWebContainerCookie)iterator.next();
                smfWebContainerCookie.print();
            }
        }
    }

    public void servletError(String string, String string2) {
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled) {
            Object object;
            if (m_tc.isEntryEnabled()) {
                object = new Object[]{string, string2};
                Tr.entry(m_tc, "servletError", object);
            }
            if ((object = this.findCurrentCookie()) != null) {
                ((SmfWebContainerCookie)object).processServletError(string, string2);
            } else {
                this.traceUnableToFindServlet("servletError");
            }
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "servletError");
            }
        }
    }

    public void servletLoaded(String string, String string2, long l) {
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled) {
            Object object;
            if (m_tc.isEntryEnabled()) {
                object = new Object[]{string, string2, new Long(l)};
                Tr.entry(m_tc, "servletLoaded", object);
            }
            if ((object = this.findCurrentCookie()) == null) {
                if (this.m_intervalRecordingEnabled) {
                    object = this.findOrCreateIntervalCookie(string);
                } else {
                    if (m_tc.isEntryEnabled()) {
                        Tr.exit(m_tc, "servletLoaded", "Ignore method request: interval recording is not enabled.");
                    }
                    return;
                }
            }
            ((SmfWebContainerCookie)object).processServletLoaded(string, string2, l);
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "servletLoaded");
            }
        }
    }

    public void servletRequestEnds(String string, String string2, long l, int n) {
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled) {
            Object object;
            if (m_tc.isEntryEnabled()) {
                object = new Object[]{string, string2, new Long(l), new Integer(n)};
                Tr.entry(m_tc, "servletRequestEnds", object);
            }
            if ((object = this.findCurrentCookie()) != null) {
                ((SmfWebContainerCookie)object).processServletRequestEnds(string, string2, l, n);
            } else {
                this.traceUnableToFindServlet("servletRequestEnds");
            }
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "servletRequestEnds");
            }
        }
    }

    public void servletRequestBegins(String string, String string2) {
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled) {
            Object object;
            if (m_tc.isEntryEnabled()) {
                object = new Object[]{string, string2};
                Tr.entry(m_tc, "servletRequestBegins", object);
            }
            if ((object = this.findCurrentCookie()) != null) {
                ((SmfWebContainerCookie)object).processServletRequestBegins(string, string2);
            } else {
                this.traceUnableToFindServlet("servletRequestBegins");
            }
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "servletRequestBegins");
            }
        }
    }

    public void servletsLoaded(String string, int n) {
        if (this.m_intervalRecordingEnabled) {
            Object object;
            if (m_tc.isEntryEnabled()) {
                object = new Object[]{string, new Integer(n)};
                Tr.entry(m_tc, "servletsLoaded", object);
            }
            object = this.findOrCreateIntervalCookie(string);
            ((SmfWebContainerCookie)object).setServletLoadCount(n);
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "servletsLoaded");
            }
        }
    }

    public String toTraceString() {
        StringBuffer stringBuffer = new StringBuffer("SmfWebContainerDataCollectorImpl (");
        stringBuffer.append("activityRecordingEnabled=").append(this.m_activityRecordingEnabled).append(", ");
        stringBuffer.append("intervalRecordingEnabled=").append(this.m_intervalRecordingEnabled).append(")");
        return stringBuffer.toString();
    }

    private void traceUnableToFindServlet(String string) {
        if (m_tc.isEventEnabled()) {
            Object[] objectArray = new Object[]{string};
            StringBuffer stringBuffer = new StringBuffer("Method {0}: ");
            stringBuffer.append("Unexpectedly, no SmfWebContainerCookie object could ").append("be found for the current thread.");
            Tr.event(m_tc, stringBuffer.toString(), objectArray);
        }
    }

    public void webContainerDispatchBegins() {
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled) {
            if (m_tc.isEntryEnabled()) {
                Tr.entry(m_tc, "webContainerDispatchBegins");
            }
            SmfWebContainerCookieTable smfWebContainerCookieTable = SmfWebContainerCookieTable.getInstance();
            smfWebContainerCookieTable.findOrCreateCookie();
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "webContainerDispatchBegins");
            }
        }
    }

    public void webContainerDispatchEnds() {
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled) {
            SmfWebContainerCookie smfWebContainerCookie;
            if (m_tc.isEntryEnabled()) {
                Tr.entry(m_tc, "webContainerDispatchEnds");
            }
            if ((smfWebContainerCookie = this.findCurrentCookie()) != null) {
                SmfPropertyVector smfPropertyVector = new SmfPropertyVector();
                SmfProperty smfProperty = new SmfProperty(0, 6);
                smfPropertyVector.addElement(smfProperty);
                while (!smfWebContainerCookie.addTo(smfPropertyVector) || smfPropertyVector.size() > 1) {
                    SmfJActivity smfJActivity = new SmfJActivity();
                    smfJActivity.addGenericEvent(6, smfPropertyVector.toByteArray());
                    smfProperty = new SmfProperty(0, 6);
                    smfPropertyVector.addElement(smfProperty);
                }
                if (smfPropertyVector.size() > 1 && m_tc.isEventEnabled()) {
                    Tr.event(m_tc, "webContainerDispatchEnds internal error: unable to flush all data");
                }
                SmfWebContainerCookieTable.getInstance().removeCookie();
            } else {
                this.traceUnableToFindServlet("webContainerDispatchEnds");
            }
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "webContainerDispatchEnds");
            }
        }
    }
}

