/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.sm.smf;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.Traceable;
import com.ibm.ws390.sm.smf.SmfJActivity;
import com.ibm.ws390.sm.smf.SmfProperty;
import com.ibm.ws390.sm.smf.SmfPropertyVector;
import com.ibm.ws390.sm.smf.SmfServletData;
import java.util.Enumeration;
import java.util.Vector;

public final class SmfWebContainerCookie
implements Traceable {
    private String m_webAppName = "";
    private int m_httpSessionCreateCount = 0;
    private int m_httpSessionFinalizeCount = 0;
    private int m_httpSessionInvalidateCount = 0;
    private int m_httpSessionInvalidateTime = 0;
    private int m_httpSessionLifeTime = 0;
    private int m_servletLoadCount = 0;
    private Vector m_servletDataVector = new Vector();
    private static TraceComponent m_tc = Tr.register("com.ibm.ws390.sm.smf.SmfWebContainerCookie", null, "com.ibm.ws390.sm.smf.SmfWebContainer");
    private Vector m_properties = new Vector(10);
    private boolean m_propertiesInSync = false;
    private int m_propertiesByteSize = 0;

    public SmfWebContainerCookie() {
    }

    protected SmfWebContainerCookie(String string) {
        this();
        this.setWebAppName(string);
    }

    private void addProperty(SmfProperty smfProperty) {
        this.m_properties.addElement(smfProperty);
        this.m_propertiesByteSize += smfProperty.getByteSize();
    }

    protected boolean addTo(SmfPropertyVector smfPropertyVector) {
        boolean bl = true;
        this.resyncProperties();
        if (smfPropertyVector.getRemainingByteArraySize() >= this.m_propertiesByteSize) {
            int n = this.m_properties.size();
            for (int i = 0; i < n; ++i) {
                smfPropertyVector.addElement(this.m_properties.elementAt(i));
            }
            SmfServletData smfServletData = null;
            while (this.m_servletDataVector.size() > 0) {
                smfServletData = (SmfServletData)this.m_servletDataVector.elementAt(0);
                if (smfServletData.addTo(smfPropertyVector)) {
                    this.m_servletDataVector.removeElementAt(0);
                    continue;
                }
                bl = false;
                break;
            }
            this.reset();
            return bl;
        }
        return false;
    }

    private SmfServletData findOrCreateServlet(String string) {
        Enumeration enumeration = null;
        SmfServletData smfServletData = null;
        String string2 = string.length() > 128 ? string.substring(0, 128) : string;
        enumeration = this.m_servletDataVector.elements();
        while (enumeration.hasMoreElements()) {
            smfServletData = (SmfServletData)enumeration.nextElement();
            if (!smfServletData.getName().equals(string2)) continue;
            return smfServletData;
        }
        smfServletData = new SmfServletData(string);
        this.m_servletDataVector.add(smfServletData);
        return smfServletData;
    }

    protected int getHttpSessionCreateCount() {
        return this.m_httpSessionCreateCount;
    }

    protected int getHttpSessionFinalizeCount() {
        return this.m_httpSessionFinalizeCount;
    }

    protected int getHttpSessionInvalidateCount() {
        return this.m_httpSessionInvalidateCount;
    }

    protected int getHttpSessionInvalidateTime() {
        return this.m_httpSessionInvalidateTime;
    }

    protected int getHttpSessionLifeTime() {
        return this.m_httpSessionLifeTime;
    }

    protected int getServletLoadCount() {
        return this.m_servletLoadCount;
    }

    protected String getWebAppName() {
        return this.m_webAppName;
    }

    protected void incrementHttpSessionCreateCount() {
        ++this.m_httpSessionCreateCount;
        this.m_propertiesInSync = false;
    }

    protected void incrementHttpSessionFinalizeCount() {
        ++this.m_httpSessionFinalizeCount;
        this.m_propertiesInSync = false;
    }

    protected void incrementHttpSessionInvalidateCount() {
        ++this.m_httpSessionInvalidateCount;
        this.m_propertiesInSync = false;
    }

    protected void print() {
        System.out.println(this.getWebAppName() + " cookie: print entered");
        System.out.println("  m_httpSessionCreateCount     " + this.m_httpSessionCreateCount);
        System.out.println("  m_httpSessionFinalizeCount   " + this.m_httpSessionFinalizeCount);
        System.out.println("  m_httpSessionInvalidateCount " + this.m_httpSessionInvalidateCount);
        System.out.println("  m_httpSessionInvalidateTime  " + this.m_httpSessionInvalidateTime);
        System.out.println("  m_httpSessionLifeTime        " + this.m_httpSessionLifeTime);
        System.out.println("  m_servletLoadCount           " + this.m_servletLoadCount);
        Enumeration enumeration = null;
        SmfServletData smfServletData = null;
        enumeration = this.m_servletDataVector.elements();
        while (enumeration.hasMoreElements()) {
            smfServletData = (SmfServletData)enumeration.nextElement();
            System.out.println(smfServletData.toString());
        }
    }

    protected void processServletError(String string, String string2) {
        this.setWebAppName(string);
        SmfServletData smfServletData = this.findOrCreateServlet(string2);
        if (smfServletData != null) {
            smfServletData.incrementErrorCount();
        } else {
            this.traceUnableToFindServlet("processServletError", string, string2);
        }
    }

    protected void processServletLoaded(String string, String string2, long l) {
        this.setWebAppName(string);
        SmfServletData smfServletData = this.findOrCreateServlet(string2);
        if (smfServletData != null) {
            smfServletData.incrementLoadCount();
            smfServletData.setLoadedSince(l);
        } else {
            this.traceUnableToFindServlet("processServletLoaded", string, string2);
        }
    }

    protected void processServletRequestEnds(String string, String string2, long l, int n) {
        this.setWebAppName(string);
        SmfServletData smfServletData = this.findOrCreateServlet(string2);
        if (smfServletData != null) {
            smfServletData.setLoadedSince(l);
            smfServletData.setResponseTime(n);
            smfServletData.calculateCpuTime(SmfJActivity.obtainTotalCpuTimeUsed());
        } else {
            this.traceUnableToFindServlet("processServletRequestEnds", string, string2);
        }
    }

    protected void processServletRequestBegins(String string, String string2) {
        this.setWebAppName(string);
        SmfServletData smfServletData = this.findOrCreateServlet(string2);
        if (smfServletData != null) {
            smfServletData.setCpuStartTime(SmfJActivity.obtainTotalCpuTimeUsed());
        } else {
            this.traceUnableToFindServlet("processServletRequestBegins", string, string2);
        }
    }

    private void reset() {
        this.m_httpSessionCreateCount = 0;
        this.m_httpSessionFinalizeCount = 0;
        this.m_httpSessionInvalidateCount = 0;
        this.m_httpSessionInvalidateTime = 0;
        this.m_httpSessionLifeTime = 0;
        this.m_servletLoadCount = 0;
        this.m_propertiesInSync = false;
        this.resyncProperties();
    }

    private void resyncProperties() {
        if (!this.m_propertiesInSync) {
            this.m_properties.clear();
            this.m_propertiesByteSize = 0;
            if (this.m_httpSessionCreateCount > 0) {
                this.addProperty(new SmfProperty(2, this.m_httpSessionCreateCount));
            }
            if (this.m_httpSessionFinalizeCount > 0) {
                this.addProperty(new SmfProperty(3, this.m_httpSessionFinalizeCount));
            }
            if (this.m_httpSessionInvalidateCount > 0) {
                this.addProperty(new SmfProperty(4, this.m_httpSessionInvalidateCount));
            }
            if (this.m_httpSessionInvalidateTime > 0) {
                this.addProperty(new SmfProperty(6, this.m_httpSessionInvalidateTime));
            }
            if (this.m_httpSessionLifeTime > 0) {
                this.addProperty(new SmfProperty(7, this.m_httpSessionLifeTime));
            }
            if (this.m_webAppName.length() > 0 && (this.m_servletLoadCount > 0 || this.m_servletDataVector.size() > 0)) {
                this.addProperty(new SmfProperty(13, this.m_webAppName, null));
                if (this.m_servletLoadCount > 0) {
                    this.addProperty(new SmfProperty(14, this.m_servletLoadCount));
                }
            }
            this.m_propertiesInSync = true;
        }
    }

    protected void setHttpSessionInvalidateTime(int n) {
        if (n >= 0) {
            this.m_httpSessionInvalidateTime = n;
            this.m_propertiesInSync = false;
        }
    }

    protected void setHttpSessionLifeTime(int n) {
        if (n >= 0) {
            this.m_httpSessionLifeTime = n;
            this.m_propertiesInSync = false;
        }
    }

    protected void setServletLoadCount(int n) {
        if (n >= 0) {
            this.m_servletLoadCount = n;
            this.m_propertiesInSync = false;
        }
    }

    protected void setWebAppName(String string) {
        if (string != null) {
            this.m_webAppName = string.length() > 128 ? string.substring(0, 128) : string;
            this.m_propertiesInSync = false;
        }
    }

    public String toTraceString() {
        StringBuffer stringBuffer = new StringBuffer("SmfWebContainerCookie: ");
        stringBuffer.append("web app name: >").append(this.getWebAppName()).append("< ");
        stringBuffer.append("create/finalize/invalidate count: >").append(this.getHttpSessionCreateCount()).append("/").append(this.getHttpSessionFinalizeCount()).append("/").append(this.getHttpSessionInvalidateCount()).append("< ");
        stringBuffer.append("invalidate/life time: >").append(this.getHttpSessionInvalidateTime()).append("/").append(this.getHttpSessionLifeTime()).append("< ");
        return stringBuffer.toString();
    }

    private void traceUnableToFindServlet(String string, String string2, String string3) {
        if (m_tc.isEventEnabled()) {
            Object[] objectArray = new Object[]{string, string2, string3};
            StringBuffer stringBuffer = new StringBuffer("Method {0}");
            stringBuffer.append(" could not find or create SmfServletData object related to");
            stringBuffer.append(" web application {1} and servlet {2}.");
            Tr.event(m_tc, stringBuffer.toString(), objectArray);
        }
    }
}

