/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.sm.smf;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.ServletSessionsPerf;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.ws.pmi.server.PmiCallback;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.modules.ServletSessionsModule;
import com.ibm.ws390.sm.smf.SmfScheduledUpdate;
import com.ibm.ws390.sm.smf.SmfWebContainerDataCollector;
import com.ibm.ws390.sm.smf.SmfWebContainerDataCollectorFactory;
import com.ibm.ws390.sm.smf.SmfWebContainerDataCollectorIntervalManager;

public class SmfServletSessionsModule
implements SmfScheduledUpdate,
ServletSessionsPerf {
    private static SmfWebContainerDataCollectorIntervalManager _intervalManager = SmfWebContainerDataCollectorIntervalManager.getInstance();
    private static SmfWebContainerDataCollector _collector = SmfWebContainerDataCollectorFactory.getInstance();
    private int _activeSessionCount = 0;
    private int _liveSessionCount = 0;
    private long _totalInvalidationTime = 0L;
    private long _totalLifeTime = 0L;
    private int _numInvalidatedSessions = 0;
    private int _numFinalizedSessions = 0;
    private ServletSessionsPerf m_ServletSessionsModule = null;
    private static TraceComponent _tc = Tr.register(SmfServletSessionsModule.class.getName(), "SMF Servlet Sessions Module");

    public SmfServletSessionsModule(String string, PmiCallback pmiCallback) {
        if (!PmiRegistry.isDisabled()) {
            this.m_ServletSessionsModule = new ServletSessionsModule(string, pmiCallback);
        }
        _intervalManager.registerModule(this);
    }

    public void sessionCreated() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.sessionCreated();
            }
            ++this._liveSessionCount;
            _collector.httpSessionCreated();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Tr.error(_tc, "sessionCreated error", throwable);
        }
    }

    public void sessionActivated() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.sessionActivated();
            }
            ++this._activeSessionCount;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void sessionActivated(long l) {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.sessionActivated(l);
            }
            ++this._activeSessionCount;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void sessionInactivated() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.sessionInactivated();
            }
            --this._activeSessionCount;
            if (this._activeSessionCount < 0) {
                this._activeSessionCount = 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void sessionInvalidated(long l) {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.sessionInvalidated(l);
            }
            ++this._numInvalidatedSessions;
            long l2 = System.currentTimeMillis() - l;
            this._totalLifeTime += l2;
            --this._liveSessionCount;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Tr.error(_tc, "sessionInvalidated error", throwable);
        }
    }

    public synchronized void sessionFinalized(long l) {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.sessionFinalized(l);
            }
            ++this._numFinalizedSessions;
            long l2 = System.currentTimeMillis() - l;
            this._totalInvalidationTime += l2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Tr.error(_tc, "sessionFinalized error", throwable);
        }
    }

    public void noRoomForNewSession() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.noRoomForNewSession();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void discardCache() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.discardCache();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void readExternal(long l, long l2) {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.readExternal(l, l2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void writeExternal(long l, long l2) {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.writeExternal(l, l2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void affinityBreak() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.affinityBreak();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void invalidatedViaTimeout() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.invalidatedViaTimeout();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void attempToActiveNonExistSession() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.attempToActiveNonExistSession();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void sessionAdded() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.sessionAdded();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void sessionRemoved() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.sessionRemoved();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void unregister() {
        try {
            if (this.m_ServletSessionsModule != null) {
                this.m_ServletSessionsModule.unregister();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void flushScheduledData() {
        try {
            int n;
            long l;
            _collector.activeSessionCount(this._activeSessionCount);
            _collector.liveSessionCount(this._liveSessionCount);
            if (this._numFinalizedSessions > 0) {
                l = this._totalInvalidationTime / (long)this._numFinalizedSessions;
                for (n = 0; n < this._numFinalizedSessions; ++n) {
                    _collector.httpSessionFinalized();
                    _collector.httpSessionInvalidateTime((int)l);
                }
            }
            this._numFinalizedSessions = 0;
            this._totalInvalidationTime = 0L;
            if (this._numInvalidatedSessions > 0) {
                l = this._totalLifeTime / (long)this._numInvalidatedSessions;
                for (n = 0; n < this._numInvalidatedSessions; ++n) {
                    _collector.httpSessionInvalidated();
                    _collector.httpSessionLifeTime((int)l);
                }
            }
            this._numInvalidatedSessions = 0;
            this._totalLifeTime = 0L;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Tr.error(_tc, "flushScheduledData error", throwable);
        }
    }

    public PmiModule getPmiModule() {
        return (PmiModule)((Object)this.m_ServletSessionsModule);
    }
}

