/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.sm.smf;

import com.ibm.ws390.sm.smf.SmfConst;
import com.ibm.ws390.sm.smf.SmfOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public final class SmfProperty {
    private static final String ENCODING_UNICODE = SmfConst.UNICODE_BE;
    private static final String ENCODING_EBCDIC = SmfConst.EBCDIC;
    private static final String TYPE_INT = "I";
    private static final String TYPE_STRING_UNICODE = "U";
    private static final String TYPE_STRING_EBCDIC = "E";
    private static byte[] TYPE_INT_BA;
    private static byte[] TYPE_STRING_UNICODE_BA;
    private static byte[] TYPE_STRING_EBCDIC_BA;
    private static Hashtable UnicodeStringByteCache;
    private static Hashtable EbcdicStringByteCache;
    private byte[] m_type = null;
    private int m_name = -1;
    private String m_stringValue = "";
    private int m_intValue = 0;
    private int m_bytesStringValue = 0;
    private int m_bytesIntValue = 0;

    private SmfProperty(int n) {
        this.m_name = n;
    }

    public SmfProperty(int n, int n2) {
        this(n);
        this.m_type = TYPE_INT_BA;
        this.m_intValue = n2;
        this.m_bytesIntValue = 4;
        this.m_stringValue = "";
        this.m_bytesStringValue = 0;
    }

    public SmfProperty(int n, String string, String string2) {
        this(n);
        this.m_stringValue = string == null ? "" : string;
        if (string2 == null || string2.equals(ENCODING_UNICODE)) {
            this.m_type = TYPE_STRING_UNICODE_BA;
            this.m_bytesStringValue = 2 * this.m_stringValue.length() + SmfConst.getPaddingByteNumber(ENCODING_UNICODE);
        } else {
            this.m_type = TYPE_STRING_EBCDIC_BA;
            this.m_bytesStringValue = this.m_stringValue.length();
        }
        this.m_intValue = 0;
        this.m_bytesIntValue = 0;
    }

    public int getByteSize() {
        byte[] byArray;
        int n = 0;
        if (this.m_type != null) {
            n = this.m_type.length;
        }
        if (this.m_name > -1 && (byArray = SmfConst.getBytesForNameInt(this.m_name)) != null) {
            n += byArray.length;
        }
        return 12 + n + this.m_bytesIntValue + this.m_bytesStringValue;
    }

    public static final String getEbcdicEncoding() {
        return ENCODING_EBCDIC;
    }

    public int getIntValue() {
        return this.m_intValue;
    }

    public int getName() {
        return this.m_name;
    }

    public String getStringValue() {
        return this.m_stringValue;
    }

    public byte[] getType() {
        return this.m_type;
    }

    public static final String getUnicodeEncoding() {
        return ENCODING_UNICODE;
    }

    public void writeTo(SmfOutputStream smfOutputStream) {
        byte[] byArray;
        if (this.m_type == null) {
            smfOutputStream.putInteger4(0);
        } else {
            smfOutputStream.putInteger4(this.m_type.length);
            smfOutputStream.putBytes(this.m_type);
        }
        if (this.m_name == -1) {
            smfOutputStream.putInteger4(0);
        } else {
            byArray = SmfConst.getBytesForNameInt(this.m_name);
            if (byArray == null) {
                smfOutputStream.putInteger4(0);
            } else {
                smfOutputStream.putInteger4(byArray.length);
                smfOutputStream.putBytes(byArray);
            }
        }
        if (this.m_type[0] == TYPE_INT_BA[0]) {
            smfOutputStream.putInteger4(4);
            smfOutputStream.putInteger4(this.m_intValue);
        } else if (this.m_name == 8 || this.m_name == 15) {
            smfOutputStream.putInteger4(this.m_bytesStringValue);
            smfOutputStream.putString(this.m_stringValue, ENCODING_EBCDIC, this.m_bytesStringValue);
        } else {
            byArray = this.getBytesForString(this.m_stringValue);
            smfOutputStream.putInteger4(byArray.length);
            smfOutputStream.putBytes(byArray);
        }
    }

    private byte[] getBytesForString(String string) {
        if (this.m_type[0] == TYPE_STRING_UNICODE_BA[0]) {
            return this.findOrAddBytes(string, UnicodeStringByteCache);
        }
        return this.findOrAddBytes(string, EbcdicStringByteCache);
    }

    private byte[] findOrAddBytes(String string, Hashtable hashtable) {
        byte[] byArray = (byte[])hashtable.get(string);
        if (byArray == null) {
            byArray = this.convertStringToBytes(string);
            hashtable.put(string, byArray);
        }
        return byArray;
    }

    private byte[] convertStringToBytes(String string) {
        byte[] byArray = null;
        String string2 = this.m_type[0] == TYPE_STRING_UNICODE_BA[0] ? ENCODING_UNICODE : ENCODING_EBCDIC;
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                stringBuffer.append(" ");
            }
            byArray = stringBuffer.toString().getBytes();
        }
        return byArray;
    }

    static {
        try {
            TYPE_INT_BA = TYPE_INT.getBytes(SmfConst.EBCDIC);
            TYPE_STRING_UNICODE_BA = TYPE_STRING_UNICODE.getBytes(SmfConst.EBCDIC);
            TYPE_STRING_EBCDIC_BA = TYPE_STRING_EBCDIC.getBytes(SmfConst.EBCDIC);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        UnicodeStringByteCache = new Hashtable();
        EbcdicStringByteCache = new Hashtable();
    }
}

