/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscommonbnd.AlgorithmMapping;
import com.ibm.etools.webservice.wscommonbnd.AlgorithmURI;
import com.ibm.etools.webservice.wscommonbnd.CallbackHandlerFactory;
import com.ibm.etools.webservice.wscommonbnd.Key;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.KeyStore;
import com.ibm.etools.webservice.wscommonbnd.LDAPCertStore;
import com.ibm.etools.webservice.wscommonbnd.LDAPServer;
import com.ibm.etools.webservice.wscommonbnd.LoginMapping;
import com.ibm.etools.webservice.wscommonbnd.Property;
import com.ibm.etools.webservice.wscommonbnd.TokenValueType;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.webservices.wssecurity.config.AlgorithmMappingConfig;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyLocatorProxy;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.id.TrustedIDEvaluator;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.LDAPCertStoreParameters;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public final class ConfigConstants {
    public static final String TR_GROUP = "Web Services Security";
    public static final String TR_NLSPROPS = "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity";
    public static final String WS_SECURITY_RESOURCE_NAME = "ws-security.xml";
    public static final String WS_SECURITY_DEFAULT_LOCATION = "${USER_INSTALL_ROOT}/properties/ws-security.xml";
    public static final String WS_SECURITY_LOCATION_PROPERTY = "wssecurity.defaultbindings.location";
    public static final String WS_INITIAL_SENDER_ID = "wssecurity.initial.sender.id";
    public static final String BASICAUTH_NONCE = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce";
    public static final String BASICAUTH_NONCE_TIMESTAMP = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.timestamp";
    public static final String BASICAUTH_NONCE_REQUIRED = "com.ibm.ws.wssecurity.config.token.BasicAuth.NonceRequired";
    public static final String BASICAUTH_NONCE_TIMESTAMP_REQUIRED = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.timestampRequired";
    public static final String BASICAUTH_NONCE_MAX_AGE = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.maxAge";
    public static final String BASICAUTH_NONCE_CLOCK_SKEW = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.clockSkew";
    public static final String BASICAUTH_NONCE_CACHE_USED = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.useCache";
    public static final String BASICAUTH_NONCE_CACHE_NAME = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheName";
    public static final String BASICAUTH_NONCE_CACHE_SIZE = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheSize";
    public static final String BASICAUTH_NONCE_CACHE_TIMEOUT = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheTimeout";
    public static final String BASICAUTH_NONCE_LENGTH = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.length";
    public static final String CERTIFICATE_CACHE_USED = "com.ibm.ws.wssecurity.config.token.certificate.useCache";
    public static final String CERTIFICATE_CACHE_NAME = "com.ibm.ws.wssecurity.config.token.certificate.cacheName";
    public static final String CERTIFICATE_CACHE_SIZE = "com.ibm.ws.wssecurity.config.token.certificate.cacheSize";
    public static final String CERTIFICATE_CACHE_TIMEOUT = "com.ibm.ws.wssecurity.config.token.certificate.cacheTimeout";
    public static final String DISTRIBUTED_CONFIG_CACHE_USED = "com.ibm.ws.wssecurity.handler.useConfigCache";
    public static final String CONFIG_CACHENAME = "com.ibm.ws.wssecurity.handler.configCacheName";
    public static final String DISTRIBUTED_CONFIG_CACHE_SIZE = "com.ibm.ws.wssecurity.handler.configCacheSize";
    public static final String DISTRIBUTED_CONFIG_CACHE_TIMETOLIVE = "com.ibm.ws.wssecurity.handler.configCacheTimeToLive";
    public static final String TOKEN_CACHE_USED = "com.ibm.ws.wssecurity.handler.token.useCache";
    public static final String TOKEN_CACHE_NAME = "com.ibm.ws.wssecurity.handler.token.cacheName";
    public static final String TOKEN_CACHE_SIZE = "com.ibm.ws.wssecurity.handler.token.cacheSize";
    public static final String TOKEN_CACHE_TIMEOUT = "com.ibm.ws.wssecurity.handler.token.cacheTimeout";
    public static final String TOKEN_CACHE_CUSHION = "com.ibm.ws.wssecurity.handler.token.cushion";
    public static final boolean DEFAULT_DISTRIBUTED_CONFIG_CACHE_USED = true;
    public static final String DEFAULT_CONFIG_CACHENAME = "WSSReqGeneratorConfigMap";
    public static final int DEFAULT_DISTRIBUTED_CONFIG_CACHE_SIZE = 128;
    public static final int DEFAULT_DISTRIBUTED_CONFIG_CACHE_TIMETOLIVE = 900;
    public static final String WSSREQGEN_CONFIG_KEY = "com.ibm.ws.wssecurity.handler.GenConfigCacheKey";
    public static final String WSSRESCON_CONFIG_KEY = "com.ibm.ws.wssecurity.handler.ConConfigCacheKey";
    public static final String OFFLOAD_ALL_CRYPTO = "com.ibm.ws.wssecurity.handler.OffloadAllCryptography";
    public static final String OFFLOAD_RSA_PUBKEY_CRYPTO = "com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography";
    public static final String HARDWARE_CACHE_SIZE = "com.ibm.ws.wssecurity.handler.hardwareCacheSize";
    public static final int DEFAULT_HARDWARE_CACHE_SIZE = 1000;
    public static final String HARDWARE_CACHE_ENTRY_REFRESH = "com.ibm.ws.wssecurity.handler.hardwareCacheEntryRefreshHours";
    public static final int DEFAULT_HARDWARE_CACHE_ENTRY_REFRESH = 8;
    public static final boolean DEFAULT_NONCE_CACHEUSED = true;
    public static final String DEFAULT_NONCE_CACHENAME = "NonceDistributionCacheMap";
    public static final int DEFAULT_NONCE_CACHESIZE = 1024;
    public static final int MIN_NONCE_CACHESIZE = 16;
    public static final int DEFAULT_NONCE_CACHETIMEOUT = 600;
    public static final int MIN_NONCE_CACHETIMEOUT = 300;
    public static final int DEFAULT_NONCE_LENGTH = 128;
    public static final int MIN_NONCE_LENGTH = 16;
    public static final int DEFAULT_NONCE_MAXAGE = 300;
    public static final int MIN_NONCE_MAXAGE = 300;
    public static final int DEFAULT_NONCE_CLOCKSKEW = 0;
    public static final int MIN_NONCE_CLOCKSKEW = 0;
    public static final boolean DEFAULT_NONCE_DISTRIBUTED = false;
    public static final boolean DEFAULT_CERT_CACHEUSED = true;
    public static final String DEFAULT_CERT_CACHENAME = "WSSCertCache";
    public static final int DEFAULT_CERT_CACHESIZE = 128;
    public static final int MIN_CERT_CACHESIZE = 16;
    public static final int DEFAULT_CERT_CACHETIMEOUT = 900;
    public static final int MIN_CERT_CACHETIMEOUT = 300;
    public static final boolean DEFAULT_TOKEN_CACHEUSED = true;
    public static final String DEFAULT_TOKEN_CACHENAME = "WSSTokenCache";
    public static final int DEFAULT_TOKEN_CACHESIZE = 128;
    public static final int MIN_TOKEN_CACHESIZE = 16;
    public static final int DEFAULT_TOKEN_CACHETIMEOUT = 900;
    public static final int MIN_TOKEN_CACHETIMEOUT = 300;
    public static final int DEFAULT_TOKEN_CUSHION = 600;
    public static final int MIN_TOKEN_CUSHION = 300;
    public static final int DEFAULT_TIMESTAMP_TIMEOUT = 600;
    public static final int MIN_TIMESTAMP_TIMEOUT = 300;
    public static final int DEFAULT_TIMESTAMP_MAXAGE = 300;
    public static final int MIN_TIMESTAMP_MAXAGE = 300;
    public static final int DEFAULT_TIMESTAMP_CLOCKSKEW = 0;
    public static final int MIN_TIMESTAMP_CLOCKSKEW = 0;
    public static final String WSSE_NS = "com.ibm.ws.wssecurity.config.WSSE.Namespace";
    public static final String DEFAULT_CONFIG_REF = "DEFAULT";
    public static final String LOCALTEST_MODE = "com.ibm.ws.wssecurity.config.localtest.on";
    private static final TraceComponent tc = Tr.register(ConfigConstants.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");

    public static String getMessage(String string) {
        return ConfigUtil.getMessage((String)string);
    }

    public static com.ibm.xml.soapsec.token.LoginMapping readLoginMapping(LoginMapping loginMapping, VariableMap variableMap, ClassLoader classLoader) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readLoginMapping", loginMapping);
        }
        if (loginMapping == null) {
            Tr.error(tc, "security.wssecurity.loginmapping.is.null");
            throw new SoapSecurityException(ConfigConstants.getMessage("security.wssecurity.loginmapping.is.null"));
        }
        CallbackHandlerFactory callbackHandlerFactory = loginMapping.getCallbackHandlerFactory();
        String string = callbackHandlerFactory.getClassname();
        Map map = ConfigConstants.getProperties(callbackHandlerFactory.getProperties(), variableMap);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating CallbackHandlerFactory: ", new Object[]{string, map});
        }
        com.ibm.wsspi.wssecurity.auth.callback.CallbackHandlerFactory callbackHandlerFactory2 = (com.ibm.wsspi.wssecurity.auth.callback.CallbackHandlerFactory)ConfigUtil.instantiate((String)string, (Class)com.ibm.wsspi.wssecurity.auth.callback.CallbackHandlerFactory.class, (Map)map, (ClassLoader)classLoader);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CallbackHandlerFactory " + string + " created");
        }
        TokenValueType tokenValueType = loginMapping.getTokenValueType();
        QName qName = null;
        if (tokenValueType != null) {
            qName = new QName(tokenValueType.getUri(), tokenValueType.getLocalName());
        }
        com.ibm.xml.soapsec.token.LoginMapping loginMapping2 = new com.ibm.xml.soapsec.token.LoginMapping(loginMapping.getAuthMethod(), qName, loginMapping.getConfigName(), callbackHandlerFactory2, ConfigConstants.getProperties(loginMapping.getProperties(), variableMap));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readLoginMapping", loginMapping2);
        }
        return loginMapping2;
    }

    public static TrustedIDEvaluator readTrustedIDEvaluator(com.ibm.etools.webservice.wscommonbnd.TrustedIDEvaluator trustedIDEvaluator, VariableMap variableMap, ClassLoader classLoader) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readTrustedIDEvaluator", trustedIDEvaluator);
        }
        if (trustedIDEvaluator == null) {
            Tr.error(tc, "security.wssecurity.trustedidevaluator.is.null");
            throw new SoapSecurityException(ConfigConstants.getMessage("security.wssecurity.trustedidevaluator.is.null"));
        }
        Map map = ConfigConstants.getProperties(trustedIDEvaluator.getProperties(), variableMap);
        String string = trustedIDEvaluator.getClassname();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating TrustedIDEvaluator: ", new Object[]{string, map});
        }
        TrustedIDEvaluator trustedIDEvaluator2 = (TrustedIDEvaluator)ConfigUtil.instantiate((String)string, (Class)TrustedIDEvaluator.class, (Map)map, (ClassLoader)classLoader);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TrustedIDEvaluator " + string + " created");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readTrustedIDEvaluator", trustedIDEvaluator2);
        }
        return trustedIDEvaluator2;
    }

    public static com.ibm.wsspi.wssecurity.config.KeyLocator findKeyLocator(EList eList, String string, VariableMap variableMap, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration, ClassLoader classLoader) throws SoapSecurityException {
        KeyLocatorProxy keyLocatorProxy;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findKeyLocator(" + eList + "," + string + ")");
        }
        com.ibm.wsspi.wssecurity.config.KeyLocator keyLocator = null;
        for (int i = 0; i < eList.size(); ++i) {
            KeyLocator keyLocator2 = (KeyLocator)eList.get(i);
            if (!string.equals(keyLocator2.getName())) continue;
            keyLocatorProxy = ConfigConstants.readKeyLocator(keyLocator2, variableMap);
            if (keyLocatorProxy == null) break;
            keyLocator = keyLocatorProxy.getKeyLocator5(classLoader);
            break;
        }
        if (keyLocator == null && wSSecurityDefaultConfiguration != null && (keyLocatorProxy = wSSecurityDefaultConfiguration.getKeyLocator(string)) != null) {
            keyLocator = keyLocatorProxy.getKeyLocator5(classLoader);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findKeyLocator(EList locators, String locatorRef) returns " + keyLocator);
        }
        return keyLocator;
    }

    public static KeyLocatorProxy readKeyLocator(KeyLocator keyLocator, VariableMap variableMap) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readKeyLocator", keyLocator);
        }
        if (keyLocator == null) {
            Tr.error(tc, "security.wssecurity.keylocator.is.null");
            throw new SoapSecurityException(ConfigConstants.getMessage("security.wssecurity.keylocator.is.null"));
        }
        PrivateCommonConfig.KeyLocatorConfImpl keyLocatorConfImpl = new PrivateCommonConfig.KeyLocatorConfImpl();
        keyLocatorConfImpl._className = keyLocator.getClassname();
        KeyStore keyStore = keyLocator.getKeyStore();
        if (keyStore != null) {
            object = new PrivateCommonConfig.KeyStoreConfImpl();
            ((PrivateCommonConfig.KeyStoreConfImpl)object)._type = keyStore.getType();
            String string = keyStore.getPath();
            if (variableMap != null) {
                string = variableMap.expand(string);
            }
            ((PrivateCommonConfig.KeyStoreConfImpl)object)._path = string;
            ((PrivateCommonConfig.KeyStoreConfImpl)object)._password = keyStore.getStorepass();
            ((PrivateCommonConfig.KeyStoreConfImpl)object)._ksRef = keyStore.getKeyStoreRef();
            keyLocatorConfImpl._keyStore = object;
        }
        object = keyLocator.getKeys();
        int n = object.size();
        for (int i = 0; i < n; ++i) {
            Key key = (Key)object.get(i);
            PrivateCommonConfig.KeyInformationConfImpl keyInformationConfImpl = new PrivateCommonConfig.KeyInformationConfImpl();
            keyInformationConfImpl._alias = key.getAlias();
            keyInformationConfImpl._keypass = key.getKeypass();
            keyInformationConfImpl._name = key.getName();
            keyLocatorConfImpl._keyInformationList.add(keyInformationConfImpl);
        }
        ConfigConstants.getProperties(keyLocatorConfImpl._properties, keyLocator.getProperties(), variableMap);
        KeyLocatorProxy keyLocatorProxy = new KeyLocatorProxy(keyLocatorConfImpl);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyLocator loaded [" + keyLocatorConfImpl + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readKeyLocator", keyLocatorProxy);
        }
        return keyLocatorProxy;
    }

    public static CertStore readLDAPCertStore(LDAPCertStore lDAPCertStore, VariableMap variableMap) throws SoapSecurityException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readLDAPCertStore", lDAPCertStore);
        }
        if (lDAPCertStore == null) {
            Tr.error(tc, "security.wssecurity.ldapCertStore.is.null");
            throw new SoapSecurityException(ConfigConstants.getMessage("security.wssecurity.ldapCertStore.is.null"));
        }
        LDAPServer lDAPServer = lDAPCertStore.getLdapServer();
        if (lDAPServer == null) {
            Tr.error(tc, "security.wssecurity.ldapserver.is.null");
            throw new SoapSecurityException(ConfigConstants.getMessage("security.wssecurity.ldapserver.is.null"));
        }
        String string = lDAPServer.getHost();
        try {
            n = Integer.parseInt(lDAPServer.getPort());
        }
        catch (NumberFormatException numberFormatException) {
            throw SoapSecurityException.format("security.wssecurity.CommonReceiverConfig.s19", lDAPServer.getPort(), (Throwable)numberFormatException);
        }
        String string2 = "LDAP";
        String string3 = lDAPCertStore.getProvider();
        CertStore certStore = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "algorithm=" + string2 + ", provider=" + string3 + ", LDAPServer host=" + string + ", LDAPServer port=" + n);
        }
        LDAPCertStoreParameters lDAPCertStoreParameters = new LDAPCertStoreParameters(string, n);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "LDAPCertStoreParameters: ", new Object[]{lDAPCertStoreParameters});
        }
        try {
            certStore = "".equals(string3) ? CertStore.getInstance(string2, lDAPCertStoreParameters) : CertStore.getInstance(string2, (CertStoreParameters)lDAPCertStoreParameters, string3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw SoapSecurityException.format("security.wssecurity.CommonReceiverConfig.s20", string2);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw SoapSecurityException.format("security.wssecurity.CommonReceiverConfig.s21", lDAPCertStoreParameters.toString());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw SoapSecurityException.format("security.wssecurity.CommonReceiverConfig.s22", string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readLDAPCertStore", certStore);
        }
        return certStore;
    }

    public static AlgorithmMappingConfig readAlgorithmMapping(AlgorithmMapping algorithmMapping, VariableMap variableMap) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readAlgorithmMapping", algorithmMapping);
        }
        if (algorithmMapping == null) {
            Tr.error(tc, "security.wssecurity.algorithmMapping.is.null");
            throw new SoapSecurityException(ConfigConstants.getMessage("security.wssecurity.algorithmMapping.is.null"));
        }
        PrivateCommonConfig.AlgorithmMappingConfImpl algorithmMappingConfImpl = new PrivateCommonConfig.AlgorithmMappingConfImpl();
        algorithmMappingConfImpl._factoryName = algorithmMapping.getFactoryname();
        ConfigConstants.getProperties(algorithmMappingConfImpl._properties, algorithmMapping.getProperties(), variableMap);
        EList eList = algorithmMapping.getAlgorithmURI();
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            AlgorithmURI algorithmURI = (AlgorithmURI)eList.get(i);
            PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
            algorithmConfImpl._algorithm = algorithmURI.getAlgorithm();
            algorithmConfImpl._type = algorithmURI.getType();
            algorithmMappingConfImpl._algorithmURIs.add(algorithmConfImpl._algorithm);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Added an algorithmURI[" + algorithmConfImpl._algorithm + "] as the type [" + algorithmConfImpl._type + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readAlgorithmMapping", algorithmMappingConfImpl);
        }
        return algorithmMappingConfImpl;
    }

    public static Map getProperties(EList eList, VariableMap variableMap) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getProperties(EList, VariableMap):", new Object[]{eList, variableMap});
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (eList != null && !eList.isEmpty()) {
            int n = eList.size();
            for (int i = 0; i < n; ++i) {
                String string;
                EObject eObject;
                Object e = eList.get(i);
                if (e instanceof Property) {
                    eObject = (Property)e;
                    string = variableMap == null ? eObject.getValue() : variableMap.expand(eObject.getValue());
                    hashMap.put(eObject.getName(), string);
                    continue;
                }
                eObject = (com.ibm.etools.webservice.wscommonext.Property)e;
                string = variableMap == null ? eObject.getValue() : variableMap.expand(eObject.getValue());
                hashMap.put(eObject.getName(), string);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getProperties(EList, VariableMap)");
        }
        return hashMap;
    }

    public static void getProperties(Map map, EList eList, VariableMap variableMap) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getProperties(Map, EList, VariableMap):", new Object[]{map, eList, variableMap});
        }
        if (eList != null && !eList.isEmpty()) {
            int n = eList.size();
            for (int i = 0; i < n; ++i) {
                String string;
                EObject eObject;
                Object e = eList.get(i);
                if (e instanceof Property) {
                    eObject = (Property)e;
                    string = variableMap == null ? eObject.getValue() : variableMap.expand(eObject.getValue());
                    map.put(eObject.getName(), string);
                    continue;
                }
                eObject = (com.ibm.etools.webservice.wscommonext.Property)e;
                string = variableMap == null ? eObject.getValue() : variableMap.expand(eObject.getValue());
                map.put(eObject.getName(), string);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getProperties(Map, EList, VariableMap)");
        }
    }

    public static int validNonceCacheTimeout(int n) {
        int n2;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validNonceCacheTimeout(int):", new Object[]{new Integer(n)});
        }
        if ((n2 = n) < 300) {
            n2 = 300;
            Tr.warning(tc, "security.wssecurity.WSEC0116W", (Object)new Object[]{new Integer(n2), new Integer(300)});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validNonceCacheTimeout(int) returns " + n2);
        }
        return n2;
    }

    private static int validNonceMaxAge(int n, int n2) {
        int n3;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validNonceMaxAge(int, int):", new Object[]{new Integer(n), new Integer(n2)});
        }
        if ((n3 = n) < 300 || n3 > n2) {
            n3 = 300;
            Tr.warning(tc, "security.wssecurity.WSEC0118W", (Object)new Object[]{new Integer(n3), new Integer(300), new Integer(n2), new Integer(300)});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validNonceMaxAge(int, int) returns " + n3);
        }
        return n3;
    }

    private static int validNonceClockSkew(int n, int n2) {
        int n3;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validNonceClockSkew(int, int):", new Object[]{new Integer(n), new Integer(n2)});
        }
        if ((n3 = n) < 0 || n3 > n2) {
            n3 = 0;
            Tr.warning(tc, "security.wssecurity.WSEC0119W", (Object)new Object[]{new Integer(n3), new Integer(0), new Integer(n2), new Integer(0)});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validNonceClockSkew(int, int) returns " + n3);
        }
        return n3;
    }

    private static int validNonceCacheSize(int n) {
        int n2;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validNonceCacheSize(int):", new Object[]{new Integer(n)});
        }
        if ((n2 = n) < 16) {
            n2 = 1024;
            Tr.warning(tc, "security.wssecurity.WSEC0124W", (Object)new Object[]{new Integer(n2), new Integer(16), new Integer(1024)});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validNonceCacheSize(int) returns " + n2);
        }
        return n2;
    }

    private static int validNonceLength(int n) {
        int n2;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validNonceLength(int):", new Object[]{new Integer(n)});
        }
        if ((n2 = n) < 16) {
            n2 = 128;
            Tr.warning(tc, "security.wssecurity.WSEC0127W", (Object)new Object[]{new Integer(n2), new Integer(16), new Integer(128)});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validNonceLength(int) returns " + n2);
        }
        return n2;
    }

    public static int processNonceMaxAge(String string, int n) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processNonceMaxAge(String, int):", new Object[]{string, new Integer(n)});
        }
        int n2 = 300;
        if (string != null && (string = string.trim()).length() != 0) {
            try {
                int n3 = Integer.parseInt(string);
                n2 = ConfigConstants.validNonceMaxAge(n3, n);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 300;
                FFDCFilter.processException(numberFormatException, ConfigConstants.class.getName() + ".processNonceMaxAge", "692");
                Tr.warning(tc, "security.wssecurity.WSEC0117W", (Object)new Object[]{string, new Integer(300)});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processNonceMaxAge(String, int) returns " + n2);
        }
        return n2;
    }

    public static int processNonceClockSkew(String string, int n) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processNonceClockSkew(String, int):", new Object[]{string, new Integer(n)});
        }
        int n2 = 0;
        if (string != null && (string = string.trim()).length() != 0) {
            try {
                int n3 = Integer.parseInt(string);
                n2 = ConfigConstants.validNonceClockSkew(n3, n);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
                FFDCFilter.processException(numberFormatException, ConfigConstants.class.getName() + ".processNonceClockSkew", "720");
                Tr.warning(tc, "security.wssecurity.WSEC0120W", (Object)new Object[]{string, new Integer(0)});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processNonceClockSkew(String, int) returns " + n2);
        }
        return n2;
    }

    public static int processNonceCacheSize(String string) {
        int n;
        block5: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "processNonceCacheSize(String):", new Object[]{string});
            }
            n = 1024;
            if (string != null && (string = string.trim()).length() != 0) {
                try {
                    int n2 = Integer.parseInt(string);
                    n = ConfigConstants.validNonceCacheSize(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 1024;
                    FFDCFilter.processException(numberFormatException, ConfigConstants.class.getName() + ".processNonceCacheSize", "748");
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "WARNING: Exception occurred during parsing the Nonce (randomly generated value) cache size" + string + ", default value " + 1024 + " is used instead.");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processNonceCacheSize(String) returns " + n);
        }
        return n;
    }

    public static int processNonceLength(String string) {
        int n;
        block5: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "processNonceLength(String):", new Object[]{string});
            }
            n = 128;
            if (string != null && (string = string.trim()).length() != 0) {
                try {
                    int n2 = Integer.parseInt(string);
                    n = ConfigConstants.validNonceCacheSize(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 128;
                    FFDCFilter.processException(numberFormatException, ConfigConstants.class.getName() + ".processNonceLength", "779");
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "WARNING: Exception occurred during parsing the Nonce (randomly generated value) length" + string + ", default value " + 128 + " is used instead.");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processNonceLength(String) returns " + n);
        }
        return n;
    }

    public static int validCertCacheTimeout(int n) {
        int n2;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validCertCacheTimeout(int):", new Object[]{new Integer(n)});
        }
        if ((n2 = n) < 300) {
            n2 = 300;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The certificate cache timeout " + n2 + " seconds is less than the minimum, the minimum " + 300 + " seconds is used instead.");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validCertCacheTimeout(int) returns " + n2);
        }
        return n2;
    }

    public static int validCertCacheSize(int n) {
        int n2;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validCertCacheSize(int):", new Object[]{new Integer(n)});
        }
        if ((n2 = n) < 16) {
            n2 = 128;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified certificate cache size " + n2 + " is less than the allowed minimum " + 16 + ", the default " + 128 + " is used.");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validCertCacheSize(int) returns " + n2);
        }
        return n2;
    }

    public static int processCertCacheSize(String string) {
        int n;
        block5: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "processCertCacheSize(String):", new Object[]{string});
            }
            n = 128;
            if (string != null && (string = string.trim()).length() != 0) {
                try {
                    int n2 = Integer.parseInt(string);
                    n = ConfigConstants.validCertCacheSize(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 128;
                    FFDCFilter.processException(numberFormatException, ConfigConstants.class.getName() + ".processCertCacheSize", "856");
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "WARNING: Exception occurred during parsing the certificate cache size" + string + ", default value " + 128 + " is used instead.");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processCertCacheSize(String) returns " + n);
        }
        return n;
    }

    public static int validTokenCacheTimeout(int n) {
        int n2;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validTokenCacheTimeout(int):", new Object[]{new Integer(n)});
        }
        if ((n2 = n) < 300) {
            n2 = 300;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The token cache timeout " + n2 + " seconds is less than the minimum, the minimum " + 300 + " seconds is used instead.");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validTokenCacheTimeout(int) returns " + n2);
        }
        return n2;
    }

    public static int validTokenCacheSize(int n) {
        int n2;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validTokenCacheSize(int):", new Object[]{new Integer(n)});
        }
        if ((n2 = n) < 16) {
            n2 = 128;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified token cache size " + n2 + " is less than the allowed minimum " + 16 + ", the default " + 128 + " is used.");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validTokenCacheSize(int) returns " + n2);
        }
        return n2;
    }

    public static int processTokenCacheSize(String string) {
        int n;
        block5: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "processTokenCacheSize(String):", new Object[]{string});
            }
            n = 128;
            if (string != null && (string = string.trim()).length() != 0) {
                try {
                    int n2 = Integer.parseInt(string);
                    n = ConfigConstants.validTokenCacheSize(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 128;
                    FFDCFilter.processException(numberFormatException, ConfigConstants.class.getName() + ".processTokenCacheSize", "974");
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "WARNING: Exception occurred during parsing the token cache size" + string + ", default value " + 128 + " is used instead.");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processTokenCacheSize(String) returns " + n);
        }
        return n;
    }

    public static long validTokenCushion(long l) {
        long l2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validTokenCushion(long cushion = " + l + ")");
        }
        if ((l2 = l) < 300000L) {
            l2 = 300000L;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The token cushion " + l + " milliseconds is less than the minimum. The minimum " + l2 + " milliseconds is used instead.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validTokenCushion(long) returns " + l2);
        }
        return l2;
    }

    public static int validTimestampTimeout(int n) {
        int n2;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validTimestampTimeout(int):", new Object[]{new Integer(n)});
        }
        if ((n2 = n) < 300) {
            n2 = 300;
            Tr.warning(tc, "security.wssecurity.WSEC0139W", (Object)new Object[]{new Integer(n2), new Integer(300)});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validTimestampTimeout(int) returns " + n2);
        }
        return n2;
    }

    private static int validTimestampMaxAge(int n, int n2) {
        int n3;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validTimestampMaxAge(int, int):", new Object[]{new Integer(n), new Integer(n2)});
        }
        if ((n3 = n) < 300 || n3 > n2) {
            n3 = 300;
            Tr.warning(tc, "security.wssecurity.WSEC0141W", (Object)new Object[]{new Integer(n3), new Integer(300), new Integer(n2), new Integer(300)});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validTimestampMaxAge(int, int) returns " + n3);
        }
        return n3;
    }

    private static int validTimestampClockSkew(int n, int n2) {
        int n3;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validTimestampClockSkew(int, int):", new Object[]{new Integer(n), new Integer(n2)});
        }
        if ((n3 = n) < 0 || n3 > n2) {
            n3 = 0;
            Tr.warning(tc, "security.wssecurity.WSEC0142W", (Object)new Object[]{new Integer(n3), new Integer(0), new Integer(n2), new Integer(0)});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validTimestampClockSkew(int, int) returns " + n3);
        }
        return n3;
    }

    public static int processTimestampMaxAge(String string, int n) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processTimestampMaxAge(String, int):", new Object[]{string, new Integer(n)});
        }
        int n2 = 300;
        if (string != null && (string = string.trim()).length() != 0) {
            try {
                int n3 = Integer.parseInt(string);
                n2 = ConfigConstants.validTimestampMaxAge(n3, n);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 300;
                FFDCFilter.processException(numberFormatException, ConfigConstants.class.getName() + ".processTimestampMaxAge", "947");
                Tr.warning(tc, "security.wssecurity.WSEC0140W", (Object)new Object[]{string, new Integer(300)});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processTimestampMaxAge(String, int) returns " + n2);
        }
        return n2;
    }

    public static int processTimestampClockSkew(String string, int n) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processTimestampClockSkew(String, int):", new Object[]{string, new Integer(n)});
        }
        int n2 = 0;
        if (string != null && (string = string.trim()).length() != 0) {
            try {
                int n3 = Integer.parseInt(string);
                n2 = ConfigConstants.validTimestampClockSkew(n3, n);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
                FFDCFilter.processException(numberFormatException, ConfigConstants.class.getName() + ".processTimestampClockSkew", "975");
                Tr.warning(tc, "security.wssecurity.WSEC0143W", (Object)new Object[]{string, new Integer(0)});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processTimestampClockSkew(String, int) returns " + n2);
        }
        return n2;
    }

    public static long processHardwareCacheEntryRefresh(String string) {
        long l;
        block6: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "processHardwareCacheEntryRefresh(String):", new Object[]{string});
            }
            l = 0L;
            if (string != null && (string = string.trim()).length() != 0) {
                try {
                    int n = Integer.parseInt(string);
                    if (n >= 0) {
                        l = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    l = 0L;
                    FFDCFilter.processException(numberFormatException, ConfigConstants.class.getName() + ".processHardwareCacheEntryRefresh", "1147");
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "WARNING: Exception occurred during parsing the hardware cache refresh time" + string + ", cache entry refresh disabled.");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processHardwareCacheEntryRefresh(String) returns " + l);
        }
        return l;
    }

    public static int processHardwareCacheSize(String string) {
        int n;
        block6: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "processHardwareCacheSize(String):", new Object[]{string});
            }
            n = 1000;
            if (string != null && (string = string.trim()).length() != 0) {
                try {
                    int n2 = Integer.parseInt(string);
                    if (n2 >= 0) {
                        n = n2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    n = 1000;
                    FFDCFilter.processException(numberFormatException, ConfigConstants.class.getName() + ".processHardwareCacheSize", "1180");
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "WARNING: Exception occurred during parsing the hardware cache size" + string + ", default value " + 1000 + " is used instead.");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processHardwareCacheSize(String) returns " + n);
        }
        return n;
    }

    public static String getWSSENS(SOAPMessageContext sOAPMessageContext) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSSENS(SOAPMessageContext)");
        }
        if ((string = (String)sOAPMessageContext.getProperty("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace")) == null || string.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No WSSE namespace found in MessageContext, use default");
            }
            string = Constants.NS_WSSE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSSENS(SOAPMessageContext) returns " + string);
        }
        return string;
    }

    public static String getWSUNS(SOAPMessageContext sOAPMessageContext) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSUNS(SOAPMessageContext)");
        }
        if ((string = (String)sOAPMessageContext.getProperty("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace")) == null || string.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No WSU namespace found in MessageContext, use default");
            }
            string = Constants.NS_WSU;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSUNS(SOAPMessageContext) returns " + string);
        }
        return string;
    }
}

