/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public final class ClientVariableMap
implements com.ibm.ws.runtime.service.VariableMap {
    private Map variables;
    private String state = "state";
    private static final String comp = "security.wssecurity";
    private static final String clsName = ClientVariableMap.class.getName();
    private static final TraceComponent tc = Tr.register(ClientVariableMap.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final com.ibm.ws.runtime.service.VariableMap instance = new ClientVariableMap();

    public static com.ibm.ws.runtime.service.VariableMap getInstance() {
        return instance;
    }

    public String expand(String string) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ClientVariableMap", string);
        }
        String string2 = string;
        try {
            string2 = this.substitute(string, this.variables);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, this.getClass().getName() + ".expand", "64", this);
            Tr.warning(tc, "security.wssecurity.variable.cannot.expanded", (Object)new Object[]{string, exception});
            string2 = string;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ClientVariableMap", string2);
        }
        return string2;
    }

    public boolean refresh() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refresh");
            Tr.exit(tc, "refresh");
        }
        return true;
    }

    public String getName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getName");
            Tr.exit(tc, "getName");
        }
        return clsName;
    }

    public String getState() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getState");
            Tr.exit(tc, "getState");
        }
        return this.state;
    }

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.state = "initialize";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        this.state = "destroy";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        this.state = "start";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        this.state = "stop";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public void addVariableMap(Resource resource) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addVariableMap");
        }
        if (resource != null) {
            EList eList = resource.getContents();
            for (int i = 0; i < eList.size(); ++i) {
                VariableMap variableMap = (VariableMap)eList.get(i);
                EList eList2 = variableMap.getEntries();
                for (int j = 0; j < eList2.size(); ++j) {
                    VariableSubstitutionEntry variableSubstitutionEntry = (VariableSubstitutionEntry)eList2.get(j);
                    this.variables.put(variableSubstitutionEntry.getSymbolicName(), variableSubstitutionEntry.getValue());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addVariableMap");
        }
    }

    private String substitute(String string, Map map) throws IllegalArgumentException {
        if (string == null) {
            return null;
        }
        return this.expand(string, 0, string.length(), map, new HashMap());
    }

    private String expand(String string, int n, int n2, Map map, Map map2) throws IllegalArgumentException {
        StringBuffer stringBuffer = new StringBuffer();
        block4: for (int i = n; i < n2; ++i) {
            int n3 = string.indexOf(36, i);
            this.append(stringBuffer, string, i, n3 - i);
            if (n3 == -1) break;
            i = n3 + 1;
            if (i >= n2) continue;
            switch (string.charAt(i)) {
                case '$': {
                    stringBuffer.append('$');
                    continue block4;
                }
                case '(': 
                case '{': {
                    char c = string.charAt(i);
                    char c2 = c == '(' ? (char)')' : '}';
                    int n4 = i + 1;
                    int n5 = string.indexOf(c2, n4);
                    if (n5 == -1) {
                        throw new IllegalArgumentException("unterminated variable reference");
                    }
                    i = this.indexOf(string, '$', n4, n5);
                    if (i != -1) {
                        n4 = i + 1;
                        int n6 = 0;
                        for (i = n4; i < string.length(); ++i) {
                            char c3 = string.charAt(i);
                            if (c3 == c) {
                                ++n6;
                                continue;
                            }
                            if (c3 == c2 && --n6 < 0) break;
                        }
                        if (n6 < 0) {
                            this.expand(string, n4, i, map, map2);
                        }
                    } else {
                        i = n5;
                    }
                    this.referenceVariable(stringBuffer, string, n4, n5 - n4, map, map2);
                    continue block4;
                }
                default: {
                    char c = string.charAt(i);
                    if (Character.isWhitespace(c)) continue block4;
                    this.referenceVariable(stringBuffer, string, i, 1, map, map2);
                }
            }
        }
        return stringBuffer.toString();
    }

    private void append(StringBuffer stringBuffer, String string, int n, int n2) {
        if (n2 < 0) {
            n2 = string.length() - n;
        }
        stringBuffer.ensureCapacity(stringBuffer.length() + n2);
        n2 += n;
        for (int i = n; i < n2; ++i) {
            stringBuffer.append(string.charAt(i));
        }
    }

    private int indexOf(String string, char c, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (string.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    private String expand(String string, Map map, Map map2) throws IllegalArgumentException {
        return this.expand(string, 0, string.length(), map, map2);
    }

    private String recursivelyExpand(String string, Map map, Map map2) throws IllegalArgumentException {
        if (map2.get(string) != null) {
            throw new IllegalArgumentException("Recursive variable: " + string);
        }
        map2.put(string, string);
        String string2 = (String)map.get(string);
        String string3 = this.expand(string2, map, map2);
        map2.remove(string);
        return string3;
    }

    private void referenceVariable(StringBuffer stringBuffer, String string, int n, int n2, Map map, Map map2) throws IllegalArgumentException {
        String string2 = string.substring(n, n + n2);
        String string3 = (String)map.get(string2);
        if (string3 == null) {
            throw new IllegalArgumentException("undefined variable: " + string2);
        }
        String string4 = this.recursivelyExpand(string2, map, map2);
        stringBuffer.append(string4);
    }

    private ClientVariableMap() {
        String string;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ClientVariableMap");
        }
        this.variables = new HashMap<Object, Object>(System.getProperties());
        Iterator iterator = this.variables.keySet().iterator();
        HashMap hashMap = new HashMap(this.variables.size());
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            string = string2.replace('.', '_');
            hashMap.put(string, this.variables.get(string2));
        }
        this.variables.putAll(hashMap);
        string2 = (String)this.variables.get("USER_INSTALL_ROOT");
        if (string2 == null || string2.length() == 0) {
            string2 = (String)this.variables.get("user_install_root");
            if (string2 == null || string2.length() == 0) {
                string = (String)this.variables.get("WAS_INSTALL_ROOT");
                if (string == null || string.length() == 0) {
                    string = (String)this.variables.get("was_install_root");
                }
                if (string == null || string.length() == 0) {
                    Tr.error(tc, "security.wssecurity.was.install.root.isnull");
                } else {
                    this.variables.put("WAS_INSTALL_ROOT", string);
                    this.variables.put("USER_INSTALL_ROOT", string);
                    this.variables.put("user_install_root", string);
                    this.variables.put("user.install.root", string);
                }
            } else {
                this.variables.put("USER_INSTALL_ROOT", string2);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Variables:", this.variables);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ClientVariableMap");
        }
    }
}

