/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.token;

import com.ibm.ISecurityUtilityImpl.SecurityServer;
import com.ibm.WebSphereSecurityImpl.SecurityServerImpl;
import com.ibm.websphere.security.UserMapping;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Permission;
import java.security.cert.X509Certificate;
import javax.security.auth.login.LoginException;

public class UserRegistryProcessor {
    private static final TraceComponent tc = Tr.register((Class)UserRegistryProcessor.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = UserRegistryProcessor.class.getName();
    private static UserMapping _userMapping;
    private static final String USERMAPPING_IMPL = "com.ibm.ws.security.core.UserMappingImpl";
    private static final Permission PERM;

    public static boolean checkRegistry(String string, char[] cArray) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkRegistry()");
        }
        boolean bl = false;
        try {
            SecurityServer securityServer;
            ContextManager contextManager = ContextManagerFactory.getInstance();
            if (contextManager != null && (securityServer = SecServer.instance) != null) {
                if (tc.isDebugEnabled()) {
                    String string2 = cArray == null ? "null" : "not mull";
                    Tr.debug((TraceComponent)tc, (String)("Username [" + string + "], password [" + string2 + "]"));
                }
                bl = securityServer.simple_authenticate(new BasicAuthData(string, new String(cArray)));
            }
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, (String)(clsName + ".checkRegistry"), (String)"%C");
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.UserRegistryProcessor.s01", (Object)new Object[]{string, exception});
            throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.UserRegistryProcessor.s01", (String[])new String[]{string, exception.toString()}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkRegistry() returns boolean[" + bl + "]"));
        }
        return bl;
    }

    public static boolean checkUsername(String string) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkUsername(String username[" + string + "])"));
        }
        boolean bl = false;
        try {
            ContextManager contextManager = ContextManagerFactory.getInstance();
            if (contextManager != null) {
                SecurityServer securityServer = SecServer.instance;
                if (securityServer != null && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Username [" + string + "]"));
                }
                UserRegistry userRegistry = securityServer.getRegistry(contextManager.getDefaultRealm());
                bl = userRegistry.isValidUser(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("registry.isValidUser() [" + string + "] = " + bl));
                }
                if (!bl) {
                    String string2 = userRegistry.getUserSecurityName(string);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("registry.getUserSecurityName()=" + string2));
                    }
                    bl = userRegistry.isValidUser(string2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("registry.isValidUser() [" + string2 + "] = " + bl));
                    }
                }
            }
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, (String)(clsName + ".checkUsername"), (String)"%C");
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.UserRegistryProcessor.s02", (Object)new Object[]{string, exception});
            throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.UserRegistryProcessor.s02", (String[])new String[]{string, exception.toString()}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkUsername(String username) returns boolean[" + bl + "]"));
        }
        return bl;
    }

    static String mapCertificate(X509Certificate x509Certificate) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("mapCertificate(X509Certificate [" + x509Certificate + "])"));
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(PERM);
        }
        String string = null;
        UserMapping userMapping = _userMapping;
        if (userMapping != null) {
            try {
                string = userMapping.mapCertificateToName(new X509Certificate[]{x509Certificate});
            }
            catch (Exception exception) {
                Tr.processException((Throwable)exception, (String)(clsName + ".mapCertificate"), (String)"84");
                Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5185W", (Object)new Object[]{x509Certificate.getSubjectDN().getName(), exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("mapCertificate(X509Certificate) returns " + string));
        }
        return string;
    }

    static {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"UserMapping Init");
        }
        if (ContextManagerFactory.getInstance().isServerSecurityEnabled() && WSSecurityPlatformContextFactory.getInstance().isServer()) {
            try {
                Class clazz = UserRegistryProcessor.class;
                Class<?> clazz2 = Class.forName(USERMAPPING_IMPL);
                _userMapping = (UserMapping)clazz2.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                Tr.processException((Throwable)classNotFoundException, (String)(clsName + ".getUserMapping"), (String)"183");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5186E", (Object)new Object[]{USERMAPPING_IMPL, classNotFoundException});
            }
            catch (IllegalAccessException illegalAccessException) {
                Tr.processException((Throwable)illegalAccessException, (String)(clsName + ".getUserMapping"), (String)"186");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5188E", (Object)new Object[]{USERMAPPING_IMPL, illegalAccessException});
            }
            catch (Exception exception) {
                Tr.processException((Throwable)exception, (String)(clsName + ".getUserMapping"), (String)"189");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5187E", (Object)new Object[]{USERMAPPING_IMPL, exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"UserMapping Init");
        }
        PERM = new WebSphereRuntimePermission("wssecurity.WSUserRegistry.mapCertificate");
    }

    private static class SecServer {
        private static SecurityServer instance;

        private SecServer() {
        }

        private static void init() {
            try {
                instance = new SecurityServerImpl();
            }
            catch (Exception exception) {
                Tr.processException((Throwable)exception, (String)(clsName + ".SecServer.init"), (String)"58");
                throw new ExceptionInInitializerError(exception);
            }
        }

        static {
            SecServer.init();
        }
    }
}

