/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.proxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.SOAPPart;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.proxy.MessageFactory;
import com.ibm.xml.soapsec.proxy.MessageProxy;
import com.ibm.xml.soapsec.util.DOMUtil;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class MessageFactoryImpl
extends MessageFactory {
    private static final TraceComponent tc = Tr.register(MessageFactoryImpl.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = MessageFactoryImpl.class.getName();

    public MessageFactoryImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MessageFactoryImpl");
            Tr.exit(tc, "MessageFactoryImpl");
        }
    }

    public MessageProxy create(Document document, MessageProxy messageProxy) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create");
        }
        Message message = (Message)messageProxy.get();
        SOAPPart sOAPPart = (SOAPPart)message.getSOAPPart();
        String string = messageProxy.getCharEncoding();
        try {
            sOAPPart.setContent(DOMUtil.toString((Node)document, (String)string));
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException(sOAPException, clsName + ".create", "51");
            Tr.error(tc, "security.wssecurity.WSEC0132E", sOAPException);
            throw SoapSecurityException.format("security.wssecurity.WSEC0132E", sOAPException.getMessage(), (Throwable)sOAPException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create");
        }
        return MessageProxy.getInstance((Object)message);
    }
}

