/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.keyinfo;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSComponent;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.STRReferenceContentGenerator;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class X509IssuerContentGenerator
implements KeyInfoContentGeneratorComponent {
    private static final TraceComponent tc = Tr.register((Class)X509IssuerContentGenerator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = X509IssuerContentGenerator.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public Key getKey(Document document, Element element, Map map, Map map2) throws SoapSecurityException {
        Object object;
        WSSComponent wSSComponent;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getKey(Document doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)element) + "]," + "Map type," + "Map context)"));
        }
        KeyInfoContentGeneratorConfig keyInfoContentGeneratorConfig = (KeyInfoContentGeneratorConfig)map2.remove("com.ibm.wsspi.wssecurity.config.keyinfoContentGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyInfoContentGeneratorConfig [" + keyInfoContentGeneratorConfig + "]."));
        }
        if (!ConfigUtil.isKeyInfoX509issuer((String)keyInfoContentGeneratorConfig.getKeyInfoType())) {
            String string = (String)map.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
            boolean bl = WSSecurityPlatformContextFactory.getInstance().isServer();
            StringBuffer stringBuffer = new StringBuffer(clsName).append(" expects KeyInfo's type [X509ISSUER],");
            stringBuffer.append(" but the type requested in the configuration is [").append(keyInfoContentGeneratorConfig.getKeyInfoType()).append("].");
            stringBuffer.append(" Please make sure the KeyInfo used for");
            if ("SigningKey".equals(string)) {
                stringBuffer.append(" siganture");
            } else {
                stringBuffer.append(" encryption");
            }
            stringBuffer.append(" in the");
            if (bl) {
                stringBuffer.append(" response generator configuration.");
            } else {
                stringBuffer.append(" request generator configuration.");
            }
            throw new SoapSecurityException(stringBuffer.toString());
        }
        int n = 0;
        Object v = map2.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        String string = Constants.NAMESPACES[0][n];
        map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, keyInfoContentGeneratorConfig.getKeyInfoType());
        map2.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, keyInfoContentGeneratorConfig.getKeyInfoType());
        if (keyInfoContentGeneratorConfig.getKeyName() == null) {
            map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF);
            map2.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF);
        } else {
            map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF, keyInfoContentGeneratorConfig.getKeyName());
            map2.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF, keyInfoContentGeneratorConfig.getKeyName());
        }
        String string2 = null;
        String string3 = null;
        TokenGeneratorConfig tokenGeneratorConfig = keyInfoContentGeneratorConfig.getTokenGenerator();
        if (tokenGeneratorConfig != null) {
            wSSComponent = tokenGeneratorConfig.getInstance();
            if (wSSComponent == null) {
                throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey01");
            }
            map2.put("com.ibm.wsspi.wssecurity.config.tokenGenerator.configKey", tokenGeneratorConfig);
            object = STRReferenceContentGenerator.getSecurityElement(document, element, n, string, map2);
            wSSComponent.invoke(document, (Element)object, map2);
            string2 = (String)map2.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERNAME);
            string3 = (String)map2.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERSERIAL);
        }
        if ((wSSComponent = keyInfoContentGeneratorConfig.getKeyLocator()) == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey03");
        }
        if (string2 != null) {
            map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERNAME, string2);
        } else {
            map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERNAME);
        }
        if (string3 != null) {
            map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERSERIAL, string3);
        } else {
            map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERSERIAL);
        }
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMBID);
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_REFERENCE);
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID);
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME);
        object = wSSComponent.getKey(map, map2);
        if (string2 == null) {
            string2 = (String)map2.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERNAME);
            string3 = (String)map2.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERSERIAL);
        }
        String string4 = DOMUtil.getNamespacePrefix((Element)element, (String)string);
        boolean bl = false;
        if (string4 == null) {
            bl = true;
            string4 = "wsse:";
        } else if (string4.length() > 0) {
            string4 = string4 + ":";
        }
        Element element2 = document.createElementNS(string, string4 + "SecurityTokenReference");
        if (bl) {
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", string);
        }
        if ((string4 = DOMUtil.getNamespacePrefix((Element)element, (String)Constants.NS_DSIG)) == null) {
            bl = true;
            string4 = "ds:";
        } else if (string4.length() > 0) {
            string4 = string4 + ":";
        }
        Element element3 = document.createElementNS(Constants.NS_DSIG, string4 + "X509Data");
        element3 = (Element)element2.appendChild(element3);
        Element element4 = document.createElementNS(Constants.NS_DSIG, string4 + "X509IssuerSerial");
        element4 = (Element)element3.appendChild(element4);
        Element element5 = document.createElementNS(Constants.NS_DSIG, string4 + "X509IssuerName");
        element5 = (Element)element4.appendChild(element5);
        Text text = document.createTextNode(string2);
        text = (Text)element5.appendChild(text);
        Element element6 = document.createElementNS(Constants.NS_DSIG, string4 + "X509SerialNumber");
        element6 = (Element)element4.appendChild(element6);
        Text text2 = document.createTextNode(string3);
        text2 = (Text)element6.appendChild(text2);
        element2 = (Element)element.appendChild(element2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKey(Document doc,Element parent,Map type,Map context) returns Key[" + object + "]"));
        }
        return object;
    }
}

