/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler.token;

import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.webservices.wssecurity.handler.token.CacheEntry;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

class TokenCache
implements AlarmListener {
    private static final TraceComponent tc = Tr.register((Class)TokenCache.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = TokenCache.class.getName();
    private static final String comp = "security.wssecurity";
    private Hashtable _table;
    private Hashtable _secondaryTable;
    private Hashtable _tertiaryTable;
    private int _minSize = 0;
    private boolean _wipeCache;
    private Alarm _defaultAlarm;

    public TokenCache(String string, int n, int n2, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("TokenCache(String cacheName[" + string + "]," + "int size[" + n + "]," + "int timeout[" + n2 + "]," + "boolean wipeCache[" + bl + "]," + "boolean cacheDistributed[" + bl2 + "]"));
        }
        this._defaultAlarm = new Alarm(n2);
        this._table = new Hashtable(n);
        this._secondaryTable = new Hashtable(n);
        this._tertiaryTable = new Hashtable(n);
        this._minSize = n;
        this._wipeCache = bl;
        this.addAlarmListener(this, n2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"TokenCache(String cacheName, int size, int timeout, boolean wipeCache, boolean cacheDistributed");
        }
    }

    public Object get(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("get(Object key[" + object + "]"));
            Tr.debug((TraceComponent)tc, (String)("key class is " + object.getClass().getName()));
        }
        Object object2 = null;
        Hashtable hashtable = null;
        CacheEntry cacheEntry = (CacheEntry)this._table.get(object);
        if (cacheEntry == null) {
            cacheEntry = (CacheEntry)this._secondaryTable.get(object);
            if (cacheEntry == null) {
                cacheEntry = (CacheEntry)this._tertiaryTable.get(object);
                if (cacheEntry != null) {
                    hashtable = this._tertiaryTable;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found cached token corresponding the key [" + object + "] in the tertiary table."));
                    }
                }
            } else {
                hashtable = this._secondaryTable;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found cached token corresponding the key [" + object + "] in the secondary table."));
                }
            }
            if (cacheEntry != null) {
                this._table.put(object, cacheEntry);
                hashtable.remove(object);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Found cached token corresponding the key [" + object + "] in the firs table."));
        }
        if (cacheEntry != null) {
            object2 = cacheEntry.getValue();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("get(Object key) returns Object[" + cacheEntry + "]"));
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("put(Object key[" + object + "], Object value[" + object2 + "]"));
            Tr.debug((TraceComponent)tc, (String)("key class is " + object.getClass().getName()));
        }
        if (object != null && object2 != null) {
            Serializable serializable;
            if (tc.isEntryEnabled() && (this._table.size() + this._secondaryTable.size() + this._tertiaryTable.size()) % 100 == 0) {
                serializable = new StringBuffer(this.getClass().getName());
                ((StringBuffer)serializable).append(" number of entries: ");
                ((StringBuffer)serializable).append(this._table.size() + this._secondaryTable.size() + this._tertiaryTable.size());
                Tr.debug((TraceComponent)tc, (String)((StringBuffer)serializable).toString());
            }
            serializable = this._table;
            synchronized (serializable) {
                this._table.put(object, new CacheEntry(object, object2));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Cached the specified token corresponding the key [" + object + "] in the secondary table."));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"put(Object key, Object value)");
        }
    }

    protected void mark() {
        if (this._wipeCache) {
            this._tertiaryTable.clear();
        } else {
            this._tertiaryTable.putAll(this._secondaryTable);
        }
        this._secondaryTable = this._table;
        this._table = new Hashtable(this._minSize > this._secondaryTable.size() ? this._minSize : this._secondaryTable.size() + 100);
    }

    public void alarm(Object object) {
        long l = System.currentTimeMillis();
        this.mark();
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
            stringBuffer.append(" Time elapsed cleaning cache: ");
            stringBuffer.append(System.currentTimeMillis() - l);
            stringBuffer.append(" milliseconds, Primary cache size: ");
            stringBuffer.append(this._table.size());
            stringBuffer.append(", Secondary cache size: ");
            stringBuffer.append(this._secondaryTable.size());
            stringBuffer.append(", Tertiary cache size: ");
            stringBuffer.append(this._tertiaryTable.size());
            Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
        }
    }

    private void addAlarmListener(AlarmListener alarmListener, long l) {
        if (l == this._defaultAlarm.getTimeout()) {
            this._defaultAlarm.addAlarmListener(alarmListener);
        } else {
            Alarm alarm = new Alarm(l);
            alarm.addAlarmListener(alarmListener);
        }
    }

    private class Alarm
    implements AlarmListener {
        private Vector alarms = new Vector();
        private long timeout;

        public void addAlarmListener(AlarmListener alarmListener) {
            this.alarms.addElement(alarmListener);
        }

        public Alarm(long l) {
            this.timeout = l / 2L;
            this.alarm(null);
        }

        public void alarm(Object object) {
            for (int i = 0; i < this.alarms.size(); ++i) {
                ((AlarmListener)this.alarms.elementAt(i)).alarm(object);
            }
            AlarmManager.create(this.timeout, this);
        }

        public long getTimeout() {
            return this.timeout * 2L;
        }
    }
}

