/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.LoginBinding;
import com.ibm.etools.webservice.wscbnd.SecurityRequestSenderBindingConfig;
import com.ibm.etools.webservice.wscext.LoginConfig;
import com.ibm.etools.webservice.wscext.SecurityRequestSenderServiceConfig;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.Property;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonext.AddCreatedTimeStamp;
import com.ibm.etools.webservice.wscommonext.ConfidentialPart;
import com.ibm.etools.webservice.wscommonext.Confidentiality;
import com.ibm.etools.webservice.wscommonext.IDAssertion;
import com.ibm.etools.webservice.wscommonext.Integrity;
import com.ibm.etools.webservice.wscommonext.Reference;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.webservices.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.util.ClientVariableMap;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.xml.soapsec.confimpl.PrivateSenderConfig;
import com.ibm.xml.soapsec.enc.EncryptionSettings;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Duration;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class WSEMFRequestSenderConfig
extends PrivateSenderConfig {
    private String wsseNS = com.ibm.xml.soapsec.Constants.NS_WSSE;
    private String wsuNS = com.ibm.xml.soapsec.Constants.NS_WSU;
    private String origin = "non-ws-security";
    private static final TraceComponent tc = Tr.register(WSEMFRequestSenderConfig.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSEMFRequestSenderConfig.class.getName();

    public WSEMFRequestSenderConfig(SecurityRequestSenderBindingConfig securityRequestSenderBindingConfig, SecurityRequestSenderServiceConfig securityRequestSenderServiceConfig, String string, VariableMap variableMap, WSSecurityService wSSecurityService) throws SoapSecurityException {
        this(securityRequestSenderBindingConfig, securityRequestSenderServiceConfig, string, variableMap, wSSecurityService, null);
    }

    public WSEMFRequestSenderConfig(SecurityRequestSenderBindingConfig securityRequestSenderBindingConfig, SecurityRequestSenderServiceConfig securityRequestSenderServiceConfig, String string, VariableMap variableMap, WSSecurityService wSSecurityService, ClassLoader classLoader) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFRequestSenderConfig(SecurityRequestSenderBindingConfig, SecurityRequestSenderServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader):", new Object[]{securityRequestSenderBindingConfig, securityRequestSenderServiceConfig, string, variableMap, wSSecurityService, classLoader});
        }
        this.init(securityRequestSenderBindingConfig, securityRequestSenderServiceConfig, string, variableMap, wSSecurityService, classLoader);
        this.origin = "ws-security";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSEMFRequestSenderConfig()");
        }
    }

    WSEMFRequestSenderConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFRequestSenderConfig()");
            Tr.exit(tc, "WSEMFRequestSenderConfig()");
        }
    }

    final void init(SecurityRequestSenderBindingConfig securityRequestSenderBindingConfig, SecurityRequestSenderServiceConfig securityRequestSenderServiceConfig, String string, VariableMap variableMap, WSSecurityService wSSecurityService, ClassLoader classLoader) throws SoapSecurityException {
        Constructor<?> constructor;
        EObject eObject;
        Object object;
        EObject eObject2;
        String string2;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        EObject eObject3;
        int n;
        String string3;
        Object object7;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(SecurityRequestSenderBindingConfig, SecurityRequestSenderServiceConfig, actorURI, VariableMap, Object, ClassLoader):", new Object[]{securityRequestSenderBindingConfig, securityRequestSenderServiceConfig, string, variableMap, wSSecurityService, classLoader});
        }
        AddCreatedTimeStamp addCreatedTimeStamp = null;
        Confidentiality confidentiality = null;
        Integrity integrity = null;
        LoginConfig loginConfig = null;
        IDAssertion iDAssertion = null;
        Map map = null;
        String string4 = null;
        if (variableMap == null) {
            variableMap = ClientVariableMap.getInstance();
        }
        WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration = null;
        if (wSSecurityService != null && (object7 = wSSecurityService.getConfig()) instanceof WSSecurityDefaultConfiguration) {
            wSSecurityDefaultConfiguration = (WSSecurityDefaultConfiguration)object7;
        }
        if (securityRequestSenderServiceConfig != null) {
            confidentiality = securityRequestSenderServiceConfig.getConfidentiality();
            integrity = securityRequestSenderServiceConfig.getIntegrity();
            string4 = securityRequestSenderServiceConfig.getActor();
            loginConfig = securityRequestSenderServiceConfig.getLoginConfig();
            iDAssertion = securityRequestSenderServiceConfig.getIdAssertion();
            addCreatedTimeStamp = securityRequestSenderServiceConfig.getAddCreatedTimeStamp();
            object7 = securityRequestSenderServiceConfig.getProperties();
            map = ConfigConstants.getProperties((EList)object7, variableMap);
            if (tc.isDebugEnabled()) {
                if (map != null) {
                    Tr.debug(tc, "Request Sender Service Config(Confidentiality, Integrity, Actor, LoginConfig, IdAssertion, AddCreatedTimeStamp, Properties):", new Object[]{confidentiality, integrity, string4, loginConfig, iDAssertion, addCreatedTimeStamp, map});
                } else {
                    Tr.debug(tc, "Request Sender Service Config(Confidentiality, Integrity, Actor, LoginConfig, IdAssertion, AddCreatedTimeStamp):", new Object[]{confidentiality, integrity, string4, loginConfig, iDAssertion, addCreatedTimeStamp});
                }
            }
        }
        if (!((ConfigValidation)(object7 = new ConfigValidation(variableMap, wSSecurityDefaultConfiguration))).confidentialityValid(confidentiality)) {
            throw new SoapSecurityException("Invalid Confidentiality");
        }
        if (!((ConfigValidation)object7).integrityValid(integrity)) {
            throw new SoapSecurityException("Invalid Integrity");
        }
        if (!((ConfigValidation)object7).idAssertionValid(iDAssertion)) {
            throw new SoapSecurityException("Invalid IDAssertion");
        }
        if (string != null) {
            string3 = string.trim();
            if (string3.length() != 0) {
                this.myactor = string3;
            }
        } else {
            this.myactor = null;
        }
        if (string4 != null) {
            string3 = string4.trim();
            if (string3.length() != 0) {
                this.targetactor = string3;
            }
        } else {
            this.targetactor = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "actorURI = " + this.myactor + ", actor = " + this.targetactor);
        }
        if (addCreatedTimeStamp != null) {
            this.enableCreatedTimestamp = addCreatedTimeStamp.isFlag();
            string3 = addCreatedTimeStamp.getExpires();
            if (string3 != null && string3.length() > 0) {
                try {
                    this.duration = Duration.parse((String)string3);
                }
                catch (ParseException parseException) {
                    String string5 = "security.wssecurity.CommonSenderConfig.sconf07";
                    FFDCFilter.processException((Throwable)parseException, clsName + ".WSEMFRequestSenderConfig", "205", (Object)this);
                    Tr.error(tc, string5, string3);
                    throw SoapSecurityException.format(string5, string3, (Throwable)parseException);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addCreatedTimeStamp = " + this.enableCreatedTimestamp + ", expires = " + addCreatedTimeStamp.getExpires() + ", duration = " + this.duration);
            }
        }
        if (integrity != null) {
            int n2 = integrity.getReferences().size();
            for (n = 0; n < n2; ++n) {
                eObject3 = (Reference)integrity.getReferences().get(n);
                object6 = eObject3.getPart();
                object5 = ((AbstractEnumerator)object6).getName();
                this.integralParts.add(object5);
                if (!((String)object5).equals("securitytoken")) continue;
                this.isSecTokenSigned = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "integrity constraints = " + this.integralParts + "signed security token = " + this.isSecTokenSigned);
            }
        }
        if (confidentiality != null) {
            int n3 = confidentiality.getConfidentialParts().size();
            for (n = 0; n < n3; ++n) {
                eObject3 = (ConfidentialPart)confidentiality.getConfidentialParts().get(n);
                object6 = eObject3.getPart();
                object5 = ((AbstractEnumerator)object6).getName();
                this.confidentialParts.add(object5);
                if (!((String)object5).equals("usernametoken")) continue;
                this.isUsernameTokenEncrypted = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "confidentiality constraints = " + this.confidentialParts + "encrypt username token = " + this.isUsernameTokenEncrypted);
            }
        }
        if (iDAssertion != null) {
            this.idType = iDAssertion.getIdType();
            this.idType = this.idType == null ? this.idType : this.idType.trim();
            this.trustMode = iDAssertion.getTrustMode();
            String string6 = this.trustMode = this.trustMode == null ? this.trustMode : this.trustMode.trim();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IDType = " + this.idType + "Trust Mode = " + this.trustMode);
            }
        }
        this.nonceManager = NonceManagerFactory.getInstance();
        if (loginConfig != null) {
            this.authMethod = loginConfig.getAuthMethod().trim();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AuthMethod = " + this.authMethod);
            }
            if (map != null && !map.isEmpty()) {
                String string7 = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce");
                if (string7 != null) {
                    if ((string7 = string7.trim()).length() != 0) {
                        this.addNonce = Boolean.valueOf(string7);
                        if (this.addNonce) {
                            if (!"BasicAuth".equals(this.authMethod)) {
                                this.addNonce = false;
                                this.addNonceTimestamp = false;
                                Tr.warning(tc, "security.wssecurity.WSEC0113W", (Object)new Object[]{this.authMethod});
                            } else {
                                this.addNonceTimestamp = true;
                            }
                        }
                    }
                } else {
                    this.addNonce = false;
                    this.addNonceTimestamp = false;
                }
                if ((string7 = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.timestamp")) != null && (string7 = string7.trim()).length() != 0) {
                    this.addNonceTimestamp = Boolean.valueOf(string7);
                    if (this.addNonceTimestamp && !this.addNonce) {
                        this.addNonceTimestamp = false;
                        Tr.warning(tc, "security.wssecurity.WSEC0114W");
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nonce enabled: " + this.addNonce + ", Nonce timestamp: " + this.addNonceTimestamp);
            }
        }
        EncryptionInfo encryptionInfo = null;
        EList eList = null;
        eObject3 = null;
        object6 = null;
        object5 = null;
        if (securityRequestSenderBindingConfig != null) {
            encryptionInfo = securityRequestSenderBindingConfig.getEncryptionInfo();
            eList = securityRequestSenderBindingConfig.getKeyLocators();
            eObject3 = securityRequestSenderBindingConfig.getLoginBinding();
            object6 = securityRequestSenderBindingConfig.getSigningInfo();
            object4 = securityRequestSenderBindingConfig.getProperties();
            if (object4 != null) {
                object5 = ConfigConstants.getProperties((EList)object4, variableMap);
            }
            if (tc.isDebugEnabled()) {
                if (object5 != null) {
                    Tr.debug(tc, "Request Sender Service Config (EncryptionInfo, KeyLocators, LoginBinding, SigningInfo, Properties):", new Object[]{encryptionInfo, eList, eObject3, object6, object5});
                } else {
                    Tr.debug(tc, "Request Sender Service Config (EncryptionInfo, KeyLocators, LoginBinding, SigningInfo):", new Object[]{encryptionInfo, eList, eObject3, object6});
                }
            }
            if (object5 != null || object5.size() != 0) {
                object3 = (String)object5.get("com.ibm.ws.wssecurity.config.WSSE.Namespace");
                if (object3 != null && ((String)object3).length() != 0) {
                    if (!NamespaceUtil.isWsse((String)object3)) {
                        throw SoapSecurityException.format("security.wssecurity.WSEC0152E", (String)object3);
                    }
                    this.wsseNS = object3;
                    this.wsuNS = NamespaceUtil.getCorrespondingWSUNS((String)this.wsseNS);
                }
                object2 = (String)object5.get(Constants.WSSECURITY_INCLUSIVE_NAMESPACES);
                this.inclusiveNamespaces = ConfigUtil.isTrue((String)object2);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Namespace configured to be used to send the request, wsse=" + this.wsseNS + ", wsu=" + this.wsuNS);
            }
        }
        if (!((ConfigValidation)object7).senderSigningInfoValid((SigningInfo)object6, null, null, integrity)) {
            throw new SoapSecurityException("Invalid sender SigningInfo");
        }
        if (!((ConfigValidation)object7).encryptionInfoValid(encryptionInfo, eList, confidentiality)) {
            throw new SoapSecurityException("Invalid EncryptionInfo");
        }
        if (!((ConfigValidation)object7).loginBindingValid((LoginBinding)eObject3, loginConfig)) {
            throw new SoapSecurityException("Invalid LoginBinding");
        }
        if (encryptionInfo != null) {
            object4 = encryptionInfo.getName();
            object3 = encryptionInfo.getEncryptionKey();
            object2 = null;
            string2 = null;
            if (object3 != null) {
                object2 = object3.getName();
                string2 = object3.getLocatorRef();
            }
            eObject2 = encryptionInfo.getEncryptionMethod();
            object = null;
            if (eObject2 != null) {
                object = eObject2.getAlgorithm();
            }
            eObject = encryptionInfo.getKeyEncryptionMethod();
            String string8 = null;
            if (eObject != null) {
                string8 = eObject.getAlgorithm();
            }
            constructor = ConfigConstants.findKeyLocator(eList, string2, variableMap, wSSecurityDefaultConfiguration, classLoader);
            if (object == null || object2 == null || constructor == null) {
                String string9 = "security.wssecurity.IncompleteEncryptionInfo";
                if (object == null) {
                    Tr.warning(tc, string9, "Data Encryption Algorithm");
                }
                if (object2 == null) {
                    Tr.warning(tc, string9, "Encryption Key Name");
                }
                if (constructor == null) {
                    Tr.warning(tc, string9, "Key Locator");
                }
            }
            this.encryptionSettings = new EncryptionSettings((String)object, string8, (String)object2, (KeyLocator)((Object)constructor));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Encryption Info Name = " + (String)object4 + "Encryption Key Name = " + (String)object2 + "Encryption KeyLocatorRef = " + string2 + "Encryption Data Algorithm = " + (String)object + "Encryption Key Algorithm = " + string8);
            }
        }
        if (eObject3 != null) {
            object4 = null;
            object3 = null;
            object2 = null;
            string2 = null;
            eObject2 = eObject3.getBasicAuth();
            if (eObject2 != null) {
                object3 = eObject2.getUserid();
                object2 = eObject2.getPassword().toCharArray();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Basic-Auth(" + (String)object3 + ", XXXXXXXX)");
                }
            }
            if ((object = eObject3.getTokenValueType()) != null) {
                this.tokenValueType = new QName(object.getUri(), object.getLocalName());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TokenValue(" + object.getUri() + ", " + object.getLocalName() + ")");
                }
            }
            object4 = eObject3.getCallbackHandler();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CallbackHandler Class Name = " + (String)object4);
            }
            int n4 = eObject3.getProperties().size();
            for (int i = 0; i < n4; ++i) {
                constructor = (Property)eObject3.getProperties().get(i);
                if (variableMap == null) {
                    string2.put(constructor.getName(), constructor.getValue());
                } else {
                    string2.put(constructor.getName(), variableMap.expand(constructor.getValue()));
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "CallbackHandler Properties = " + string2);
            }
            if (object4 != null) {
                try {
                    Class<?> clazz = Class.forName((String)object4);
                    constructor = clazz.getConstructor(String.class, [C.class, Map.class);
                    this.callbackHandler = (CallbackHandler)constructor.newInstance(object3, object2, string2);
                }
                catch (Exception exception) {
                    throw SoapSecurityException.format(com.ibm.xml.soapsec.Constants.getQName((String)this.getWSSENS(), (String)"InvalidSecurity"), "security.wssecurity.RequestSenderConfig.token28", exception.toString());
                }
            }
        }
        if (object6 != null) {
            object4 = object6.getCanonicalizationMethod();
            object3 = null;
            if (object4 == null) {
                Tr.warning(tc, "security.wssecurity.nocanonicalization.algo");
            } else {
                object3 = object4.getAlgorithm();
            }
            this.c14nMethod = object3;
            object2 = object6.getSignatureMethod();
            string2 = null;
            if (object2 == null) {
                Tr.warning(tc, "security.wssecurity.nosignature.algo");
            } else {
                string2 = object2.getAlgorithm();
            }
            this.signatureMethod = string2;
            eObject2 = object6.getDigestMethod();
            object = null;
            if (eObject2 == null) {
                Tr.warning(tc, "security.wssecurity.nodigest.algo");
            } else {
                object = eObject2.getAlgorithm();
            }
            this.digestMethod = object;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Signature Canonicalization Algorithm = " + this.c14nMethod + "Signature Algorithm = " + this.signatureMethod + "Signature Digest Algorithm = " + this.digestMethod);
            }
            if ((eObject = object6.getSigningKey()) != null) {
                String string10 = eObject.getLocatorRef();
                this.keyName = eObject.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Signature Keyname = " + this.keyName + "Signature KeyLocatorRef = " + string10);
                }
                this.keyLocator = ConfigConstants.findKeyLocator(eList, string10, variableMap, wSSecurityDefaultConfiguration, classLoader);
            }
        }
        this.processPrivateConfig(DOMUtil.getPrivateConfig((boolean)true));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    final String getOrigin() {
        return this.origin;
    }

    final String getWSSENS() {
        return this.wsseNS;
    }

    final String getWSUNS() {
        return this.wsuNS;
    }
}

