/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wsbnd.SecurityRequestReceiverBindingConfig;
import com.ibm.etools.webservice.wscommonbnd.CertPathSettings;
import com.ibm.etools.webservice.wscommonbnd.CertStoreList;
import com.ibm.etools.webservice.wscommonbnd.CollectionCertStore;
import com.ibm.etools.webservice.wscommonbnd.DataEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.DigestMethod;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.LDAPCertStore;
import com.ibm.etools.webservice.wscommonbnd.LoginMapping;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchor;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchorRef;
import com.ibm.etools.webservice.wscommonbnd.TrustAnyCertificate;
import com.ibm.etools.webservice.wscommonbnd.TrustedIDEvaluator;
import com.ibm.etools.webservice.wscommonbnd.TrustedIDEvaluatorRef;
import com.ibm.etools.webservice.wscommonbnd.X509Certificate;
import com.ibm.etools.webservice.wscommonext.AddReceivedTimestamp;
import com.ibm.etools.webservice.wscommonext.AuthMethod;
import com.ibm.etools.webservice.wscommonext.ConfidentialPart;
import com.ibm.etools.webservice.wscommonext.IDAssertion;
import com.ibm.etools.webservice.wscommonext.Reference;
import com.ibm.etools.webservice.wscommonext.RequiredConfidentiality;
import com.ibm.etools.webservice.wscommonext.RequiredIntegrity;
import com.ibm.etools.webservice.wsext.LoginConfig;
import com.ibm.etools.webservice.wsext.SecurityRequestReceiverServiceConfig;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.webservices.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.xml.soapsec.confimpl.PrivateReceiverConfig;
import com.ibm.xml.soapsec.dsig.VerificationSettings;
import com.ibm.xml.soapsec.enc.EncryptionSettings;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import java.io.File;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CertSelector;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class WSEMFRequestReceiverConfig
extends PrivateReceiverConfig {
    private static Map keyStores = new Hashtable();
    private static Map certFactories = new Hashtable();
    private static Map certs = new Hashtable();
    private String wsseNS = null;
    private String wsuNS = null;
    private String origin = "non-ws-security";
    static final String WS_SEC = "ws-security";
    static final String NON_WS_SEC = "non-ws-security";
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSEMFRequestReceiverConfig.class.getName();
    private static final TraceComponent tc = Tr.register(WSEMFRequestReceiverConfig.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");

    public WSEMFRequestReceiverConfig(SecurityRequestReceiverBindingConfig securityRequestReceiverBindingConfig, SecurityRequestReceiverServiceConfig securityRequestReceiverServiceConfig, String string, VariableMap variableMap, WSSecurityService wSSecurityService) throws SoapSecurityException {
        this(securityRequestReceiverBindingConfig, securityRequestReceiverServiceConfig, string, variableMap, wSSecurityService, null);
    }

    public WSEMFRequestReceiverConfig(SecurityRequestReceiverBindingConfig securityRequestReceiverBindingConfig, SecurityRequestReceiverServiceConfig securityRequestReceiverServiceConfig, String string, VariableMap variableMap, WSSecurityService wSSecurityService, ClassLoader classLoader) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFRequestReceiverConfig (SecurityRequestReceiverBindingConfig, SecurityRequestReceiverServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader):", new Object[]{securityRequestReceiverBindingConfig, securityRequestReceiverServiceConfig, string, variableMap, wSSecurityService, classLoader});
        }
        this.init(securityRequestReceiverBindingConfig, securityRequestReceiverServiceConfig, string, variableMap, wSSecurityService, classLoader);
        this.origin = WS_SEC;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSEMFRequestReceiverConfig()");
        }
    }

    WSEMFRequestReceiverConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFRequestReceiverConfig");
            Tr.exit(tc, "WSEMFRequestReceiverConfig");
        }
    }

    final void init(SecurityRequestReceiverBindingConfig securityRequestReceiverBindingConfig, SecurityRequestReceiverServiceConfig securityRequestReceiverServiceConfig, String string, VariableMap variableMap, WSSecurityService wSSecurityService, ClassLoader classLoader) throws SoapSecurityException {
        Object object;
        String string2;
        EObject eObject;
        Object object2;
        Object object3;
        String string3;
        Object object4;
        Object object5;
        Object object6;
        com.ibm.xml.soapsec.token.LoginMapping loginMapping;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        EObject eObject2;
        int n;
        Object object11;
        Object object12;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(SecurityRequestReceiverBindingConfig, SecurityRequestReceiverServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader):", new Object[]{securityRequestReceiverBindingConfig, securityRequestReceiverServiceConfig, string, variableMap, wSSecurityService, classLoader});
        }
        AddReceivedTimestamp addReceivedTimestamp = null;
        IDAssertion iDAssertion = null;
        LoginConfig loginConfig = null;
        RequiredConfidentiality requiredConfidentiality = null;
        RequiredIntegrity requiredIntegrity = null;
        Map map = null;
        WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration = null;
        if (wSSecurityService != null && (object12 = wSSecurityService.getConfig()) instanceof WSSecurityDefaultConfiguration) {
            wSSecurityDefaultConfiguration = (WSSecurityDefaultConfiguration)object12;
        }
        if (securityRequestReceiverServiceConfig != null) {
            addReceivedTimestamp = securityRequestReceiverServiceConfig.getAddReceivedTimestamp();
            iDAssertion = securityRequestReceiverServiceConfig.getIdAssertion();
            loginConfig = securityRequestReceiverServiceConfig.getLoginConfig();
            requiredConfidentiality = securityRequestReceiverServiceConfig.getRequiredConfidentiality();
            requiredIntegrity = securityRequestReceiverServiceConfig.getRequiredIntegrity();
            object12 = securityRequestReceiverServiceConfig.getProperties();
            map = ConfigConstants.getProperties((EList)object12, variableMap);
            if (tc.isDebugEnabled()) {
                if (map != null) {
                    Tr.debug(tc, "Request Receiver Deployment Descriptor (AddReceivedTimestamp, IdAssertion, LoginConfig, RequiredConfidentiality, RequiredIntegrity, Property):", new Object[]{addReceivedTimestamp, iDAssertion, loginConfig, requiredConfidentiality, requiredIntegrity, map});
                } else {
                    Tr.debug(tc, "Request Receiver Deployment Descriptor (AddReceivedTimestamp, IdAssertion, LoginConfig, RequiredConfidentiality, RequiredIntegrity):", new Object[]{addReceivedTimestamp, iDAssertion, loginConfig, requiredConfidentiality, requiredIntegrity});
                }
            }
        }
        if (!((ConfigValidation)(object12 = new ConfigValidation(variableMap, wSSecurityDefaultConfiguration))).requiredConfidentialityValid(requiredConfidentiality)) {
            throw new SoapSecurityException("Invalid RequiredConfidentiality");
        }
        if (!((ConfigValidation)object12).requiredIntegrityValid(requiredIntegrity)) {
            throw new SoapSecurityException("Invalid RequiredIntegrity");
        }
        if (!((ConfigValidation)object12).idAssertionValid(iDAssertion)) {
            throw new SoapSecurityException("Invalid IDAssertion");
        }
        if (string != null) {
            object11 = string.trim();
            if (((String)object11).length() != 0) {
                this.myactor = object11;
            }
        } else {
            this.myactor = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "actorURI = " + this.myactor);
        }
        this.enableReceivedTimestamp = false;
        if (addReceivedTimestamp != null) {
            this.enableReceivedTimestamp = addReceivedTimestamp.isFlag();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding enableReceivedTimestamp: " + this.enableReceivedTimestamp);
            }
        }
        this.idType = null;
        this.trustMode = null;
        if (iDAssertion != null) {
            this.idType = iDAssertion.getIdType();
            String string4 = this.idType = this.idType == null ? this.idType : this.idType.trim();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding IDAssertion Type: " + this.idType);
            }
            this.trustMode = iDAssertion.getTrustMode();
            String string5 = this.trustMode = this.trustMode == null ? this.trustMode : this.trustMode.trim();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding IDAssertion TrustMode: " + this.trustMode);
            }
        }
        if (requiredIntegrity != null) {
            int n2 = requiredIntegrity.getReferences().size();
            for (n = 0; n < n2; ++n) {
                eObject2 = (Reference)requiredIntegrity.getReferences().get(n);
                object10 = eObject2.getPart();
                object9 = ((AbstractEnumerator)object10).getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding integrity part: " + (String)object9);
                }
                this.requiredIntegralParts.add(object9);
            }
        }
        if (requiredConfidentiality != null) {
            int n3 = requiredConfidentiality.getConfidentialParts().size();
            for (n = 0; n < n3; ++n) {
                eObject2 = (ConfidentialPart)requiredConfidentiality.getConfidentialParts().get(n);
                object10 = eObject2.getPart();
                object9 = ((AbstractEnumerator)object10).getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding confidentiality part: " + (String)object9);
                }
                this.requiredConfidentialParts.add(object9);
            }
        }
        if (loginConfig != null) {
            int n4 = loginConfig.getAuthMethods().size();
            n = 0;
            for (int i = 0; i < n4; ++i) {
                object10 = (AuthMethod)loginConfig.getAuthMethods().get(i);
                if (object10 == null) continue;
                object9 = object10.getText();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding authMethod name: " + (String)object9);
                }
                this.authMethods.add(object9);
                n = "BasicAuth".equals(object9) ? 1 : 0;
            }
            if (map != null && !map.isEmpty()) {
                String string6 = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.NonceRequired");
                if (string6 != null && (string6 = string6.trim()).length() != 0) {
                    this.checkNonce = Boolean.valueOf(string6);
                    if (this.checkNonce) {
                        if (n == 0) {
                            this.checkNonce = false;
                            this.checkNonceTimestamp = false;
                            object10 = new StringBuffer();
                            for (int i = 0; i < this.authMethods.size(); ++i) {
                                ((StringBuffer)object10).append(this.authMethods.get(i)).append(",");
                            }
                            object9 = ((StringBuffer)object10).toString();
                            object9 = ((String)object9).substring(0, ((String)object9).length() - 1);
                            Tr.warning(tc, "security.wssecurity.WSEC0113W", (Object)new Object[]{object9});
                        } else {
                            this.checkNonceTimestamp = true;
                        }
                    }
                }
                if ((object10 = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.timestampRequired")) != null && ((String)(object10 = ((String)object10).trim())).length() != 0) {
                    this.checkNonceTimestamp = Boolean.valueOf((String)object10);
                    if (this.checkNonceTimestamp && !this.checkNonce) {
                        this.checkNonceTimestamp = false;
                        Tr.warning(tc, "security.wssecurity.WSEC0114W");
                    }
                }
            }
        }
        object11 = null;
        EList eList = null;
        EList eList2 = null;
        object10 = null;
        object9 = null;
        EList eList3 = null;
        TrustedIDEvaluator trustedIDEvaluator = null;
        TrustedIDEvaluatorRef trustedIDEvaluatorRef = null;
        Map map2 = null;
        if (securityRequestReceiverBindingConfig != null) {
            object11 = securityRequestReceiverBindingConfig.getCertStoreList();
            eList = securityRequestReceiverBindingConfig.getEncryptionInfos();
            eList2 = securityRequestReceiverBindingConfig.getKeyLocators();
            object10 = securityRequestReceiverBindingConfig.getLoginMappings();
            object9 = securityRequestReceiverBindingConfig.getSigningInfos();
            eList3 = securityRequestReceiverBindingConfig.getTrustAnchors();
            trustedIDEvaluator = securityRequestReceiverBindingConfig.getTrustedIDEvaluator();
            trustedIDEvaluatorRef = securityRequestReceiverBindingConfig.getTrustedIDEvaluatorRef();
            object8 = securityRequestReceiverBindingConfig.getProperties();
            if (object8 != null) {
                map2 = ConfigConstants.getProperties((EList)object8, variableMap);
            }
            if (tc.isDebugEnabled()) {
                if (map2 != null) {
                    Tr.debug(tc, "Request Receiver Binding (CertStoreList, EncryptionInfos, KeyLocators, LoginMappings, SigningInfos, TrustAnchors, TrustedIDEvaluator, TrustedIDEvaluatorRef, Property):", new Object[]{object11, eList, eList2, object10, object9, eList3, trustedIDEvaluator, trustedIDEvaluatorRef, map2});
                } else {
                    Tr.debug(tc, "Request Receiver Binding (CertStoreList, EncryptionInfos, KeyLocators, LoginMappings, SigningInfos, TrustAnchors, TrustedIDEvaluator, TrustedIDEvaluatorRef):", new Object[]{object11, eList, eList2, object10, object9, eList3, trustedIDEvaluator, trustedIDEvaluatorRef});
                }
            }
            if ((map2 != null || map2.size() != 0) && (object7 = (String)map2.get("com.ibm.ws.wssecurity.config.WSSE.Namespace")) != null && ((String)object7).length() != 0) {
                if (!NamespaceUtil.isWsse((String)object7)) {
                    throw SoapSecurityException.format("security.wssecurity.WSEC0152E", (String)object7);
                }
                this.wsseNS = object7;
                this.wsuNS = NamespaceUtil.getCorrespondingWSUNS((String)this.wsseNS);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Namespace configured to be used to send the request, wsse=" + this.wsseNS + ", wsu=" + this.wsuNS);
            }
            this._bypassSecurityHeader = ConfigUtil.setupBypassSecurityHeaderProperty((WSSecurityDefaultConfiguration)wSSecurityDefaultConfiguration, null, (Map)map2);
        }
        if (!((ConfigValidation)object12).receiverSigningInfoValid((EList)object9, eList3, (CertStoreList)object11, requiredIntegrity)) {
            throw new SoapSecurityException("Invalid receiver SigningInfo");
        }
        if (!((ConfigValidation)object12).encryptionInfosValid(eList, eList2, requiredConfidentiality)) {
            throw new SoapSecurityException("Invalid EncryptionInfo");
        }
        if (!((ConfigValidation)object12).loginMappingValid((EList)object10, loginConfig)) {
            throw new SoapSecurityException("Invalid LoginMappings");
        }
        if (!((ConfigValidation)object12).trustedIDEvaluatorRefValid(trustedIDEvaluatorRef)) {
            throw new SoapSecurityException("Invalid TrustedIDEvaluatorRef");
        }
        if (!((ConfigValidation)object12).trustedIDEvaluatorValid(trustedIDEvaluator)) {
            throw new SoapSecurityException("Invalid TrustedIDEvaluator");
        }
        this.nonceMaxAge = (long)(wSSecurityDefaultConfiguration == null ? 300 : wSSecurityDefaultConfiguration.getNonceMaxAge()) * 1000L;
        this.nonceClockSkew = (long)(wSSecurityDefaultConfiguration == null ? 0 : wSSecurityDefaultConfiguration.getNonceClockSkew()) * 1000L;
        this.nonceManager = NonceManagerFactory.getInstance();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "default Nonce.maxAge = " + this.nonceMaxAge + " ms, default Nonce.clockSkew = " + this.nonceClockSkew + " ms");
            Tr.debug(tc, "NonceManager = " + this.nonceManager);
        }
        if (object10 != null) {
            int n5 = object10.size();
            for (int i = 0; i < n5; ++i) {
                loginMapping = ConfigConstants.readLoginMapping((LoginMapping)object10.get(i), variableMap, classLoader);
                this.am2lm.put(loginMapping.getAuthMethod(), loginMapping);
                if (loginMapping.getTokenValueType() != null) {
                    this.tvt2lm.put(loginMapping.getTokenValueType(), loginMapping);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding binding LoginMapping: ", new Object[]{loginMapping});
                }
                this.processNonceBinding(loginMapping.getAuthMethod(), loginMapping.getProperties(), wSSecurityDefaultConfiguration);
            }
        }
        object8 = this.authMethods.iterator();
        while (object8.hasNext()) {
            object7 = (String)object8.next();
            if (this.am2lm.containsKey(object7) || wSSecurityDefaultConfiguration == null) continue;
            loginMapping = wSSecurityDefaultConfiguration.getLoginMapping((String)object7);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding default LoginMapping: ", new Object[]{loginMapping});
            }
            this.am2lm.put(object7, loginMapping);
            this.processNonceBinding(loginMapping.getAuthMethod(), loginMapping.getProperties(), wSSecurityDefaultConfiguration);
            if (loginMapping.getTokenValueType() == null) continue;
            this.tvt2lm.put(loginMapping.getTokenValueType(), loginMapping);
        }
        if (trustedIDEvaluator != null) {
            object7 = ConfigConstants.readTrustedIDEvaluator(trustedIDEvaluator, variableMap, classLoader);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding TrustID Evaluator.");
            }
            this.trustedIDEvaluator = object7;
        }
        if (eList != null) {
            int n6 = eList.size();
            for (int i = 0; i < n6; ++i) {
                object6 = (EncryptionInfo)eList.get(i);
                object5 = object6.getEncryptionKey();
                object4 = null;
                string3 = null;
                if (object5 != null) {
                    object4 = object5.getName();
                    string3 = object5.getLocatorRef();
                }
                object3 = ConfigConstants.findKeyLocator(eList2, string3, variableMap, wSSecurityDefaultConfiguration, classLoader);
                DataEncryptionMethod dataEncryptionMethod = object6.getEncryptionMethod();
                object2 = null;
                if (dataEncryptionMethod != null) {
                    object2 = dataEncryptionMethod.getAlgorithm();
                }
                eObject = object6.getKeyEncryptionMethod();
                string2 = null;
                if (eObject != null) {
                    string2 = eObject.getAlgorithm();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding Encryption Info.", new Object[]{"Locator: " + object3, "dataEncAlg: " + (String)object2, "keyEncAlg: " + string2, "encKeyName: " + (String)object4});
                }
                if (object2 == null || object4 == null || object3 == null) {
                    object = "security.wssecurity.IncompleteEncryptionInfo";
                    if (object2 == null) {
                        Tr.warning(tc, (String)object, "Data Encryption Algorithm");
                    }
                    if (object4 == null) {
                        Tr.warning(tc, (String)object, "Encryption Key Name");
                    }
                    if (object3 == null) {
                        Tr.warning(tc, (String)object, "Key Locator");
                    }
                }
                this.encryptionSettingsList.add(new EncryptionSettings((String)object2, string2, (String)object4, (KeyLocator)object3));
            }
        }
        if (object9 != null) {
            int n7 = object9.size();
            for (int i = 0; i < n7; ++i) {
                object6 = null;
                object5 = null;
                object4 = new HashSet();
                string3 = null;
                object3 = null;
                boolean bl = false;
                object2 = (SigningInfo)object9.get(i);
                eObject = object2.getCanonicalizationMethod();
                string2 = null;
                if (eObject == null) {
                    Tr.warning(tc, "security.wssecurity.nocanonicalization.algo");
                } else {
                    string2 = eObject.getAlgorithm();
                }
                object = object2.getSignatureMethod();
                String string7 = null;
                if (object == null) {
                    Tr.warning(tc, "security.wssecurity.nosignature.algo");
                } else {
                    string7 = object.getAlgorithm();
                }
                DigestMethod digestMethod = object2.getDigestMethod();
                String string8 = null;
                if (digestMethod == null) {
                    Tr.warning(tc, "security.wssecurity.nodigest.algo");
                } else {
                    string8 = digestMethod.getAlgorithm();
                }
                CertPathSettings certPathSettings = object2.getCertPathSettings();
                TrustAnyCertificate trustAnyCertificate = certPathSettings.getTrustAnyCertificate();
                if (trustAnyCertificate != null) {
                    bl = true;
                } else {
                    String string9;
                    Object object13;
                    Object object14;
                    Object object15;
                    KeyStore keyStore = null;
                    TrustAnchorRef trustAnchorRef = certPathSettings.getTrustAnchorRef();
                    string3 = trustAnchorRef.getRef();
                    boolean bl2 = false;
                    for (int j = 0; j < eList3.size(); ++j) {
                        object15 = (TrustAnchor)eList3.get(j);
                        if (!string3.equals(object15.getName())) continue;
                        object14 = object15.getKeyStore();
                        File file = null;
                        file = variableMap == null ? new File(object14.getPath()) : new File(variableMap.expand(object14.getPath()));
                        keyStore = ConfigUtil.getKeyStore((String)object14.getType(), (File)file, (char[])object14.getStorepass().toCharArray());
                        bl2 = true;
                        break;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "(from application binding) Keystore for TrustAnchor: " + string3 + " = " + keyStore + "Found = " + bl2);
                    }
                    if (!bl2 && wSSecurityDefaultConfiguration != null) {
                        keyStore = wSSecurityDefaultConfiguration.getTrustAnchor(string3);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "(from default binding) Keystore for TrustAnchor: " + string3 + " = " + keyStore);
                        }
                    }
                    if (keyStore == null) {
                        throw SoapSecurityException.format("security.wssecurity.ConfigValidation.keystore.taref.open", string3);
                    }
                    try {
                        object13 = new X509CertSelector();
                        object6 = new PKIXBuilderParameters(keyStore, (CertSelector)object13);
                        ((PKIXParameters)object6).setDate(null);
                    }
                    catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                        object15 = "security.wssecurity.CommonReceiverConfig.s12";
                        FFDCFilter.processException((Throwable)invalidAlgorithmParameterException, clsName + ".WSEMFResponseReceiverConfig", "567", (Object)this);
                        Tr.error(tc, (String)object15);
                        throw SoapSecurityException.format((String)object15, invalidAlgorithmParameterException);
                    }
                    catch (KeyStoreException keyStoreException) {
                        object15 = "security.wssecurity.CommonReceiverConfig.s12";
                        FFDCFilter.processException((Throwable)keyStoreException, clsName + ".WSEMFResponseReceiverConfig", "572", (Object)this);
                        Tr.error(tc, (String)object15);
                        throw SoapSecurityException.format((String)object15, keyStoreException);
                    }
                    object13 = certPathSettings.getCertStoreRef();
                    if (object13 != null) {
                        object3 = object13.getRef();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "CertStoreRef = " + (String)object3);
                    }
                    boolean bl3 = false;
                    if (object11 != null) {
                        String string10;
                        Object object16;
                        Object object17;
                        Object object18;
                        Object object19;
                        object14 = object11.getCollectionCertStores();
                        int n8 = object14.size();
                        for (int j = 0; j < n8; ++j) {
                            Object object20;
                            CollectionCertStore collectionCertStore = (CollectionCertStore)object14.get(j);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "collectionCertStores.get(" + j + ") = " + collectionCertStore.getName());
                            }
                            if (object3 == null || !((String)object3).equals(collectionCertStore.getName())) continue;
                            object5 = Security.getProvider(collectionCertStore.getProvider());
                            EList eList4 = collectionCertStore.getX509Certificates();
                            int n9 = eList4.size();
                            object19 = new HashMap();
                            for (int k = 0; k < n9; ++k) {
                                object20 = (X509Certificate)eList4.get(k);
                                object18 = null;
                                object18 = variableMap == null ? object20.getPath() : variableMap.expand(object20.getPath());
                                object17 = "";
                                object16 = (CertificateFactory)object19.get(object17);
                                if (object16 == null) {
                                    object16 = ConfigUtil.createCertificateFactory((String)object17);
                                    object19.put(object17, object16);
                                }
                                File file = new File((String)object18);
                                ((HashSet)object4).add(ConfigUtil.getX509Certificate((File)file, (CertificateFactory)object16));
                            }
                            string10 = "Collection";
                            object20 = null;
                            try {
                                object20 = new CollectionCertStoreParameters((Collection<?>)object4);
                                object18 = null;
                                object18 = "".equals(object5) ? CertStore.getInstance(string10, (CertStoreParameters)object20) : CertStore.getInstance(string10, (CertStoreParameters)object20, (Provider)object5);
                                ((PKIXParameters)object6).addCertStore((CertStore)object18);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found CertStore for " + (String)object3);
                                }
                                bl3 = true;
                                break;
                            }
                            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                                object17 = "security.wssecurity.CommonReceiverConfig.s20";
                                Tr.error(tc, (String)object17, new Object[]{string10});
                                throw SoapSecurityException.format((String)object17, string10, (Throwable)noSuchAlgorithmException);
                            }
                            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                                object17 = "security.wssecurity.CommonReceiverConfig.s21";
                                Tr.error(tc, (String)object17, new Object[]{((CollectionCertStoreParameters)object20).toString() == null ? "" : ((CollectionCertStoreParameters)object20).toString()});
                                throw SoapSecurityException.format((String)object17, ((CollectionCertStoreParameters)object20).toString() == null ? "" : ((CollectionCertStoreParameters)object20).toString(), (Throwable)invalidAlgorithmParameterException);
                            }
                            catch (Throwable throwable) {
                                object17 = "security.wssecurity.load.collectioncertstore.failed";
                                Tr.error(tc, (String)object17, new Object[]{collectionCertStore.getName(), throwable});
                                throw SoapSecurityException.format((String)object17, collectionCertStore.getName(), throwable);
                            }
                        }
                        if (!bl3) {
                            EList eList5 = object11.getLdapCertStores();
                            int n10 = eList5.size();
                            for (int j = 0; j < n10; ++j) {
                                int n11;
                                LDAPCertStore lDAPCertStore = (LDAPCertStore)eList5.get(j);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "ldapCertStores.get(" + j + ") = " + lDAPCertStore.getName());
                                }
                                if (object3 == null || !((String)object3).equals(lDAPCertStore.getName())) continue;
                                object19 = lDAPCertStore.getLdapServer();
                                string10 = object19.getHost();
                                try {
                                    n11 = Integer.parseInt(object19.getPort());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    object17 = "security.wssecurity.CommonReceiverConfig.s19";
                                    object16 = object19.getPort();
                                    FFDCFilter.processException((Throwable)numberFormatException, clsName + ".CommonReceiverConfig", "677", (Object)this);
                                    Tr.error(tc, (String)object17, object16);
                                    throw SoapSecurityException.format((String)object17, (String)object16, (Throwable)numberFormatException);
                                }
                                object18 = "LDAP";
                                object5 = Security.getProvider(lDAPCertStore.getProvider());
                                object16 = new LDAPCertStoreParameters(string10, n11);
                                try {
                                    object17 = "".equals(object5) ? CertStore.getInstance((String)object18, (CertStoreParameters)object16) : CertStore.getInstance((String)object18, (CertStoreParameters)object16, (Provider)object5);
                                }
                                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                                    String string11 = "security.wssecurity.CommonReceiverConfig.s20";
                                    FFDCFilter.processException((Throwable)noSuchAlgorithmException, clsName + ".CommonReceiverConfig", "693", (Object)this);
                                    Tr.error(tc, string11, object18);
                                    throw SoapSecurityException.format(string11, (String)object18);
                                }
                                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                                    String string12 = "security.wssecurity.CommonReceiverConfig.s21";
                                    FFDCFilter.processException((Throwable)invalidAlgorithmParameterException, clsName + ".CommonReceiverConfig", "698", (Object)this);
                                    Tr.error(tc, string12, ((PKIXBuilderParameters)object6).toString());
                                    throw SoapSecurityException.format(string12, ((PKIXBuilderParameters)object6).toString());
                                }
                                ((PKIXParameters)object6).addCertStore((CertStore)object17);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found CertStore for " + (String)object3);
                                }
                                bl3 = true;
                                break;
                            }
                        }
                    }
                    if (!bl3 && object3 != null && wSSecurityDefaultConfiguration != null) {
                        object14 = wSSecurityDefaultConfiguration.getCertStore((String)object3);
                        if (object14 == null) {
                            String string13 = "security.wssecurity.ConfigValidation.csref.notfound";
                            Tr.error(tc, string13, new Object[]{object3});
                            throw SoapSecurityException.format(string13, (String)object3);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found CertStore for " + (String)object3);
                        }
                        ((PKIXParameters)object6).addCertStore((CertStore)object14);
                    }
                    if (string3 != null && object5 == null && (object5 = ConfigUtil.setupCertStoreProvider((WSSecurityDefaultConfiguration)wSSecurityDefaultConfiguration, object14 = new HashMap(), null)) == null && ConfigUtil.hasValue((String)(string9 = (String)object14.get("com.ibm.wsspi.wssecurity.config.CertStore.Provider")))) {
                        throw new SoapSecurityException("The cert store security provider '" + string9 + "' does not exist.  The cert store security provider is " + "configured on the '" + "com.ibm.wsspi.wssecurity.config.CertStore.Provider" + "' property.");
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding Signing Info.", new Object[]{"c14nAlgorithm: " + string2, "digestAlgorithm: " + string8, "signatureAlgorithm: " + string7, "provider: " + object5, "eeCerts: " + object4, "anchorRef: " + string3, "storeRef: " + (String)object3, "trustAny: " + bl});
                }
                this.verificationSettingsList.add(new VerificationSettings(string2, string8, string7, (PKIXBuilderParameters)object6, (Provider)object5, (HashSet)object4, string3, (String)object3, bl));
            }
        }
        if (trustedIDEvaluator == null && trustedIDEvaluatorRef != null) {
            String string14 = trustedIDEvaluatorRef.getRef();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding TrustID Evaluator Reference: " + string14);
            }
            this.trustedIDEvaluator = wSSecurityDefaultConfiguration.getTrustedIDEvaluator(string14);
        }
        this.processPrivateConfig(DOMUtil.getPrivateConfig((boolean)false));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    private void processNonceBinding(String string, Map map, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processNonceBinding", new Object[]{string, map});
        }
        if (map != null && !map.isEmpty()) {
            String string2 = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.maxAge");
            String string3 = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.clockSkew");
            boolean bl = "BasicAuth".equals(string);
            if (bl && this.checkNonce && this.checkNonceTimestamp) {
                if (wSSecurityDefaultConfiguration == null) {
                    if (string2 != null) {
                        this.nonceMaxAge = (long)ConfigConstants.processNonceMaxAge(string2, 600) * 1000L;
                    }
                    if (string3 != null) {
                        this.nonceClockSkew = (long)ConfigConstants.processNonceClockSkew(string3, (int)(this.nonceMaxAge / 1000L)) * 1000L;
                    }
                } else {
                    if (string2 != null) {
                        this.nonceMaxAge = (long)ConfigConstants.processNonceMaxAge(string2, wSSecurityDefaultConfiguration.getNonceCacheTimeout()) * 1000L;
                    }
                    if (string3 != null) {
                        this.nonceClockSkew = (long)ConfigConstants.processNonceClockSkew(string3, (int)(this.nonceMaxAge / 1000L)) * 1000L;
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nonce.maxAge = " + this.nonceMaxAge + " ms, Nonce.clockSkew = " + this.nonceClockSkew + " ms");
            }
            map.remove("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.maxAge");
            map.remove("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.clockSkew");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processNonceBinding");
        }
    }

    final String getOrigin() {
        return this.origin;
    }

    final String getWSSENS() {
        return this.wsseNS;
    }

    final String getWSUNS() {
        return this.wsuNS;
    }
}

