/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.webservices.wssecurity.util.CORBAHelper;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.wsspi.webservices.rpc.handler.GenericHandler;
import com.ibm.wsspi.webservices.rpc.handler.SystemHandler;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;

public class GlobalSecurityResponseHandler
extends GenericHandler
implements SystemHandler {
    private Map configMap;
    private boolean isServer = true;
    private static final TraceComponent tc = Tr.register(GlobalSecurityResponseHandler.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");

    public GlobalSecurityResponseHandler() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "GlobalSecurityResponseHandler()");
            Tr.exit(tc, "GlobalSecurityResponseHandler()");
        }
    }

    public void init(HandlerInfo handlerInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init()");
        }
        super.init(handlerInfo);
        this.configMap = handlerInfo.getHandlerConfig();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ConfigMap=" + this.configMap);
        }
        if (this.configMap != null) {
            this.isServer = this.configMap.get(HANDLER_PARAM_ROLE).equals(HANDLER_PARAM_ROLE_SERVER);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    public boolean handleRequest(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequest", messageContext);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequest", Boolean.TRUE);
        }
        return true;
    }

    private boolean cleanUp(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanUp", messageContext);
        }
        if (this.isServer) {
            Serializable serializable;
            Serializable serializable2;
            Exception exception = null;
            try {
                CORBAHelper.popCredential((com.ibm.ws.webservices.engine.MessageContext)((Object)messageContext));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removed credential from the thread");
                }
            }
            catch (Exception exception2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception: ", exception2);
                }
                exception = exception2;
            }
            JAXRPCException jAXRPCException = null;
            ContextManager contextManager = ContextManagerFactory.getInstance();
            if (contextManager == null) {
                jAXRPCException = new JAXRPCException(ConfigConstants.getMessage("security.wssecurity.ctxmgr.isnull"));
            } else {
                serializable2 = (Subject)contextManager.put("wssecurity.initial.sender.id", null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initial Sender Removed", serializable2);
                }
                serializable = (X509Certificate)contextManager.put("com.ibm.ws.wssecurity.OriginalCert", null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initial Sender Certificate Removed", serializable);
                }
            }
            serializable2 = null;
            if (jAXRPCException == null) {
                try {
                    String string;
                    serializable = (Subject)messageContext.getProperty("com.ibm.ws.webservices.wssecurity.constants.callerSubject");
                    contextManager.setCallerSubject((Subject)serializable);
                    if (tc.isDebugEnabled()) {
                        string = serializable == null ? "null" : "not null";
                        Tr.debug(tc, "Restored the caller subject [" + string + "]");
                    }
                    serializable = (Subject)messageContext.getProperty("com.ibm.ws.webservices.wssecurity.constants.invocationSubject");
                    contextManager.setInvocationSubject((Subject)serializable);
                    if (tc.isDebugEnabled()) {
                        string = serializable == null ? "null" : "not null";
                        Tr.debug(tc, "Restored the invocation subject [" + string + "]");
                    }
                }
                catch (Exception exception3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception: ", exception3);
                    }
                    serializable2 = exception3;
                }
            }
            if (exception != null) {
                throw new JAXRPCException(exception.getMessage(), exception);
            }
            if (jAXRPCException != null) {
                throw jAXRPCException;
            }
            if (serializable2 != null) {
                throw new JAXRPCException(((Throwable)serializable2).getMessage(), (Throwable)serializable2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanUp", Boolean.TRUE);
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleResponse", messageContext);
        }
        this.cleanUp(messageContext);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleResponse", Boolean.TRUE);
        }
        return true;
    }

    public void handleClosure(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleClosure", messageContext);
        }
        this.cleanUp(messageContext);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleClosure", Boolean.TRUE);
        }
    }

    public boolean handleFault(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleFault", messageContext);
        }
        this.cleanUp(messageContext);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleFault", Boolean.TRUE);
        }
        return true;
    }

    public void preHandleIncoming(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preHandleIncoming", messageContext);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preHandleIncoming");
        }
    }
}

