/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig;
import com.ibm.etools.webservice.wscbnd.SecurityRequestSenderBindingConfig;
import com.ibm.etools.webservice.wscbnd.SecurityResponseConsumerBindingConfig;
import com.ibm.etools.webservice.wscbnd.SecurityResponseReceiverBindingConfig;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.etools.webservice.wscext.SecurityRequestGeneratorServiceConfig;
import com.ibm.etools.webservice.wscext.SecurityRequestSenderServiceConfig;
import com.ibm.etools.webservice.wscext.SecurityResponseConsumerServiceConfig;
import com.ibm.etools.webservice.wscext.SecurityResponseReceiverServiceConfig;
import com.ibm.etools.webservice.wscext.WsClientExtension;
import com.ibm.etools.webservice.wscommonext.Confidentiality;
import com.ibm.etools.webservice.wscommonext.Integrity;
import com.ibm.etools.webservice.wscommonext.RequiredConfidentiality;
import com.ibm.etools.webservice.wscommonext.RequiredIntegrity;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandler;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.DistributedConfigCache;
import com.ibm.ws.webservices.wssecurity.core.DistributedConfigCacheFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSConsumer;
import com.ibm.ws.webservices.wssecurity.core.WSSGenerator;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestConsumerConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestReceiverConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestSenderConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseConsumerConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseReceiverConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseSenderConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSSecurityConsumerBase;
import com.ibm.ws.webservices.wssecurity.handler.WSSecurityGeneratorBase;
import com.ibm.ws.webservices.wssecurity.handler.WSSoapSecurityReceiverBase;
import com.ibm.ws.webservices.wssecurity.handler.WSSoapSecuritySenderBase;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.NamespaceUtil;
import com.ibm.wsspi.webservices.rpc.handler.GenericHandler;
import com.ibm.wsspi.webservices.rpc.handler.SystemHandler;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.ReceiverConfig;
import com.ibm.xml.soapsec.SenderConfig;
import com.ibm.xml.soapsec.proxy.FaultProxy;
import com.ibm.xml.soapsec.proxy.MessageContextProxy;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.w3c.dom.Element;

public class GlobalSecurityHandler
extends GenericHandler
implements SystemHandler {
    private static final String clsName = GlobalSecurityHandler.class.getName();
    private static final TraceComponent tc = Tr.register(GlobalSecurityHandler.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private boolean _isServer = true;
    private Map _configMap;
    private WSSoapSecuritySenderBase _sh = null;
    private WSSoapSecurityReceiverBase _rh = null;
    private WSSecurityGeneratorBase _gh = null;
    private WSSecurityConsumerBase _ch = null;
    private boolean isWebSphereClient = true;
    private static final JAXRPCHandler.QNameSet securityHeaderQNames = new JAXRPCHandler.QNameSet();
    private static final ContextManager ctxManager;
    private static boolean isSecurityEnabled;

    public GlobalSecurityHandler() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "GlobalSecurityHandler()");
        }
        boolean bl = this.isWebSphereClient = !WSSecurityPlatformContextFactory.getInstance().isServer();
        if (ctxManager != null) {
            isSecurityEnabled = ctxManager.isServerSecurityEnabled();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "GlobalSecurityHandler()");
        }
    }

    public void init(HandlerInfo handlerInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init()");
        }
        super.init(handlerInfo);
        this._configMap = handlerInfo.getHandlerConfig();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Options: ", new Object[]{this._configMap});
        }
        this._sh = new WSSoapSecuritySenderBase();
        this._rh = new WSSoapSecurityReceiverBase();
        this._gh = new WSSecurityGeneratorBase();
        this._ch = new WSSecurityConsumerBase();
        if (this._configMap != null) {
            this._isServer = this._configMap.get(GenericHandler.HANDLER_PARAM_ROLE).equals(GenericHandler.HANDLER_PARAM_ROLE_SERVER);
            Iterator iterator = this._configMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)this._configMap.get(string);
                this._sh.setHandlerOption(string, string2);
                this._rh.setHandlerOption(string, string2);
                this._gh.setHandlerOption(string, string2);
                this._ch.setHandlerOption(string, string2);
            }
        }
        this._sh.init();
        this._rh.init();
        try {
            this._gh.init();
            this._ch.init();
        }
        catch (SoapSecurityException soapSecurityException) {
            FFDCFilter.processException((Throwable)soapSecurityException, clsName + ".init", "197", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    public boolean handleRequest(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequest:", new Object[]{messageContext});
        }
        final SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        if (this._isServer) {
            Object object = sOAPMessageContext.getProperty("RequestReceiverConfig");
            if (object == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSConsumerConfig or ReceiverConfig found");
                }
            } else if (object instanceof WSSConsumerConfig) {
                this.handleRequest6(sOAPMessageContext, object);
            } else if (object instanceof ReceiverConfig) {
                this.handleRequest5(sOAPMessageContext, object);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to cast to WSSConsumerConfig or ReceiverConfig: " + object.getClass().getName());
            }
        } else {
            boolean bl;
            Object object = null;
            final String string = (String)sOAPMessageContext.getProperty(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_CDD);
            final String string2 = (String)sOAPMessageContext.getProperty(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_CBIND);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, com.ibm.wsspi.wssecurity.Constants.WSSECURITY_CDD + " [" + string + "], " + com.ibm.wsspi.wssecurity.Constants.WSSECURITY_CBIND + " [" + string2 + "].");
            }
            final boolean bl2 = string != null && string.length() != 0;
            boolean bl3 = bl = string2 != null && string2.length() != 0;
            if (bl2) {
                final DistributedConfigCache distributedConfigCache = _disCache._cache;
                object = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        boolean bl4;
                        URI uRI = bl2 ? URI.createURI(string) : null;
                        boolean bl22 = bl2 && !uRI.isEmpty();
                        URI uRI2 = bl ? URI.createURI(string2) : null;
                        boolean bl3 = bl4 = !bl || !uRI.isEmpty();
                        if (!bl22) {
                            throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s01", (String[])new String[]{string}));
                        }
                        if (!bl4) {
                            throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s02", (String[])new String[]{string2}));
                        }
                        CachedEntry cachedEntry = null;
                        Object object = null;
                        Object object2 = null;
                        if (distributedConfigCache != null) {
                            block11: {
                                try {
                                    cachedEntry = (CachedEntry)distributedConfigCache.getConfigObject(uRI);
                                }
                                catch (SoapSecurityException soapSecurityException) {
                                    if (!tc.isDebugEnabled()) break block11;
                                    Tr.debug(tc, "Exception occured when getting Cached Context", new Object[]{soapSecurityException});
                                    FFDCFilter.processException((Throwable)soapSecurityException, clsName + ".handleRequest", "267", this);
                                }
                            }
                            if (cachedEntry != null) {
                                if (cachedEntry.isWas6()) {
                                    object = cachedEntry.getGeneratorConfig();
                                    object2 = cachedEntry.getConsumerConfig();
                                } else {
                                    object = cachedEntry.getSenderConfig();
                                    object2 = cachedEntry.getReceiverConfig();
                                }
                                if (object2 != null) {
                                    sOAPMessageContext.setProperty("ResponseReceiverConfig", object2);
                                }
                                return object;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "getConfigObject returns null");
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Distributed Config Cache instance is null, continue normal processing");
                        }
                        object = GlobalSecurityHandler.this.loadConfig(uRI, uRI2, sOAPMessageContext);
                        return object;
                    }
                });
            } else {
                object = sOAPMessageContext.getProperty("RequestSenderConfig");
            }
            if (object == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSGeneratorConfig or SenderConfig found");
                }
            } else if (object instanceof WSSGeneratorConfig) {
                this.handleRequest6(sOAPMessageContext, object);
            } else if (object instanceof SenderConfig) {
                if (bl2) {
                    sOAPMessageContext.setProperty("RequestSenderConfig", object);
                }
                this.handleRequest5(sOAPMessageContext, object);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to cast to WSSGeneratorConfig or SenderConfig: " + object.getClass().getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequest");
        }
        return true;
    }

    private boolean handleRequest5(SOAPMessageContext sOAPMessageContext, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequest5(SOAPMessageContext, Object):", new Object[]{sOAPMessageContext, object});
        }
        try {
            if (this._isServer) {
                ReceiverConfig receiverConfig = (ReceiverConfig)object;
                if (receiverConfig != null) {
                    if (this.shouldProcessSecurityHeader(receiverConfig.getBypassSecurityHeaderSetting())) {
                        if (tc.isDebugEnabled()) {
                            StringBuffer stringBuffer = new StringBuffer("isServer=");
                            stringBuffer.append(this._isServer).append(", calling ");
                            stringBuffer.append(((Object)((Object)this._rh)).getClass().getName());
                            stringBuffer.append(".invoke(), context=").append(sOAPMessageContext);
                            stringBuffer.append(", Config Class Name=").append(receiverConfig.getClass().getName());
                            stringBuffer.append(", source=");
                            if (receiverConfig instanceof WSEMFRequestReceiverConfig) {
                                stringBuffer.append(((WSEMFRequestReceiverConfig)receiverConfig).getOrigin());
                            } else {
                                stringBuffer.append("unknown");
                            }
                            Tr.debug(tc, stringBuffer.toString());
                        }
                        this._rh.invoke(MessageContextProxy.getInstance((Object)sOAPMessageContext));
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No ReceiverConfig found");
                }
            } else {
                SenderConfig senderConfig = (SenderConfig)object;
                if (senderConfig != null) {
                    if (tc.isDebugEnabled()) {
                        StringBuffer stringBuffer = new StringBuffer("isServer=");
                        stringBuffer.append(this._isServer).append(", calling ");
                        stringBuffer.append(((Object)((Object)this._sh)).getClass().getName());
                        stringBuffer.append(".invoke(), context=").append(sOAPMessageContext);
                        stringBuffer.append(", Config Class Name=").append(senderConfig.getClass().getName());
                        stringBuffer.append(", source=");
                        if (senderConfig instanceof WSEMFRequestSenderConfig) {
                            stringBuffer.append(((WSEMFRequestSenderConfig)senderConfig).getOrigin());
                        } else {
                            stringBuffer.append("unknown");
                        }
                        Tr.debug(tc, stringBuffer.toString());
                    }
                    this._sh.invoke(MessageContextProxy.getInstance((Object)sOAPMessageContext));
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No SenderConfig found");
                }
            }
        }
        catch (FaultProxy faultProxy) {
            FFDCFilter.processException((Throwable)faultProxy.get(), clsName + ".handleRequest5", "383", (Object)this);
            throw new JAXRPCException(faultProxy.get());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequest5(SOAPMessageContext, Object)");
        }
        return true;
    }

    private boolean handleRequest6(SOAPMessageContext sOAPMessageContext, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequest6(SOAPMessageContext, Object):", new Object[]{sOAPMessageContext, object});
        }
        try {
            if (this._isServer) {
                WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)object;
                if (wSSConsumerConfig != null) {
                    if (this.shouldProcessSecurityHeader(wSSConsumerConfig.getBypassSecurityHeaderSetting())) {
                        if (tc.isDebugEnabled()) {
                            StringBuffer stringBuffer = new StringBuffer("isServer=");
                            stringBuffer.append(this._isServer).append(", calling ");
                            stringBuffer.append(this._ch.getClass().getName());
                            stringBuffer.append(".invoke(), context=").append(sOAPMessageContext);
                            stringBuffer.append(", Config Class Name=").append(wSSConsumerConfig.getClass().getName());
                            stringBuffer.append(", source=");
                            if (wSSConsumerConfig instanceof WSEMFRequestConsumerConfig) {
                                stringBuffer.append(((WSEMFRequestConsumerConfig)wSSConsumerConfig).getOrigin());
                            } else {
                                stringBuffer.append("unknown");
                            }
                            Tr.debug(tc, stringBuffer.toString());
                        }
                        this._ch.invoke(sOAPMessageContext, wSSConsumerConfig);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSConsumerConfig found");
                }
            } else {
                WSSGeneratorConfig wSSGeneratorConfig = (WSSGeneratorConfig)object;
                if (wSSGeneratorConfig != null) {
                    if (tc.isDebugEnabled()) {
                        StringBuffer stringBuffer = new StringBuffer("isServer=");
                        stringBuffer.append(this._isServer).append(", calling ");
                        stringBuffer.append(this._gh.getClass().getName());
                        stringBuffer.append(".invoke(), context=").append(sOAPMessageContext);
                        stringBuffer.append(", Config Class Name=").append(wSSGeneratorConfig.getClass().getName());
                        stringBuffer.append(", source=");
                        if (wSSGeneratorConfig instanceof WSEMFRequestGeneratorConfig) {
                            stringBuffer.append(((WSEMFRequestGeneratorConfig)wSSGeneratorConfig).getOrigin());
                        } else {
                            stringBuffer.append("unknown");
                        }
                        Tr.debug(tc, stringBuffer.toString());
                    }
                    this._gh.invoke(sOAPMessageContext, wSSGeneratorConfig);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSGeneratorConfig found");
                }
            }
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, clsName + ".handleRequest6", "450", (Object)this);
            throw new JAXRPCException(webServicesFault);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequest6(SOAPMessageContext, Object)");
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleResponse:", new Object[]{messageContext});
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        if (this._isServer) {
            Object object = sOAPMessageContext.getProperty("ResponseSenderConfig");
            if (object == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSGeneratorConfig or SenderConfig found");
                }
            } else if (object instanceof WSSGeneratorConfig) {
                this.handleResponse6(sOAPMessageContext, object);
            } else if (object instanceof SenderConfig) {
                this.handleResponse5(sOAPMessageContext, object);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to cast to WSSGeneratorConfig or SenderConfig: " + object.getClass().getName());
            }
        } else {
            Object object = sOAPMessageContext.getProperty("RequestSenderConfig");
            if (object != null) {
                String string = (String)sOAPMessageContext.getProperty("javax.xml.rpc.service.endpoint.address");
                Object object2 = null;
                if (object instanceof WSSGeneratorConfig) {
                    object2 = sOAPMessageContext.getProperty("com.ibm.wsspi.wssecurity.username.basicAuthToken");
                    if (string != null && string.length() != 0 && object2 != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "TargetEndpointAddress is [" + string + "]");
                            Tr.debug(tc, "Cached username token is [" + object2 + "]");
                        }
                        this._gh.saveObject(string, object2);
                    }
                } else if (object instanceof SenderConfig) {
                    object2 = sOAPMessageContext.getProperty("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.basicAuthToken");
                    if (string != null && string.length() != 0 && object2 != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "TargetEndpointAddress is [" + string + "]");
                            Tr.debug(tc, "Cached username token is [" + object2 + "]");
                        }
                        this._sh.saveObject(string, object2);
                    }
                }
            }
            if ((object = sOAPMessageContext.getProperty("ResponseReceiverConfig")) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSConsumerConfig or ReceiverConfig found");
                }
            } else if (object instanceof WSSConsumerConfig) {
                this.handleResponse6(sOAPMessageContext, object);
            } else if (object instanceof ReceiverConfig) {
                this.handleResponse5(sOAPMessageContext, object);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to cast to WSSConsumerConfig or ReceiverConfig: " + object.getClass().getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleResponse");
        }
        return true;
    }

    private boolean handleResponse5(SOAPMessageContext sOAPMessageContext, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleResponse5(SOAPMessageContext, Object):", new Object[]{sOAPMessageContext, object});
        }
        try {
            if (this._isServer) {
                SenderConfig senderConfig = (SenderConfig)object;
                if (senderConfig != null) {
                    if (tc.isDebugEnabled()) {
                        StringBuffer stringBuffer = new StringBuffer("isServer=");
                        stringBuffer.append(this._isServer).append(", calling ");
                        stringBuffer.append(((Object)((Object)this._sh)).getClass().getName());
                        stringBuffer.append(".invoke(), context=").append(sOAPMessageContext);
                        stringBuffer.append(", Config Class Name=").append(senderConfig.getClass().getName());
                        stringBuffer.append(", source=");
                        if (senderConfig instanceof WSEMFResponseSenderConfig) {
                            stringBuffer.append(((WSEMFResponseSenderConfig)senderConfig).getOrigin());
                        } else {
                            stringBuffer.append("unknown");
                        }
                        Tr.debug(tc, stringBuffer.toString());
                    }
                    this._sh.invoke(MessageContextProxy.getInstance((Object)sOAPMessageContext));
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No SenderConfig found");
                }
            } else {
                ReceiverConfig receiverConfig = (ReceiverConfig)object;
                if (receiverConfig != null) {
                    if (this.shouldProcessSecurityHeader(receiverConfig.getBypassSecurityHeaderSetting())) {
                        if (tc.isDebugEnabled()) {
                            StringBuffer stringBuffer = new StringBuffer("isServer=");
                            stringBuffer.append(this._isServer).append(", calling ");
                            stringBuffer.append(((Object)((Object)this._rh)).getClass().getName());
                            stringBuffer.append(".invoke(), context=").append(sOAPMessageContext);
                            stringBuffer.append(", Config Class Name=").append(receiverConfig.getClass().getName());
                            stringBuffer.append(", source=");
                            if (receiverConfig instanceof WSEMFResponseReceiverConfig) {
                                stringBuffer.append(((WSEMFResponseReceiverConfig)receiverConfig).getOrigin());
                            } else {
                                stringBuffer.append("unknown");
                            }
                            Tr.debug(tc, stringBuffer.toString());
                        }
                        this._rh.invoke(MessageContextProxy.getInstance((Object)sOAPMessageContext));
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No ReceiverConfig found");
                }
            }
        }
        catch (FaultProxy faultProxy) {
            FFDCFilter.processException((Throwable)faultProxy.get(), clsName + ".handleResponse5", "594", (Object)this);
            throw new JAXRPCException(faultProxy.get());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleResponse(SOAPMessageContext, Object)");
        }
        return true;
    }

    private boolean handleResponse6(SOAPMessageContext sOAPMessageContext, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleResponse6(SOAPMessageContext, Object):", new Object[]{sOAPMessageContext, object});
        }
        try {
            HashMap<String, SOAPMessageContext> hashMap = new HashMap<String, SOAPMessageContext>();
            hashMap.put("com.ibm.wsspi.wssecurity.core.messageContext", sOAPMessageContext);
            if (this._isServer) {
                WSSGeneratorConfig wSSGeneratorConfig = (WSSGeneratorConfig)object;
                if (wSSGeneratorConfig != null) {
                    if (tc.isDebugEnabled()) {
                        StringBuffer stringBuffer = new StringBuffer("isServer=");
                        stringBuffer.append(this._isServer).append(", calling ");
                        stringBuffer.append(this._gh.getClass().getName());
                        stringBuffer.append(".invoke(), context=").append(sOAPMessageContext);
                        stringBuffer.append(", Config Class Name=").append(wSSGeneratorConfig.getClass().getName());
                        stringBuffer.append(", source=");
                        if (wSSGeneratorConfig instanceof WSEMFResponseGeneratorConfig) {
                            stringBuffer.append(((WSEMFResponseGeneratorConfig)wSSGeneratorConfig).getOrigin());
                        } else {
                            stringBuffer.append("unknown");
                        }
                        Tr.debug(tc, stringBuffer.toString());
                    }
                    this._gh.invoke(sOAPMessageContext, wSSGeneratorConfig);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSGeneratorConfig found");
                }
            } else {
                WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)object;
                if (wSSConsumerConfig != null) {
                    if (this.shouldProcessSecurityHeader(wSSConsumerConfig.getBypassSecurityHeaderSetting())) {
                        if (tc.isDebugEnabled()) {
                            StringBuffer stringBuffer = new StringBuffer("isServer=");
                            stringBuffer.append(this._isServer).append(", calling ");
                            stringBuffer.append(this._ch.getClass().getName());
                            stringBuffer.append(".invoke(), context=").append(sOAPMessageContext);
                            stringBuffer.append(", Config Class Name=").append(wSSConsumerConfig.getClass().getName());
                            stringBuffer.append(", source=");
                            if (wSSConsumerConfig instanceof WSEMFResponseConsumerConfig) {
                                stringBuffer.append(((WSEMFResponseConsumerConfig)wSSConsumerConfig).getOrigin());
                            } else {
                                stringBuffer.append("unknown");
                            }
                            Tr.debug(tc, stringBuffer.toString());
                        }
                        this._ch.invoke(sOAPMessageContext, wSSConsumerConfig);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSConsumerConfig found");
                }
            }
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, clsName + ".handleResponse6", "662", (Object)this);
            throw new JAXRPCException(webServicesFault);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleResponse6(SOAPMessageContext, Object)");
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleFault", new Object[]{messageContext});
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        if (this._isServer) {
            Object object = sOAPMessageContext.getProperty("ResponseSenderConfig");
            if (object == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSGeneratorConfig or SenderConfig found");
                }
            } else if (object instanceof WSSGeneratorConfig) {
                this.handleFault6(sOAPMessageContext, object);
            } else if (object instanceof SenderConfig) {
                this.handleFault5(sOAPMessageContext, object);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to cast to WSSGeneratorConfig or SenderConfig: " + object.getClass().getName());
            }
        } else {
            Object object = sOAPMessageContext.getProperty("RequestReceiverConfig");
            if (object == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSConsumerConfig or ReceiverConfig found");
                }
            } else if (object instanceof WSSConsumerConfig) {
                this.handleFault6(sOAPMessageContext, object);
            } else if (object instanceof ReceiverConfig) {
                this.handleFault5(sOAPMessageContext, object);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to cast to WSSConsumerConfig or ReceiverConfig: " + object.getClass().getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleFault");
        }
        return true;
    }

    private boolean handleFault5(SOAPMessageContext sOAPMessageContext, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleFault5(SOAPMessageContext, Object):", new Object[]{sOAPMessageContext, object});
        }
        if (this._isServer) {
            SenderConfig senderConfig = (SenderConfig)object;
            if (senderConfig != null) {
                if (tc.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("isServer=");
                    stringBuffer.append(this._isServer).append(", calling ");
                    stringBuffer.append(((Object)((Object)this._rh)).getClass().getName());
                    stringBuffer.append(".onFault(), context=").append(sOAPMessageContext);
                    stringBuffer.append(", Config Class Name=").append(senderConfig.getClass().getName());
                    stringBuffer.append(", source=");
                    if (senderConfig instanceof WSEMFResponseSenderConfig) {
                        stringBuffer.append(((WSEMFResponseSenderConfig)senderConfig).getOrigin());
                    } else {
                        stringBuffer.append("unknown");
                    }
                    Tr.debug(tc, stringBuffer.toString());
                }
                this._rh.onFault(MessageContextProxy.getInstance((Object)sOAPMessageContext));
            } else {
                Tr.debug(tc, "No SenderConfig found");
            }
        } else {
            Object object2;
            SOAPMessage sOAPMessage;
            if (this.isWebSphereClient && (sOAPMessage = sOAPMessageContext.getMessage()) != null && (object2 = sOAPMessage.getSOAPPart()) != null) {
                try {
                    String string;
                    QName qName;
                    String string2;
                    Object object3;
                    Object object4;
                    boolean bl = true;
                    SOAPEnvelope sOAPEnvelope = ((SOAPPart)object2).getEnvelope();
                    if (sOAPEnvelope != null && (object4 = sOAPEnvelope.getBody()) != null && object4.hasFault() && (object3 = object4.getFault()) != null && (string2 = object3.getFaultCode()) != null && string2.length() != 0 && !(qName = com.ibm.xml.soapsec.Constants.getQName((String)(string = ConfigConstants.getWSSENS(sOAPMessageContext)), (String)"FailedAuthentication")).getLocalPart().equals(string2)) {
                        bl = false;
                    }
                    if (!bl) {
                        object4 = sOAPMessageContext.getProperty("com.ibm.wsspi.wssecurity.username.basicAuthToken");
                        object3 = (String)sOAPMessageContext.getProperty("javax.xml.rpc.service.endpoint.address");
                        if (object3 != null && ((String)object3).length() != 0 && object4 != null) {
                            this._gh.saveObject((String)object3, object4);
                        }
                    }
                }
                catch (SOAPException sOAPException) {
                    FFDCFilter.processException((Throwable)sOAPException, clsName + ".handleFault5", "788", (Object)this);
                }
                catch (SoapSecurityException soapSecurityException) {
                    FFDCFilter.processException((Throwable)soapSecurityException, clsName + ".handleFault5", "790", (Object)this);
                }
            }
            if ((sOAPMessage = (ReceiverConfig)object) != null) {
                if (tc.isDebugEnabled()) {
                    object2 = new StringBuffer("isServer=");
                    ((StringBuffer)object2).append(this._isServer).append(", calling ");
                    ((StringBuffer)object2).append(((Object)((Object)this._sh)).getClass().getName());
                    ((StringBuffer)object2).append(".onFault(), context=").append(sOAPMessageContext);
                    ((StringBuffer)object2).append(", Config Class Name=").append(sOAPMessage.getClass().getName());
                    ((StringBuffer)object2).append(", source=");
                    if (sOAPMessage instanceof WSEMFResponseReceiverConfig) {
                        ((StringBuffer)object2).append(((WSEMFResponseReceiverConfig)((Object)sOAPMessage)).getOrigin());
                    } else {
                        ((StringBuffer)object2).append("unknown");
                    }
                    Tr.debug(tc, ((StringBuffer)object2).toString());
                }
                this._sh.onFault(MessageContextProxy.getInstance((Object)sOAPMessageContext));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No ReceiverConfig found");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleFault5(SOAPMessageContext, Object)");
        }
        return true;
    }

    private boolean handleFault6(SOAPMessageContext sOAPMessageContext, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleFault6(SOAPMessageContext, Object):", new Object[]{sOAPMessageContext, object});
        }
        if (this._isServer) {
            WSSGeneratorConfig wSSGeneratorConfig = (WSSGeneratorConfig)object;
            if (wSSGeneratorConfig != null) {
                if (tc.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("isServer=");
                    stringBuffer.append(this._isServer).append(", calling ");
                    stringBuffer.append(this._ch.getClass().getName());
                    stringBuffer.append(".onFault(), context=").append(sOAPMessageContext);
                    stringBuffer.append(", Config Class Name=").append(object.getClass().getName());
                    stringBuffer.append(", source=");
                    if (wSSGeneratorConfig instanceof WSEMFResponseGeneratorConfig) {
                        stringBuffer.append(((WSEMFResponseGeneratorConfig)wSSGeneratorConfig).getOrigin());
                    } else {
                        stringBuffer.append("unknown");
                    }
                    Tr.debug(tc, stringBuffer.toString());
                }
                this._ch.onFault(sOAPMessageContext);
            } else {
                Tr.debug(tc, "No SenderConfig found");
            }
        } else {
            Object object2;
            Object object3;
            if (this.isWebSphereClient && (object3 = sOAPMessageContext.getMessage()) != null && (object2 = ((SOAPMessage)object3).getSOAPPart()) != null) {
                try {
                    String string;
                    Object object4;
                    Object object5;
                    boolean bl = true;
                    SOAPEnvelope sOAPEnvelope = ((SOAPPart)object2).getEnvelope();
                    if (sOAPEnvelope != null && (object5 = sOAPEnvelope.getBody()) != null && object5.hasFault() && (object4 = object5.getFault()) != null && (string = object4.getFaultCode()) != null && string.length() != 0) {
                        String string2;
                        QName qName;
                        int n = 0;
                        Object object6 = sOAPMessageContext.getProperty("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
                        if (object6 != null && object6 instanceof Integer) {
                            n = (Integer)object6;
                        }
                        if (!(qName = com.ibm.xml.soapsec.Constants.getQName((String)(string2 = Constants.NAMESPACES[0][n]), (String)"FailedAuthentication")).getLocalPart().equals(string)) {
                            bl = false;
                        }
                    }
                    if (!bl) {
                        object5 = sOAPMessageContext.getProperty("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.basicAuthToken");
                        object4 = (String)sOAPMessageContext.getProperty("javax.xml.rpc.service.endpoint.address");
                        if (object4 != null && ((String)object4).length() != 0 && object5 != null) {
                            this._sh.saveObject((String)object4, object5);
                        }
                    }
                }
                catch (SOAPException sOAPException) {
                    FFDCFilter.processException((Throwable)sOAPException, clsName + ".handleFault6", "899", (Object)this);
                }
                catch (SoapSecurityException soapSecurityException) {
                    FFDCFilter.processException((Throwable)soapSecurityException, clsName + ".handleFault6", "901", (Object)this);
                }
            }
            object3 = (WSSConsumerConfig)object;
            if (object != null) {
                if (tc.isDebugEnabled()) {
                    object2 = new StringBuffer("isServer=");
                    ((StringBuffer)object2).append(this._isServer).append(", calling ");
                    ((StringBuffer)object2).append(this._gh.getClass().getName());
                    ((StringBuffer)object2).append(".onFault(), context=").append(sOAPMessageContext);
                    ((StringBuffer)object2).append(", Config Class Name=").append(object.getClass().getName());
                    ((StringBuffer)object2).append(", source=");
                    if (object3 instanceof WSEMFResponseConsumerConfig) {
                        ((StringBuffer)object2).append(((WSEMFResponseConsumerConfig)object3).getOrigin());
                    } else {
                        ((StringBuffer)object2).append("unknown");
                    }
                    Tr.debug(tc, ((StringBuffer)object2).toString());
                }
                this._gh.onFault(sOAPMessageContext);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No ReceiverConfig found");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleFault(SOAPMessageContext, Object)");
        }
        return true;
    }

    public void preHandleIncoming(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preHandleIncoming", messageContext);
        }
        Object object = null;
        com.ibm.ws.webservices.engine.MessageContext messageContext2 = (com.ibm.ws.webservices.engine.MessageContext)((Object)messageContext);
        if (this._isServer && !messageContext2.getPastPivot()) {
            object = messageContext2.getProperty("RequestReceiverConfig");
        } else if (!this._isServer && messageContext2.getPastPivot()) {
            object = messageContext2.getProperty("ResponseReceiverConfig");
        }
        if (object != null) {
            if (object instanceof WSSConsumerConfig) {
                WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)object;
                boolean bl = GlobalSecurityHandler.requireIdCheck(messageContext2, wSSConsumerConfig);
                if (bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting High Fidelity.");
                    }
                    messageContext2.setHighFidelity(true);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Setting High Fidelity.");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "config not instanceof WSSConsumerConfig; setting High Fidelity.");
                }
                messageContext2.setHighFidelity(true);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "High fidelity = " + messageContext2.isHighFidelity());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preHandleIncoming");
        }
    }

    private static boolean requireIdCheck(com.ibm.ws.webservices.engine.MessageContext messageContext, WSSConsumerConfig wSSConsumerConfig) {
        Object object;
        block21: {
            Element element;
            block20: {
                SOAPPart sOAPPart;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "requireIdCheck.");
                }
                if (wSSConsumerConfig.isVerificationRequired() || wSSConsumerConfig.isDecryptionRequired()) {
                    messageContext.setProperty("com.ibm.ws.webservices.wssecurity.constants.checkIdUniqueness", "true");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "requireIdCheck. Verification or decryption required; ID validation is required.");
                    }
                    return true;
                }
                messageContext.setProperty("com.ibm.ws.webservices.wssecurity.constants.checkIdUniqueness", "false");
                SOAPMessage sOAPMessage = messageContext.getMessage();
                SOAPPart sOAPPart2 = sOAPPart = sOAPMessage.getSOAPPart();
                element = null;
                try {
                    element = WSSGenerator.getHeader(sOAPPart2, false);
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block20;
                    Tr.debug(tc, "requireIdCheck. Exception occur while calling WSSGenerator.getHeader():", exception);
                }
            }
            if (element == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "requireIdCheck. Not header from WSSGenerator, ID validation not required.");
                }
                return false;
            }
            int n = NamespaceUtil.isSoap(element.getNamespaceURI());
            if (tc.isDebugEnabled()) {
                object = null;
                object = n == 0 ? "The spec of SOAP is SOAP1.1." : (n == 1 ? "The spec of SOAP is SOAP1.2." : "Unknown spec of SOAP: " + element.getNamespaceURI());
                Tr.debug(tc, (String)object);
            }
            object = null;
            try {
                object = WSSConsumer.getSecurityHeaders(element, n, wSSConsumerConfig.isUltimateReceiver(), wSSConsumerConfig.getMyActor());
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block21;
                Tr.debug(tc, "requireIdCheck. Exception occur when call ing WSSConsumer.getSecurityHeaders() :", exception);
            }
        }
        if (object == null || object.getLength() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "requireIdCheck. Security header not found, ID validation not required.");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, object.getLength() + " security headers found");
        }
        boolean bl = false;
        try {
            Element element = (Element)object.item(0);
            String string = WSSConsumer.getId(element);
            if (string == null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "requireIdCheck. Exception occur when calling WSSConsumer.getId() :", exception);
            }
            bl = true;
        }
        if (bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "requireIdCheck. ID validation not required.");
            }
            return false;
        }
        messageContext.setProperty("com.ibm.ws.webservices.wssecurity.constants.checkIdUniqueness", "true");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requireIdCheck. ID validation is required.");
        }
        return true;
    }

    private Object loadConfig(URI uRI, URI uRI2, SOAPMessageContext sOAPMessageContext) {
        Object object;
        Object object2;
        Notifier notifier;
        Object object3;
        EObject eObject;
        Object object4;
        Object object5;
        Object object6;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadConfig(URI, URI, SOAPMesageContext): ", new Object[]{uRI, uRI2, sOAPMessageContext});
        }
        Object object7 = null;
        WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
        SecurityRequestSenderServiceConfig securityRequestSenderServiceConfig = null;
        SecurityResponseReceiverServiceConfig securityResponseReceiverServiceConfig = null;
        SecurityRequestGeneratorServiceConfig securityRequestGeneratorServiceConfig = null;
        SecurityResponseConsumerServiceConfig securityResponseConsumerServiceConfig = null;
        String string = null;
        if (uRI != null) {
            object6 = wASResourceSetImpl.getResource(uRI, true);
            object5 = object6.getContents();
            object4 = object5.get(0);
            if (!(object4 instanceof WsClientExtension)) {
                throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s03", (String[])new String[]{object4.getClass().getName()}));
            }
            eObject = (WsClientExtension)object4;
            object3 = eObject.getServiceRefs();
            if (object3 != null && !object3.isEmpty()) {
                if (object3.size() > 1) {
                    throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s05"));
                }
                notifier = (com.ibm.etools.webservice.wscext.ServiceRef)object3.get(0);
                if ((object3 = notifier.getPortQnameBindings()) != null && !object3.isEmpty()) {
                    if (object3.size() > 1) {
                        throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s06"));
                    }
                    object2 = (com.ibm.etools.webservice.wscext.PortQnameBinding)object3.get(0);
                    if (object2 != null && (object = object2.getClientServiceConfig()) != null) {
                        securityRequestSenderServiceConfig = object.getSecurityRequestSenderServiceConfig();
                        securityResponseReceiverServiceConfig = object.getSecurityResponseReceiverServiceConfig();
                        securityRequestGeneratorServiceConfig = object.getSecurityRequestGeneratorServiceConfig();
                        securityResponseConsumerServiceConfig = object.getSecurityResponseConsumerServiceConfig();
                        string = object.getActorURI();
                    }
                }
            }
        }
        if ((object6 = ((com.ibm.ws.webservices.engine.MessageContext)sOAPMessageContext).getPort()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Can't add header bindings based on actor [" + string + "] since there is no port is found.");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added header bindings based on actor [" + string + "] since the port is found.");
            }
            object6.addActorHeaderBinding(string, (Collection)securityHeaderQNames);
        }
        object5 = null;
        object4 = null;
        eObject = null;
        object3 = null;
        if (uRI2 != null) {
            notifier = wASResourceSetImpl.getResource(uRI2, true);
            object2 = notifier.getContents();
            object = object2.get(0);
            if (!(object instanceof ClientBinding)) {
                throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s04", (String[])new String[]{object.getClass().getName()}));
            }
            ClientBinding clientBinding = (ClientBinding)object;
            EList eList = clientBinding.getServiceRefs();
            if (eList != null && eList.size() > 1) {
                throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s05"));
            }
            ServiceRef serviceRef = (ServiceRef)eList.get(0);
            if ((eList = serviceRef.getPortQnameBindings()) != null && !eList.isEmpty()) {
                if (eList.size() > 1) {
                    throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s06"));
                }
                PortQnameBinding portQnameBinding = (PortQnameBinding)eList.get(0);
                if (portQnameBinding != null) {
                    object5 = portQnameBinding.getSecurityRequestSenderBindingConfig();
                    object4 = portQnameBinding.getSecurityResponseReceiverBindingConfig();
                    eObject = portQnameBinding.getSecurityRequestGeneratorBindingConfig();
                    object3 = portQnameBinding.getSecurityResponseConsumerBindingConfig();
                }
            }
        }
        boolean bl = true;
        if (securityRequestSenderServiceConfig != null || object5 != null || securityResponseReceiverServiceConfig != null || object4 != null) {
            bl = false;
        }
        if (securityRequestGeneratorServiceConfig != null || eObject != null || securityResponseConsumerServiceConfig != null || object3 != null) {
            bl = true;
        }
        try {
            object2 = null;
            if (bl) {
                if (GlobalSecurityHandler.createRequestGeneratorConfig(securityRequestGeneratorServiceConfig, (SecurityRequestGeneratorBindingConfig)eObject)) {
                    object7 = new WSEMFRequestGeneratorConfig((SecurityRequestGeneratorBindingConfig)eObject, securityRequestGeneratorServiceConfig, string, null, null);
                }
                if (GlobalSecurityHandler.createResponseConsumerConfig(securityResponseConsumerServiceConfig, (SecurityResponseConsumerBindingConfig)object3)) {
                    object2 = new WSEMFResponseConsumerConfig((SecurityResponseConsumerBindingConfig)object3, securityResponseConsumerServiceConfig, string, null, null);
                    sOAPMessageContext.setProperty("ResponseReceiverConfig", object2);
                }
                object = new CachedEntry(object7, object2, null, null, bl);
                if (_disCache._cache != null) {
                    if (_disCache._cache.putConfigObject(uRI, object) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "putConfigObject success");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "putConfigObject returns null");
                    }
                }
            } else {
                if (GlobalSecurityHandler.createRequestSenderConfig(securityRequestSenderServiceConfig, (SecurityRequestSenderBindingConfig)object5)) {
                    object7 = new WSEMFRequestSenderConfig((SecurityRequestSenderBindingConfig)object5, securityRequestSenderServiceConfig, string, null, null);
                }
                if (GlobalSecurityHandler.createResponseReceiverConfig(securityResponseReceiverServiceConfig, object4)) {
                    object2 = new WSEMFResponseReceiverConfig((SecurityResponseReceiverBindingConfig)object4, securityResponseReceiverServiceConfig, string, null, null);
                    sOAPMessageContext.setProperty("ResponseReceiverConfig", object2);
                }
                object = new CachedEntry(null, null, object7, object2, bl);
                if (_disCache._cache != null) {
                    if (_disCache._cache.putConfigObject(uRI, object) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "putConfigObject success");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "putConfigObject returns null");
                    }
                }
            }
        }
        catch (SoapSecurityException soapSecurityException) {
            FFDCFilter.processException((Throwable)soapSecurityException, clsName + ".loadConfig", "1255", (Object)this);
            Tr.error(tc, "security.wssecurity.GlobalSecurityHandler.s09", soapSecurityException);
            throw new JAXRPCException(soapSecurityException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadConfig(URI, URI, MesageContext)");
        }
        return object7;
    }

    private static boolean createRequestGeneratorConfig(SecurityRequestGeneratorServiceConfig securityRequestGeneratorServiceConfig, SecurityRequestGeneratorBindingConfig securityRequestGeneratorBindingConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRequestGeneratorConfig", new Object[]{securityRequestGeneratorServiceConfig, securityRequestGeneratorBindingConfig});
        }
        boolean bl = false;
        if (securityRequestGeneratorServiceConfig != null) {
            EList eList;
            Object object;
            Object object2;
            boolean[] blArray = new boolean[4];
            blArray[3] = false;
            blArray[2] = false;
            blArray[1] = false;
            blArray[0] = false;
            EList eList2 = securityRequestGeneratorServiceConfig.getIntegrity();
            if (eList2 != null) {
                for (int i = 0; i < eList2.size(); ++i) {
                    object2 = (Integrity)eList2.get(i);
                    object = object2.getMessageParts();
                    boolean bl2 = blArray[0] = object != null && !object.isEmpty();
                    if (blArray[0]) break;
                    object = object2.getTimestamp();
                    boolean bl3 = blArray[0] = object != null && !object.isEmpty();
                    if (blArray[0]) break;
                    object = object2.getNonce();
                    boolean bl4 = blArray[0] = object != null && !object.isEmpty();
                    if (blArray[0]) break;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Integrity constraint defined: " + blArray[0]);
            }
            if ((eList = securityRequestGeneratorServiceConfig.getConfidentiality()) != null) {
                for (int i = 0; i < eList.size(); ++i) {
                    object = (Confidentiality)eList.get(i);
                    EList eList3 = object.getMessageParts();
                    boolean bl5 = blArray[1] = eList3 != null && !eList3.isEmpty();
                    if (blArray[1]) break;
                    eList3 = object.getTimestamp();
                    boolean bl6 = blArray[1] = eList3 != null && !eList3.isEmpty();
                    if (blArray[1]) break;
                    eList3 = object.getNonce();
                    boolean bl7 = blArray[1] = eList3 != null && !eList3.isEmpty();
                    if (blArray[1]) break;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Confidentiality constraint defined: " + blArray[1]);
            }
            boolean bl8 = blArray[2] = (object2 = securityRequestGeneratorServiceConfig.getSecurityToken()) != null && !object2.isEmpty();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SecurityToken constraint defined: " + blArray[2]);
            }
            boolean bl9 = blArray[3] = securityRequestGeneratorServiceConfig.getAddTimestamp() != null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AddTimestamp constraint defined: " + blArray[2]);
            }
            if ((blArray[0] || blArray[1] || blArray[2]) && securityRequestGeneratorBindingConfig == null) {
                throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s07"));
            }
            bl = blArray[0] || blArray[1] || blArray[2] || blArray[3];
        } else if (securityRequestGeneratorBindingConfig != null) {
            throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s08"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRequestGeneratorConfig returns " + bl);
        }
        return bl;
    }

    private static boolean createResponseConsumerConfig(SecurityResponseConsumerServiceConfig securityResponseConsumerServiceConfig, SecurityResponseConsumerBindingConfig securityResponseConsumerBindingConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createResponseConsumerConfig", new Object[]{securityResponseConsumerServiceConfig, securityResponseConsumerBindingConfig});
        }
        boolean bl = false;
        if (securityResponseConsumerServiceConfig != null) {
            EList eList;
            Object object;
            Object object2;
            boolean[] blArray = new boolean[4];
            blArray[3] = false;
            blArray[2] = false;
            blArray[1] = false;
            blArray[0] = false;
            EList eList2 = securityResponseConsumerServiceConfig.getRequiredIntegrity();
            if (eList2 != null) {
                for (int i = 0; i < eList2.size(); ++i) {
                    object2 = (RequiredIntegrity)eList2.get(i);
                    object = object2.getMessageParts();
                    boolean bl2 = blArray[0] = object != null && !object.isEmpty();
                    if (blArray[0]) break;
                    object = object2.getTimestamp();
                    boolean bl3 = blArray[0] = object != null && !object.isEmpty();
                    if (blArray[0]) break;
                    object = object2.getNonce();
                    boolean bl4 = blArray[0] = object != null && !object.isEmpty();
                    if (blArray[0]) break;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequiredIntegrity constraint defined: " + blArray[0]);
            }
            if ((eList = securityResponseConsumerServiceConfig.getRequiredConfidentiality()) != null) {
                for (int i = 0; i < eList.size(); ++i) {
                    object = (RequiredConfidentiality)eList.get(i);
                    EList eList3 = object.getMessageParts();
                    boolean bl5 = blArray[1] = eList3 != null && !eList3.isEmpty();
                    if (blArray[1]) break;
                    eList3 = object.getTimestamp();
                    boolean bl6 = blArray[1] = eList3 != null && !eList3.isEmpty();
                    if (blArray[1]) break;
                    eList3 = object.getNonce();
                    boolean bl7 = blArray[1] = eList3 != null && !eList3.isEmpty();
                    if (blArray[1]) break;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequiredConfidentiality constraint defined: " + blArray[1]);
            }
            boolean bl8 = blArray[2] = (object2 = securityResponseConsumerServiceConfig.getRequiredSecurityToken()) != null && !object2.isEmpty();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequiredSecurityToken constraint defined: " + blArray[2]);
            }
            boolean bl9 = blArray[3] = securityResponseConsumerServiceConfig.getAddTimestamp() != null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AddTimestamp constraint defined: " + blArray[3]);
            }
            if ((blArray[0] || blArray[1] || blArray[2]) && securityResponseConsumerBindingConfig == null) {
                throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s07"));
            }
            bl = blArray[0] || blArray[1] || blArray[2] || blArray[3];
        } else if (securityResponseConsumerBindingConfig != null) {
            throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s08"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResponseConsumerConfig returns " + bl);
        }
        return bl;
    }

    private static boolean createRequestSenderConfig(SecurityRequestSenderServiceConfig securityRequestSenderServiceConfig, SecurityRequestSenderBindingConfig securityRequestSenderBindingConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRequestSenderConfig", new Object[]{securityRequestSenderServiceConfig, securityRequestSenderBindingConfig});
        }
        boolean bl = false;
        if (securityRequestSenderServiceConfig != null) {
            Object object;
            Object object2;
            boolean[] blArray = new boolean[5];
            blArray[4] = false;
            blArray[3] = false;
            blArray[2] = false;
            blArray[1] = false;
            blArray[0] = false;
            Integrity integrity = securityRequestSenderServiceConfig.getIntegrity();
            if (integrity != null) {
                object2 = integrity.getReferences();
                boolean bl2 = blArray[0] = object2 != null && !object2.isEmpty();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Integrity constraint defined: " + blArray[0]);
            }
            if ((object2 = securityRequestSenderServiceConfig.getConfidentiality()) != null) {
                object = object2.getConfidentialParts();
                boolean bl3 = blArray[1] = object != null && !object.isEmpty();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Confidentiality constraint defined: " + blArray[1]);
            }
            if ((object = securityRequestSenderServiceConfig.getLoginConfig()) != null) {
                String string = object.getAuthMethod();
                boolean bl4 = blArray[2] = string != null && string.length() != 0;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "LoginConfig constraint defined: " + blArray[2]);
            }
            boolean bl5 = blArray[3] = securityRequestSenderServiceConfig.getAddCreatedTimeStamp() != null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AddCreatedTimeStamp constraint defined: " + blArray[3]);
            }
            boolean bl6 = blArray[4] = securityRequestSenderServiceConfig.getIdAssertion() != null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IdAssertion constraint defined: " + blArray[4]);
            }
            if ((blArray[0] || blArray[1] || blArray[2]) && securityRequestSenderBindingConfig == null) {
                throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s07"));
            }
            bl = blArray[0] || blArray[1] || blArray[2] || blArray[3] || blArray[4];
        } else if (securityRequestSenderBindingConfig != null) {
            throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s08"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRequestSenderConfig returns " + bl);
        }
        return bl;
    }

    private static boolean createResponseReceiverConfig(SecurityResponseReceiverServiceConfig securityResponseReceiverServiceConfig, SecurityResponseReceiverBindingConfig securityResponseReceiverBindingConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createResponseReceiverConfig", new Object[]{securityResponseReceiverServiceConfig, securityResponseReceiverBindingConfig});
        }
        boolean bl = false;
        if (securityResponseReceiverServiceConfig != null) {
            Object object;
            boolean[] blArray = new boolean[3];
            blArray[2] = false;
            blArray[1] = false;
            blArray[0] = false;
            RequiredIntegrity requiredIntegrity = securityResponseReceiverServiceConfig.getRequiredIntegrity();
            if (requiredIntegrity != null) {
                object = requiredIntegrity.getReferences();
                boolean bl2 = blArray[0] = object != null && !object.isEmpty();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequiredIntegrity constraint defined: " + blArray[0]);
            }
            if ((object = securityResponseReceiverServiceConfig.getRequiredConfidentiality()) != null) {
                EList eList = object.getConfidentialParts();
                boolean bl3 = blArray[1] = eList != null && !eList.isEmpty();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequiredConfidentiality constraint defined: " + blArray[1]);
            }
            boolean bl4 = blArray[2] = securityResponseReceiverServiceConfig.getAddReceivedTimeStamp() != null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AddReceivedTimeStamp constraint defined: " + blArray[2]);
            }
            if ((blArray[0] || blArray[1]) && securityResponseReceiverBindingConfig == null) {
                throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s07"));
            }
            bl = blArray[0] || blArray[1] || blArray[2];
        } else if (securityResponseReceiverBindingConfig != null) {
            throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s08"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResponseReceiverConfig returns " + bl);
        }
        return bl;
    }

    private boolean shouldProcessSecurityHeader(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "shouldProcessSecurityHeader");
        }
        boolean bl2 = true;
        if (bl) {
            if (!isSecurityEnabled) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server security is disabled and com.ibm.wsspi.wssecurity.config.disableWSSIfApplicationSecurityDisabled is true.  The security header will not be processed.");
                }
                bl2 = false;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server security is enabled.  The security header will be processed.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shouldProcessSecurityHeader");
        }
        return bl2;
    }

    static {
        securityHeaderQNames.add((Object)QNameTable.createQName("http://schemas.xmlsoap.org/ws/2002/04/secext", "Security"));
        securityHeaderQNames.add((Object)QNameTable.createQName("http://schemas.xmlsoap.org/ws/2002/07/secext", "Security"));
        securityHeaderQNames.add((Object)QNameTable.createQName("http://schemas.xmlsoap.org/ws/2003/06/secext", "Security"));
        securityHeaderQNames.add((Object)QNameTable.createQName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"));
        ctxManager = ContextManagerFactory.getInstance();
        isSecurityEnabled = false;
    }

    private static class _disCache {
        static DistributedConfigCache _cache = null;

        private _disCache() {
        }

        static {
            try {
                DistributedConfigCacheFactory.init();
                _cache = DistributedConfigCacheFactory.getInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, clsName + "init", "1465");
            }
        }
    }

    private class CachedEntry {
        private WSEMFRequestGeneratorConfig gConfig = null;
        private WSEMFResponseConsumerConfig cConfig = null;
        private WSEMFRequestSenderConfig sConfig = null;
        private WSEMFResponseReceiverConfig rConfig = null;
        private boolean isWAS6 = false;

        public CachedEntry(Object object, Object object2, Object object3, Object object4, boolean bl) {
            this.isWAS6 = bl;
            if (this.isWAS6) {
                this.gConfig = (WSEMFRequestGeneratorConfig)object;
                this.cConfig = (WSEMFResponseConsumerConfig)object2;
            } else {
                this.sConfig = (WSEMFRequestSenderConfig)((Object)object3);
                this.rConfig = (WSEMFResponseReceiverConfig)((Object)object4);
            }
        }

        public boolean isWas6() {
            return this.isWAS6;
        }

        public WSEMFRequestGeneratorConfig getGeneratorConfig() {
            return this.gConfig;
        }

        public WSEMFResponseConsumerConfig getConsumerConfig() {
            return this.cConfig;
        }

        public WSEMFRequestSenderConfig getSenderConfig() {
            return this.sConfig;
        }

        public WSEMFResponseReceiverConfig getReceiverConfig() {
            return this.rConfig;
        }
    }
}

