/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.enc;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSConsumerComponent;
import com.ibm.ws.webservices.wssecurity.config.EncryptionConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.dsig.SignatureGenerator;
import com.ibm.ws.webservices.wssecurity.enc.DecryptionResult;
import com.ibm.ws.webservices.wssecurity.enc.PartList;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.token.AuthResult;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.webservices.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DecryptedPartChecker
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register((Class)DecryptedPartChecker.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = DecryptedPartChecker.class.getName();
    private Map _selectors = null;
    private IDResolver _idResolver = null;
    private boolean _initialized = false;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wssecurity$util$ConfidentialDialectElementSelector;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtil)((Object)map.get("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver"));
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Node node, Map map) throws SoapSecurityException {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Node target[" + DOMUtil.getDisplayName((Node)node) + "]," + "Map context)"));
        }
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.VerifiedPartChecker.s05");
        }
        Object v = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int n = 0;
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        String string = Constants.NAMESPACES[0][n];
        String string2 = Constants.NAMESPACES[1][n];
        Document document = null;
        document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        NonceManager nonceManager = wSSConsumerConfig.getNonceManager();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(map);
        hashMap.put(NonceManager.class, nonceManager);
        hashMap.put("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver", this._idResolver);
        hashMap.put("com.ibm.ws.webservices.wssecurity.util.selector.config", wSSConsumerConfig.getTokenConsumers());
        Set set = DecryptedPartChecker.preprocess(document, wSSConsumerConfig.getRequiredConfidentialParts(), this._selectors, hashMap);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Processing the decrypted results...");
        }
        Result[] resultArray = ResultPool.get((Map)map, (Class)DecryptionResult.class);
        HashSet<ReferencePartConfig> hashSet = new HashSet<ReferencePartConfig>();
        if (resultArray != null && resultArray.length > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(resultArray.length + " decrypted results found."));
            }
            for (int i = 0; i < resultArray.length; ++i) {
                object3 = (DecryptionResult)resultArray[i];
                hashSet.clear();
                object2 = ((DecryptionResult)object3)._decryptedParts.iterator();
                while (object2.hasNext()) {
                    DecryptionResult.DecryptedPart decryptedPart = (DecryptionResult.DecryptedPart)object2.next();
                    object = DecryptedPartChecker.getRelatedPart((DecryptionResult)object3, decryptedPart, set);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("DecryptedPart [" + decryptedPart + "], RequiredPart [" + object + "]"));
                    }
                    if (object == null) continue;
                    if (((RequiredPart)object)._requiredNonce) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Checking required nonce...");
                        }
                        if (decryptedPart._nonce == null) {
                            String string3 = ((RequiredPart)object)._pconfig.getKeyword();
                            throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.VerifiedPartChecker.s02", string3);
                        }
                        NonceUtil.checkNonce(decryptedPart._nonce, string, nonceManager);
                    }
                    if (((RequiredPart)object)._requiredTimestamp) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Checking required timestamp...");
                        }
                        if (decryptedPart._timestamp == null) {
                            String string4 = ((RequiredPart)object)._pconfig.getKeyword();
                            throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.VerifiedPartChecker.s03", string4);
                        }
                        NonceUtil.checkTimestamp(decryptedPart._timestamp, string2, wSSConsumerConfig.getTimestampMaxAge(), wSSConsumerConfig.getTimestampClockSkew(), false);
                    }
                    ((RequiredPart)object)._processed = true;
                    ((RequiredPart)object)._tokens.add(((DecryptionResult)object3)._token);
                    hashSet.add(((RequiredPart)object)._rconfig);
                }
                DecryptedPartChecker.checkCaller((DecryptionResult)object3, hashSet, wSSConsumerConfig, map);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Checking whether all required confidentiality is processed...");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object3 = (RequiredParts)iterator.next();
            object2 = ((RequiredParts)object3)._parts;
            for (int i = 0; i < ((RequiredPart[])object2).length; ++i) {
                object = ((RequiredPart)object2[i])._pconfig.getUsage();
                String string5 = ((RequiredPart)object2[i])._pconfig.getKeyword();
                if (!((RequiredPart)object2[i])._processed) {
                    if (ConfigUtil.isUsageRequired((String)object)) {
                        throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.DecryptedPartChecker.s01", string5);
                    }
                    if (!ConfigUtil.isUsageOptional((String)object) && !ConfigUtil.isUsageObserved((String)object)) continue;
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.DecryptedPartChecker.s01", (Object)string5);
                    continue;
                }
                if (!ConfigUtil.isUsageRejected((String)object)) continue;
                throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.DecryptedPartChecker.s02", string5);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Node target,Map context)");
        }
    }

    private static Set preprocess(Document document, Set set, Map map, Map map2) throws SoapSecurityException {
        RequiredPart requiredPart;
        int n;
        RequiredParts requiredParts;
        Element element;
        int n2;
        boolean bl;
        String string;
        String string2;
        PartList partList;
        ReferencePartConfig.PartConfig partConfig;
        Iterator iterator;
        Map map3;
        ReferencePartConfig referencePartConfig;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("preprocess(Document doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "Set requiredConfidentiality[" + set + "]," + "Set selectors," + "Map selectorMap)"));
        }
        HashSet<RequiredParts> hashSet = new HashSet<RequiredParts>();
        HashSet<ReferencePartConfig.PartConfig> hashSet2 = new HashSet<ReferencePartConfig.PartConfig>();
        HashMap hashMap = new HashMap();
        HashMap<ReferencePartConfig.PartConfig, ReferencePartConfig> hashMap2 = new HashMap<ReferencePartConfig.PartConfig, ReferencePartConfig>();
        Iterator iterator2 = set.iterator();
        while (iterator2.hasNext()) {
            referencePartConfig = (ReferencePartConfig)iterator2.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing ReferencePartConfig [" + referencePartConfig + "]..."));
            }
            map3 = new HashMap(map2);
            iterator = referencePartConfig.getParts().iterator();
            while (iterator.hasNext()) {
                partConfig = (ReferencePartConfig.PartConfig)iterator.next();
                if (partConfig.isTimestamp() || partConfig.isNonce()) {
                    hashSet2.add(partConfig);
                    hashMap.put(partConfig, map3);
                    hashMap2.put(partConfig, referencePartConfig);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Processing PartConfig [" + partConfig + "]..."));
                }
                if ((partList = (PartList)SignatureGenerator.getMessagePart(document, string2 = partConfig.getDialect(), string = partConfig.getKeyword(), "decryption_mode", map, class$com$ibm$ws$webservices$wssecurity$util$ConfidentialDialectElementSelector == null ? DecryptedPartChecker.class$("com.ibm.ws.webservices.wssecurity.util.ConfidentialDialectElementSelector") : class$com$ibm$ws$webservices$wssecurity$util$ConfidentialDialectElementSelector, map3)) != null && partList.getLength() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(partList.getLength() + " parts found."));
                    }
                    bl = false;
                    for (n2 = 0; n2 < partList.getLength(); ++n2) {
                        element = (Element)partList.item(n2);
                        Iterator iterator3 = hashSet.iterator();
                        block3: while (iterator3.hasNext()) {
                            requiredParts = (RequiredParts)iterator3.next();
                            for (n = 0; n < requiredParts._parts.length; ++n) {
                                requiredPart = requiredParts._parts[n];
                                if (!DOMUtil.equals((Node)element, (Node)requiredPart._element)) continue;
                                bl = true;
                                continue block3;
                            }
                        }
                        if (bl) continue;
                        RequiredPart[] requiredPartArray = new RequiredPart[]{new RequiredPart(referencePartConfig, partConfig, element)};
                        requiredParts = new RequiredParts(requiredPartArray, partList.getType());
                        hashSet.add(requiredParts);
                    }
                    continue;
                }
                throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s14", string2, string);
            }
        }
        iterator2 = hashSet2.iterator();
        while (iterator2.hasNext()) {
            partConfig = (ReferencePartConfig.PartConfig)iterator2.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing PartConfig [" + partConfig + "]..."));
            }
            map3 = (Map)hashMap.get(partConfig);
            referencePartConfig = (ReferencePartConfig)hashMap2.get(partConfig);
            if (!partConfig.isTimestamp() && !partConfig.isNonce()) continue;
            string2 = partConfig.getDialect();
            string = partConfig.getKeyword();
            partList = (PartList)SignatureGenerator.getNoncePart(document, null, partConfig, "decryption_mode", map, class$com$ibm$ws$webservices$wssecurity$util$ConfidentialDialectElementSelector == null ? DecryptedPartChecker.class$("com.ibm.ws.webservices.wssecurity.util.ConfidentialDialectElementSelector") : class$com$ibm$ws$webservices$wssecurity$util$ConfidentialDialectElementSelector, map3);
            if (partList != null && partList.getLength() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(partList.getLength() + " parts found."));
                }
                bl = false;
                for (n2 = 0; n2 < partList.getLength(); ++n2) {
                    element = (Element)partList.item(n2);
                    iterator = hashSet.iterator();
                    block7: while (iterator.hasNext()) {
                        requiredParts = (RequiredParts)iterator.next();
                        for (n = 0; n < requiredParts._parts.length; ++n) {
                            requiredPart = requiredParts._parts[n];
                            if (!DOMUtil.equals((Node)element, (Node)requiredPart._element)) continue;
                            if (partConfig.isTimestamp()) {
                                requiredPart._requiredTimestamp = partConfig.isTimestamp();
                            }
                            if (partConfig.isNonce()) {
                                requiredPart._requiredNonce = partConfig.isNonce();
                            }
                            bl = true;
                            continue block7;
                        }
                    }
                    if (bl) continue;
                    throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s14", string2, string);
                }
                continue;
            }
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s14", string2, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("preprocess(Document doc,Set requiredConfidentiality,Set selectors,Map selectorMap) returns Set[" + hashSet + "]"));
        }
        return hashSet;
    }

    private static RequiredPart getRelatedPart(DecryptionResult decryptionResult, DecryptionResult.DecryptedPart decryptedPart, Set set) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getRelatedPart(DecryptionResult dresult,DecryptedPart dpart[" + decryptedPart + "]," + "Set requiredParts[" + set + "])"));
        }
        SoapSecurityException soapSecurityException = null;
        RequiredPart requiredPart = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            RequiredParts requiredParts = (RequiredParts)iterator.next();
            RequiredPart[] requiredPartArray = requiredParts._parts;
            for (int i = 0; i < requiredPartArray.length; ++i) {
                if (requiredPartArray[i]._processed) continue;
                SoapSecurityException soapSecurityException2 = DecryptedPartChecker.checkBinding(requiredPartArray[i]._rconfig.getBindings(), decryptionResult);
                if (soapSecurityException2 == null) {
                    if (!DecryptedPartChecker.hasSameUri(requiredPartArray[i]._element, decryptedPart._object) && !DOMUtil.equals((Node)requiredPartArray[i]._element, (Node)decryptedPart._object)) continue;
                    requiredPart = requiredPartArray[i];
                    break;
                }
                soapSecurityException = soapSecurityException2;
            }
            if (requiredPart == null) continue;
            soapSecurityException = null;
            break;
        }
        if (soapSecurityException != null) {
            throw soapSecurityException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRelatedPart(DecryptionResult dresult,DecryptedPart dpart,Set requiredParts) returns RequiredPart[" + requiredPart + "]"));
        }
        return requiredPart;
    }

    private static boolean hasSameUri(Element element, Element element2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("hasSameUri(Element rpart[" + DOMUtil.getDisplayName((Node)element) + "]," + "Element dpart[" + DOMUtil.getDisplayName((Node)element2) + "])"));
        }
        boolean bl = false;
        String string = IdUtil.getInstance().getId(element);
        String string2 = IdUtil.getInstance().getId(element2);
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0 && string.equals(string2)) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("hasSameUri(Element rpart,Element dpart) returns boolean[" + bl + "]"));
        }
        return bl;
    }

    private static void checkCaller(DecryptionResult decryptionResult, Set set, WSSConsumerConfig wSSConsumerConfig, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkCaller(DecryptionResult vresult[" + decryptionResult + "]," + "Set rpconfigs[" + set + "]," + "WSSConsumerConfig gconfig," + "Map context)"));
        }
        Set set2 = wSSConsumerConfig.getCallers();
        boolean bl = true;
        if (set2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(set2.size() + " Callers found, so start to process it..."));
            }
            if (decryptionResult._token == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The token used for decryption not found...");
                }
            } else {
                boolean bl2 = decryptionResult._token.isTrusted();
                Iterator iterator = set2.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    Object object2;
                    Object object3;
                    WSSConsumerConfig.CallerConfig callerConfig = (WSSConsumerConfig.CallerConfig)iterator.next();
                    if (!bl2) {
                        object3 = callerConfig.getTokenType();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Checking the value type of the caller[" + object3 + "]"));
                        }
                        if (object3 != null && !((QName)object3).equals(decryptionResult._token.getType())) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("The value types are different: Caller config[" + object3 + "] and decrypted result[" + decryptionResult._token.getType() + "]"));
                            }
                            bl = false;
                        }
                        if (bl) {
                            object2 = callerConfig.getPart();
                            if (object2 == null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"ReferencePart of Caller config is null.");
                                }
                            } else if (object2.isOneOfIntegralParts()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"ReferencePart of Caller config is not confidential part.");
                                }
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Checking the ReferencePart of Caller config[" + object2 + "]"));
                                }
                                if (set.contains(object2)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("Linked the token[" + decryptionResult._token + "] and the Caller[" + callerConfig + "]."));
                                    }
                                    object = new AuthResult(decryptionResult._token, callerConfig);
                                    ResultPool.add((Map)map, (Result)object);
                                }
                            }
                        }
                    }
                    bl = true;
                    object3 = callerConfig.getTrustMethod();
                    if (object3 == null || !bl2) continue;
                    object2 = object3.getTokenType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Checking the value type of the TrustMethod[" + object2 + "]"));
                    }
                    if (object2 != null && !((QName)object2).equals(decryptionResult._token.getType())) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("The value types are different: TrustMethod config[" + object2 + "] and decrypted result[" + decryptionResult._token.getType() + "]"));
                        }
                        bl = false;
                    }
                    if (!bl) continue;
                    object = object3.getPart();
                    if (object == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"ReferencePart of TrustMethod config is null.");
                        continue;
                    }
                    if (object.isOneOfIntegralParts()) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"ReferencePart of TrustMethod config is not confidential part.");
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Checking the ReferencePart of TrustMethod config[" + object + "]"));
                    }
                    if (!set.contains(object)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Linked the token [" + decryptionResult._token + "] and the TrustMethod [" + object3 + "]."));
                    }
                    AuthResult authResult = new AuthResult(decryptionResult._token, (WSSConsumerConfig.CallerConfig)object3);
                    ResultPool.add((Map)map, (Result)authResult);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkCaller(Document doc,DecryptionResult dresult,WSSConsumerConfig gconfig,Map selectors,Map context)");
        }
    }

    private static SoapSecurityException checkBinding(Set set, DecryptionResult decryptionResult) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkBinding(Set bindings[" + set + "]," + "DecryptionResult dresult[" + decryptionResult + "])"));
        }
        Throwable throwable = null;
        boolean bl = set.contains(decryptionResult._config);
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The configuration of encryption consumer used for decryption was found in the bindings.");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The configuration of encryption consumer used for decryption was NOT found in the bindings.");
            }
            object = set.iterator();
            while (!bl && object.hasNext()) {
                EncryptionConsumerConfig encryptionConsumerConfig = (EncryptionConsumerConfig)object.next();
                KeyInfoResult keyInfoResult = (KeyInfoResult)decryptionResult._identities.get(encryptionConsumerConfig);
                if (keyInfoResult == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"There is no keyinfo result corresponding to the EncryptionConsumerConfig.");
                    continue;
                }
                Exception exception = keyInfoResult.getError();
                if (exception == null) {
                    Token token;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The keyinfo result has no exception.");
                    }
                    if ((token = (Token)decryptionResult._kresults.get(keyInfoResult)) == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"There is no token corresponding to the keyinfo result.");
                        continue;
                    }
                    if (token.getError() == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("The token [" + token + "] has no exception."));
                        }
                        bl = true;
                        break;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("The token [" + token + "] has the exception [" + exception.getMessage() + "]."));
                    }
                    throwable = token.getError();
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The keyinfo result has the exception [" + exception.getMessage() + "]."));
                }
                if (exception instanceof SoapSecurityException) {
                    throwable = (SoapSecurityException)exception;
                    continue;
                }
                throwable = SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKey04", exception);
            }
            if (bl) {
                throwable = null;
            }
        }
        if (tc.isEntryEnabled()) {
            object = throwable == null ? "null" : throwable.toString();
            Tr.exit((TraceComponent)tc, (String)("checkBinding(Set bindings,DecryptionResult dresult) returns SoapSecurityException[" + (String)object + "]"));
        }
        return throwable;
    }

    private static class RequiredPart {
        private ReferencePartConfig _rconfig;
        private ReferencePartConfig.PartConfig _pconfig;
        private Element _element;
        private boolean _requiredTimestamp;
        private boolean _requiredNonce;
        private Set _tokens;
        private boolean _processed;

        RequiredPart(ReferencePartConfig referencePartConfig, ReferencePartConfig.PartConfig partConfig, Element element) {
            this._rconfig = referencePartConfig;
            this._pconfig = partConfig;
            this._element = element;
            this._tokens = new HashSet();
            this._processed = false;
            this._requiredTimestamp = false;
            this._requiredNonce = false;
        }
    }

    private static class RequiredParts {
        private RequiredPart[] _parts;
        private String _type;

        RequiredParts(RequiredPart[] requiredPartArray, String string) {
            this._parts = requiredPartArray;
            this._type = string;
        }
    }
}

