/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.dsig;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSConsumer;
import com.ibm.ws.webservices.wssecurity.dsig.SignatureConsumer;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoConsumer;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.keyinfo.STRReferenceContentConsumer;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolverBase;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xss4j.enc.type.KeyInfo;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLDTKeyInfoResolver
extends KeyInfoResolverBase {
    private static final TraceComponent tc = Tr.register((Class)XMLDTKeyInfoResolver.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = XMLDTKeyInfoResolver.class.getName();
    private IDResolver _idResolver;
    private Set _tokenConsumers;
    private Set _encKIConsumers;
    private Map _context;
    private Map _selectors;
    private boolean _storedToken = false;
    private Set _stokens = null;
    private Result[] _results = null;

    protected XMLDTKeyInfoResolver() {
    }

    protected void setTokenConsumers(Set set) {
        this._tokenConsumers = set;
    }

    protected void setEncKeyInfoConsumers(Set set) {
        this._encKIConsumers = set;
    }

    protected void setContext(Map map) {
        this._context = map;
    }

    protected void setSelectors(Map map) {
        this._selectors = new HashMap(map);
    }

    public void setIdResolver(IDResolver iDResolver) {
        this._idResolver = iDResolver;
        super.setIdResolver(iDResolver);
    }

    public Key resolve(KeyInfo keyInfo, EncryptionMethod encryptionMethod) throws KeyInfoResolvingException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("resolve(KeyInfo keyInfo[" + keyInfo + "]," + "EncryptionMethod encMethod[" + encryptionMethod + "])"));
        }
        Key key = null;
        if (keyInfo != null) {
            try {
                Element element = keyInfo.getBase();
                if (element != null) {
                    if (!this._storedToken) {
                        this._stokens = XMLDTKeyInfoResolver.storeSubject(this._context);
                        this._results = XMLDTKeyInfoResolver.storeResult(this._context);
                        this._storedToken = true;
                    }
                    Document document = element.getOwnerDocument();
                    HashMap hashMap = new HashMap();
                    int n = 0;
                    Object v = this._context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
                    if (v != null && v instanceof Integer) {
                        n = (Integer)v;
                    }
                    String string = Constants.NAMESPACES[0][n];
                    String string2 = KeyInfoConsumer.getKeyInfoType(element, string);
                    boolean bl = "STRREF".equals(string2);
                    String string3 = null;
                    if (bl) {
                        string3 = STRReferenceContentConsumer.getReferenceURI(element, string);
                    }
                    if (bl) {
                        Element element2 = this._idResolver.resolveID(document, string3);
                        Element element3 = document.getDocumentElement();
                        boolean bl2 = XMLDTKeyInfoResolver.isUNT(element2, n);
                        boolean bl3 = bl2 ? false : XMLDTKeyInfoResolver.isBST(element2, n);
                        WSSConsumer.callTokenConsumer(null, this._tokenConsumers, element3, null, element2, this._context, bl2, bl3, n);
                    }
                    key = XMLDTKeyInfoResolver.callKeyInfoConsumer(this._encKIConsumers, hashMap, this._selectors, element, this._context);
                }
                if (key == null) {
                    key = super.resolve(keyInfo, encryptionMethod);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (KeyInfoResolvingException keyInfoResolvingException) {
                throw keyInfoResolvingException;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3;
                if (throwable instanceof SoapSecurityException && (throwable3 = ((SoapSecurityException)throwable).getCauseException()) != null) {
                    throwable2 = throwable3;
                }
                throw new KeyInfoResolvingException(throwable2.toString());
            }
            finally {
                if (this._storedToken) {
                    XMLDTKeyInfoResolver.restoreSubject(this._context, this._stokens);
                    XMLDTKeyInfoResolver.restoreResult(this._context, this._results);
                    this._storedToken = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("resolve(KeyInfo keyInfo,EncryptionMethod encMethod) returns Key[" + key + "]"));
        }
        return key;
    }

    private static Key callKeyInfoConsumer(Set set, Map map, Map map2, Element element, Map map3) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callKeyInfoConsumer(Set kconfig,Map type,Map properties,Element target[" + DOMUtil.getDisplayName((Node)element) + "]," + "Map context)"));
        }
        boolean bl = false;
        Exception exception = null;
        KeyInfoConsumerConfig keyInfoConsumerConfig = null;
        Key key = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            keyInfoConsumerConfig = (KeyInfoConsumerConfig)iterator.next();
            try {
                key = SignatureConsumer.callKeyInfoConsumer(keyInfoConsumerConfig, "DecryptingKey", map, map2, element, map3);
                bl = true;
                break;
            }
            catch (Exception exception2) {
                Tr.processException((Throwable)exception2, (String)(clsName + ".callSignatureConsumer"), (String)"233");
                exception = exception2;
            }
        }
        if (!bl) {
            throw SoapSecurityException.format("security.wssecurity.DTKeyInfoResolver.s01", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("callKeyInfoConsumer(Set sconfig,Map type,Map properties,Element target,Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    protected static Set storeSubject(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"storeSubject(Map context)");
        }
        Set set = TokenManager.getTokens(map);
        HashSet hashSet = new HashSet(set);
        TokenManager.removeTokens(map, set);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("storeSubject(Map context)returns Set[" + hashSet + "]"));
        }
        return hashSet;
    }

    protected static void restoreSubject(Map map, Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("restoreSubject(Map context,Set tokens[" + set + "])"));
        }
        if (set != null) {
            TokenManager.removeAllTokens(map);
            TokenManager.setTokens(map, set);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"restoreSubject(Map context,Set tolens)");
        }
    }

    protected static Result[] storeResult(Map map) {
        Result[] resultArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"storeResult(Map context)");
        }
        if ((resultArray = ResultPool.get((Map)map, (Class)KeyInfoResult.class)) != null) {
            ResultPool.remove((Map)map, (Result[])resultArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"storeResult(Map context)");
        }
        return resultArray;
    }

    protected static void restoreResult(Map map, Result[] resultArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("restoreResult(Map context,Result[] results[" + resultArray + "])"));
        }
        if (resultArray != null) {
            Result[] resultArray2 = ResultPool.get((Map)map, (Class)KeyInfoResult.class);
            if (resultArray2 != null) {
                ResultPool.remove((Map)map, (Result[])resultArray2);
            }
            for (int i = 0; i < resultArray.length; ++i) {
                ResultPool.add((Map)map, (Result)resultArray[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"restoreResult(Map context,Result[] results)");
        }
    }

    protected static boolean isUNT(Element element, int n) {
        return NamespaceUtil.checkWsseVersion(element, n, "UsernameToken") >= 0;
    }

    protected static boolean isBST(Element element, int n) {
        return NamespaceUtil.checkWsseVersion(element, n, "BinarySecurityToken") >= 0;
    }
}

