/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.dsig;

import com.ibm.ws.webservices.wssecurity.dsig.Canonicalizer;
import com.ibm.ws.wssecurity.xss4j.enc.util.DOMUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ExclusiveCanonicalizer {
    private static final boolean DEBUG = false;

    private ExclusiveCanonicalizer() {
    }

    public static void serializeSubset(Hashtable hashtable, NodeList nodeList, boolean bl, Map map, Writer writer) throws IOException {
        ExclusiveCanonicalizer.serializeSubset(hashtable, nodeList, bl, map, writer, null);
    }

    private static void serializeSubset(Hashtable hashtable, NodeList nodeList, boolean bl, Map map, Writer writer, Set set) throws IOException {
        Vector<Object> vector = new Vector<Object>(nodeList.getLength());
        block0: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node;
            Node node2 = nodeList.item(i);
            if (map.containsKey(node2)) {
                vector.add(new Canonicalizer.ReplacedNode(node2));
                int n = nodeList.getLength();
                for (int j = i + 1; j <= n; ++j) {
                    if (j < n && DOMUtil.isDescendantNode((Node)nodeList.item(j), (Node)node2)) continue;
                    i = j - 1;
                    continue block0;
                }
                continue;
            }
            if (node2.getNodeType() != 2) {
                Node node3;
                vector.addElement(node2);
                if (node2.getNodeType() != 1) continue;
                Hashtable<String, Node> hashtable2 = new Hashtable<String, Node>();
                if (i + 1 < nodeList.getLength() && (node3 = nodeList.item(i + 1)).getNodeType() == 2 && ((Attr)node3).getOwnerElement() == node2) {
                    ++i;
                    while (i < nodeList.getLength() && (node = nodeList.item(i)).getNodeType() == 2 && node2 == ((Attr)node).getOwnerElement()) {
                        hashtable2.put(node.getNodeName(), node);
                        ++i;
                    }
                    if (hashtable2.containsKey("xmlns") && ((Attr)hashtable2.get("xmlns")).getNodeValue().length() == 0) {
                        hashtable2.remove("xmlns");
                    }
                    --i;
                }
                vector.addElement(new Canonicalizer.Attributes(node2, hashtable2));
                continue;
            }
            Element element = ((Attr)node2).getOwnerElement();
            Hashtable<String, Node> hashtable3 = new Hashtable<String, Node>();
            while (i < nodeList.getLength() && (node = nodeList.item(i)).getNodeType() == 2 && element == ((Attr)node).getOwnerElement()) {
                hashtable3.put(node.getNodeName(), node);
                ++i;
            }
            vector.addElement(new Canonicalizer.Attributes(element, hashtable3));
            --i;
        }
        Stack stack = new Stack();
        for (int i = 0; i < vector.size(); ++i) {
            ExclusiveCanonicalizer.serializeSubset(stack, hashtable, vector, i, bl, map, writer, set);
        }
    }

    private static void serializeSubset(Stack stack, Hashtable hashtable, Vector vector, int n, boolean bl, Map map, Writer writer, Set set) throws IOException {
        Object object;
        Object e = vector.elementAt(n);
        if (e == null) {
            return;
        }
        if (e instanceof Canonicalizer.Attributes) {
            vector.setElementAt(null, n);
            ((Canonicalizer.Attributes)e).serialize(null, hashtable, null, writer);
            return;
        }
        if (e instanceof Canonicalizer.ReplacedNode) {
            Node node = ((Canonicalizer.ReplacedNode)e).getNode();
            NodeList nodeList = (NodeList)map.get(node);
            HashSet<Node> hashSet = new HashSet<Node>();
            int n2 = 0;
            int n3 = nodeList.getLength();
            block0: while (n2 < n3) {
                Node node2 = nodeList.item(n2);
                hashSet.add(node2);
                for (int i = n2 + 1; i <= n3; ++i) {
                    if (i < n3 && DOMUtil.isDescendantNode((Node)nodeList.item(i), (Node)node2)) continue;
                    n2 = i;
                    continue block0;
                }
            }
            ExclusiveCanonicalizer.serializeSubset(hashtable, nodeList, false, map, writer, hashSet);
            return;
        }
        Node node = (Node)e;
        short s = node.getNodeType();
        if (s == 9) {
            return;
        }
        if (s != 1) {
            Canonicalizer.serializeNode(null, node, null, bl, true, writer);
            return;
        }
        writer.write("<");
        writer.write(node.getNodeName());
        Canonicalizer.Attributes attributes = stack.empty() ? null : (Canonicalizer.Attributes)stack.peek();
        Canonicalizer.Attributes attributes2 = null;
        int n4 = n + 1;
        boolean bl2 = hashtable == null || hashtable.get("") == null ? node.getPrefix() == null : true;
        if (n4 >= vector.size() || vector.elementAt(n4) instanceof Node || vector.elementAt(n4) instanceof Canonicalizer.ReplacedNode) {
            object = node.getParentNode();
            if (set != null && set.contains(node) || bl2 && object.getNodeType() != 9 && attributes != null && attributes.contains("xmlns")) {
                writer.write(" xmlns=\"\"");
            }
        } else {
            attributes2 = (Canonicalizer.Attributes)vector.elementAt(n4);
            if (!attributes2.contains("xmlns")) {
                object = node.getParentNode();
                if (set != null && set.contains(node) || bl2 && object.getNodeType() != 9 && attributes != null && attributes.contains("xmlns")) {
                    writer.write(" xmlns=\"\"");
                }
            }
            if ((object = node.getPrefix()) == null) {
                object = "";
            }
            attributes2.serialize(stack, hashtable, (String)object, writer);
            vector.setElementAt(null, n4);
        }
        writer.write(">");
        stack.push(attributes2);
        while (n4 < vector.size()) {
            if (vector.elementAt(n4) == null) {
                ++n4;
                continue;
            }
            if (!Canonicalizer.isAncestor(vector.elementAt(n4), node)) break;
            ExclusiveCanonicalizer.serializeSubset(stack, hashtable, vector, n4, bl, map, writer, set);
            vector.setElementAt(null, n4++);
        }
        stack.pop();
        writer.write("</");
        writer.write(node.getNodeName());
        writer.write(">");
    }

    public static byte[] serializeSubset(Hashtable hashtable, NodeList nodeList, boolean bl, Map map) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            ExclusiveCanonicalizer.serializeSubset(hashtable, nodeList, bl, map, outputStreamWriter);
            ((Writer)outputStreamWriter).close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Internal Error: " + iOException);
        }
    }

    public static Hashtable parsePrefixList(String string) {
        Hashtable<String, String> hashtable = null;
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (hashtable == null) {
                hashtable = new Hashtable<String, String>();
            }
            if (string2.equals("#default")) {
                string2 = "";
            }
            hashtable.put(string2, string2);
        }
        return hashtable;
    }

    public static String serializePrefixList(Hashtable hashtable) {
        String string = null;
        if (hashtable != null && !hashtable.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if ("".equals(string2)) {
                    string2 = "#default";
                }
                if (bl) {
                    stringBuffer.append(" ");
                } else {
                    bl = true;
                }
                stringBuffer.append(string2);
            }
            string = stringBuffer.toString();
        }
        return string;
    }
}

