/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.webservice.wsbnd.PCBinding;
import com.ibm.etools.webservice.wsbnd.SecurityRequestReceiverBindingConfig;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.ComponentScopedRefs;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.SecurityRequestSenderBindingConfig;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.etools.webservice.wscommonbnd.DataEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.DigestMethod;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.PartReference;
import com.ibm.etools.webservice.wscommonbnd.SignatureMethod;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.ws.webservices.wssecurity.util.WebServicesSecurityAlgorithmHelper;
import com.ibm.wsspi.webservices.models.WSModels;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;

public class WSSFipsValidationServerTask
extends AbstractTask {
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSFipsValidationServerTask.class.getName();
    private static final TraceComponent tc = Tr.register(WSSFipsValidationServerTask.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String _taskName = "WSSFipsValidationServerTask";
    protected String _appName = null;
    protected String _moduleName = null;
    protected String _portName = null;
    protected boolean _fipsMode = false;
    protected boolean _algorithmsInitialized = false;
    protected Set _fipsSignatureMethods = new HashSet();
    protected Set _fipsDigestMethods = new HashSet();
    protected Set _fipsEncryptionMethods = new HashSet();
    protected Set _fipsKeyEncryptionMethods = new HashSet();

    public WSSFipsValidationServerTask() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSSFipsValidationServerTask()");
        }
        this.appTaskName = _taskName;
        this.bundle = ResourceBundle.getBundle("com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
        this._fipsMode = ConfigValidation.isFipsEnabled();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "FIPS mode is " + this._fipsMode);
        }
        if (this._fipsMode) {
            try {
                WebServicesSecurityAlgorithmHelper webServicesSecurityAlgorithmHelper = new WebServicesSecurityAlgorithmHelper();
                this._fipsSignatureMethods = webServicesSecurityAlgorithmHelper.getFipsSignatureAlgorithms();
                this._fipsDigestMethods = webServicesSecurityAlgorithmHelper.getFipsDigestAlgorithms();
                this._fipsEncryptionMethods = webServicesSecurityAlgorithmHelper.getFipsDataEncryptionAlgorithms();
                this._fipsKeyEncryptionMethods = webServicesSecurityAlgorithmHelper.getFipsKeyEncryptionAlgorithms();
                this._fipsSignatureMethods.addAll(webServicesSecurityAlgorithmHelper.get5xFipsSignatureAlgorithms());
                this._fipsDigestMethods.addAll(webServicesSecurityAlgorithmHelper.get5xFipsDigestAlgorithms());
                this._fipsEncryptionMethods.addAll(webServicesSecurityAlgorithmHelper.get5xFipsDataEncryptionAlgorithms());
                this._fipsKeyEncryptionMethods.addAll(webServicesSecurityAlgorithmHelper.get5xFipsKeyEncryptionAlgorithms());
                this._algorithmsInitialized = true;
            }
            catch (SoapSecurityException soapSecurityException) {
                FFDCFilter.processException((Throwable)soapSecurityException, clsName + ".WSSFipsValidationServerTask", "130", this);
                Tr.error(tc, "security.wssecurity.WSEC0150E", new Object[]{soapSecurityException});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSSFipsValidationServerTask()");
        }
    }

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask()");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "FIPS mode is " + this._fipsMode);
            Tr.debug(tc, "Algorithms initialized: " + this._algorithmsInitialized);
        }
        if (!this._fipsMode || !this._algorithmsInitialized) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask()");
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "task name is WSSFipsValidationServerTask");
        }
        InstallScheduler installScheduler = (InstallScheduler)this.scheduler;
        this._appName = installScheduler.getAppName();
        EARFile eARFile = installScheduler.getEarFile(false, true);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_appName is " + this._appName + ", ear file is " + eARFile);
        }
        boolean bl = DeployUtils.isWebServicesSecurityEnabled(eARFile);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WebServicesSecurityEnabled: " + bl);
        }
        if (!bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask()");
            }
            return true;
        }
        this.validateFipsAlgos(eARFile);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask()");
        }
        return true;
    }

    private void validateFipsAlgos(EARFile eARFile) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateFipsAlgos(EARFile ear[" + eARFile + "])");
        }
        List list = eARFile.getModuleFiles();
        LoadStrategy loadStrategy = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ModuleFile moduleFile = (ModuleFile)iterator.next();
            if (moduleFile == null) continue;
            loadStrategy = moduleFile.getLoadStrategy();
            String string = moduleFile.isWARFile() ? "WEB-INF/ibm-webservices-bnd.xmi" : "META-INF/ibm-webservices-bnd.xmi";
            String string2 = moduleFile.isWARFile() ? "WEB-INF/ibm-webservicesclient-bnd.xmi" : "META-INF/ibm-webservicesclient-bnd.xmi";
            WSBinding wSBinding = WSSFipsValidationServerTask.loadWebServicesBindingXML(loadStrategy, string);
            ClientBinding clientBinding = WSSFipsValidationServerTask.loadWebServicesClientBindingXML(loadStrategy, string2);
            this._moduleName = moduleFile.getName();
            if (this._moduleName == null) {
                this._moduleName = "<null>";
            }
            if (wSBinding != null) {
                this.validateFipsAlgosInWSBinding(wSBinding);
            }
            if (clientBinding == null) continue;
            this.validateFipsAlgosInClientBinding(clientBinding);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateFipsAlgos(EARFile ear)");
        }
    }

    private void validateFipsAlgosInWSBinding(WSBinding wSBinding) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateFipsAlgosInWSBinding(WSBinding wsb[" + wSBinding + "])");
        }
        boolean bl = true;
        EList eList = wSBinding.getWsdescBindings();
        if (eList != null && !eList.isEmpty()) {
            int n = eList.size();
            for (int i = 0; i < n; ++i) {
                WSDescBinding wSDescBinding = (WSDescBinding)eList.get(i);
                EList eList2 = wSDescBinding.getPcBindings();
                if (eList2 == null || eList2.isEmpty()) continue;
                int n2 = eList2.size();
                for (int j = 0; j < n2; ++j) {
                    EList eList3;
                    EList eList4;
                    Object object;
                    Object object2;
                    Object object3;
                    SecurityRequestReceiverBindingConfig securityRequestReceiverBindingConfig;
                    PCBinding pCBinding = (PCBinding)eList2.get(j);
                    this._portName = pCBinding.getPcNameLink();
                    if (this._portName == null) {
                        this._portName = "<null>";
                    }
                    if ((securityRequestReceiverBindingConfig = pCBinding.getSecurityRequestReceiverBindingConfig()) != null) {
                        object3 = securityRequestReceiverBindingConfig.getSigningInfos();
                        if (object3 != null && !object3.isEmpty()) {
                            bl = this.validateSigningInfos((EList)object3);
                        }
                        if ((object2 = securityRequestReceiverBindingConfig.getEncryptionInfos()) != null && !object2.isEmpty()) {
                            bl = this.validateEncryptionInfos((EList)object2);
                        }
                    }
                    if ((object3 = pCBinding.getSecurityResponseSenderBindingConfig()) != null) {
                        object2 = object3.getSigningInfo();
                        if (object2 != null) {
                            bl = this.validateSigningInfo((SigningInfo)object2);
                        }
                        if ((object = object3.getEncryptionInfo()) != null) {
                            bl = this.validateEncryptionInfo((EncryptionInfo)object);
                        }
                    }
                    if ((object2 = pCBinding.getSecurityRequestConsumerBindingConfig()) != null) {
                        object = object2.getSigningInfo();
                        if (object != null && !object.isEmpty()) {
                            bl = this.validateSigningInfos((EList)object);
                        }
                        if ((eList4 = object2.getEncryptionInfo()) != null && !eList4.isEmpty()) {
                            bl = this.validateEncryptionInfos(eList4);
                        }
                    }
                    if ((object = pCBinding.getSecurityResponseGeneratorBindingConfig()) == null) continue;
                    eList4 = object.getSigningInfo();
                    if (eList4 != null && !eList4.isEmpty()) {
                        bl = this.validateSigningInfos(eList4);
                    }
                    if ((eList3 = object.getEncryptionInfo()) == null || eList3.isEmpty()) continue;
                    bl = this.validateEncryptionInfos(eList3);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateFipsAlgosInWSBinding: valid = " + bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateFipsAlgosInWSBinding(WSBinding wsb)");
        }
    }

    private void validateFipsAlgosInClientBinding(ClientBinding clientBinding) {
        EList eList;
        EList eList2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateFipsAlgosInClientBinding(ClientBinding wscb[" + clientBinding + "])");
        }
        if ((eList2 = clientBinding.getServiceRefs()) != null && !eList2.isEmpty()) {
            this.validateServiceRefs(eList2);
        }
        if ((eList = clientBinding.getComponentScopedRefs()) != null && !eList.isEmpty()) {
            int n = eList.size();
            for (int i = 0; i < n; ++i) {
                EList eList3;
                ComponentScopedRefs componentScopedRefs = (ComponentScopedRefs)eList.get(i);
                if (componentScopedRefs == null || (eList3 = componentScopedRefs.getServiceRefs()) == null || eList3.isEmpty()) continue;
                this.validateServiceRefs(eList3);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateFipsAlgosInClientBinding(ClientBinding wscb)");
        }
    }

    private void validateServiceRefs(EList eList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateServiceRefs(EList srefs[" + eList + "])");
        }
        boolean bl = true;
        if (eList != null && !eList.isEmpty()) {
            int n = eList.size();
            for (int i = 0; i < n; ++i) {
                EList eList2;
                ServiceRef serviceRef = (ServiceRef)eList.get(i);
                if (serviceRef == null || (eList2 = serviceRef.getPortQnameBindings()) == null || eList2.isEmpty()) continue;
                int n2 = serviceRef.getPortQnameBindings().size();
                for (int j = 0; j < n2; ++j) {
                    EList eList3;
                    EList eList4;
                    Object object;
                    Object object2;
                    EObject eObject;
                    SecurityRequestSenderBindingConfig securityRequestSenderBindingConfig;
                    PortQnameBinding portQnameBinding = (PortQnameBinding)serviceRef.getPortQnameBindings().get(j);
                    if (portQnameBinding == null) continue;
                    this._portName = portQnameBinding.getPortQnameLocalNameLink();
                    if (this._portName == null) {
                        this._portName = "<null>";
                    }
                    if ((securityRequestSenderBindingConfig = portQnameBinding.getSecurityRequestSenderBindingConfig()) != null) {
                        eObject = securityRequestSenderBindingConfig.getSigningInfo();
                        if (eObject != null) {
                            bl = this.validateSigningInfo((SigningInfo)eObject);
                        }
                        if ((object2 = securityRequestSenderBindingConfig.getEncryptionInfo()) != null) {
                            bl = this.validateEncryptionInfo((EncryptionInfo)object2);
                        }
                    }
                    if ((eObject = portQnameBinding.getSecurityResponseReceiverBindingConfig()) != null) {
                        object2 = eObject.getSigningInfos();
                        if (object2 != null && !object2.isEmpty()) {
                            bl = this.validateSigningInfos((EList)object2);
                        }
                        if ((object = eObject.getEncryptionInfos()) != null && !object.isEmpty()) {
                            bl = this.validateEncryptionInfos((EList)object);
                        }
                    }
                    if ((object2 = portQnameBinding.getSecurityRequestGeneratorBindingConfig()) != null) {
                        object = object2.getSigningInfo();
                        if (object != null && !object.isEmpty()) {
                            bl = this.validateSigningInfos((EList)object);
                        }
                        if ((eList4 = object2.getEncryptionInfo()) != null && !eList4.isEmpty()) {
                            bl = this.validateEncryptionInfos(eList4);
                        }
                    }
                    if ((object = portQnameBinding.getSecurityResponseConsumerBindingConfig()) == null) continue;
                    eList4 = object.getSigningInfo();
                    if (eList4 != null && !eList4.isEmpty()) {
                        bl = this.validateSigningInfos(eList4);
                    }
                    if ((eList3 = object.getEncryptionInfo()) == null || eList3.isEmpty()) continue;
                    bl = this.validateEncryptionInfos(eList3);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateServicesRefs: valid = " + bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateServiceRefs(EList srefs)");
        }
    }

    private boolean validateSigningInfos(EList eList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateSigningInfos(EList sis[" + eList + "])");
        }
        boolean bl = true;
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            SigningInfo signingInfo = (SigningInfo)eList.get(i);
            if (signingInfo == null) continue;
            bl = this.validateSigningInfo(signingInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateSigningInfos(EList sis) returns " + bl);
        }
        return bl;
    }

    private boolean validateSigningInfo(SigningInfo signingInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateSigningInfo(SigningInfo si[" + signingInfo + "])");
        }
        boolean bl = true;
        if (signingInfo != null) {
            Object object;
            SignatureMethod signatureMethod = signingInfo.getSignatureMethod();
            if (signatureMethod != null) {
                object = signatureMethod.getAlgorithm();
                if (!this._fipsSignatureMethods.contains(object)) {
                    this.invalidAlgorithmNotification((String)object, "SignatureMethod");
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Valid signature algorithm URI:" + (String)object);
                }
            }
            if ((object = signingInfo.getPartReference()) != null) {
                int n = object.size();
                for (int i = 0; i < n; ++i) {
                    DigestMethod digestMethod;
                    PartReference partReference = (PartReference)object.get(i);
                    if (partReference == null || (digestMethod = partReference.getDigestMethod()) == null) continue;
                    String string = digestMethod.getAlgorithm();
                    if (!this._fipsDigestMethods.contains(string)) {
                        this.invalidAlgorithmNotification(string, "DigestMethod");
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Valid digest algorithm URI:" + string);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateSigningInfo(SigningInfo si) returns " + bl);
        }
        return bl;
    }

    private boolean validateEncryptionInfos(EList eList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateEncryptionInfos(EList eis[" + eList + "])");
        }
        boolean bl = true;
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            EncryptionInfo encryptionInfo = (EncryptionInfo)eList.get(i);
            if (encryptionInfo == null) continue;
            bl = this.validateEncryptionInfo(encryptionInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateEncryptionInfos(EList eis) returns " + bl);
        }
        return bl;
    }

    private boolean validateEncryptionInfo(EncryptionInfo encryptionInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateEncryptionInfo(EncryptionInfo ei[" + encryptionInfo + "])");
        }
        boolean bl = true;
        if (encryptionInfo != null) {
            Object object;
            DataEncryptionMethod dataEncryptionMethod = encryptionInfo.getEncryptionMethod();
            if (dataEncryptionMethod != null) {
                object = dataEncryptionMethod.getAlgorithm();
                if (!this._fipsEncryptionMethods.contains(object)) {
                    this.invalidAlgorithmNotification((String)object, "DataEncryptionMethod");
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Valid data encryption algorithm URI:" + (String)object);
                }
            }
            if ((object = encryptionInfo.getKeyEncryptionMethod()) != null) {
                String string = object.getAlgorithm();
                if (!this._fipsKeyEncryptionMethods.contains(string)) {
                    this.invalidAlgorithmNotification(string, "KeyEncryptionMethod");
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Valid key encryption algorithm URI:" + string);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateEncryptionInfo(EncryptionInfo ei) returns " + bl);
        }
        return bl;
    }

    private void invalidAlgorithmNotification(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invalidAlgorithmNotification(String uri[" + string + "], String description[" + string2 + "])");
        }
        InstallScheduler installScheduler = (InstallScheduler)this.scheduler;
        Tr.warning(tc, "security.wssecurity.WSEC0149W", (Object)new Object[]{this._appName, this._moduleName, this._portName, string2, string});
        installScheduler.propagateTaskEvent(this.createNotification("Completed", "security.wssecurity.WSEC0149W", new String[]{this._appName, this._moduleName, this._portName, string2, string}));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invalidAlgorithmNotification()");
        }
    }

    private static WSBinding loadWebServicesBindingXML(LoadStrategy loadStrategy, String string) {
        if (loadStrategy.getContainer().containsFile(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing IBM web services XML binding file:" + string);
            }
            try {
                return WSModels.getWSBinding(loadStrategy, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static ClientBinding loadWebServicesClientBindingXML(LoadStrategy loadStrategy, String string) {
        if (loadStrategy.getContainer().containsFile(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing IBM web services client XML binding file:" + string);
            }
            try {
                return WSModels.getWSClientBinding(loadStrategy, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

