/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.runtime.service.WSSecurityService;
import java.security.Permission;

public class WebServicesSecurityAdmin {
    private WSSecurityService wssec = null;
    private static final String clsName = WebServicesSecurityAdmin.class.getName();
    private static final TraceComponent tc = Tr.register(WebServicesSecurityAdmin.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final Permission SET_WSSEC_SERV_PERM = new WebSphereRuntimePermission("wssecurity.setSecurityService");

    WebServicesSecurityAdmin() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WebServicesSecurityAdmin");
            Tr.exit(tc, "WebServicesSecurityAdmin");
        }
    }

    void setWSSecurityService(WSSecurityService wSSecurityService) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setWSSecurityService", new Object[]{wSSecurityService});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(SET_WSSEC_SERV_PERM);
        }
        this.wssec = wSSecurityService;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setWSSecurityService");
        }
    }

    public void refresh() throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refresh");
        }
        if (this.wssec != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling WSSecurityService.refresh");
            }
            this.wssec.refresh();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refresh");
        }
    }
}

