/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ws.webservices.wssecurity.enc.PartList;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RequestMessagePool {
    private static final TraceComponent tc = Tr.register((Class)RequestMessagePool.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = RequestMessagePool.class.getName();

    private static void clear(Map map) {
        StoredMessage storedMessage = (StoredMessage)map.get(RequestMessagePool.class);
        if (storedMessage == null) {
            return;
        }
        storedMessage.clear();
    }

    public static void addDocument(Map map, Document document, List list, boolean bl) {
        StoredMessage storedMessage;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addDocument(Map context,Docment doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "List list," + "boolean cloneDoc[" + bl + "]"));
        }
        if ((storedMessage = (StoredMessage)map.get(RequestMessagePool.class)) == null) {
            storedMessage = new StoredMessage();
            map.put(RequestMessagePool.class, storedMessage);
        }
        storedMessage.addDocument(document, list, bl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addDocument(Map context,Docment doc,List list,boolean cloneDoc[" + bl + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addElement(Map map, Element element, Element element2, Element element3) {
        StoredMessage storedMessage;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addElement(Map context,Element objToBeEncrypted[" + DOMUtil.getDisplayName((Node)element) + "]," + "Element encryptedData[" + DOMUtil.getDisplayName((Node)element2) + "]," + "Element headerInfo[" + DOMUtil.getDisplayName((Node)element3) + "])"));
        }
        if ((storedMessage = (StoredMessage)map.get(RequestMessagePool.class)) == null) {
            storedMessage = new StoredMessage();
            map.put(RequestMessagePool.class, storedMessage);
        }
        StoredMessage storedMessage2 = storedMessage;
        synchronized (storedMessage2) {
            storedMessage.addElement(element, element2, element3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addElement(Map context,Element objToBeEncrypted,Element encryptedData,Element headerInfo)");
        }
    }

    public static Document getDocument(Map map, int n) {
        StoredMessage storedMessage;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getDocument(Map context,int order[" + n + "])"));
        }
        if ((storedMessage = (StoredMessage)map.get(RequestMessagePool.class)) == null) {
            storedMessage = new StoredMessage();
            map.put(RequestMessagePool.class, storedMessage);
        }
        Document document = storedMessage.getDocument(n);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getDocument(Map context,int order) returns Document[" + DOMUtil.getDisplayName((Node)document) + "]"));
        }
        return document;
    }

    public static EncryptedObject convertElement(Map map, Element element, int n) {
        StoredMessage storedMessage;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("convertElement(Map context,Element object[" + DOMUtil.getDisplayName((Node)element) + "]," + "int order[" + n + "])"));
        }
        if ((storedMessage = (StoredMessage)map.get(RequestMessagePool.class)) == null) {
            storedMessage = new StoredMessage();
            map.put(RequestMessagePool.class, storedMessage);
        }
        EncryptedObject encryptedObject = storedMessage.convertElement(element, n);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("convertElement(Map context,Element object,int order) returns EncryptedObject[" + encryptedObject + "]"));
        }
        return encryptedObject;
    }

    public static void initialize(Map map) {
        RequestMessagePool.clear(map);
    }

    public static void finalize(Map map) {
        RequestMessagePool.clear(map);
        map.remove(RequestMessagePool.class);
    }

    public static class EncryptedObject {
        private Element _headerInfo;
        private Element _encryptedData;

        public Element getHeaderInfo() {
            return this._headerInfo;
        }

        public Element getEncryptedData() {
            return this._encryptedData;
        }

        public void setEncryptedData(Element element) {
            this._encryptedData = element;
        }

        public String toString() {
            return "Element headerInfo[" + DOMUtil.getDisplayName((Node)this._headerInfo) + "]," + "Element encryptedData[" + DOMUtil.getDisplayName((Node)this._encryptedData) + "]";
        }
    }

    private static class StoredMessage {
        private ArrayList _messageList = new ArrayList();
        private ArrayList _objectList = new ArrayList();
        private ArrayList _edataList = new ArrayList();

        private StoredMessage() {
        }

        private void clear() {
            this._messageList.clear();
            this._objectList.clear();
            this._edataList.clear();
        }

        private void addDocument(Document document, List list, boolean bl) {
            Object object;
            Node node;
            Object object2;
            long l = System.currentTimeMillis();
            String string = "Attr" + l;
            String string2 = "dummy_";
            HashMap<String, Element> hashMap = new HashMap<String, Element>();
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object2 = (PartList)iterator.next();
                for (int i = 0; i < ((PartList)object2).getLength(); ++i) {
                    node = ((PartList)object2).item(i);
                    if (node.getNodeType() != 1) continue;
                    object = (Element)node;
                    String string3 = string2 + n++;
                    object.setAttribute(string, string3);
                    hashMap.put(string3, (Element)object);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Set attribute[" + string + "=" + string3 + "] to the element[" + DOMUtil.getDisplayName((Node)object) + "]"));
                }
            }
            object2 = bl ? (Document)document.cloneNode(true) : document;
            HashMap hashMap2 = new HashMap();
            node = object2.getDocumentElement();
            if (node != null) {
                this.putElement((Element)node, hashMap2, hashMap, string);
            }
            this._messageList.add(object2);
            this._objectList.add(hashMap2);
            this._edataList.add(new HashMap());
            iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (PartList)iterator.next();
                for (int i = 0; i < ((PartList)object).getLength(); ++i) {
                    Node node2 = ((PartList)object).item(i);
                    if (node2.getNodeType() != 1) continue;
                    Element element = (Element)node2;
                    element.removeAttribute(string);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Removed attribute[" + string + "] from the element[" + DOMUtil.getDisplayName((Node)element) + "]"));
                }
            }
        }

        private void putElement(Element element, Map map, Map map2, String string) {
            Element element2 = DOMUtil.getFirstElement((Node)element);
            while (element2 != null) {
                String string2;
                if (element2.hasAttribute(string) && (string2 = element2.getAttribute(string)) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found attribute[" + string + "=" + string2 + "] at the element[" + DOMUtil.getDisplayName((Node)element2) + "]"));
                    }
                    map.put(map2.get(string2), element2);
                }
                this.putElement(element2, map, map2, string);
                element2 = DOMUtil.getNextElement((Node)element2);
            }
        }

        private void addElement(Element element, Element element2, Element element3) {
            int n = this._messageList.size() - 1;
            if (n >= 0) {
                HashMap hashMap = (HashMap)this._objectList.get(n);
                HashMap hashMap2 = (HashMap)this._edataList.get(n);
                Object v = hashMap.get(element);
                if (v != null) {
                    EncryptedObject encryptedObject = new EncryptedObject();
                    encryptedObject._headerInfo = element3;
                    encryptedObject._encryptedData = element2;
                    hashMap2.put(v, encryptedObject);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Set EncryptedData and HeaderInfo(EncryptedKey or ReferenceList) for the element [" + DOMUtil.getDisplayName((Node)((Element)v)) + "]."));
                    }
                }
            }
        }

        private Document getDocument(int n) {
            Document document = null;
            int n2 = this._messageList.size() - 1 - n;
            if (n2 >= 0) {
                document = (Document)this._messageList.get(n2);
            }
            return document;
        }

        private EncryptedObject convertElement(Element element, int n) {
            EncryptedObject encryptedObject = null;
            if (n >= 0) {
                int n2 = this._messageList.size() - 1 - n;
                if (n2 >= 0) {
                    HashMap hashMap = (HashMap)this._edataList.get(n2);
                    encryptedObject = (EncryptedObject)hashMap.get(element);
                }
            } else {
                for (int i = this._messageList.size() - 1; i >= 0; --i) {
                    HashMap hashMap = (HashMap)this._edataList.get(i);
                    HashMap hashMap2 = (HashMap)this._objectList.get(i);
                    Iterator iterator = hashMap2.keySet().iterator();
                    while (iterator.hasNext()) {
                        Element element2 = (Element)iterator.next();
                        if (!DOMUtil.equalsc14n(element2, element, false)) continue;
                        encryptedObject = (EncryptedObject)hashMap.get(hashMap2.get(element2));
                        break;
                    }
                    if (encryptedObject != null) break;
                }
            }
            return encryptedObject;
        }
    }
}

