/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.confimpl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSAlgorithmFactory;
import com.ibm.ws.webservices.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.webservices.wssecurity.config.CollectionCertStore;
import com.ibm.ws.webservices.wssecurity.config.EncryptionConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.webservices.wssecurity.config.SignatureConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.TimestampConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.webservices.wssecurity.dsig.VerifiedConfig;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.webservices.wssecurity.token.CertCacheManager;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.id.TrustedIDEvaluator;
import com.ibm.wsspi.wssecurity.keyinfo.KeyLocator;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class PrivateConsumerConfig
extends PrivateCommonConfig
implements WSSConsumerConfig {
    private static final TraceComponent tc = Tr.register((Class)PrivateConsumerConfig.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = PrivateConsumerConfig.class.getName();
    protected String _myActor = null;
    protected boolean _ultimateReceiver = false;
    protected boolean _nonceCacheDistributed = false;
    protected final Set _allowedTransforms = new HashSet();
    protected final Set _allowedCanonicalizationMethods = new HashSet();
    protected final Set _allowedSignatureMethods = new HashSet();
    protected final Set _allowedDigestMethods = new HashSet();
    protected final Set _allowedDataEncryptionMethods = new HashSet();
    protected final Set _allowedKeyEncryptionMethods = new HashSet();
    protected final WSSAlgorithmFactory _algorithmFactory = (WSSAlgorithmFactory)WSSAlgorithmFactory.getInstance();
    protected final Set _defaultKeyInfoContentConsumers = new HashSet();
    protected final Set _defaultTokenConsumers = new HashSet();
    protected final Set _defaultJAASConfigs = new HashSet();
    protected final Set _defaultKeyLocators = new HashSet();
    protected boolean _userDefinedComponentsUsed = false;
    protected boolean _verificationRequired = false;
    protected boolean _decryptionRequired = false;
    protected boolean _tokenRequired = false;
    protected boolean _loginRequired = false;
    protected boolean _timestampRequired = false;
    protected final Set _requiredIntegralParts = new HashSet();
    protected final Set _requiredConfidentialParts = new HashSet();
    protected final Set _requiredSecurityTokens = new HashSet();
    protected final Set _callers = new HashSet();
    protected final Set _signatureConsumers = new HashSet();
    protected final Set _encryptionConsumers = new HashSet();
    protected final Set _tokenConsumers = new HashSet();
    protected TimestampConsumerConfImpl _timestampConsumer = null;
    protected NonceManager _nonceManager = null;
    protected CertCacheManager _certManager = null;
    protected int _timestampMaxAge = -1;
    protected int _timestampClockSkew = -1;
    protected Map _properties = null;
    protected boolean _bypassSecurityHeader = false;

    protected void processPrivateConfig(Document document) throws SoapSecurityException {
        String string;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processPrivateConfig(Document pconfig[" + document + "])"));
        }
        boolean bl = false;
        if (ConfigValidation.isFipsEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isFipsEnabled() is true; getting FIPS algorithms");
            }
            bl = true;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isFipsEnabled() is false; getting non-FIPS algorithms");
            }
            bl = false;
        }
        NodeList nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "Transform");
        int n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            string = DOMUtil.getAttribute((Element)((Element)nodeList.item(n)), (String)"algorithm");
            this._allowedTransforms.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Allowed Transforms:", (Object)new Object[]{this._allowedTransforms});
        }
        if (this._allowedTransforms.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.PrivateGeneratorConfig.s11");
        }
        nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "canonicalizationMethod");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            string = DOMUtil.getAttribute((Element)((Element)nodeList.item(n)), (String)"algorithm");
            this._allowedCanonicalizationMethods.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Allowed canonicalizationMethods:", (Object)new Object[]{this._allowedCanonicalizationMethods});
        }
        if (this._allowedCanonicalizationMethods.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.PrivateGeneratorConfig.s12");
        }
        nodeList = bl ? document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "fipsSignatureMethod") : document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "signatureMethod");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            string = DOMUtil.getAttribute((Element)((Element)nodeList.item(n)), (String)"algorithm");
            this._allowedSignatureMethods.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Allowed signatureMethods:", (Object)new Object[]{this._allowedSignatureMethods});
        }
        if (this._allowedSignatureMethods.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.PrivateGeneratorConfig.s13");
        }
        nodeList = bl ? document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "fipsDigestMethod") : document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "digestMethod");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            string = DOMUtil.getAttribute((Element)((Element)nodeList.item(n)), (String)"algorithm");
            this._allowedDigestMethods.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Allowed digestMethods:", (Object)new Object[]{this._allowedDigestMethods});
        }
        if (this._allowedDigestMethods.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.PrivateGeneratorConfig.s14");
        }
        nodeList = bl ? document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "fipsEncryptionMethod") : document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "encryptionMethod");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            string = DOMUtil.getAttribute((Element)((Element)nodeList.item(n)), (String)"algorithm");
            this._allowedDataEncryptionMethods.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Allowed encryptionMethods:", (Object)new Object[]{this._allowedDataEncryptionMethods});
        }
        if (this._allowedDataEncryptionMethods.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.PrivateGeneratorConfig.s15");
        }
        nodeList = bl ? document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "fipsKeyEncryptionMethod") : document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "keyEncryptionMethod");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            string = DOMUtil.getAttribute((Element)((Element)nodeList.item(n)), (String)"algorithm");
            if (!ConfigValidation.isAlgoSupportedByRuntime(string)) continue;
            this._allowedKeyEncryptionMethods.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Allowed keyEncryptionMethods:", (Object)new Object[]{this._allowedKeyEncryptionMethods});
        }
        if (this._allowedKeyEncryptionMethods.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.PrivateGeneratorConfig.s16");
        }
        nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "KeyInfoContentConsumer");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            string = DOMUtil.getAttribute((Element)((Element)nodeList.item(n)), (String)"class");
            this._defaultKeyInfoContentConsumers.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Default KeyInfoContentConsumer:", (Object)new Object[]{this._defaultKeyInfoContentConsumers});
        }
        if (this._defaultKeyInfoContentConsumers.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC6711W");
        }
        nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "TokenConsumer");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            string = DOMUtil.getAttribute((Element)((Element)nodeList.item(n)), (String)"class");
            this._defaultTokenConsumers.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Default TokenConsumer:", (Object)new Object[]{this._defaultTokenConsumers});
        }
        if (this._defaultTokenConsumers.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC6712W");
        }
        nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "JAASConfig");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            string = DOMUtil.getAttribute((Element)((Element)nodeList.item(n)), (String)"name");
            this._defaultJAASConfigs.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Default JAAS configuration:", (Object)new Object[]{this._defaultJAASConfigs});
        }
        if (this._defaultJAASConfigs.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC6713W");
        }
        nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "KeyLocator");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            string = DOMUtil.getAttribute((Element)((Element)nodeList.item(n)), (String)"class");
            this._defaultKeyLocators.add(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Default KeyLocator:", (Object)new Object[]{this._defaultKeyLocators});
        }
        if (this._defaultKeyLocators.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC6714W");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processPrivateConfig(Document pconfig)");
        }
    }

    public void validate() throws SoapSecurityException {
        this.validate(false);
    }

    public void validate(boolean bl) throws SoapSecurityException {
        EncryptionConsumerConfImpl encryptionConsumerConfImpl;
        KeyInfoContentConsumerConfImpl keyInfoContentConsumerConfImpl;
        KeyInfoConsumerConfImpl keyInfoConsumerConfImpl;
        PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl;
        SignatureConsumerConfImpl signatureConsumerConfImpl;
        TokenConsumerConfImpl tokenConsumerConfImpl;
        int n;
        String string;
        String string2;
        PrivateCommonConfig.PartConfImpl partConfImpl;
        Iterator iterator;
        PrivateCommonConfig.ReferencePartConfImpl referencePartConfImpl;
        int n2;
        int n3;
        int n4;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("validate(boolean defaultConfig[" + bl + "])"));
        }
        HashSet<PrivateCommonConfig.ReferencePartConfImpl> hashSet = new HashSet<PrivateCommonConfig.ReferencePartConfImpl>();
        HashSet<PrivateCommonConfig.ReferencePartConfImpl> hashSet2 = new HashSet<PrivateCommonConfig.ReferencePartConfImpl>();
        Iterator iterator2 = this._requiredIntegralParts.iterator();
        while (iterator2.hasNext()) {
            n4 = 0;
            n3 = 0;
            n2 = 0;
            referencePartConfImpl = (PrivateCommonConfig.ReferencePartConfImpl)iterator2.next();
            referencePartConfImpl.validate();
            if (referencePartConfImpl._usage != null && ConfigUtil.isUsage((String)referencePartConfImpl._usage) < 0) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s02", referencePartConfImpl._usage, referencePartConfImpl.toString());
            }
            iterator = referencePartConfImpl._parts.iterator();
            while (iterator.hasNext()) {
                partConfImpl = (PrivateCommonConfig.PartConfImpl)iterator.next();
                partConfImpl.validate();
                if (partConfImpl.isNonce()) {
                    ++n3;
                } else if (partConfImpl.isTimestamp()) {
                    ++n2;
                } else {
                    ++n4;
                }
                string2 = partConfImpl._dialect;
                string = partConfImpl._keyword;
                if (Constants.DIALECT_WAS.equals(string2)) {
                    n = ConfigUtil.isIntegralWASDialect((String)string);
                    if (n == 1 && partConfImpl.isTimestamp()) {
                        throw new SoapSecurityException("security.wssecurity.TimestampGenerator.s02");
                    }
                    if (n == 3) {
                        hashSet.add(referencePartConfImpl);
                        continue;
                    }
                    if (n == 4) {
                        hashSet2.add(referencePartConfImpl);
                        continue;
                    }
                    if (n >= 0) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", string, partConfImpl.toString());
                }
                if (Constants.DIALECT_FUNCTION.equals(string2)) {
                    if (string != null) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", string2, partConfImpl.toString());
                }
                if (Constants.DIALECT_XPATH.equals(string2)) {
                    if (string != null) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", string2, partConfImpl.toString());
                }
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s05", string2, partConfImpl.toString());
            }
            if (n3 <= 0 && n2 <= 0 || n4 > 0) continue;
            throw new SoapSecurityException("security.wssecurity.PrivateConsumerConfig.s36");
        }
        iterator2 = this._requiredConfidentialParts.iterator();
        while (iterator2.hasNext()) {
            n4 = 0;
            n3 = 0;
            n2 = 0;
            referencePartConfImpl = (PrivateCommonConfig.ReferencePartConfImpl)iterator2.next();
            referencePartConfImpl.validate();
            if (referencePartConfImpl._usage != null && ConfigUtil.isUsage((String)referencePartConfImpl._usage) < 0) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s02", referencePartConfImpl._usage, referencePartConfImpl.toString());
            }
            iterator = referencePartConfImpl._parts.iterator();
            while (iterator.hasNext()) {
                partConfImpl = (PrivateCommonConfig.PartConfImpl)iterator.next();
                partConfImpl.validate();
                if (partConfImpl.isNonce()) {
                    ++n3;
                } else if (partConfImpl.isTimestamp()) {
                    ++n2;
                } else {
                    ++n4;
                }
                string2 = partConfImpl._dialect;
                string = partConfImpl._keyword;
                if (Constants.DIALECT_WAS.equals(string2)) {
                    if (ConfigUtil.isConfidentialWASDialect((String)string) >= 0) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", string, partConfImpl.toString());
                }
                if (Constants.DIALECT_FUNCTION.equals(string2)) {
                    if (string != null) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", string2, partConfImpl.toString());
                }
                if (Constants.DIALECT_XPATH.equals(string2)) {
                    if (string != null) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", string2, partConfImpl.toString());
                }
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s05", string2, partConfImpl.toString());
            }
            if (n3 <= 0 && n2 <= 0 || n4 > 0) continue;
            throw new SoapSecurityException("security.wssecurity.PrivateConsumerConfig.s36");
        }
        if (bl) {
            HashMap<QName, TokenConsumerConfImpl> hashMap = new HashMap<QName, TokenConsumerConfImpl>();
            iterator2 = this._tokenConsumers.iterator();
            while (iterator2.hasNext()) {
                tokenConsumerConfImpl = (TokenConsumerConfImpl)iterator2.next();
                hashMap.put(tokenConsumerConfImpl.getType(), tokenConsumerConfImpl);
            }
            iterator2 = this._requiredSecurityTokens.iterator();
            while (iterator2.hasNext()) {
                tokenConsumerConfImpl = (TokenConsumerConfImpl)iterator2.next();
                QName qName = tokenConsumerConfImpl.getType();
                TokenConsumerConfImpl tokenConsumerConfImpl2 = (TokenConsumerConfImpl)hashMap.get(qName);
                if (tokenConsumerConfImpl2 == null) {
                    String string3 = "There is a required security token that does not have a matching token consumer. Its name is [" + tokenConsumerConfImpl._name + "] and its type is [" + qName + "].";
                    throw new SoapSecurityException(string3);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Found token consumer of type [" + qName + "]."));
            }
        } else {
            iterator2 = this._requiredSecurityTokens.iterator();
            while (iterator2.hasNext()) {
                tokenConsumerConfImpl = (TokenConsumerConfImpl)iterator2.next();
                if (this._tokenConsumers.contains(tokenConsumerConfImpl)) continue;
                String string4 = "There is a required security token that no token consumer references. Its name is [" + tokenConsumerConfImpl._name + "].";
                throw new SoapSecurityException(string4);
            }
        }
        if (this._callers != null) {
            iterator2 = this._callers.iterator();
            while (iterator2.hasNext()) {
                CallerConfImpl callerConfImpl = (CallerConfImpl)iterator2.next();
                callerConfImpl.validate();
                QName qName = callerConfImpl._tokenType;
                referencePartConfImpl = callerConfImpl._part;
                if (referencePartConfImpl != null && (Constants.UNTOKEN.equals(qName) || Constants.KERBEROSV5_ST.equals(qName) || Constants.KERBEROSV5_TGT.equals(qName))) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s06", callerConfImpl.toString());
                }
                if (referencePartConfImpl != null && !ConfigUtil.isUsageRequired((String)referencePartConfImpl._usage)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s33", callerConfImpl.toString());
                }
                if (!this.checkCallerRequired(this._tokenConsumers)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s34", qName.toString());
                }
                CallerConfImpl callerConfImpl2 = callerConfImpl._trustMethod;
                if (callerConfImpl2 == null) continue;
                qName = callerConfImpl2._tokenType;
                referencePartConfImpl = callerConfImpl2._part;
                if (referencePartConfImpl != null && (qName == null || Constants.UNTOKEN.equals(qName) || Constants.KERBEROSV5_ST.equals(qName) || Constants.KERBEROSV5_TGT.equals(qName))) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s07", callerConfImpl2.toString());
                }
                if (referencePartConfImpl != null && !ConfigUtil.isUsageRequired((String)referencePartConfImpl._usage)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s33", callerConfImpl2.toString());
                }
                if (qName == null || this.checkTrustMethodRequired(this._tokenConsumers)) continue;
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s34", qName.toString());
            }
        }
        iterator2 = this._signatureConsumers.iterator();
        while (iterator2.hasNext()) {
            signatureConsumerConfImpl = (SignatureConsumerConfImpl)iterator2.next();
            signatureConsumerConfImpl.validate(bl);
            algorithmConfImpl = signatureConsumerConfImpl._canonicalizationMethod;
            if (algorithmConfImpl != null) {
                algorithmConfImpl.validate();
                if (!this._allowedCanonicalizationMethods.contains(algorithmConfImpl._algorithm)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s08", algorithmConfImpl._algorithm);
                }
            }
            algorithmConfImpl = signatureConsumerConfImpl._signatureMethod;
            boolean bl2 = false;
            String string5 = null;
            if (algorithmConfImpl != null) {
                algorithmConfImpl.validate();
                if (!this._allowedSignatureMethods.contains(algorithmConfImpl._algorithm)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s09", algorithmConfImpl._algorithm);
                }
                string5 = algorithmConfImpl._algorithm;
                bl2 = ConfigUtil.isSecretKeyAlgorithm((String)string5);
            }
            if ((algorithmConfImpl = signatureConsumerConfImpl._keyInfoSignature) != null) {
                algorithmConfImpl.validate();
                if (ConfigUtil.isKeyInfoSignature((String)algorithmConfImpl._algorithm) < 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s10", algorithmConfImpl._algorithm);
                }
            }
            PrivateCommonConfig.ReferencePartConfImpl referencePartConfImpl2 = null;
            iterator = signatureConsumerConfImpl.getReferences().iterator();
            while (iterator.hasNext()) {
                PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl = (PrivateCommonConfig.SigningReferenceConfImpl)iterator.next();
                signingReferenceConfImpl.validate();
                algorithmConfImpl = signingReferenceConfImpl._digestMethod;
                if (algorithmConfImpl != null) {
                    algorithmConfImpl.validate();
                    if (!this._allowedDigestMethods.contains(algorithmConfImpl._algorithm)) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s11", algorithmConfImpl._algorithm);
                    }
                }
                boolean bl3 = false;
                Iterator iterator3 = signingReferenceConfImpl.getTransforms().iterator();
                while (iterator3.hasNext()) {
                    algorithmConfImpl = (PrivateCommonConfig.AlgorithmConfImpl)iterator3.next();
                    algorithmConfImpl.validate();
                    if (!this._allowedTransforms.contains(algorithmConfImpl._algorithm)) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s12", algorithmConfImpl._algorithm);
                    }
                    if ("http://www.w3.org/2002/07/decrypt#XML".equals(algorithmConfImpl._algorithm)) {
                        signatureConsumerConfImpl._isDecryptionXformEnabled = true;
                        continue;
                    }
                    if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(algorithmConfImpl._algorithm)) continue;
                    bl3 = true;
                }
                if (!bl3 || referencePartConfImpl2 != null) continue;
                if (hashSet.contains(signingReferenceConfImpl._reference)) {
                    referencePartConfImpl2 = signingReferenceConfImpl._reference;
                    continue;
                }
                if (!hashSet2.contains(signingReferenceConfImpl._reference)) continue;
                referencePartConfImpl2 = signingReferenceConfImpl._reference;
            }
            keyInfoConsumerConfImpl = signatureConsumerConfImpl._signingKeyInfo;
            keyInfoConsumerConfImpl.validate();
            iterator = keyInfoConsumerConfImpl._contentConsumers.iterator();
            while (iterator.hasNext()) {
                keyInfoContentConsumerConfImpl = (KeyInfoContentConsumerConfImpl)iterator.next();
                keyInfoContentConsumerConfImpl.validate();
                if (ConfigUtil.isKeyInfoType((String)keyInfoContentConsumerConfImpl._keyInfoType) < 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s13", keyInfoContentConsumerConfImpl.toString());
                }
                if (bl2) {
                    if (ConfigUtil.isKeyInfoEmb((String)keyInfoContentConsumerConfImpl._keyInfoType)) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", string5, keyInfoContentConsumerConfImpl._keyInfoType);
                    }
                    if (!ConfigUtil.isKeyInfoX509issuer((String)keyInfoContentConsumerConfImpl._keyInfoType)) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", string5, keyInfoContentConsumerConfImpl._keyInfoType);
                }
                if (referencePartConfImpl2 == null || keyInfoContentConsumerConfImpl._tokenConsumer != null) continue;
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s35");
            }
            this.checkIdentity(signatureConsumerConfImpl, this._signatureConsumers);
        }
        int n5 = this._signatureConsumers.size();
        if (n5 > 1) {
            iterator2 = this._signatureConsumers.iterator();
            while (iterator2.hasNext()) {
                signatureConsumerConfImpl = (SignatureConsumerConfImpl)iterator2.next();
                keyInfoConsumerConfImpl = signatureConsumerConfImpl._signingKeyInfo;
                iterator = this._signatureConsumers.iterator();
                while (iterator.hasNext()) {
                    SignatureConsumerConfImpl signatureConsumerConfImpl2 = (SignatureConsumerConfImpl)iterator.next();
                    if (signatureConsumerConfImpl.equals(signatureConsumerConfImpl2)) continue;
                    keyInfoConsumerConfImpl._otherContentConsumers.addAll(signatureConsumerConfImpl2._signingKeyInfo._contentConsumers);
                }
            }
        }
        iterator2 = this._encryptionConsumers.iterator();
        while (iterator2.hasNext()) {
            encryptionConsumerConfImpl = (EncryptionConsumerConfImpl)iterator2.next();
            encryptionConsumerConfImpl.validate(bl);
            algorithmConfImpl = encryptionConsumerConfImpl._dataEncryptionMethod;
            algorithmConfImpl.validate();
            if (!this._allowedDataEncryptionMethods.contains(algorithmConfImpl._algorithm)) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s14", algorithmConfImpl._algorithm);
            }
            String string6 = algorithmConfImpl._algorithm;
            boolean bl4 = ConfigUtil.isSecretKeyAlgorithm((String)string6);
            algorithmConfImpl = encryptionConsumerConfImpl._keyEncryptionMethod;
            if (algorithmConfImpl != null) {
                algorithmConfImpl.validate();
                if (!this._allowedKeyEncryptionMethods.contains(algorithmConfImpl._algorithm)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s15", algorithmConfImpl._algorithm);
                }
                string6 = algorithmConfImpl._algorithm;
                bl4 = ConfigUtil.isSecretKeyAlgorithm((String)string6);
            }
            keyInfoConsumerConfImpl = encryptionConsumerConfImpl._encryptionKeyInfo;
            keyInfoConsumerConfImpl.validate();
            iterator = keyInfoConsumerConfImpl._contentConsumers.iterator();
            while (iterator.hasNext()) {
                keyInfoContentConsumerConfImpl = (KeyInfoContentConsumerConfImpl)iterator.next();
                keyInfoContentConsumerConfImpl.validate();
                if (ConfigUtil.isKeyInfoType((String)keyInfoContentConsumerConfImpl._keyInfoType) < 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s13", keyInfoContentConsumerConfImpl.toString());
                }
                if (!bl4) continue;
                if (ConfigUtil.isKeyInfoEmb((String)keyInfoContentConsumerConfImpl._keyInfoType)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", string6, keyInfoContentConsumerConfImpl._keyInfoType);
                }
                if (!ConfigUtil.isKeyInfoX509issuer((String)keyInfoContentConsumerConfImpl._keyInfoType)) continue;
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", string6, keyInfoContentConsumerConfImpl._keyInfoType);
            }
            this.checkIdentity(encryptionConsumerConfImpl, this._encryptionConsumers);
        }
        n5 = this._encryptionConsumers.size();
        if (n5 > 1) {
            iterator2 = this._encryptionConsumers.iterator();
            while (iterator2.hasNext()) {
                encryptionConsumerConfImpl = (EncryptionConsumerConfImpl)iterator2.next();
                keyInfoConsumerConfImpl = encryptionConsumerConfImpl._encryptionKeyInfo;
                iterator = this._encryptionConsumers.iterator();
                while (iterator.hasNext()) {
                    EncryptionConsumerConfImpl encryptionConsumerConfImpl2 = (EncryptionConsumerConfImpl)iterator.next();
                    if (encryptionConsumerConfImpl.equals(encryptionConsumerConfImpl2)) continue;
                    keyInfoConsumerConfImpl._otherContentConsumers.addAll(encryptionConsumerConfImpl2._encryptionKeyInfo._contentConsumers);
                }
            }
        }
        iterator2 = this._tokenConsumers.iterator();
        while (iterator2.hasNext()) {
            tokenConsumerConfImpl = (TokenConsumerConfImpl)iterator2.next();
            tokenConsumerConfImpl.validate();
            if (tokenConsumerConfImpl._trustAnchorKeyStore != null) {
                tokenConsumerConfImpl._trustAnchorKeyStore.validate();
            }
            if (tokenConsumerConfImpl._usage != null && ConfigUtil.isUsage((String)tokenConsumerConfImpl._usage) < 0) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s02", tokenConsumerConfImpl._usage, tokenConsumerConfImpl.toString());
            }
            if (!this._requiredSecurityTokens.contains(tokenConsumerConfImpl)) continue;
            if (tokenConsumerConfImpl._usedForVerification) {
                String string7 = "The token consumer [" + tokenConsumerConfImpl._name + "] that refers to the required security token in DD is used for signature verification." + " The required security token should be used for \"stand-alone\" tokens.  Please check the configuration.";
                throw new SoapSecurityException(string7);
            }
            if (!tokenConsumerConfImpl._usedForDecryption) continue;
            String string8 = "The token consumer [" + tokenConsumerConfImpl._name + "] that refers to the required security token in DD is used for decryption." + " The required security token should be used for \"stand-alone\" tokens.  Please check the configuration.";
            throw new SoapSecurityException(string8);
        }
        if (this._timestampConsumer != null) {
            this._timestampConsumer.validate();
            String string9 = (String)this._timestampConsumer._properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TIMESTAMP_DIALECT);
            if (string9 != null && Constants.DIALECT_WAS.equals(string9) && (string9 = (String)this._timestampConsumer._properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TIMESTAMP_KEYWORD)) != null && (n = ConfigUtil.isTimestampWASDialect((String)string9)) < 0) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", string9, this._timestampConsumer.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validate(boolean)");
        }
    }

    public String getMyActor() {
        return this._myActor;
    }

    public boolean isUltimateReceiver() {
        return this._ultimateReceiver;
    }

    public boolean isNonceCacheDistributed() {
        return this._nonceCacheDistributed;
    }

    public Set getAllowedTransforms() {
        return this._allowedTransforms;
    }

    public Set getAllowedCanonicalizationMethods() {
        return this._allowedCanonicalizationMethods;
    }

    public Set getAllowedSignatureMethods() {
        return this._allowedSignatureMethods;
    }

    public Set getAllowedDigestMethods() {
        return this._allowedDigestMethods;
    }

    public Set getAllowedDataEncryptionMethods() {
        return this._allowedDataEncryptionMethods;
    }

    public Set getAllowedKeyEncryptionMethods() {
        return this._allowedKeyEncryptionMethods;
    }

    public WSSAlgorithmFactory getAlgorithmFactory() {
        return this._algorithmFactory;
    }

    public boolean isVerificationRequired() {
        return this._verificationRequired;
    }

    public boolean isDecryptionRequired() {
        return this._decryptionRequired;
    }

    public boolean isTokenRequired() {
        return this._tokenRequired;
    }

    public boolean isLoginRequired() {
        return this._loginRequired;
    }

    public boolean isTimestampRequired() {
        return this._timestampRequired;
    }

    public Set getRequiredIntegralParts() {
        return this._requiredIntegralParts;
    }

    public Set getRequiredConfidentialParts() {
        return this._requiredConfidentialParts;
    }

    public Set getRequiredSecurityTokens() {
        return this._requiredSecurityTokens;
    }

    public Set getCallers() {
        return this._callers;
    }

    public Set getSignatureConsumers() {
        return this._signatureConsumers;
    }

    public Set getEncryptionConsumers() {
        return this._encryptionConsumers;
    }

    public Set getTokenConsumers() {
        return this._tokenConsumers;
    }

    public TimestampConsumerConfig getTimestampConsumer() {
        return this._timestampConsumer;
    }

    public NonceManager getNonceManager() {
        return this._nonceManager;
    }

    public CertCacheManager getCertManager() {
        return this._certManager;
    }

    public int getTimestampMaxAge() {
        return this._timestampMaxAge;
    }

    public int getTimestampClockSkew() {
        return this._timestampClockSkew;
    }

    public boolean isUserDefinedComponentsUsed() {
        return this._userDefinedComponentsUsed;
    }

    public Map getProperties() {
        return this._properties;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
        stringBuffer.append("myActor=[").append(this._myActor).append("], ");
        stringBuffer.append("ultimateReceiver=[").append(this._ultimateReceiver).append("], ");
        stringBuffer.append("nonceCacheDistributed=[").append(this._nonceCacheDistributed).append("], ");
        stringBuffer.append("allowedTransforms=[").append(this._allowedTransforms).append("], ");
        stringBuffer.append("allowedCanonicalizations=[").append(this._allowedCanonicalizationMethods).append("], ");
        stringBuffer.append("allowedSignatures=[").append(this._allowedSignatureMethods).append("], ");
        stringBuffer.append("allowedDigests=[").append(this._allowedDigestMethods).append("], ");
        stringBuffer.append("allowedDataEncryptions=[").append(this._allowedDataEncryptionMethods).append("], ");
        stringBuffer.append("allowedKeyEncryptions=[").append(this._allowedKeyEncryptionMethods).append("], ");
        stringBuffer.append("algorithmFactory=[").append((Object)this._algorithmFactory).append("], ");
        stringBuffer.append("verificationRequired=[").append(this._verificationRequired).append("], ");
        stringBuffer.append("decryptionRequired=[").append(this._decryptionRequired).append("], ");
        stringBuffer.append("tokenRequired=[").append(this._tokenRequired).append("], ");
        stringBuffer.append("timestampRequired=[").append(this._timestampRequired).append("], ");
        stringBuffer.append("requiredIntegralParts=[").append(this._requiredIntegralParts).append("], ");
        stringBuffer.append("requiredConfidentialParts=[").append(this._requiredConfidentialParts).append("], ");
        stringBuffer.append("callers=[").append(this._callers).append("], ");
        stringBuffer.append("signatureConsumers=[").append(this._signatureConsumers).append("], ");
        stringBuffer.append("encryptionConsumers=[").append(this._encryptionConsumers).append("], ");
        stringBuffer.append("tokenConsumers=[").append(this._tokenConsumers).append("], ");
        stringBuffer.append("timestampConsumer=[").append(this._timestampConsumer).append("], ");
        stringBuffer.append("nonceManager=[").append(this._nonceManager).append("], ");
        stringBuffer.append("timestampMaxAge=[").append(this._timestampMaxAge).append("], ");
        stringBuffer.append("timestampClockSkew=[").append(this._timestampClockSkew).append("], ");
        stringBuffer.append("userDefinedComponentsUsed=[").append(this._userDefinedComponentsUsed).append("], ");
        stringBuffer.append("bypassSecurityHeader=[").append(this._bypassSecurityHeader).append("], ");
        stringBuffer.append("properties=[").append(this._properties).append("]");
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private boolean checkCallerRequired(Set set) {
        boolean bl = false;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            TokenConsumerConfImpl tokenConsumerConfImpl = (TokenConsumerConfImpl)iterator.next();
            if (!tokenConsumerConfImpl._callerRequired) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean checkTrustMethodRequired(Set set) {
        boolean bl = false;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            TokenConsumerConfImpl tokenConsumerConfImpl = (TokenConsumerConfImpl)iterator.next();
            if (!tokenConsumerConfImpl._trustMethodRequired) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void checkIdentity(SignatureConsumerConfImpl signatureConsumerConfImpl, Set set) {
        if (set.size() > 1) {
            String string = signatureConsumerConfImpl._canonicalizationMethod._algorithm;
            String string2 = signatureConsumerConfImpl._signatureMethod._algorithm;
            String string3 = signatureConsumerConfImpl._keyInfoSignature == null ? null : signatureConsumerConfImpl._keyInfoSignature._algorithm;
            List list = signatureConsumerConfImpl._references;
            List list2 = signatureConsumerConfImpl._signingKeyInfo._contentConsumers;
            boolean bl = true;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                SignatureConsumerConfImpl signatureConsumerConfImpl2 = (SignatureConsumerConfImpl)iterator.next();
                if (signatureConsumerConfImpl2.equals(signatureConsumerConfImpl) || !string.equals(signatureConsumerConfImpl2._canonicalizationMethod._algorithm) || !string2.equals(signatureConsumerConfImpl2._signatureMethod._algorithm)) continue;
                PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl = signatureConsumerConfImpl2._keyInfoSignature;
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl = (PrivateCommonConfig.SigningReferenceConfImpl)iterator2.next();
                    ArrayList<VerifiedConfig> arrayList = (ArrayList<VerifiedConfig>)signatureConsumerConfImpl._identity.get(signingReferenceConfImpl);
                    if (arrayList == null) {
                        arrayList = new ArrayList<VerifiedConfig>();
                        signatureConsumerConfImpl._identity.put(signingReferenceConfImpl, arrayList);
                    }
                    String string4 = signingReferenceConfImpl._digestMethod._algorithm;
                    HashSet<String> hashSet = new HashSet<String>();
                    Iterator iterator3 = signingReferenceConfImpl._transforms.iterator();
                    while (iterator3.hasNext()) {
                        algorithmConfImpl = (PrivateCommonConfig.AlgorithmConfImpl)iterator3.next();
                        hashSet.add(algorithmConfImpl._algorithm);
                    }
                    iterator3 = signatureConsumerConfImpl2._references.iterator();
                    while (iterator3.hasNext()) {
                        PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl2 = (PrivateCommonConfig.SigningReferenceConfImpl)iterator3.next();
                        if (!string4.equals(signingReferenceConfImpl2._digestMethod._algorithm)) continue;
                        boolean bl2 = true;
                        Iterator iterator4 = signingReferenceConfImpl2._transforms.iterator();
                        while (iterator4.hasNext()) {
                            algorithmConfImpl = (PrivateCommonConfig.AlgorithmConfImpl)iterator4.next();
                            if (hashSet.contains(algorithmConfImpl._algorithm)) continue;
                            bl2 = false;
                            break;
                        }
                        if (!bl2) continue;
                        arrayList.add(new VerifiedConfig(signatureConsumerConfImpl2, signingReferenceConfImpl2));
                    }
                }
            }
        }
    }

    private void checkIdentity(EncryptionConsumerConfImpl encryptionConsumerConfImpl, Set set) {
        if (set.size() > 1) {
            String string = encryptionConsumerConfImpl._dataEncryptionMethod._algorithm;
            String string2 = encryptionConsumerConfImpl._keyEncryptionMethod == null ? null : encryptionConsumerConfImpl._keyEncryptionMethod._algorithm;
            List list = encryptionConsumerConfImpl._encryptionKeyInfo._contentConsumers;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                EncryptionConsumerConfImpl encryptionConsumerConfImpl2 = (EncryptionConsumerConfImpl)iterator.next();
                if (encryptionConsumerConfImpl2.equals(encryptionConsumerConfImpl) || !string.equals(encryptionConsumerConfImpl2._dataEncryptionMethod._algorithm)) continue;
                PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl = encryptionConsumerConfImpl2._keyEncryptionMethod;
                if (string2 == null ? algorithmConfImpl != null : algorithmConfImpl == null || !string2.equals(algorithmConfImpl._algorithm)) continue;
                encryptionConsumerConfImpl._identity.add(encryptionConsumerConfImpl2);
            }
        }
    }

    public boolean getBypassSecurityHeaderSetting() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("com.ibm.wsspi.wssecurity.config.disableWSSIfApplicationSecurityDisabled=" + this._bypassSecurityHeader));
        }
        return this._bypassSecurityHeader;
    }

    public static class KeyInfoContentConsumerConfImpl
    implements KeyInfoContentConsumerConfig {
        public String _className = null;
        public KeyInfoContentConsumerComponent _instance = null;
        public String _keyInfoType = null;
        public KeyLocator _keyLocator = null;
        public String _keyName = null;
        public TokenConsumerConfImpl _tokenConsumer = null;
        public final Map _properties = new HashMap();

        public void validate() throws SoapSecurityException {
            if (this._instance == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s25", this.toString());
            }
            if (this._keyInfoType == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s26", this.toString());
            }
        }

        public KeyInfoContentConsumerComponent getInstance() {
            return this._instance;
        }

        public String getKeyInfoType() {
            return this._keyInfoType;
        }

        public KeyLocator getKeyLocator() {
            return this._keyLocator;
        }

        public String getKeyName() {
            return this._keyName;
        }

        public TokenConsumerConfig getTokenConsumer() {
            return this._tokenConsumer;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("className=[").append(this._className).append("], ");
            stringBuffer.append("keyInfoType=[").append(this._keyInfoType).append("], ");
            stringBuffer.append("keyLocator=[").append(this._keyLocator).append("], ");
            stringBuffer.append("tokenConsumer=[").append(this._tokenConsumer).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    public static class KeyInfoConsumerConfImpl
    implements KeyInfoConsumerConfig {
        public List _contentConsumers = null;
        public final List _otherContentConsumers = new ArrayList();

        public void validate() throws SoapSecurityException {
            if (this._contentConsumers == null || this._contentConsumers.isEmpty()) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s24", this.toString());
            }
        }

        public List getContentConsumers() {
            return this._contentConsumers;
        }

        public List getOtherContentConsumers() {
            return this._otherContentConsumers;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("contentConsumers=[").append(this._contentConsumers).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    public static class TimestampConsumerConfImpl
    implements TimestampConsumerConfig {
        public String _actor = null;
        public int _timestampMaxAge = 300;
        public int _timestampClockSkew = 0;
        public final Map _properties = new HashMap();

        public void validate() throws SoapSecurityException {
        }

        public String getActor() {
            return this._actor;
        }

        public int getTimestampMaxAge() {
            return this._timestampMaxAge;
        }

        public int getTimestampClockSkew() {
            return this._timestampClockSkew;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("actor=[").append(this._actor).append("], ");
            stringBuffer.append("timestampMaxAge=[").append(this._timestampMaxAge).append("], ");
            stringBuffer.append("timestampClockSkew=[").append(this._timestampClockSkew).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    public static class TokenConsumerConfImpl
    implements TokenConsumerConfig {
        public String _name = null;
        public String _className = null;
        public TokenConsumerComponent _instance = null;
        public String _usage = null;
        public QName _type = null;
        public TrustedIDEvaluator _trustedIDEvaluator = null;
        public boolean _trustAny = false;
        public Provider _provider = null;
        public PKIXBuilderParameters _pkixBuilderParams = null;
        public boolean _callerRequired = false;
        public Map _callerProperties = null;
        public boolean _trustMethodRequired = false;
        public Map _trustMethodProperties = null;
        public String _jaasConfig = null;
        public final Map _jaasConfigProperties = new HashMap();
        public boolean _usedForVerification = false;
        public boolean _usedForDecryption = false;
        public final Map _properties = new HashMap();
        private volatile boolean _initialized = false;
        public List _certStores = new ArrayList();
        public String _trustAnchorRef = null;
        public com.ibm.ws.webservices.wssecurity.config.KeyStore _trustAnchorKeyStore = null;

        public void validate() throws SoapSecurityException {
            String string;
            String string2;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"TokenConsumerConfImpl.validate");
            }
            if (this._instance == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s22", this.toString());
            }
            if (this._type == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s23", this.toString());
            }
            if (this._certStores.isEmpty() && this._provider == null && ConfigUtil.hasValue((String)(string2 = (String)this._properties.get(string = "com.ibm.wsspi.wssecurity.config.CertStore.Provider")))) {
                throw new SoapSecurityException("The cert store security provider '" + string2 + "' active for the token consumer '" + this._name + "' does not exist.  The cert store security provider is " + "configured on the '" + string + "' property.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"TokenConsumerConfImpl.validate");
            }
        }

        protected synchronized void initCerts() {
            Object object;
            Object object2;
            Object object3;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"initCerts()");
            }
            if (this._initialized) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"initCerts()");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("_pkixBuilderParams is " + this._pkixBuilderParams));
                Tr.debug((TraceComponent)tc, (String)("_trustAnchorKeyStore is " + this._trustAnchorKeyStore));
                Tr.debug((TraceComponent)tc, (String)("_trustAnchorRef is " + this._trustAnchorRef));
            }
            if (this._pkixBuilderParams == null && this._trustAnchorKeyStore != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Getting java.security.KeyStore instance from trust anchor " + this._trustAnchorRef));
                }
                object3 = this._trustAnchorKeyStore.getInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Got java.security.KeyStore instance: " + object3));
                }
                if (object3 == null) {
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.ConfigValidation.keystore.taref.open", (Object)new Object[]{this._trustAnchorRef});
                }
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Creating X509CertSelector.");
                    }
                    object2 = new X509CertSelector();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Creating PKIXBuilderParameters.");
                    }
                    this._pkixBuilderParams = new PKIXBuilderParameters((KeyStore)object3, (CertSelector)object2);
                    this._pkixBuilderParams.setDate(null);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    object = "security.wssecurity.CommonReceiverConfig.s12";
                    FFDCFilter.processException((Throwable)invalidAlgorithmParameterException, clsName + ".WSEMFRequestConsumerConfig", "1291", this);
                    Tr.warning((TraceComponent)tc, (String)object, (Object)new Object[]{invalidAlgorithmParameterException});
                }
                catch (KeyStoreException keyStoreException) {
                    object = "security.wssecurity.CommonReceiverConfig.s12";
                    FFDCFilter.processException((Throwable)keyStoreException, clsName + ".WSEMFRequestConsumerConfig", "1295", this);
                    Tr.warning((TraceComponent)tc, (String)object, (Object)new Object[]{keyStoreException});
                }
            }
            if (this._certStores != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"_certStores is non-null");
                }
                if (!(object3 = this._certStores.iterator()).hasNext() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"_certStores is empty");
                }
                while (object3.hasNext()) {
                    object2 = object3.next();
                    if (object2 instanceof CollectionCertStore) {
                        CertStore certStore;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Instance is a CollectionCertStore, creating CertStore instance.");
                        }
                        if ((certStore = ((CollectionCertStore)(object = (CollectionCertStore)object2)).getInstance()) != null) {
                            if (this._pkixBuilderParams != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Adding CertStore to pkixBuilderParams.");
                                }
                                this._pkixBuilderParams.addCertStore(certStore);
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"pkixBuilderParams was null; not adding CertStore.");
                            }
                            this._provider = certStore.getProvider();
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"CollectionCertStore.getInstance() returned null.");
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Instance not a CollectionCertStore, nothing to do.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"_certStores is null");
            }
            this._initialized = true;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initCerts()");
            }
        }

        public TokenConsumerComponent getInstance() {
            return this._instance;
        }

        public String getUsage() {
            return this._usage;
        }

        public QName getType() {
            return this._type;
        }

        public TrustedIDEvaluator getTrustedIDEvaluator() {
            return this._trustedIDEvaluator;
        }

        public boolean isTrustAnyCertificate() {
            return this._trustAny;
        }

        public Provider getProvider() {
            this.initCerts();
            return this._provider;
        }

        public PKIXBuilderParameters getPKIXBuilderParameters() {
            this.initCerts();
            return this._pkixBuilderParams;
        }

        public boolean isCallerRequired() {
            return this._callerRequired;
        }

        public Map getCallerProperties() {
            return this._callerProperties;
        }

        public boolean isTrustMethodRequired() {
            return this._trustMethodRequired;
        }

        public Map getTrustMethodProperties() {
            return this._trustMethodProperties;
        }

        public String getJAASConfig() {
            return this._jaasConfig;
        }

        public Map getJAASConfigProperties() {
            return this._jaasConfigProperties;
        }

        public boolean isUsedForVerification() {
            return this._usedForVerification;
        }

        public boolean isUsedForDecryption() {
            return this._usedForDecryption;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("className=[").append(this._className).append("], ");
            stringBuffer.append("usage=[").append(this._usage).append("], ");
            stringBuffer.append("type=[").append(this._type).append("], ");
            stringBuffer.append("trustedIdEvaluator=[").append(this._trustedIDEvaluator).append("], ");
            stringBuffer.append("trustAny=[").append(this._trustAny).append("], ");
            stringBuffer.append("provider=[").append(this._provider).append("], ");
            stringBuffer.append("pkixBuilderParams=[").append(this._pkixBuilderParams).append("], ");
            stringBuffer.append("callerRequired=[").append(this._callerRequired).append("], ");
            stringBuffer.append("callerProperties=[").append(this._callerProperties).append("], ");
            stringBuffer.append("trustMethodRequired=[").append(this._trustMethodRequired).append("], ");
            stringBuffer.append("trustMethodProperties=[").append(this._trustMethodProperties).append("], ");
            stringBuffer.append("jaasConfig=[").append(this._jaasConfig).append("], ");
            stringBuffer.append("jaasConfigProperties=[").append(this._jaasConfigProperties).append("], ");
            stringBuffer.append("usedForVerification=[").append(this._usedForVerification).append("], ");
            stringBuffer.append("usedForDecryption=[").append(this._usedForDecryption).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    public static class EncryptionConsumerConfImpl
    implements EncryptionConsumerConfig {
        public PrivateCommonConfig.AlgorithmConfImpl _dataEncryptionMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _keyEncryptionMethod = null;
        public KeyInfoConsumerConfImpl _encryptionKeyInfo = null;
        public PrivateCommonConfig.ReferencePartConfImpl _reference = null;
        public final Map _properties = new HashMap();
        public final List _identity = new ArrayList();

        public void validate() throws SoapSecurityException {
            this.validate(false);
        }

        public void validate(boolean bl) throws SoapSecurityException {
            if (this._dataEncryptionMethod == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s19", this.toString());
            }
            if (this._encryptionKeyInfo == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s20", this.toString());
            }
            if (this._reference == null && !bl) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s21", this.toString());
            }
        }

        public AlgorithmConfig getDataEncryptionMethod() {
            return this._dataEncryptionMethod;
        }

        public AlgorithmConfig getKeyEncryptionMethod() {
            return this._keyEncryptionMethod;
        }

        public KeyInfoConsumerConfig getEncryptionKeyInfo() {
            return this._encryptionKeyInfo;
        }

        public ReferencePartConfig getReference() {
            return this._reference;
        }

        public Map getProperties() {
            return this._properties;
        }

        public List getIdentityList() {
            return this._identity;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("dataEncryptionMethod=[").append(this._dataEncryptionMethod).append("], ");
            stringBuffer.append("keyEncryptionMethod=[").append(this._keyEncryptionMethod).append("], ");
            stringBuffer.append("encryptionKeyInfo=[").append(this._encryptionKeyInfo).append("], ");
            stringBuffer.append("reference=[").append(this._reference).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    public static class SignatureConsumerConfImpl
    implements SignatureConsumerConfig {
        public PrivateCommonConfig.AlgorithmConfImpl _canonicalizationMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _signatureMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _keyInfoSignature = null;
        public KeyInfoConsumerConfImpl _signingKeyInfo = null;
        public final List _references = new ArrayList();
        public final Map _properties = new HashMap();
        public final Map _identity = new HashMap();
        private boolean _isDecryptionXformEnabled = false;

        public void validate() throws SoapSecurityException {
            this.validate(false);
        }

        public void validate(boolean bl) throws SoapSecurityException {
            if (this._signingKeyInfo == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s17", this.toString());
            }
            if (this._references.isEmpty() && !bl) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s18", this.toString());
            }
        }

        public AlgorithmConfig getCanonicalizationMethod() {
            return this._canonicalizationMethod;
        }

        public AlgorithmConfig getSignatureMethod() {
            return this._signatureMethod;
        }

        public AlgorithmConfig getKeyInfoSignature() {
            return this._keyInfoSignature;
        }

        public KeyInfoConsumerConfig getSigningKeyInfo() {
            return this._signingKeyInfo;
        }

        public List getReferences() {
            return this._references;
        }

        public Map getProperties() {
            return this._properties;
        }

        public Map getIdentityMap() {
            return this._identity;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("canonicalizationMethod=[").append(this._canonicalizationMethod).append("], ");
            stringBuffer.append("signatureMethod=[").append(this._signatureMethod).append("], ");
            stringBuffer.append("keyInfoSignature=[").append(this._keyInfoSignature).append("], ");
            stringBuffer.append("signingKeyInfo=[").append(this._signingKeyInfo).append("], ");
            stringBuffer.append("refereces=[").append(this._references).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("], ");
            stringBuffer.append("isDecryptionXformEnabled=[").append(this._isDecryptionXformEnabled).append("], ");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        public boolean isDecryptionTransformEnabled() {
            return this._isDecryptionXformEnabled;
        }
    }

    public static class CallerConfImpl
    implements WSSConsumerConfig.CallerConfig {
        public PrivateCommonConfig.ReferencePartConfImpl _part = null;
        public QName _tokenType = null;
        public QName _tokenConsumerType = null;
        public CallerConfImpl _trustMethod = null;
        public final Map _properties = new HashMap();

        public void validate() throws SoapSecurityException {
            if (this._tokenType == null || this._tokenConsumerType == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s16", this.toString());
            }
        }

        public ReferencePartConfig getPart() {
            return this._part;
        }

        public QName getTokenType() {
            return this._tokenType;
        }

        public QName getTokenConsumerType() {
            return this._tokenConsumerType;
        }

        public WSSConsumerConfig.CallerConfig getTrustMethod() {
            return this._trustMethod;
        }

        public Map getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("part=[").append(this._part).append("], ");
            stringBuffer.append("tokenType=[").append(this._tokenType).append("], ");
            stringBuffer.append("tokenConsumerType=[").append(this._tokenConsumerType).append("], ");
            stringBuffer.append("trustMethod=[").append(this._trustMethod).append("], ");
            stringBuffer.append("properties=[").append(this._properties).append("]");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }
}

