/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity;

import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.wsspi.wssecurity.EngineFactory;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Iterator;
import java.util.Set;

public class WSSAlgorithmFactory
extends AlgorithmFactory {
    private static final TraceComponent tc = Tr.register((Class)WSSAlgorithmFactory.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSAlgorithmFactory.class.getName();
    private final Object _lock = new Object();
    protected boolean _fipsMode = false;

    protected WSSAlgorithmFactory(String string) {
        super(string);
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000601", "com.ibm.ws.webservices.wssecurity.dsig.WSSW3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000613", "com.ibm.ws.webservices.wssecurity.dsig.WSSW3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20001011", "com.ibm.ws.webservices.wssecurity.dsig.WSSW3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/CR-xml-c14n-20001026", "com.ibm.ws.webservices.wssecurity.dsig.WSSW3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "com.ibm.ws.webservices.wssecurity.dsig.WSSW3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20001011#WithComments", "com.ibm.ws.webservices.wssecurity.dsig.WSSW3CCanonicalizer2WC");
        this.transformTable.put("http://www.w3.org/TR/2000/CR-xml-c14n-20001026#WithComments", "com.ibm.ws.webservices.wssecurity.dsig.WSSW3CCanonicalizer2WC");
        this.transformTable.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", "com.ibm.ws.webservices.wssecurity.dsig.WSSW3CCanonicalizer2WC");
        this.transformTable.put("http://www.w3.org/2001/10/xml-exc-c14n#", "com.ibm.ws.webservices.wssecurity.dsig.WSSExclusiveC11r");
        this.transformTable.put("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", "com.ibm.ws.webservices.wssecurity.dsig.WSSExclusiveC11rWC");
        this.transformTable.put("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", "com.ibm.ws.webservices.wssecurity.dsig.STRDereferenceTransformer");
        this.transformTable.put("http://www.w3.org/2002/07/decrypt#XML", "com.ibm.ws.webservices.wssecurity.dsig.XMLDecryptionTransformer");
        if (ConfigValidation.isFipsEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isFipsEnabled() is true");
            }
            this._fipsMode = true;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isFipsEnabled() is false");
            }
            this._fipsMode = false;
        }
    }

    public static AlgorithmFactory getInstance() {
        return new WSSAlgorithmFactory(null);
    }

    public EngineFactory addPluggableFactory(String string, Set set, ClassLoader classLoader) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addPluggableFactory(String factoryName[" + string + "]," + "Set algorithmURIs[" + set + "]," + "ClassLoader appClassLoader[" + classLoader + "])"));
        }
        if (ConfigValidation.isFipsEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isFipsEnabled() is true; disabling pluggable factory");
            }
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC0146E", (Object)string);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addPluggableFactory() returning null");
            }
            return null;
        }
        EngineFactory engineFactory = null;
        if (string != null && string.length() > 0) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Instantiating a new engine factory [" + string + "]..."));
                }
                engineFactory = (EngineFactory)ConfigUtil.instantiate((String)string, (Class)EngineFactory.class, (ClassLoader)classLoader);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Succeeded to instantiate a new engine factory [" + string + "]."));
                }
            }
            catch (SoapSecurityException soapSecurityException) {
                // empty catch block
            }
            if (engineFactory != null) {
                this.childFactory.add(engineFactory);
                if (set != null) {
                    this.childFactoryURIs.put(engineFactory, set);
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string2 = iterator.next().toString();
                        if (!this.supportedSignature.contains(string2) && !this.supportedDigest.contains(string2) && !this.supportedDataEncryption.contains(string2) && !this.supportedKeyEncryption.contains(string2)) continue;
                        Tr.debug((TraceComponent)tc, (String)("You can't overwrite the default URI supported by WAS: " + string2));
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Added the engine factory [" + string + "] into the list."));
                    Tr.debug((TraceComponent)tc, (String)("A set of the supported algorithms is [" + set + "]."));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addPluggableFactory(String factoryName, Set algorithmURIs, ClassLoader appClassLoader)");
        }
        return engineFactory;
    }
}

