/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.tools.resource.FileWriteDenialException;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.DuplicateFileException;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import java.io.IOException;
import java.io.PrintWriter;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.Service;

public class JavaServiceIfaceWriter
extends JavaClassWriter {
    private ServiceEntry sEntry;
    private SymbolTable symbolTable;
    static /* synthetic */ Class class$javax$xml$rpc$ServiceException;

    protected JavaServiceIfaceWriter(Emitter emitter, ServiceEntry serviceEntry, SymbolTable symbolTable) {
        super(emitter, serviceEntry.getName(), "service");
        this.sEntry = serviceEntry;
        this.symbolTable = symbolTable;
    }

    public void generate() throws IOException {
        String string = this.getFileName();
        if (this.isFileGenerated(string)) {
            throw new DuplicateFileException(Messages.getMessage("duplicateFile00", string), string);
        }
        try {
            String string2;
            PrintWriter printWriter = this.getPrintWriter(string);
            this.registerFile(string);
            if (this.emitter.isVerbose() && (string2 = this.verboseMessage(string)) != null) {
                this.emitter.getToolEnv().report(string2);
            }
            this.writeFileHeader(printWriter);
            this.writeFileBody(printWriter);
            this.writeFileFooter(printWriter);
            this.closePrintWriter(printWriter);
        }
        catch (FileWriteDenialException fileWriteDenialException) {
            this.emitter.getToolEnv().report(Messages.getMessage("FileWriteDenied", string));
        }
    }

    protected String getClassText() {
        return "interface ";
    }

    protected String getExtendsText() {
        return "extends javax.xml.rpc.Service ";
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        Service service = this.sEntry.getService();
        this.writeComment(printWriter, service.getDocumentationElement());
        for (int i = 0; i < this.sEntry.numPorts(); ++i) {
            PortEntry portEntry = this.sEntry.getPort(i);
            Port port = portEntry.getPort();
            Binding binding = port.getBinding();
            if (binding == null) {
                throw new IOException(Messages.getMessage("emitFailNoBinding01", new String[]{port.getName()}));
            }
            BindingEntry bindingEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bindingEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoBindingEntry01", new String[]{binding.getQName().toString()}));
            }
            PortTypeEntry portTypeEntry = this.symbolTable.getPortTypeEntry(binding.getPortType().getQName());
            if (portTypeEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoPortType01", new String[]{binding.getPortType().getQName().toString()}));
            }
            Boolean bl = (Boolean)this.sEntry.getDynamicVar(SymbolTable.NON_BOUND_WSDL);
            boolean bl2 = bl != null && bl != false;
            String string = portEntry.getAddress();
            if (string == null && !bl2) continue;
            String string2 = JavaUtils.xmlNameToJavaClass(portEntry.getQName().getLocalPart());
            String string3 = (String)bindingEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME);
            printWriter.println("    public " + string3 + " get" + string2 + "() throws " + (class$javax$xml$rpc$ServiceException == null ? JavaServiceIfaceWriter.class$("javax.xml.rpc.ServiceException") : class$javax$xml$rpc$ServiceException).getName() + ";");
            if (bl2) continue;
            printWriter.println();
            printWriter.println("    public java.lang.String get" + string2 + "Address();");
            printWriter.println();
            printWriter.println("    public " + string3 + " get" + string2 + "(java.net.URL portAddress) throws " + (class$javax$xml$rpc$ServiceException == null ? JavaServiceIfaceWriter.class$("javax.xml.rpc.ServiceException") : class$javax$xml$rpc$ServiceException).getName() + ";");
        }
    }
}

