/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.symbolTable;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.wsdl.symbolTable.Resolver;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class WSIUtils {
    protected static Log log = LogFactory.getLog(Resolver.class.getName());
    private ToolEnv env;
    private boolean wsiCheck = true;

    WSIUtils() {
    }

    public void setEnv(ToolEnv toolEnv) {
        this.env = toolEnv;
    }

    public void enableWSIChecking(boolean bl) {
        this.wsiCheck = bl;
    }

    protected void checkNamespaceTargetNamespace(String string, String string2, String string3, String string4) {
        if (this.wsiCheck) {
            if (string == null && string2 == null) {
                return;
            }
            if (string == null || string2 == null || !string.equals(string2)) {
                this.env.reportWarning(Messages.getMessage("notWSINamespaceTargetNamespace01", string3, string4, string, string2));
            }
        }
    }

    protected void checkValidWSDLImport(Document document, String string, String string2) {
        if (this.wsiCheck) {
            int n;
            if (document == null) {
                return;
            }
            NodeList nodeList = document.getChildNodes();
            for (n = 0; n < nodeList.getLength() && nodeList.item(n).getNodeName().indexOf("schema") == -1 && nodeList.item(n).getNodeName().indexOf("definitions") == -1; ++n) {
            }
            if (n >= nodeList.getLength()) {
                this.env.reportFatalErr(Messages.getMessage("notValidImportDoc00", string, string2));
            } else if (nodeList.item(n).getNodeName().equals("schema")) {
                this.env.reportWarning(Messages.getMessage("notWSICompliantWSDLImportSchema00", string, string2));
            }
        }
    }

    protected String getTargetNamespace(Node node) {
        if (node != null && node.getAttributes() != null && node.getAttributes().getNamedItem("targetNamespace") != null) {
            return node.getAttributes().getNamedItem("targetNamespace").getNodeValue();
        }
        return null;
    }

    protected Node getRootSchema(Node node, String string, boolean bl) {
        if (node != null) {
            if (((Document)node).getDocumentElement().getTagName().indexOf("schema") == -1) {
                int n;
                if (this.wsiCheck && bl) {
                    this.env.reportWarning(Messages.getMessage("notWSICompliantNotSchemaRoot00", string));
                }
                NodeList nodeList = node.getChildNodes();
                for (n = 0; n < nodeList.getLength() && nodeList.item(n).getNodeName().indexOf("schema") == -1; ++n) {
                }
                return nodeList.item(n);
            }
            return ((Document)node).getDocumentElement();
        }
        return null;
    }

    protected Node getRootDoc(Node node, String string) {
        if (node != null) {
            if (((Document)node).getDocumentElement().getTagName().indexOf("definitions") == -1) {
                int n;
                NodeList nodeList = node.getChildNodes();
                for (n = 0; n < nodeList.getLength() && nodeList.item(n).getNodeName().indexOf("definitions") == -1; ++n) {
                }
                if (nodeList.item(n) == null) {
                    return this.getRootSchema(node, string, false);
                }
                return nodeList.item(n);
            }
            return ((Document)node).getDocumentElement();
        }
        return null;
    }
}

