/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.tools.resource;

import com.ibm.ws.classloader.CompoundClassLoader;
import com.ibm.ws.webservices.engine.encoding.custom.Utils;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.tools.resource.ClassFactory;
import com.ibm.ws.webservices.wsdl.toJava.JavaSearchCriteria;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.java.adapters.jdk.JavaJDKAdapterFactory;

public abstract class ToolEnv {
    private ClassFactory classFactory = new ClassFactory(this);
    private JavaSearchCriteria javaSearch = null;
    protected String javaOutputDir = null;
    private boolean suspendGen = false;
    protected boolean isJavaIntrospectionAllowed = false;
    protected boolean allowRelativeNamespace = false;
    private CompoundClassLoader classLoader = null;

    public abstract boolean fileExists(String var1);

    public abstract PrintWriter getPrintWriter(String var1) throws IOException;

    public abstract OutputStream getOutputStream(String var1) throws IOException;

    public abstract InputStream getInputStream(String var1) throws IOException;

    public abstract char getSeparatorChar();

    public abstract void mkdir(String var1) throws IOException;

    public abstract void report(String var1);

    public abstract void reportWarning(String var1);

    public abstract void reporterr(String var1);

    public void reportFatalErr(String string) {
        if (!this.suspendGen) {
            this.reporterr(Messages.getMessage("fatalError"));
            this.suspendGen = true;
        }
        this.reporterr(string);
    }

    public abstract boolean isJavaIntrospectionAllowed();

    public void allowJavaIntrospection() {
        this.isJavaIntrospectionAllowed = true;
    }

    public boolean isRelativeNamespaceAllowed() {
        return this.allowRelativeNamespace;
    }

    public void allowRelativeNamespace(boolean bl) {
        this.allowRelativeNamespace = bl;
    }

    public abstract void setJavaContext(ResourceSet var1);

    public abstract ResourceSet getJavaContext();

    public void setJavaSearch(JavaSearchCriteria javaSearchCriteria) {
        this.javaSearch = javaSearchCriteria;
    }

    public JavaSearchCriteria getJavaSearch() {
        return this.javaSearch;
    }

    public void setJavaOutputDir(String string) {
        this.javaOutputDir = string;
    }

    public CompoundClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassFactory getClassFactory() {
        return this.classFactory;
    }

    public boolean getSuspendGen() {
        return this.suspendGen;
    }

    public char getPathSeparatorChar() {
        return File.pathSeparatorChar;
    }

    public void setIntrospectionClassPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "" + this.getPathSeparatorChar());
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        this.classLoader = new CompoundClassLoader(stringArray, null, false);
        ResourceSet resourceSet = this.getJavaContext();
        EList eList = resourceSet.getAdapterFactories();
        for (n = 0; n < eList.size(); ++n) {
            if (!(eList.get(n) instanceof JavaJDKAdapterFactory)) continue;
            JavaJDKAdapterFactory javaJDKAdapterFactory = (JavaJDKAdapterFactory)eList.get(n);
            javaJDKAdapterFactory.setContextClassLoader(this.classLoader);
        }
    }

    public List getCustomBindingProviders(Object object) throws PrivilegedActionException {
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                return classLoader;
            }
        };
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(privilegedAction);
        String string = null;
        if (object != null && object instanceof String) {
            string = (String)object;
        }
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            URL[] uRLArray = new URL[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    URL uRL = new URL("file:" + stringTokenizer.nextToken());
                    uRLArray[n++] = uRL;
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
            classLoader = new URLClassLoader(uRLArray, classLoader);
        }
        return this.loadCustomProviders(classLoader);
    }

    protected List loadCustomProviders(final ClassLoader classLoader) {
        return (List)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Utils.loadCustomProviders(classLoader);
            }
        });
    }
}

