/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.extensions.models;

import com.ibm.ws.webservices.multiprotocol.extensions.ExtensionDescription;
import com.ibm.ws.webservices.multiprotocol.extensions.models.ExtensionDescriptionImpl;
import com.ibm.ws.webservices.multiprotocol.extensions.models.ModelExtensibilityElementDeserializer;
import com.ibm.ws.webservices.multiprotocol.extensions.models.ModelExtensibilityElementSerializer;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;

public abstract class ModelExtensibilityElement
implements ExtensibilityElement,
Serializable {
    protected Class parentClass;
    protected QName elementType;
    protected Boolean required;
    protected List validAttributeNames;
    protected Map elementAttributes;

    public ModelExtensibilityElement(Class clazz, QName qName) {
        this.parentClass = clazz;
        this.setElementType(qName);
        this.elementAttributes = new HashMap();
        this.validAttributeNames = Arrays.asList(this.getAttributeNames());
    }

    protected abstract String[] getAttributeNames();

    public Class getParentClass() {
        return this.parentClass;
    }

    public void setElementType(QName qName) {
        this.elementType = qName;
    }

    public QName getElementType() {
        return this.elementType;
    }

    public void setRequired(Boolean bl) {
        this.required = bl;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public String getAttribute(String string) {
        if (!this.validAttributeNames.contains(string)) {
            throw new IllegalArgumentException(Messages.getMessage((String)"badAttrName", (String)string));
        }
        String string2 = (String)this.elementAttributes.get(string);
        return string2;
    }

    public void setAttribute(String string, String string2) {
        if (!this.validAttributeNames.contains(string)) {
            throw new IllegalArgumentException(Messages.getMessage((String)"badAttrName", (String)string));
        }
        this.elementAttributes.put(string, string2);
    }

    public Iterator getAttributes() {
        return this.validAttributeNames.iterator();
    }

    public ExtensionDescription getExtensionDescription() {
        ExtensionDescriptionImpl extensionDescriptionImpl = new ExtensionDescriptionImpl(this.getClass(), this.getElementType(), this.getParentClass(), new ModelExtensibilityElementSerializer(), new ModelExtensibilityElementDeserializer());
        return extensionDescriptionImpl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Element(").append(this.elementType).append("):");
        stringBuffer.append("\n required=").append(this.required);
        Iterator iterator = this.elementAttributes.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.elementAttributes.get(string);
            stringBuffer.append("\n ").append(string).append("=").append(string2);
        }
        return stringBuffer.toString();
    }
}

