/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.WebServicesParser;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public final class WebServicesParserFactory
extends SAXParserFactory {
    protected static Log log;
    private static WebServicesParserFactory singleton;
    private SAXParserFactory saxParserFactory = null;
    private Stack parsers;
    public int PARSER_STACK_LIMIT = 50;

    protected WebServicesParserFactory() {
    }

    public static synchronized SAXParserFactory newInstance() {
        if (singleton != null) {
            return singleton;
        }
        singleton = new WebServicesParserFactory();
        WebServicesParserFactory.singleton.saxParserFactory = (SAXParserFactory)WebServicesProperties.newSPIInstance((Class)SAXParserFactory.class);
        return singleton;
    }

    public synchronized SAXParser newSAXParser() {
        if (this.parsers != null && !this.parsers.empty()) {
            return (SAXParser)this.parsers.pop();
        }
        try {
            return new WebServicesParser(this, this.saxParserFactory);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            FFDCFilter.processException(parserConfigurationException, "com.ibm.ws.webservices.engine.utils.WebServicesParserFactory.getSAXParser", "75");
            log.error(Messages.getMessage("parserConfigurationException00", parserConfigurationException.toString()));
            return null;
        }
        catch (SAXException sAXException) {
            FFDCFilter.processException(sAXException, "com.ibm.ws.webservices.engine.utils.WebServicesParserFactory.getSAXParser", "79");
            log.error(Messages.getMessage("SAXException00", sAXException.toString()));
            return null;
        }
    }

    synchronized void recycle(WebServicesParser webServicesParser) {
        if (this.parsers == null) {
            this.parsers = new Stack();
        }
        if (this.parsers.size() < this.PARSER_STACK_LIMIT) {
            this.parsers.push(webServicesParser);
        }
    }

    public void setNamespaceAware(boolean bl) {
        this.saxParserFactory.setNamespaceAware(bl);
    }

    public void setValidating(boolean bl) {
        this.saxParserFactory.setValidating(bl);
    }

    public boolean isNamespaceAware() {
        return this.saxParserFactory.isNamespaceAware();
    }

    public boolean isValidating() {
        return this.saxParserFactory.isValidating();
    }

    public void setFeature(String string, boolean bl) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        this.saxParserFactory.setFeature(string, bl);
    }

    public boolean getFeature(String string) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        return this.saxParserFactory.getFeature(string);
    }

    static {
        WebServicesProperties.setClassDefault((Class)SAXParserFactory.class, (String)SAXParserFactory.class.getName());
        log = LogFactory.getLog(WebServicesParserFactory.class.getName());
        singleton = null;
    }
}

