/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.attachments.AttachmentPart;
import com.ibm.ws.webservices.engine.components.image.ImageIO;
import com.ibm.ws.webservices.engine.components.image.ImageIOFactory;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.types.HexBinary;
import com.ibm.ws.webservices.engine.types.URI;
import com.ibm.ws.webservices.engine.utils.CharSetUtils;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import java.awt.Image;
import java.beans.Introspector;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.xml.rpc.holders.Holder;
import javax.xml.rpc.holders.StringHolder;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;

public class JavaUtils {
    protected static Log log = LogFactory.getLog(JavaUtils.class.getName());
    public static final char NL = '\n';
    public static final char CR = '\r';
    public static final String NO_PACKAGE_HOST_NAME = "DefaultNamespace";
    public static final String LS = System.getProperty("line.separator", new Character('\n').toString());
    static final String[] keywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    static final char keywordPrefix = '_';
    private static HashMap loadableMap = new HashMap();
    private static boolean checkForAttachmentSupport;
    private static boolean attachmentSupportEnabled;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;

    public static Class getWrapperClass(Class clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        return null;
    }

    public static String getWrapper(String string) {
        if (string.equals("int")) {
            return "java.lang.Integer";
        }
        if (string.equals("short")) {
            return "java.lang.Short";
        }
        if (string.equals("boolean")) {
            return "java.lang.Boolean";
        }
        if (string.equals("byte")) {
            return "java.lang.Byte";
        }
        if (string.equals("long")) {
            return "java.lang.Long";
        }
        if (string.equals("double")) {
            return "java.lang.Double";
        }
        if (string.equals("float")) {
            return "java.lang.Float";
        }
        if (string.equals("char")) {
            return "java.lang.Character";
        }
        return null;
    }

    public static Class getPrimitiveClass(Class clazz) {
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        return null;
    }

    public static Object convert(Object object, Class object2) {
        Object object3;
        Object object4;
        if (object2 == null) {
            return object;
        }
        Class clazz = null;
        if (object != null) {
            clazz = JavaUtils.getHolderValueType(object.getClass());
        }
        if (object != null && clazz == null && ((Class)object2).isAssignableFrom(object.getClass())) {
            return object;
        }
        if (log.isDebugEnabled()) {
            object4 = "null";
            if (object != null) {
                object4 = object.getClass().getName();
            }
            log.debug(Messages.getMessage("convert00", (String)object4, ((Class)object2).getName()));
        }
        object4 = null;
        if (object instanceof ConvertCache && (object4 = ((ConvertCache)object).getConvertedValue((Class)object2)) != null) {
            return object4;
        }
        Class clazz2 = JavaUtils.getHolderValueType((Class)object2);
        if (object instanceof HexBinary && object2 == [B.class) {
            return ((HexBinary)object).getBytes();
        }
        if (object instanceof byte[] && object2 == HexBinary.class) {
            return new HexBinary((byte[])object);
        }
        if (object instanceof Calendar && object2 == Date.class) {
            return ((Calendar)object).getTime();
        }
        if (object instanceof java.net.URI && object2 == URI.class) {
            try {
                return new URI(((java.net.URI)object).toString());
            }
            catch (URI.MalformedURIException malformedURIException) {
                return object;
            }
        }
        if (object instanceof URI && object2 == java.net.URI.class) {
            try {
                return new java.net.URI(((URI)object).toString());
            }
            catch (URISyntaxException uRISyntaxException) {
                return object;
            }
        }
        if (object instanceof HashMap && object2 == Hashtable.class) {
            return new Hashtable((HashMap)object);
        }
        if (JavaUtils.isAttachmentSupported() && (object instanceof AttachmentPart || object instanceof DataHandler)) {
            try {
                object3 = ((Class)object2).getName();
                if (DataHandler.class.isAssignableFrom((Class<?>)object2)) {
                    if (object instanceof AttachmentPart) {
                        return ((AttachmentPart)object).getDataHandler();
                    }
                } else if (object2 == String.class || object2 == Image.class || object2 == Source.class || ((String)object3).equals("javax.mail.internet.MimeMultipart")) {
                    DataHandler dataHandler = object instanceof AttachmentPart ? ((AttachmentPart)object).getDataHandler() : (DataHandler)object;
                    if (object2 == Image.class) {
                        InputStream inputStream = (InputStream)dataHandler.getContent();
                        if (inputStream.available() == 0) {
                            return null;
                        }
                        ImageIO imageIO = ImageIOFactory.getImageIO();
                        if (imageIO != null) {
                            return JavaUtils.getImageFromStream(inputStream);
                        }
                        log.info(Messages.getMessage("needImageIO"));
                        return object;
                    }
                    if (object2 == Source.class) {
                        return new StreamSource(new StringReader((String)dataHandler.getContent()));
                    }
                    return dataHandler.getContent();
                }
            }
            catch (IOException iOException) {
            }
            catch (SOAPException sOAPException) {
                // empty catch block
            }
        }
        if (object != null && ((Class)object2).isArray() && !((Class)object2).getComponentType().equals(Object.class) && ((Class)object2).getComponentType().isAssignableFrom(object.getClass())) {
            object3 = Array.newInstance(((Class)object2).getComponentType(), 1);
            Array.set(object3, 0, object);
            return object3;
        }
        if (!(object instanceof Collection) && (object == null || !object.getClass().isArray()) && (clazz2 == null && clazz == null || clazz2 != null && clazz != null)) {
            return object;
        }
        if (clazz2 != null) {
            object3 = JavaUtils.convert(object, clazz2);
            Object var6_13 = null;
            try {
                var6_13 = ((Class)object2).newInstance();
                JavaUtils.setHolderValue(var6_13, object3);
                return var6_13;
            }
            catch (Exception exception) {
                return object;
            }
        }
        if (clazz != null) {
            try {
                object3 = JavaUtils.getHolderValue(object);
                return JavaUtils.convert(object3, (Class)object2);
            }
            catch (HolderException holderException) {
                return object;
            }
        }
        if (object instanceof ConvertCache && ((ConvertCache)object).getDestClass() != object2 && (object3 = ((ConvertCache)object).getDestClass()) != null && ((Class)object3).isArray() && ((Class)object2).isArray() && ((Class)object2).isAssignableFrom((Class<?>)object3) && (object4 = ((ConvertCache)object).getConvertedValue((Class)(object2 = object3))) != null) {
            return object4;
        }
        if (object == null) {
            return object;
        }
        int n = 0;
        n = object.getClass().isArray() ? Array.getLength(object) : ((Collection)object).size();
        if (((Class)object2).isArray()) {
            if (((Class)object2).getComponentType().isPrimitive()) {
                Object object5 = Array.newInstance(((Class)object2).getComponentType(), n);
                if (object.getClass().isArray()) {
                    for (int i = 0; i < n; ++i) {
                        Array.set(object5, i, Array.get(object, i));
                    }
                } else {
                    int n2 = 0;
                    Iterator iterator = ((Collection)object).iterator();
                    while (iterator.hasNext()) {
                        Array.set(object5, n2++, iterator.next());
                    }
                }
                object4 = object5;
            } else {
                Object[] objectArray;
                try {
                    objectArray = (Object[])Array.newInstance(((Class)object2).getComponentType(), n);
                }
                catch (Exception exception) {
                    return object;
                }
                if (object.getClass().isArray()) {
                    for (int i = 0; i < n; ++i) {
                        objectArray[i] = JavaUtils.convert(Array.get(object, i), ((Class)object2).getComponentType());
                    }
                } else {
                    int n3 = 0;
                    Iterator iterator = ((Collection)object).iterator();
                    while (iterator.hasNext()) {
                        objectArray[n3++] = JavaUtils.convert(iterator.next(), ((Class)object2).getComponentType());
                    }
                }
                object4 = objectArray;
            }
        } else if (Collection.class.isAssignableFrom((Class<?>)object2)) {
            Collection collection = null;
            try {
                collection = object2 == Collection.class || object2 == List.class ? new ArrayList() : (object2 == Set.class ? new HashSet() : (Collection)((Class)object2).newInstance());
            }
            catch (Exception exception) {
                return object;
            }
            if (object.getClass().isArray()) {
                for (int i = 0; i < n; ++i) {
                    collection.add(Array.get(object, i));
                }
            } else {
                Iterator iterator = ((Collection)object).iterator();
                while (iterator.hasNext()) {
                    collection.add(iterator.next());
                }
            }
            object4 = collection;
        } else {
            object4 = object;
        }
        if (object instanceof ConvertCache) {
            ((ConvertCache)object).setConvertedValue((Class)object2, object4);
        }
        return object4;
    }

    public static boolean isConvertable(Object object, Class clazz) {
        Class<?> clazz2 = null;
        if (object != null) {
            clazz2 = object instanceof Class ? (Class<?>)object : object.getClass();
        }
        if (clazz == null) {
            return false;
        }
        if (clazz2 != null) {
            if (clazz.isAssignableFrom(clazz2)) {
                return true;
            }
            if (JavaUtils.getWrapperClass(clazz2) == clazz) {
                return true;
            }
            if (JavaUtils.getWrapperClass(clazz) == clazz2) {
                return true;
            }
            if ((Collection.class.isAssignableFrom(clazz2) || clazz2.isArray()) && (Collection.class.isAssignableFrom(clazz) || clazz.isArray())) {
                return true;
            }
            if (clazz.isArray() && !clazz.getComponentType().equals(Object.class) && (clazz.getComponentType().isAssignableFrom(clazz2) || JavaUtils.getWrapperClass(clazz.getComponentType()) == clazz2 || clazz.getComponentType() == JavaUtils.getWrapperClass(clazz2))) {
                return true;
            }
            if (clazz2 == HexBinary.class && clazz == [B.class || clazz2 == [B.class && clazz == HexBinary.class) {
                return true;
            }
            if (clazz2 == HashMap.class && clazz == Hashtable.class) {
                return true;
            }
            if (Calendar.class.isAssignableFrom(clazz2) && clazz == Date.class) {
                return true;
            }
            if (clazz2 == java.net.URI.class && clazz == URI.class) {
                return true;
            }
            if (clazz2 == URI.class && clazz == java.net.URI.class) {
                return true;
            }
        }
        Class clazz3 = JavaUtils.getHolderValueType(clazz);
        if (clazz2 == null) {
            return clazz3 != null;
        }
        if (clazz3 != null && (clazz3.isAssignableFrom(clazz2) || JavaUtils.isConvertable(clazz2, clazz3))) {
            return true;
        }
        Class clazz4 = JavaUtils.getHolderValueType(clazz2);
        if (clazz4 != null && (clazz.isAssignableFrom(clazz4) || JavaUtils.isConvertable(clazz4, clazz))) {
            return true;
        }
        if (clazz.getName().equals("javax.activation.DataHandler")) {
            String string = clazz2.getName();
            if (clazz2 == String.class || clazz2 == Image.class || string.equals("javax.mail.internet.MimeMultipart") || string.equals("javax.xml.transform.Source")) {
                return true;
            }
        }
        if (clazz2.isPrimitive()) {
            return JavaUtils.isConvertable(JavaUtils.getWrapperClass(clazz2), clazz);
        }
        return false;
    }

    public static Image getImageFromStream(InputStream inputStream) {
        try {
            return ImageIOFactory.getImageIO().loadImage(inputStream);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static boolean isJavaId(String string) {
        if (string == null || string.equals("") || JavaUtils.isJavaKeyword(string)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isJavaKeyword(String string) {
        return Arrays.binarySearch(keywords, string) >= 0;
    }

    public static String makeNonJavaKeyword(String string) {
        return '_' + string;
    }

    public static String getLoadableClassName(String string) {
        String string2;
        int n = string.indexOf("[");
        if (string == null || n < 0 || n == 0) {
            return string;
        }
        String string3 = string;
        if (n > 0) {
            string3 = string3.substring(0, n);
        }
        if ((string2 = (String)loadableMap.get(string3)) == null) {
            string2 = "L" + string3 + ";";
        }
        if (n > 0) {
            int n2 = string.indexOf("]");
            while (n2 > 0) {
                string2 = "[" + string2;
                n2 = string.indexOf("]", n2 + 1);
            }
        }
        return string2;
    }

    public static String getTextClassName(String string) {
        int n;
        if (string == null || string.indexOf("[") != 0) {
            return string;
        }
        String string2 = "";
        for (n = 0; n < string.length() && string.charAt(n) == '['; ++n) {
            string2 = string2 + "[]";
        }
        if (n < string.length()) {
            string2 = string.charAt(n) == 'B' ? "byte" + string2 : (string.charAt(n) == 'C' ? "char" + string2 : (string.charAt(n) == 'D' ? "double" + string2 : (string.charAt(n) == 'F' ? "float" + string2 : (string.charAt(n) == 'I' ? "int" + string2 : (string.charAt(n) == 'J' ? "long" + string2 : (string.charAt(n) == 'S' ? "short" + string2 : (string.charAt(n) == 'Z' ? "boolean" + string2 : (string.equals("void") ? "void" : string.substring(n + 1, string.indexOf(";")) + string2))))))));
        }
        return string2;
    }

    public static String java2NCName(String string) {
        return CharSetUtils.java2NCName(string);
    }

    public static String xmlNameToJava(String string) {
        int n;
        if (string == null || string.equals("")) {
            return string;
        }
        string = CharSetUtils.NCName2Java(string);
        char[] cArray = string.toCharArray();
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        boolean bl = false;
        for (n = 0; n < n2 && (JavaUtils.isPunctuation(cArray[n]) || !Character.isJavaIdentifierStart(cArray[n])); ++n) {
        }
        if (n < n2) {
            stringBuffer.append(cArray[n]);
            bl = !Character.isLetter(cArray[n]) && !Character.isJavaIdentifierStart(cArray[n]);
        } else if (Character.isJavaIdentifierPart(cArray[0])) {
            stringBuffer.append("_" + cArray[0]);
        } else {
            stringBuffer.append("_" + cArray.length);
        }
        ++n;
        while (n < n2) {
            char c = cArray[n];
            if (JavaUtils.isPunctuation(c) || !Character.isJavaIdentifierPart(c)) {
                bl = true;
            } else {
                if (bl && Character.isLowerCase(c)) {
                    stringBuffer.append(Character.toUpperCase(c));
                } else {
                    stringBuffer.append(c);
                }
                bl = Character.isDigit(c) || c == '\u2160';
            }
            ++n;
        }
        String string2 = stringBuffer.toString();
        if (Character.isUpperCase(string2.charAt(0))) {
            string2 = Introspector.decapitalize(string2);
        }
        if (JavaUtils.isJavaKeyword(string2)) {
            string2 = JavaUtils.makeNonJavaKeyword(string2);
        }
        return string2;
    }

    public static String xmlNameToJava51(String string) {
        int n;
        if (string == null || string.equals("")) {
            return string;
        }
        string = CharSetUtils.NCName2Java(string);
        char[] cArray = string.toCharArray();
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        boolean bl = false;
        for (n = 0; n < n2 && (JavaUtils.isPunctuation(cArray[n]) || !Character.isJavaIdentifierStart(cArray[n])); ++n) {
        }
        if (n < n2) {
            stringBuffer.append(cArray[n]);
            bl = !Character.isLetter(cArray[n]);
        } else if (Character.isJavaIdentifierPart(cArray[0])) {
            stringBuffer.append("_" + cArray[0]);
        } else {
            stringBuffer.append("_" + cArray.length);
        }
        ++n;
        while (n < n2) {
            char c = cArray[n];
            if (JavaUtils.isPunctuation(c) || !Character.isJavaIdentifierPart(c)) {
                bl = true;
            } else {
                if (bl && Character.isLowerCase(c)) {
                    stringBuffer.append(Character.toUpperCase(c));
                } else {
                    stringBuffer.append(c);
                }
                bl = Character.isLetter(c);
            }
            ++n;
        }
        String string2 = stringBuffer.toString();
        if (Character.isUpperCase(string2.charAt(0))) {
            string2 = Introspector.decapitalize(string2);
        }
        if (JavaUtils.isJavaKeyword(string2)) {
            string2 = JavaUtils.makeNonJavaKeyword(string2);
        }
        return string2;
    }

    public static String xmlNameToJavaClass(String string) {
        return JavaUtils.capitalizeFirstChar(JavaUtils.xmlNameToJava(string));
    }

    public static String xmlNameToJavaClass51(String string) {
        return JavaUtils.capitalizeFirstChar(JavaUtils.xmlNameToJava51(string));
    }

    public static String capitalizeFirstChar(String string) {
        if (string == null || string.equals("")) {
            return string;
        }
        char c = string.charAt(0);
        if (Character.isLowerCase(c)) {
            c = Character.toUpperCase(c);
            return c + string.substring(1);
        }
        return string;
    }

    public static String makePackageName(String string) {
        String string2 = null;
        try {
            string2 = new URL(string).getHost();
        }
        catch (MalformedURLException malformedURLException) {
            if (string.indexOf("://") > -1) {
                string2 = string.substring(string.indexOf("://") + 3);
                if (string2.indexOf("/") > -1) {
                    string2 = string2.substring(0, string2.indexOf("/"));
                }
            }
            if (string.indexOf(":") > -1) {
                string2 = string.substring(string.indexOf(":") + 1);
                if (string2.indexOf("/") > -1) {
                    string2 = string2.substring(0, string2.indexOf("/"));
                }
            }
            string2 = string;
        }
        if (string2 == null) {
            return null;
        }
        if (string2.equals(NO_PACKAGE_HOST_NAME)) {
            return "";
        }
        string2 = string2.replace('-', '_');
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        StringBuffer stringBuffer = new StringBuffer(80);
        for (int i = stringArray.length - 1; i >= 0; --i) {
            String string3 = stringArray[i];
            if (JavaUtils.isJavaKeyword(string3)) {
                string3 = JavaUtils.makeNonJavaKeyword(string3);
            }
            if (i != stringArray.length - 1) {
                stringBuffer.append('.');
            }
            if (Character.isDigit(string3.charAt(0))) {
                stringBuffer.append('_');
            }
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public static String makePackageName2(String string) {
        String string2 = null;
        try {
            string2 = new URL(string).getHost();
        }
        catch (MalformedURLException malformedURLException) {
            if (string.indexOf(":") > -1) {
                string2 = string.substring(string.indexOf(":") + 1);
                if (string2.indexOf("/") > -1) {
                    string2 = string2.substring(0, string2.indexOf("/"));
                }
            }
            string2 = string;
        }
        if (string2 != null || string2.length() == 0) {
            String string3;
            int n = string.indexOf(string2) + string2.length();
            String string4 = string.substring(n);
            string4 = string4.replace('-', '_');
            StringTokenizer stringTokenizer = new StringTokenizer(string4, "./\\:");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
            StringBuffer stringBuffer = new StringBuffer(80);
            for (int i = 0; i < stringArray.length; ++i) {
                string3 = stringArray[i];
                if (JavaUtils.isJavaKeyword(string3)) {
                    string3 = JavaUtils.makeNonJavaKeyword(string3);
                }
                stringBuffer.append('.');
                if (Character.isDigit(string3.charAt(0))) {
                    stringBuffer.append('_');
                }
                stringBuffer.append(string3);
            }
            String string5 = stringBuffer.toString();
            string3 = JavaUtils.makePackageName(string);
            if (string3 == null || string3.length() == 0) {
                return string5;
            }
            if (string5 == null || string5.length() == 0) {
                return string3;
            }
            return string3 + string5;
        }
        return JavaUtils.makePackageName(string);
    }

    private static boolean isPunctuation(char c) {
        return '-' == c || '.' == c || ':' == c || '\u00b7' == c || '\u0387' == c || '\u06dd' == c || '\u06de' == c;
    }

    public static final String replace(String string, String string2, String string3) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n = string2.length();
        try {
            int n2 = 0;
            int n3 = string.indexOf(string2, n2);
            while (n3 >= 0) {
                stringBuffer.append(string.substring(n2, n3));
                stringBuffer.append(string3);
                n2 = n3 + n;
                n3 = string.indexOf(string2, n2);
            }
            if (n2 < string.length()) {
                stringBuffer.append(string.substring(n2));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return new String(stringBuffer);
    }

    public static Class getHolderValueType(Class clazz) {
        if (clazz != null) {
            Field field;
            Class<?>[] classArray = clazz.getInterfaces();
            boolean bl = false;
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i] != (class$javax$xml$rpc$holders$Holder == null ? JavaUtils.class$("javax.xml.rpc.holders.Holder") : class$javax$xml$rpc$holders$Holder)) continue;
                bl = true;
            }
            if (!bl) {
                return null;
            }
            try {
                field = clazz.getField("value");
            }
            catch (Exception exception) {
                field = null;
            }
            if (field != null) {
                return field.getType();
            }
        }
        return null;
    }

    public static Object getHolderValue(Object object) throws HolderException {
        if (!(object instanceof Holder)) {
            throw new HolderException(Messages.getMessage("badHolder00", object.toString()));
        }
        try {
            Field field = object.getClass().getField("value");
            return field.get(object);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.webservices.engine.utils.JavaUtils.getHolderValue", "995");
            throw new HolderException(Messages.getMessage("exception01", exception.getMessage()));
        }
    }

    public static void setHolderValue(Object object, Object object2) throws HolderException {
        if (!(object instanceof Holder)) {
            throw new HolderException(Messages.getMessage("badHolder00", object.toString()));
        }
        try {
            Field field = object.getClass().getField("value");
            if (field.getType().isPrimitive()) {
                if (object2 != null) {
                    field.set(object, object2);
                }
            } else {
                field.set(object, object2);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.webservices.engine.utils.JavaUtils.setHolderValue", "1020");
            throw new HolderException(Messages.getMessage("exception01", exception.getMessage()));
        }
    }

    public static boolean isEnumClass(Class clazz) {
        block6: {
            if (JavaUtils._getValueMethod(clazz) == null) {
                return false;
            }
            Method method2 = clazz.getMethod("getValue", null);
            Method method3 = clazz.getMethod("toString", null);
            Method method4 = clazz.getMethod("fromString", String.class);
            if (method2 == null || method3 == null || method4 == null || clazz.getMethod("fromValue", method2.getReturnType()) == null) break block6;
            try {
                return clazz.getMethod("setValue", method2.getReturnType()) == null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    return true;
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private static Method _getValueMethod(Class clazz) {
        Method method2 = null;
        try {
            Method[] methodArray = clazz.getDeclaredMethods();
            for (int i = 0; i < methodArray.length && method2 == null; ++i) {
                if (!"getValue".equals(methodArray[i].getName())) continue;
                method2 = methodArray[i];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method2;
    }

    public static Object getDetail(Exception exception) {
        if (exception == null) {
            return null;
        }
        try {
            Class clazz = ClassUtils.forName(exception.getClass().getName() + "_Helper");
            Method method2 = clazz.getMethod("getDetail", Exception.class);
            return method2.invoke(null, exception);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return exception;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    public static String stackToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        PrintWriter printWriter = new PrintWriter(bufferedWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.getBuffer().toString();
    }

    public static final boolean isTrue(String string) {
        return !JavaUtils.isFalseExplicitly(string);
    }

    public static final boolean isTrueExplicitly(String string) {
        if (string == null) {
            return false;
        }
        if (string == "true" || string == "1") {
            return true;
        }
        if (string == "false" || string == "0") {
            return false;
        }
        return string.equalsIgnoreCase("true") || string.equals("1") || string.equalsIgnoreCase("yes");
    }

    public static final boolean isTrueExplicitly(Object object, boolean bl) {
        if (object == null) {
            return bl;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Integer) {
            return (Integer)object != 0;
        }
        if (object instanceof String) {
            return JavaUtils.isTrueExplicitly((String)object);
        }
        return true;
    }

    public static final boolean isTrueExplicitly(Object object) {
        return JavaUtils.isTrueExplicitly(object, false);
    }

    public static final boolean isTrue(Object object, boolean bl) {
        return !JavaUtils.isFalseExplicitly(object, !bl);
    }

    public static final boolean isTrue(Object object) {
        return JavaUtils.isTrue(object, false);
    }

    public static final boolean isFalse(String string) {
        return JavaUtils.isFalseExplicitly(string);
    }

    public static final boolean isFalseExplicitly(String string) {
        return string == null || string.equalsIgnoreCase("false") || string.equals("0") || string.equalsIgnoreCase("no");
    }

    public static final boolean isFalseExplicitly(Object object, boolean bl) {
        if (object == null) {
            return bl;
        }
        if (object instanceof Boolean) {
            return (Boolean)object == false;
        }
        if (object instanceof Integer) {
            return (Integer)object == 0;
        }
        if (object instanceof String) {
            return JavaUtils.isFalseExplicitly((String)object);
        }
        return false;
    }

    public static final boolean isFalseExplicitly(Object object) {
        return JavaUtils.isFalseExplicitly(object, true);
    }

    public static final boolean isFalse(Object object, boolean bl) {
        return JavaUtils.isFalseExplicitly(object, bl);
    }

    public static final boolean isFalse(Object object) {
        return JavaUtils.isFalse(object, true);
    }

    public static String mimeToJava(String string) {
        if ("image/gif".equals(string) || "image/jpeg".equals(string)) {
            return "java.awt.Image";
        }
        if ("text/plain".equals(string)) {
            return "java.lang.String";
        }
        if ("text/xml".equals(string) || "application/xml".equals(string)) {
            return "javax.xml.transform.Source";
        }
        if (string != null && string.startsWith("multipart/")) {
            return "javax.mail.internet.MimeMultipart";
        }
        return "javax.activation.DataHandler";
    }

    public static synchronized boolean isAttachmentSupported() {
        if (checkForAttachmentSupport) {
            checkForAttachmentSupport = false;
            try {
                ClassUtils.forName("javax.activation.DataHandler");
                ClassUtils.forName("javax.mail.internet.MimeMultipart");
                attachmentSupportEnabled = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("attachEnabled") + "  " + attachmentSupportEnabled);
            }
        }
        return attachmentSupportEnabled;
    }

    public static boolean hasValue(String string) {
        return string != null && string.length() > 0;
    }

    public static String createNonJAXRPCName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block9: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '-': {
                    stringBuffer.append("_hyphen_");
                    continue block9;
                }
                case '.': {
                    stringBuffer.append("_period_");
                    continue block9;
                }
                case ':': {
                    stringBuffer.append("_colon_");
                    continue block9;
                }
                case '\u00b7': {
                    stringBuffer.append("_dot_");
                    continue block9;
                }
                case '\u0387': {
                    stringBuffer.append("_anoteleia_");
                    continue block9;
                }
                case '\u06dd': {
                    stringBuffer.append("_endofayah_");
                    continue block9;
                }
                case '\u06de': {
                    stringBuffer.append("_startofrubelhizb_");
                    continue block9;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getSubString(InputStream inputStream, StringHolder stringHolder, char c, String string) throws IOException {
        if (!inputStream.markSupported()) {
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            stringHolder.value = new String(byArray);
            return new ByteArrayInputStream(stringHolder.value.getBytes(string));
        }
        try {
            inputStream.mark(0);
            int n = 100;
            byte[] byArray = new byte[n];
            int n2 = inputStream.read(byArray);
            stringHolder.value = "";
            String string2 = new String(byArray);
            while (string2.indexOf(c) < 0 && n2 == n) {
                stringHolder.value = stringHolder.value + string2;
                n2 = inputStream.read(byArray);
                string2 = new String(byArray);
            }
            stringHolder.value = stringHolder.value + string2;
        }
        finally {
            inputStream.reset();
        }
        return inputStream;
    }

    public static boolean isJDK14() {
        try {
            Class.forName("java.net.URI");
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.webservices.engine.utils.JavaUtils.isJDK14", "1553");
            return false;
        }
    }

    public static String getObjectIdentity(Object object) {
        if (object == null) {
            return "null";
        }
        return object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    public static int find(byte[] byArray, byte[] byArray2, int n, int n2, boolean bl) {
        int n3 = -1;
        if (byArray == null || byArray.length == 0 || byArray2 == null || byArray2.length == 0 || n < 0 || n2 < 0) {
            return n3;
        }
        if (bl) {
            for (int i = n; n3 < 0 && i <= n2; ++i) {
                if (byArray2[i] != byArray[0]) continue;
                boolean bl2 = true;
                for (int j = 1; bl2 && j < byArray.length; ++j) {
                    bl2 = i + j > n2 ? false : byArray2[i + j] == byArray[j];
                }
                if (!bl2) continue;
                n3 = i;
            }
        } else {
            for (int i = n2; n3 < 0 && i >= n; --i) {
                if (byArray2[i] != byArray[0]) continue;
                boolean bl3 = true;
                for (int j = 1; bl3 && j < byArray.length; ++j) {
                    bl3 = i + j > n2 ? false : byArray2[i + j] == byArray[j];
                }
                if (!bl3) continue;
                n3 = i;
            }
        }
        return n3;
    }

    public static String convertBytesToString(byte[] byArray, String string) {
        String string2;
        if (byArray == null) {
            string2 = null;
        } else if (string == null || string.length() == 0) {
            string2 = new String(byArray);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Message character encoding scheme: '" + string + "'");
            }
            try {
                string2 = new String(byArray, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, "com.ibm.ws.webservices.engine.SOAPPart.convertBytesToString", "1367", null);
                if (log.isDebugEnabled()) {
                    log.debug("Bad Encoding: '" + string + "', will ignore encoding");
                }
                string2 = new String(byArray);
            }
        }
        return string2;
    }

    public static byte[] convertStringToBytes(String string, String string2) {
        byte[] byArray;
        if (string == null) {
            byArray = null;
        } else if (string2 == null || string2.length() == 0) {
            byArray = string.getBytes();
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Message character encoding scheme: '" + string2 + "'");
            }
            try {
                byArray = string.getBytes(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, "com.ibm.ws.webservices.engine.SOAPPart.convertStringToBytes", "1394", null);
                if (log.isDebugEnabled()) {
                    log.debug("Bad Encoding: '" + string2 + "', will ignore encoding");
                }
                byArray = string.getBytes();
            }
        }
        return byArray;
    }

    static {
        loadableMap.put("byte", "B");
        loadableMap.put("char", "C");
        loadableMap.put("double", "D");
        loadableMap.put("float", "F");
        loadableMap.put("int", "I");
        loadableMap.put("long", "J");
        loadableMap.put("short", "S");
        loadableMap.put("boolean", "Z");
        checkForAttachmentSupport = true;
        attachmentSupportEnabled = false;
    }

    public static class HolderException
    extends Exception {
        public HolderException(String string) {
            super(string);
        }
    }

    public static interface ConvertCache {
        public void setConvertedValue(Class var1, Object var2);

        public Object getConvertedValue(Class var1);

        public Class getDestClass();
    }
}

