/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.events;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.events.PEventProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.NullAttributes;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class P2DConverter
extends PEventProcessor {
    private static Log log = LogFactory.getLog(P2DConverter.class.getName());
    private boolean debug = false;
    private DeserializationContext context;
    private DEventProcessor topProcessor;
    private ArrayList processorStack = new ArrayList();
    private Scopes scopes = new Scopes();
    private static final int STRINGBUFFER_LEN = 100;
    private StringBuffer buffer = null;
    private boolean hasData = false;
    private boolean state = true;
    private boolean simpleEventEnabled = true;
    private boolean preserveMixedContent = true;
    private String sNamespace;
    private String sLocalPart;
    private String sPrefixedName;
    private Attributes sAttributes;
    private MappingScope sMappingScope;
    private Locator locator;

    public P2DConverter(DEventProcessor dEventProcessor, DeserializationContext deserializationContext) {
        this.context = deserializationContext;
        this.topProcessor = dEventProcessor;
        this.debug = log.isDebugEnabled() || this.debug;
    }

    public void startDocument() throws SAXException {
        this.scopes.push();
    }

    public void endDocument() throws SAXException {
        this.scopes.pop();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.debug) {
            this.debugMessage("start characters1 = (" + new String(cArray, n, n2) + ")");
        }
        this.appendData(cArray, n, n2);
        if (this.debug) {
            this.debugMessage("end characters1");
        }
    }

    public void characters(String string) throws SAXException {
        if (this.debug) {
            this.debugMessage("start characters2 = (" + string + ")");
        }
        this.appendData(string);
        if (this.debug) {
            this.debugMessage("end characters2");
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.debug) {
            this.debugMessage("start startPrefixMapping prefix = {" + string + "} namespace = {" + string2 + "}");
        }
        this.flush(true);
        MappingScope mappingScope = this.scopes.getMappingScopeUnderConstruction();
        if (string != null) {
            mappingScope.addMapping(string2, string);
        } else {
            mappingScope.addMapping(string2, "");
        }
        if (this.debug) {
            this.debugMessage("end startPrefixMapping prefix = {" + string + "} namespace = {" + string2 + "}");
        }
    }

    public void startPrefixMappingNS(String string, String string2) throws SAXException {
        if (string != null && string2 != null && !"".equals(string2)) {
            Mapping mapping;
            boolean bl = true;
            MappingScope mappingScope = this.scopes.getCurrentMappingScope();
            Mapping mapping2 = mapping = mappingScope == null ? null : mappingScope.getMappingForPrefix(string, false);
            if (mapping != null) {
                String string3 = mapping.getNamespaceURI();
                boolean bl2 = string3 == null ? true : (bl = !string3.equals(string2));
                if (!bl) {
                    this.debugMessage("Prefix {" + string + "} with namespace {" + string3 + "} already in parent scope");
                }
            }
            if (bl) {
                this.startPrefixMapping(string, string2);
            }
        }
    }

    public void endPrefixMapping(String string, String string2) throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        MappingScope mappingScope;
        if (this.debug) {
            this.debugMessage("start startElement1:" + string2);
        }
        this.flush(true);
        if (this.debug) {
            this.debugMessage("start startElement1 after flush: " + string2);
        }
        if (this.storeStartElement(string, string2, string3, attributes, mappingScope = this.scopes.getMappingScopeUnderConstruction())) {
            if (this.debug) {
                this.debugMessage("end startElement1 (defer processing): " + string2);
            }
            return;
        }
        this.startElement(string, string2, string3, attributes, mappingScope, null);
        if (this.debug) {
            this.debugMessage("end startElement1: " + string2);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, SOAPElement sOAPElement) throws SAXException {
        if (this.debug) {
            this.debugMessage("start startElement2: " + string2);
        }
        this.flush(true);
        if (this.debug) {
            this.debugMessage("start startElement2 after flush: " + string2);
        }
        if (mappingScope != null) {
            this.scopes.replaceMappingScopeUnderConstruction(mappingScope);
        }
        this.scopes.push();
        if (attributes == null || attributes.getLength() == 0) {
            attributes = NullAttributes.singleton;
        }
        if (!mappingScope.isReadOnly()) {
            mappingScope.setReadOnly(true, this);
        }
        DEventProcessor dEventProcessor = null;
        if (this.topProcessor != null) {
            if (sOAPElement != null) {
                this.topProcessor.childElementEvent(sOAPElement);
            }
            dEventProcessor = this.topProcessor.onStartChild(string, string2, string3, attributes, this.scopes.getCurrentMappingScope(), this.context);
        }
        if (dEventProcessor == null) {
            throw new SAXException(Messages.getMessage("noDEventProcessor01", this.topProcessor.getClass().getName(), string3));
        }
        this.pushDEventProcessor(dEventProcessor);
        if (sOAPElement != null) {
            dEventProcessor.elementEvent(sOAPElement);
        }
        dEventProcessor.startElement(string, string2, string3, attributes, this.scopes.getCurrentMappingScope(), this.context);
        if (mappingScope.isReadOnlyOwner(this)) {
            mappingScope.setReadOnly(false, this);
        }
        if (this.debug) {
            this.debugMessage("end startElement2: " + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.debug) {
            this.debugMessage("start endElement1: " + string2);
        }
        if (this.flush(false)) {
            if (this.debug) {
                this.debugMessage("end endElement1 (optimized simple event): " + string2);
            }
            return;
        }
        try {
            DEventProcessor dEventProcessor = this.popDEventProcessor();
            dEventProcessor.endElement(string, string2, this.context);
            if (this.topProcessor != null) {
                this.topProcessor.onEndChild(string, string2, this.context);
            }
        }
        finally {
            this.scopes.pop();
            if (this.debug) {
                this.debugMessage("end endElement1 (normal): " + string2);
            }
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.debug) {
            this.debugMessage("ignorableWhitespace (" + new String(cArray, n, n2) + ")");
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        throw new SAXException(Messages.getMessage("noInstructions00"));
    }

    public void skippedEntity(String string) throws SAXException {
        if (this.debug) {
            this.debugMessage("skippedEntity (" + string + ")");
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        throw new SAXException(Messages.getMessage("unsupportedSAXEvent", "startDTD"));
    }

    public void endDTD() throws SAXException {
        throw new SAXException(Messages.getMessage("unsupportedSAXEvent", "endDTD"));
    }

    public void startEntity(String string) throws SAXException {
        if (this.debug) {
            this.debugMessage("startEntity (" + string + ")");
        }
    }

    public void endEntity(String string) throws SAXException {
        if (this.debug) {
            this.debugMessage("endEntity (" + string + ")");
        }
    }

    public void startCDATA() throws SAXException {
        if (this.debug) {
            this.debugMessage("start startCDATA");
        }
        if (this.debug) {
            this.debugMessage("end startCDATA");
        }
    }

    public void endCDATA() throws SAXException {
        if (this.debug) {
            this.debugMessage("start endCDATA");
        }
        if (this.debug) {
            this.debugMessage("end endCDATA");
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.debug) {
            this.debugMessage("start comment = (" + new String(cArray, n, n2) + ")");
        }
        this.flush(true);
        if (this.topProcessor != null) {
            this.topProcessor.comment(cArray, n, n2);
        }
        if (this.debug) {
            this.debugMessage("end comment");
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    public final void pushDEventProcessor(DEventProcessor dEventProcessor) {
        if (dEventProcessor == null) {
            throw new InternalException(Messages.getMessage("pushNullDEventProcessor00"));
        }
        if (this.debug) {
            this.debugMessage("---push " + dEventProcessor.getClass());
        }
        if (this.topProcessor != null) {
            this.processorStack.add(this.topProcessor);
        }
        this.topProcessor = dEventProcessor;
    }

    public final DEventProcessor popDEventProcessor() {
        int n;
        DEventProcessor dEventProcessor = this.topProcessor;
        if (this.debug) {
            if (this.topProcessor != null) {
                this.debugMessage("---popped " + this.topProcessor.getClass());
            } else {
                this.debugMessage("---popped AN EMPTY STACK");
            }
        }
        this.topProcessor = (n = this.processorStack.size()) > 0 ? (DEventProcessor)this.processorStack.remove(n - 1) : null;
        if (this.debug) {
            if (this.topProcessor != null) {
                this.debugMessage("---now " + this.topProcessor.getClass());
            } else {
                this.debugMessage("---now STACK IS EMPTY");
            }
        }
        return dEventProcessor;
    }

    public Object saveState() {
        ArrayList<DEventProcessor> arrayList = new ArrayList<DEventProcessor>(this.processorStack);
        if (this.topProcessor != null) {
            arrayList.add(this.topProcessor);
        }
        return arrayList;
    }

    public void restoreState(Object object) {
        this.processorStack = (ArrayList)object;
        int n = this.processorStack.size();
        this.topProcessor = n > 0 ? (DEventProcessor)this.processorStack.remove(n - 1) : null;
    }

    private void appendData(char[] cArray, int n, int n2) {
        if (this.debug) {
            this.debugMessage("appendData chars: (" + new String(cArray, n, n2) + ")");
        }
        if (this.state || this.preserveMixedContent) {
            if (this.buffer == null) {
                this.buffer = new StringBuffer(n2);
            }
            this.buffer.append(cArray, n, n2);
            this.hasData = true;
            if (this.debug) {
                this.debugMessage("appendData hasData");
            }
        }
    }

    private void appendData(String string) {
        if (this.debug) {
            this.debugMessage("appendData String: (" + string + ")");
        }
        if ((this.state || this.preserveMixedContent) && string.length() > 0) {
            if (this.buffer == null) {
                this.buffer = new StringBuffer(string.length());
            }
            this.buffer.append(string);
            this.hasData = true;
            if (this.debug) {
                this.debugMessage("appendData hasData");
            }
        }
    }

    private boolean flush(boolean bl) throws SAXException {
        boolean bl2;
        String string = "";
        boolean bl3 = false;
        boolean bl4 = bl2 = !this.state || bl;
        if (this.hasData) {
            if (!bl2 || this.preserveMixedContent) {
                bl3 = true;
                string = this.buffer.toString();
                this.buffer = null;
                if (this.debug) {
                    this.debugMessage("flush: character data = (" + string + ")");
                }
            }
            if (this.buffer != null) {
                this.buffer.setLength(0);
            }
            this.hasData = false;
        }
        if (this.sLocalPart != null) {
            if (this.state && !bl) {
                if (this.debug) {
                    this.debugMessage("flush: send onSimpleChild:" + this.sLocalPart + "(" + string + ")");
                }
                String string2 = this.sLocalPart;
                this.sLocalPart = null;
                if (this.topProcessor != null) {
                    if (!this.sMappingScope.isReadOnly()) {
                        this.sMappingScope.setReadOnly(true, this);
                    }
                    this.topProcessor.onSimpleChild(this.sNamespace, string2, this.sPrefixedName, this.sAttributes, this.sMappingScope, this.context, string);
                    if (this.sMappingScope.isReadOnlyOwner(this)) {
                        this.sMappingScope.setReadOnly(false, this);
                    }
                    if (this.sMappingScope.isReadOnly()) {
                        this.scopes.pop();
                        this.scopes.push();
                    } else {
                        this.sMappingScope.clear();
                    }
                    this.sLocalPart = null;
                    this.state = bl;
                    return true;
                }
            } else {
                if (this.debug) {
                    this.debugMessage("flush: can't send onSimpleChild:" + this.sLocalPart + "(" + string + ")");
                }
                if (this.sMappingScope != null) {
                    this.scopes.replaceMappingScopeUnderConstruction(this.sMappingScope);
                }
                this.scopes.push();
                if (!this.sMappingScope.isReadOnly()) {
                    this.sMappingScope.setReadOnly(true, this);
                }
                DEventProcessor dEventProcessor = null;
                if (this.topProcessor != null) {
                    dEventProcessor = this.topProcessor.onStartChild(this.sNamespace, this.sLocalPart, this.sPrefixedName, this.sAttributes, this.sMappingScope, this.context);
                }
                this.pushDEventProcessor(dEventProcessor);
                dEventProcessor.startElement(this.sNamespace, this.sLocalPart, this.sPrefixedName, this.sAttributes, this.sMappingScope, this.context);
                if (this.sMappingScope.isReadOnlyOwner(this)) {
                    this.sMappingScope.setReadOnly(false, this);
                }
                if (bl3) {
                    if (this.debug) {
                        this.debugMessage("flush: send buffered characters (" + string + ")");
                    }
                    this.topProcessor.characters(string);
                }
            }
            this.sLocalPart = null;
            this.state = bl;
            return false;
        }
        if (bl3) {
            if (this.debug) {
                this.debugMessage("flush: send buffered characters (" + string + ")");
            }
            this.topProcessor.characters(string);
        }
        this.state = bl;
        return false;
    }

    private boolean storeStartElement(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope) {
        int n = attributes.getLength();
        if (!this.simpleEventEnabled || n > 1 || n == 1 && (!"type".equals(attributes.getLocalName(0)) || !"http://www.w3.org/2001/XMLSchema-instance".equals(attributes.getURI(0))) || Constants.isSOAP_ENV(string)) {
            return false;
        }
        this.sNamespace = string;
        this.sLocalPart = string2;
        this.sPrefixedName = string3;
        this.sAttributes = attributes.getClass() != NullAttributes.class ? (attributes.getLength() > 0 ? new AttributesImpl(attributes) : NullAttributes.singleton) : attributes;
        this.sMappingScope = mappingScope;
        return true;
    }

    private void debugMessage(String string) {
        log.debug(string);
    }

    public void enableSimpleEvent() {
        this.simpleEventEnabled = true;
    }

    public void disableSimpleEvent() {
        this.simpleEventEnabled = false;
    }

    public boolean isSimpleEventEnabled() {
        return this.simpleEventEnabled;
    }

    public void setPreserveMixedContent(boolean bl) {
        this.preserveMixedContent = bl;
    }

    public boolean getPreserveMixedContent() {
        return this.preserveMixedContent;
    }

    class Scopes {
        private MappingScope[] mArray = new MappingScope[10];
        int top = -1;

        public Scopes() {
            this.push();
        }

        public MappingScope getCurrentMappingScope() {
            if (this.top <= 0) {
                return null;
            }
            return this.mArray[this.top - 1];
        }

        public MappingScope getMappingScopeUnderConstruction() {
            if (this.top < 0) {
                return null;
            }
            MappingScope mappingScope = this.mArray[this.top];
            if (mappingScope == null) {
                mappingScope = new MappingScope();
                mappingScope.setParent(this.getCurrentMappingScope());
                this.mArray[this.top] = mappingScope;
            }
            return mappingScope;
        }

        public void replaceMappingScopeUnderConstruction(MappingScope mappingScope) {
            if (mappingScope != this.mArray[this.top]) {
                mappingScope.setReadOnly(true, this);
                this.mArray[this.top] = mappingScope;
            }
        }

        public void push() {
            this.getMappingScopeUnderConstruction();
            ++this.top;
            if (this.top >= this.mArray.length) {
                MappingScope[] mappingScopeArray = new MappingScope[this.mArray.length * 2];
                System.arraycopy(this.mArray, 0, mappingScopeArray, 0, this.mArray.length);
                this.mArray = mappingScopeArray;
            }
        }

        public void pop() {
            --this.top;
            MappingScope mappingScope = this.mArray[this.top];
            if (mappingScope != null) {
                if (mappingScope.isReadOnly()) {
                    this.mArray[this.top] = null;
                    if (mappingScope.isReadOnlyOwner(this)) {
                        mappingScope.setReadOnly(false, this);
                    }
                } else {
                    mappingScope.clear();
                }
            }
        }
    }
}

