/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.encoding.Serializer;
import com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BeanSerializer;
import com.ibm.ws.webservices.engine.encoding.ser.EnumSerializer;
import com.ibm.ws.webservices.engine.encoding.utils.BeanDesc;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.BeanUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;

public class BeanSerializerFactory
extends BaseSerializerFactory {
    protected BeanDesc beanDesc = null;
    protected BeanPropertyDescriptor[] propertyDescriptor = null;

    public BeanSerializerFactory(Class clazz, QName qName) {
        super(BeanSerializer.class, qName, clazz);
        if (JavaUtils.isEnumClass(clazz)) {
            this.serClass = EnumSerializer.class;
        }
    }

    public static BeanSerializerFactory create(Class clazz, QName qName, QName qName2, QName qName3) {
        return new BeanSerializerFactory(clazz, qName);
    }

    protected void lazyInitialization() {
        super.lazyInitialization();
        this.beanDesc = BeanDesc.getBeanDescForClass(this.javaType);
        if (this.beanDesc == null) {
            this.propertyDescriptor = BeanUtils.getPd(this.javaType, null);
        }
    }

    public javax.xml.rpc.encoding.Serializer getSerializerAs(String string) throws JAXRPCException {
        return (Serializer)super.getSerializerAs(string);
    }

    protected Serializer getSpecialized(String string) {
        Serializer serializer = super.getSpecialized(string);
        if (serializer != null && serializer instanceof BeanSerializer && this.beanDesc != null) {
            ((BeanSerializer)serializer).setup(this.beanDesc, this.beanDesc.getPropertyDescriptors());
        }
        return serializer;
    }

    protected Serializer getGeneralPurpose(String string) {
        if (this.javaType == null || this.xmlType == null) {
            return super.getGeneralPurpose(string);
        }
        if (this.serClass == EnumSerializer.class) {
            return super.getGeneralPurpose(string);
        }
        if (this.beanDesc != null) {
            return new BeanSerializer(this.javaType, this.xmlType, this.beanDesc);
        }
        return new BeanSerializer(this.javaType, this.xmlType, null, this.propertyDescriptor);
    }

    protected Method getSerializerMethod(Class clazz) {
        Method method2 = super.getSerializerMethod(clazz);
        if (method2 == null && !this.serClass.equals(EnumSerializer.class)) {
            throw new InternalException(Messages.getMessage("missingHelper00", this.javaType.getName()));
        }
        return method2;
    }
}

