/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.attachments.AttachmentUtils;
import com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DefaultTypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializationWriter;
import com.ibm.ws.webservices.engine.encoding.Serializer;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.JAFDataHandlerSerializer;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleSerializer;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleValueSerializer;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.schema.SchemaVersion;
import com.ibm.ws.webservices.engine.types.HexBinary;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import com.ibm.ws.webservices.wsdl.symbolTable.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.AttachmentPart;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public final class SerializationContextImpl
implements SerializationContext {
    protected static Log log = LogFactory.getLog(SerializationContextImpl.class.getName());
    private static final Serializer intSerializer = new SimpleSerializer(Integer.class, Constants.XSD_INT);
    SerializationWriter sWriter;
    private MessageContext msgContext;
    private QName currentXMLType;
    private TypeMappingRegistry tmr = null;
    private TypeMapping tm = null;
    private String encodingStyle = null;
    private SOAPConstants soapConstants = SOAPConstants.SOAP11_CONSTANTS;
    SchemaVersion schemaVersion = SchemaVersion.SCHEMA_2001;
    private static QName multirefQName = QNameTable.createQName("", "multiRef");
    private QName actualXMLType = null;
    private int nesting = 0;
    private boolean doMultiRefs = false;
    private boolean sendXSIType = true;
    private HashMap multiRefValues = null;
    private int multiRefIndex = -1;
    private HashSet secondLevelObjects = null;
    private Object forceSer = null;
    private boolean outputMultiRefsFlag = false;
    private List buildNumbers = null;

    public SerializationContextImpl(Writer writer) {
        this.sWriter = new SerializationWriter(writer, "utf-8", true);
    }

    public SerializationContextImpl(Writer writer, MessageContext messageContext) {
        this(writer, messageContext, true);
    }

    public SerializationContextImpl(Writer writer, MessageContext messageContext, boolean bl) {
        this(writer, messageContext, bl, "utf-8");
    }

    public SerializationContextImpl(Writer writer, MessageContext messageContext, boolean bl, String string) {
        boolean bl2 = true;
        this.msgContext = messageContext;
        WebServicesEngine webServicesEngine = null;
        if (messageContext != null) {
            Boolean bl3;
            Boolean bl4;
            this.soapConstants = messageContext.getSOAPConstants();
            if (webServicesEngine == null) {
                webServicesEngine = messageContext.getEngine();
            }
            this.schemaVersion = messageContext.getSchemaVersion();
            Boolean bl5 = (Boolean)webServicesEngine.getOption("sendXMLDeclaration");
            if (bl5 != null) {
                bl2 = bl5;
            }
            if ((bl4 = (Boolean)messageContext.getProperty("sendMultiRefs")) == null) {
                bl4 = (Boolean)webServicesEngine.getOption("sendMultiRefs");
            }
            if (bl4 != null) {
                this.doMultiRefs = bl4;
            }
            if (!messageContext.isPropertyTrue("send_type_attr", true)) {
                this.sendXSIType = false;
            }
            if ((bl3 = (Boolean)webServicesEngine.getOption("sendXsiTypes")) != null && bl3.equals(Boolean.FALSE)) {
                this.sendXSIType = false;
            }
            Use use = null;
            if (messageContext.getOperationUseString() != null) {
                use = Use.getUse(messageContext.getOperationUseString());
            }
            if (use != null && use != Use.ENCODED) {
                this.sendXSIType = false;
                this.doMultiRefs = false;
            }
        }
        this.sWriter = new SerializationWriter(writer, string, bl2 && bl);
    }

    public SerializationWriter getSerializationWriter() {
        return this.sWriter;
    }

    public void serialize(QName qName, Attributes attributes, Object object) throws IOException {
        this.serialize(qName, attributes, object, null, true, null);
    }

    public void serialize(QName qName, Attributes attributes, Object object, QName qName2, boolean bl, Boolean bl2) throws IOException {
        this.serialize(qName, attributes, object, qName2, bl, bl2, null);
    }

    public void serialize(QName qName, Attributes attributes, Object object, QName qName2, boolean bl, Boolean bl2, Serializer serializer) throws IOException {
        this.serialize(qName, attributes, object, qName2, object == null ? null : object.getClass(), bl, bl2, serializer);
    }

    public void serialize(QName qName, Attributes attributes, Object object, QName qName2, Class clazz, boolean bl, Boolean bl2, Serializer serializer) throws IOException {
        Object object2;
        Object object3;
        boolean bl3;
        boolean bl4 = bl3 = bl2 == null ? this.shouldSendXSIType() : bl2.booleanValue();
        if (object == null) {
            object3 = AttachmentUtils.mime((QName)qName2);
            if (object3 != null) {
                object = new DataHandler((DataSource)new ManagedMemoryDataSource((InputStream)new ByteArrayInputStream(new byte[0]), (String)object3));
            } else {
                if (bl) {
                    AttributesImpl attributesImpl = new AttributesImpl();
                    if (attributes != null && 0 < attributes.getLength()) {
                        attributesImpl.setAttributes(attributes);
                    }
                    if (bl3) {
                        attributesImpl = (AttributesImpl)this.setTypeAttribute(attributesImpl, qName2);
                    }
                    String string = this.schemaVersion.getNilQName().getLocalPart();
                    attributesImpl.addAttribute(this.schemaVersion.getXsiURI(), string, "xsi:" + string, "CDATA", "true");
                    this.simpleElement(qName, attributesImpl, null);
                    return;
                }
                return;
            }
        }
        if (object instanceof AttachmentPart) {
            try {
                object = ((AttachmentPart)object).getDataHandler();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.encoding.SerializationContextImpl.serialize", "411", this);
                throw new IOException(Messages.getMessage("nullInSerActual00"));
            }
        }
        if ((object3 = this.getCurrentMessage()) != null && (object2 = ((Message)object3).getAttachmentsImpl()) != null && object2.isAttachment(object)) {
            this.serializeActual(qName, attributes, object, qName2, clazz, bl2, serializer);
            return;
        }
        if (!this.doMultiRefs || object == this.forceSer || this.isPrimitive(object) || AttachmentUtils.isMIME((QName)qName2)) {
            if (object == this.forceSer) {
                this.forceSer = null;
            }
            this.serializeActual(qName, attributes, object, qName2, clazz, bl2, serializer);
        } else {
            MultiRefItem multiRefItem;
            if (this.multiRefIndex == -1) {
                this.multiRefValues = new HashMap();
            }
            if ((multiRefItem = (MultiRefItem)this.multiRefValues.get(this.getIdentityKey(object))) != null) {
                object2 = multiRefItem.id;
            } else {
                ++this.multiRefIndex;
                object2 = "id" + this.multiRefIndex;
                multiRefItem = new MultiRefItem((String)object2, qName2, bl2, object, serializer);
                this.multiRefValues.put(this.getIdentityKey(object), multiRefItem);
                if (this.soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
                    AttributesImpl attributesImpl = new AttributesImpl();
                    if (attributes != null && 0 < attributes.getLength()) {
                        attributesImpl.setAttributes(attributes);
                    }
                    attributesImpl.addAttribute("", "id", "id", "CDATA", (String)object2);
                    this.serializeActual(qName, attributesImpl, object, qName2, clazz, bl2, serializer);
                    return;
                }
                if (this.outputMultiRefsFlag) {
                    if (this.secondLevelObjects == null) {
                        this.secondLevelObjects = new HashSet();
                    }
                    this.secondLevelObjects.add(this.getIdentityKey(object));
                }
            }
            AttributesImpl attributesImpl = new AttributesImpl();
            if (attributes != null && 0 < attributes.getLength()) {
                attributesImpl.setAttributes(attributes);
            }
            attributesImpl.addAttribute("", "href", "href", "CDATA", '#' + (String)object2);
            this.simpleElement(qName, attributesImpl, null);
        }
    }

    public void serialize(QName qName, Attributes attributes, Object object, QName qName2, Class clazz, boolean bl, Boolean bl2, Serializer serializer, RequestResponse requestResponse) throws IOException {
        Object object2;
        Object object3;
        boolean bl3;
        boolean bl4 = bl3 = bl2 == null ? this.shouldSendXSIType() : bl2.booleanValue();
        if (object == null) {
            object3 = AttachmentUtils.mime((QName)qName2);
            if (object3 != null) {
                object = new DataHandler((DataSource)new ManagedMemoryDataSource((InputStream)new ByteArrayInputStream(new byte[0]), (String)object3));
            } else {
                if (bl) {
                    AttributesImpl attributesImpl = new AttributesImpl();
                    if (attributes != null && 0 < attributes.getLength()) {
                        attributesImpl.setAttributes(attributes);
                    }
                    if (bl3) {
                        attributesImpl = (AttributesImpl)this.setTypeAttribute(attributesImpl, qName2);
                    }
                    String string = this.schemaVersion.getNilQName().getLocalPart();
                    attributesImpl.addAttribute(this.schemaVersion.getXsiURI(), string, "xsi:" + string, "CDATA", "true");
                    this.simpleElement(qName, attributesImpl, null);
                    return;
                }
                return;
            }
        }
        if (object instanceof AttachmentPart) {
            try {
                object = ((AttachmentPart)object).getDataHandler();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.encoding.SerializationContextImpl.serialize", "411", this);
                throw new IOException(Messages.getMessage("nullInSerActual00"));
            }
        }
        if ((object3 = this.getCurrentMessage()) != null && (object2 = ((Message)object3).getAttachmentsImpl()) != null && object2.isAttachment(object)) {
            this.serializeActual(qName, attributes, object, qName2, clazz, bl2, serializer, requestResponse);
            return;
        }
        if (!this.doMultiRefs || object == this.forceSer || this.isPrimitive(object) || AttachmentUtils.isMIME((QName)qName2)) {
            if (object == this.forceSer) {
                this.forceSer = null;
            }
            this.serializeActual(qName, attributes, object, qName2, clazz, bl2, serializer);
        } else {
            MultiRefItem multiRefItem;
            if (this.multiRefIndex == -1) {
                this.multiRefValues = new HashMap();
            }
            if ((multiRefItem = (MultiRefItem)this.multiRefValues.get(this.getIdentityKey(object))) != null) {
                object2 = multiRefItem.id;
            } else {
                ++this.multiRefIndex;
                object2 = "id" + this.multiRefIndex;
                multiRefItem = new MultiRefItem((String)object2, qName2, bl2, object, serializer);
                this.multiRefValues.put(this.getIdentityKey(object), multiRefItem);
                if (this.soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
                    AttributesImpl attributesImpl = new AttributesImpl();
                    if (attributes != null && 0 < attributes.getLength()) {
                        attributesImpl.setAttributes(attributes);
                    }
                    attributesImpl.addAttribute("", "id", "id", "CDATA", (String)object2);
                    this.serializeActual(qName, attributesImpl, object, qName2, clazz, bl2, serializer, requestResponse);
                    return;
                }
                if (this.outputMultiRefsFlag) {
                    if (this.secondLevelObjects == null) {
                        this.secondLevelObjects = new HashSet();
                    }
                    this.secondLevelObjects.add(this.getIdentityKey(object));
                }
            }
            AttributesImpl attributesImpl = new AttributesImpl();
            if (attributes != null && 0 < attributes.getLength()) {
                attributesImpl.setAttributes(attributes);
            }
            attributesImpl.addAttribute("", "href", "href", "CDATA", '#' + (String)object2);
            this.simpleElement(qName, attributesImpl, null);
        }
    }

    public void outputMultiRefs() throws IOException {
        if (!this.doMultiRefs || this.multiRefValues == null || this.soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
            return;
        }
        this.outputMultiRefsFlag = true;
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", "", "", "");
        String string = this.soapConstants.getEncodingURI();
        String string2 = this.sWriter.getOrCreatePrefix(string, null, true);
        String string3 = string2 + ":root";
        attributesImpl.addAttribute(string, "root", string3, "CDATA", "0");
        String string4 = this.msgContext != null ? this.msgContext.getEncodingStyle() : this.soapConstants.getEncodingURI();
        String string5 = this.sWriter.getOrCreatePrefix(this.soapConstants.getEnvelopeURI(), null, true);
        String string6 = string5 + ':' + "encodingStyle";
        attributesImpl.addAttribute(this.soapConstants.getEnvelopeURI(), "encodingStyle", string6, "CDATA", string4);
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.multiRefValues.keySet());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                MultiRefItem multiRefItem = (MultiRefItem)this.multiRefValues.get(e);
                attributesImpl.setAttribute(0, "", "id", "id", "CDATA", multiRefItem.id);
                this.forceSer = multiRefItem.value;
                this.serialize(multirefQName, attributesImpl, multiRefItem.value, multiRefItem.xmlType, true, null, multiRefItem.serializer);
            }
            if (this.secondLevelObjects == null) continue;
            iterator = this.secondLevelObjects.iterator();
            this.secondLevelObjects = null;
        }
        this.forceSer = null;
        this.outputMultiRefsFlag = false;
        this.multiRefValues = null;
        this.multiRefIndex = -1;
        this.secondLevelObjects = null;
    }

    private void serializeActual(QName qName, Attributes attributes, Object object, QName qName2, Class clazz, Boolean bl, Serializer serializer) throws IOException {
        Serializer serializer2;
        TypeMapping typeMapping;
        boolean bl2;
        if (log.isDebugEnabled()) {
            log.debug("serializeActual:" + qName + " , " + qName2);
        }
        ++this.nesting;
        if (this.nesting > 100) {
            --this.nesting;
            throw new IOException(Messages.getMessage("serNesting00", object.getClass().getName()));
        }
        boolean bl3 = bl2 = bl == null ? this.shouldSendXSIType() : bl.booleanValue();
        if (object == null) {
            --this.nesting;
            throw new IOException(Messages.getMessage("nullInSerActual00"));
        }
        if (clazz == null) {
            clazz = object.getClass();
        }
        if (log.isDebugEnabled()) {
            log.debug("  javaType=" + clazz);
        }
        if ((typeMapping = this.getTypeMapping()) == null) {
            --this.nesting;
            this.throwSerNotFound(object.getClass());
        }
        this.currentXMLType = qName2;
        if (Constants.equals(Constants.XSD_ANYTYPE, qName2)) {
            qName2 = null;
            bl2 = true;
        }
        if (serializer != null) {
            serializer2 = serializer;
            this.actualXMLType = qName2;
        } else {
            serializer2 = this.getSerializer(clazz, qName2);
        }
        if (serializer2 == null) {
            --this.nesting;
            this.throwSerNotFound(object.getClass());
        }
        if (bl2 || qName2 != null && !qName2.equals(this.actualXMLType)) {
            attributes = this.setTypeAttribute(attributes, this.actualXMLType);
        }
        this.logBuildNumber(serializer2.getBuildNumber());
        serializer2.serialize(qName, attributes, object, this);
        --this.nesting;
    }

    private void serializeActual(QName qName, Attributes attributes, Object object, QName qName2, Class clazz, Boolean bl, Serializer serializer, RequestResponse requestResponse) throws IOException {
        Serializer serializer2;
        TypeMapping typeMapping;
        boolean bl2;
        if (log.isDebugEnabled()) {
            log.debug("serializeActual:" + qName + " , " + qName2);
        }
        ++this.nesting;
        if (this.nesting > 100) {
            --this.nesting;
            throw new IOException(Messages.getMessage("serNesting00", object.getClass().getName()));
        }
        boolean bl3 = bl2 = bl == null ? this.shouldSendXSIType() : bl.booleanValue();
        if (object == null) {
            --this.nesting;
            throw new IOException(Messages.getMessage("nullInSerActual00"));
        }
        if (clazz == null) {
            clazz = object.getClass();
        }
        if (log.isDebugEnabled()) {
            log.debug("  javaType=" + clazz);
        }
        if ((typeMapping = this.getTypeMapping()) == null) {
            --this.nesting;
            this.throwSerNotFound(object.getClass());
        }
        this.currentXMLType = qName2;
        if (Constants.equals(Constants.XSD_ANYTYPE, qName2)) {
            qName2 = null;
            bl2 = true;
        }
        if (serializer != null) {
            serializer2 = serializer;
            this.actualXMLType = qName2;
        } else {
            serializer2 = this.getSerializer(clazz, qName2);
        }
        if (serializer2 == null) {
            --this.nesting;
            this.throwSerNotFound(object.getClass());
        }
        if (bl2 || qName2 != null && !qName2.equals(this.actualXMLType)) {
            attributes = this.setTypeAttribute(attributes, this.actualXMLType);
        }
        this.logBuildNumber(serializer2.getBuildNumber());
        if (serializer2 instanceof JAFDataHandlerSerializer) {
            ((JAFDataHandlerSerializer)serializer2).serialize(qName, attributes, object, this, requestResponse);
        } else {
            serializer2.serialize(qName, attributes, object, this);
        }
        --this.nesting;
    }

    public void setDoMultiRefs(boolean bl) {
        this.doMultiRefs = bl;
    }

    public boolean shouldSendXSIType() {
        return this.sendXSIType;
    }

    public TypeMapping getTypeMapping() {
        if (this.tm == null) {
            this.tm = this.msgContext == null ? DefaultTypeMappingImpl.getSingleton() : (TypeMapping)this.getTypeMappingRegistry().getTypeMapping(this.getEncodingStyle());
        }
        return this.tm;
    }

    public String getEncodingStyle() {
        if (this.encodingStyle == null) {
            if (this.msgContext != null) {
                this.encodingStyle = this.msgContext.getEncodingStyle();
            }
            if (this.encodingStyle == null) {
                this.encodingStyle = this.soapConstants.getEncodingURI();
            }
        }
        return this.encodingStyle;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.tmr == null && this.msgContext != null) {
            this.tmr = this.msgContext.getTypeMappingRegistry();
        }
        return this.tmr;
    }

    public Message getCurrentMessage() {
        if (this.msgContext == null) {
            return null;
        }
        return this.msgContext.getCurrentMessage();
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    private QName getQNameForClass(Class clazz) {
        return this.getTypeMapping().getTypeQName(clazz);
    }

    private boolean isPrimitive(Object object) {
        if (object == null) {
            return true;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz == String.class) {
            return true;
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (HexBinary.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Element.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Node.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz == [B.class) {
            return true;
        }
        if (clazz.isArray()) {
            return true;
        }
        QName qName = this.getQNameForClass(clazz);
        return qName != null && Constants.isSchemaXSD(qName.getNamespaceURI()) && Utils.isXSDType(qName);
    }

    private IDKey getIdentityKey(Object object) {
        return new IDKey(object);
    }

    public QName getCurrentXMLType() {
        return this.currentXMLType;
    }

    private SerializerFactory getSerializerFactoryFromInterface(Class clazz, QName qName, TypeMapping typeMapping) {
        SerializerFactory serializerFactory = null;
        Class<?>[] classArray = clazz.getInterfaces();
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz2 = classArray[i];
                serializerFactory = (SerializerFactory)typeMapping.getSerializer(clazz2, qName);
                if (serializerFactory == null) {
                    serializerFactory = this.getSerializerFactoryFromInterface(clazz2, qName, typeMapping);
                }
                if (serializerFactory != null) break;
            }
        }
        return serializerFactory;
    }

    public Serializer getSerializer(Class clazz, QName qName) {
        if (qName == Constants.XSD_INT && clazz != null && (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class))) {
            this.actualXMLType = Constants.XSD_INT;
            return intSerializer;
        }
        SerializerFactory serializerFactory = null;
        TypeMapping typeMapping = this.getTypeMapping();
        this.actualXMLType = null;
        while (clazz != null && (serializerFactory = (SerializerFactory)typeMapping.getSerializer(clazz, qName)) == null && (serializerFactory = this.getSerializerFactoryFromInterface(clazz, qName, typeMapping)) == null) {
            clazz = clazz.getSuperclass();
        }
        Serializer serializer = null;
        if (serializerFactory != null) {
            serializer = (Serializer)serializerFactory.getSerializerAs("WebServices SAX Mechanism");
            if (serializerFactory instanceof BaseSerializerFactory) {
                this.actualXMLType = ((BaseSerializerFactory)serializerFactory).getXMLType();
            }
            if (this.actualXMLType == null) {
                this.actualXMLType = ((TypeMappingImpl)typeMapping).getXMLType(clazz, qName);
            }
        }
        return serializer;
    }

    public String qName2String(QName qName, boolean bl) {
        return this.sWriter.qName2String(qName, bl);
    }

    public final Serializer getSerializerForJavaType(Class clazz) {
        SerializerFactory serializerFactory = null;
        Serializer serializer = null;
        try {
            serializerFactory = (SerializerFactory)this.getTypeMapping().getSerializer(clazz);
            if (serializerFactory != null) {
                serializer = (Serializer)serializerFactory.getSerializerAs("WebServices SAX Mechanism");
            }
        }
        catch (JAXRPCException jAXRPCException) {
            // empty catch block
        }
        return serializer;
    }

    public Attributes setTypeAttribute(Attributes attributes, QName qName) {
        if (qName == null || qName.getLocalPart().indexOf(">") >= 0 || attributes != null && attributes.getIndex("http://www.w3.org/2001/XMLSchema-instance", "type") != -1) {
            return attributes;
        }
        AttributesImpl attributesImpl = new AttributesImpl();
        if (attributes != null && 0 < attributes.getLength()) {
            attributesImpl.setAttributes(attributes);
        }
        String string = this.sWriter.getOrCreatePrefix("http://www.w3.org/2001/XMLSchema-instance", "xsi", true);
        attributesImpl.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", string + ":type", "CDATA", this.sWriter.qName2String(qName));
        return attributesImpl;
    }

    public String getValueAsString(Object object, QName qName) throws IOException {
        Serializable serializable;
        if (object == null) {
            return null;
        }
        Class clazz = object.getClass();
        Serializer serializer = this.getSerializer(clazz, qName);
        if (!(serializer != null && serializer instanceof SimpleValueSerializer || (serializable = JavaUtils.getPrimitiveClass(clazz)) == null)) {
            clazz = serializable;
            serializer = this.getSerializer(clazz, qName);
        }
        if (serializer == null) {
            this.throwSerNotFound(clazz);
        } else if (!(serializer instanceof SimpleValueSerializer)) {
            throw new IOException(Messages.getMessage("needSimpleValueSer", serializer.getClass().getName()));
        }
        serializable = (SimpleValueSerializer)serializer;
        return serializable.getValueAsString(object, this);
    }

    public void startElement(QName qName, Attributes attributes) throws IOException {
        this.sWriter.startElement(qName, attributes);
    }

    public void simpleElement(QName qName, Attributes attributes, String string) throws IOException {
        this.sWriter.simpleElement(qName, attributes, string);
    }

    public void endElement() throws IOException {
        this.sWriter.endElement();
    }

    private void throwSerNotFound(Class clazz) throws IOException {
        TypeMappingRegistry typeMappingRegistry = this.getTypeMappingRegistry();
        if (typeMappingRegistry.getRegisteredEncodingStyleURIs().length == 0) {
            throw new IOException(Messages.getMessage("noSerErr01", clazz.getName()));
        }
        throw new IOException(Messages.getMessage("noSerErr02", clazz.getName()));
    }

    public void logBuildNumber(String string) {
        if (string != null) {
            if (this.buildNumbers == null) {
                this.buildNumbers = new ArrayList();
            }
            if (!this.buildNumbers.contains(string)) {
                this.buildNumbers.add(string);
            }
        }
    }

    public List getBuildNumbers() {
        if (this.buildNumbers == null) {
            this.buildNumbers = new ArrayList();
        }
        return this.buildNumbers;
    }

    class IDKey {
        private Object value = null;
        private int id = 0;

        public IDKey(Object object) {
            this.id = System.identityHashCode(object);
            this.value = object;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object object) {
            if (!(object instanceof IDKey)) {
                return false;
            }
            IDKey iDKey = (IDKey)object;
            if (this.id != iDKey.id) {
                return false;
            }
            return this.value == iDKey.value;
        }
    }

    class MultiRefItem {
        String id;
        QName xmlType;
        Boolean sendType;
        Object value;
        Serializer serializer;

        MultiRefItem(String string, QName qName, Boolean bl, Object object, Serializer serializer) {
            this.id = string;
            this.xmlType = qName;
            this.sendType = bl;
            this.value = object;
            this.serializer = serializer;
        }
    }
}

