/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.enumtype.MessageType;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.events.P2DConverter;
import com.ibm.ws.webservices.engine.events.WrapperProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.HrefTable;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MCUtils;
import com.ibm.ws.webservices.engine.utils.WebServicesParser;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPEnvelopeBuilder;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class DeserializationContextImpl
implements DeserializationContext {
    protected static Log log = LogFactory.getLog(DeserializationContextImpl.class.getName());
    private SOAPEnvelope envelope;
    protected MessageContext msgContext;
    protected P2DConverter eventConverter = null;
    protected Stack eventConverterStack = null;
    private HrefTable hrefTable = null;
    private TypeMappingRegistry tmr = null;
    private TypeMapping tm = null;
    private String encodingStyle = null;
    private InputSource inputSource = null;
    private WebServicesParser parser = null;
    private List buildNumbers = null;
    private String priorThreadName = null;
    private Exception priorThreadException = null;
    private boolean inCheckThreadAccess = false;

    public DeserializationContextImpl(InputSource inputSource, MessageContext messageContext, MessageType messageType) {
        this.msgContext = messageContext;
        SOAPFactory sOAPFactory = new SOAPFactory(this.getSOAPConstants());
        sOAPFactory.setMessageType(messageType);
        try {
            this.envelope = sOAPFactory.createSOAPEnvelope(false);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl.DeserializationContextImpl", "211", this);
            throw new InternalException(sOAPException);
        }
        this.inputSource = inputSource;
        SOAPEnvelopeBuilder sOAPEnvelopeBuilder = new SOAPEnvelopeBuilder(this.envelope);
        sOAPEnvelopeBuilder.setMyElement(this.envelope);
        if (this.inputSource != null) {
            this.createEventConverter(new WrapperProcessor(sOAPEnvelopeBuilder));
        }
    }

    public DeserializationContextImpl(InputSource inputSource, MessageContext messageContext, MessageType messageType, SOAPEnvelope sOAPEnvelope) {
        this.envelope = sOAPEnvelope;
        SOAPEnvelopeBuilder sOAPEnvelopeBuilder = new SOAPEnvelopeBuilder(sOAPEnvelope);
        sOAPEnvelope.getSOAPFactory().setMessageType(messageType);
        this.msgContext = messageContext;
        this.inputSource = inputSource;
        if (this.inputSource != null) {
            this.createEventConverter(new WrapperProcessor(sOAPEnvelopeBuilder));
        }
    }

    public DeserializationContextImpl(MessageContext messageContext, DEventProcessor dEventProcessor) {
        this.msgContext = messageContext;
        if (dEventProcessor instanceof SOAPEnvelopeBuilder) {
            this.envelope = ((SOAPEnvelopeBuilder)dEventProcessor).getEnvelope();
        }
    }

    public void parse() throws SAXException {
        if (this.inputSource != null) {
            this.parser = (WebServicesParser)XMLUtils.getSAXParser();
            try {
                this.parser.parse(this.inputSource, (DefaultHandler)this.getEventConverter());
                InputStream inputStream = this.inputSource.getByteStream();
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl.parse", "269", this);
                throw MCUtils.interceptDeserializationException(exception, this);
            }
            finally {
                this.parser.recycle();
                this.parser = null;
            }
            this.inputSource = null;
            this.freeEventConverter();
        }
    }

    public InputStream getLazyParse() throws SAXException {
        if (this.parser == null) {
            return null;
        }
        return this.parser.getSubTreeAsStream();
    }

    public P2DConverter getEventConverter() {
        if (this.eventConverterStack != null && this.eventConverterStack.size() > 0) {
            this._checkThreadAccess();
            return (P2DConverter)this.eventConverterStack.peek();
        }
        return this.eventConverter;
    }

    public void createEventConverter(DEventProcessor dEventProcessor) {
        P2DConverter p2DConverter = new P2DConverter(dEventProcessor, this);
        if (this.eventConverter == null) {
            this.eventConverter = p2DConverter;
        } else {
            if (this.eventConverterStack == null) {
                this.eventConverterStack = new Stack();
            }
            this._checkThreadAccess();
            this.eventConverterStack.push(p2DConverter);
        }
    }

    public void freeEventConverter() {
        if (this.eventConverterStack != null && this.eventConverterStack.size() > 0) {
            this._checkThreadAccess();
            this.eventConverterStack.pop();
        } else {
            this.eventConverter = null;
        }
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public SOAPEnvelope getEnvelope() {
        return this.envelope;
    }

    public HrefTable getHrefTable() {
        if (this.hrefTable == null) {
            this.hrefTable = new HrefTable(this);
        }
        return this.hrefTable;
    }

    public final Deserializer getDeserializer(Class clazz, QName qName) {
        Deserializer deserializer;
        block9: {
            if (qName == null) {
                return null;
            }
            DeserializerFactory deserializerFactory = null;
            deserializer = null;
            try {
                deserializerFactory = (DeserializerFactory)this.getTypeMapping().getDeserializer(clazz, qName);
            }
            catch (JAXRPCException jAXRPCException) {
                FFDCFilter.processException((Throwable)jAXRPCException, "com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl.getDeserializer", "390", this);
                log.error(Messages.getMessage("noFactory00", qName.toString()));
            }
            if (deserializerFactory != null) {
                try {
                    deserializer = (Deserializer)deserializerFactory.getDeserializerAs("WebServices SAX Mechanism");
                }
                catch (JAXRPCException jAXRPCException) {
                    FFDCFilter.processException((Throwable)jAXRPCException, "com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl.getDeserializer", "397", this);
                    TypeMappingRegistry typeMappingRegistry = this.getTypeMappingRegistry();
                    if (typeMappingRegistry.getRegisteredEncodingStyleURIs().length == 0) {
                        log.error(Messages.getMessage("noDSerErr02", qName.toString()));
                        break block9;
                    }
                    log.error(Messages.getMessage("noDSerErr02", qName.toString()));
                }
            } else if (log.isDebugEnabled()) {
                log.debug("DeserializationContextImpl: dserF is null");
            }
        }
        return deserializer;
    }

    public TypeMapping getTypeMapping() {
        if (this.tm == null) {
            this.tm = (TypeMapping)this.getTypeMappingRegistry().getTypeMapping(this.getEncodingStyle());
        }
        return this.tm;
    }

    public String getEncodingStyle() {
        if (this.encodingStyle == null) {
            this.encodingStyle = this.msgContext.getEncodingStyle();
        }
        if (log.isDebugEnabled()) {
            log.debug("DeserializationContextImpl: getEncodingStyle() says " + this.encodingStyle);
        }
        return this.encodingStyle;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.tmr == null) {
            this.tmr = this.msgContext.getTypeMappingRegistry();
        }
        return this.tmr;
    }

    private SOAPConstants getSOAPConstants() {
        SOAPConstants sOAPConstants = null;
        if (this.msgContext != null) {
            sOAPConstants = this.msgContext.getSOAPConstants();
        }
        if (sOAPConstants == null) {
            sOAPConstants = SOAPConstants.SOAP11_CONSTANTS;
        }
        return sOAPConstants;
    }

    public void setSimpleEventOptimization(boolean bl) {
        if (bl) {
            this.getEventConverter().enableSimpleEvent();
        } else {
            this.getEventConverter().disableSimpleEvent();
        }
    }

    public boolean isSimpleEventEnabled() {
        return this.getEventConverter().isSimpleEventEnabled();
    }

    public void logBuildNumber(String string) {
        if (string != null) {
            if (this.buildNumbers == null) {
                this.buildNumbers = new ArrayList();
            }
            if (!this.buildNumbers.contains(string)) {
                this.buildNumbers.add(string);
            }
        }
    }

    public List getBuildNumbers() {
        if (this.buildNumbers == null) {
            this.buildNumbers = new ArrayList();
        }
        return this.buildNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void _checkThreadAccess() {
        Thread thread2 = Thread.currentThread();
        if (this.priorThreadName == null || !thread2.getName().equals(this.priorThreadName)) {
            DeserializationContextImpl deserializationContextImpl = this;
            synchronized (deserializationContextImpl) {
                if (this.inCheckThreadAccess) {
                    return;
                }
                this.inCheckThreadAccess = true;
                Exception exception = new Exception("Thread Trace");
                if (this.priorThreadName != null) {
                    String string = "Possible Simultaneous Multi-Thread Access Discovered \n Prior Thread = " + this.priorThreadName + "\n Current Thread = " + thread2.getName() + "\n Prior Stack = " + JavaUtils.stackToString(this.priorThreadException) + "\n Current Stack = " + JavaUtils.stackToString(exception);
                    log.error(Messages.getMessage("exception01", string));
                }
                this.priorThreadName = thread2.getName();
                this.priorThreadException = exception;
                this.inCheckThreadAccess = false;
            }
        }
    }
}

