/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.AttachmentsImpl;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDBeanMapping;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDChain;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDConstants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDispatcher;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDGen;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDJAXRPCHandlerInfoChain;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDNonFatalException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDOperation;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTargetedChain;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTypeMapping;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTypeMappingContainer;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistryImpl;
import com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory;
import com.ibm.ws.webservices.engine.enumtype.Style;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerChain;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandler;
import com.ibm.ws.webservices.engine.handlers.soap.ClientSOAPPort;
import com.ibm.ws.webservices.engine.handlers.soap.ServerSOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.LockableHashtable;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.tools.WSDLQuery;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDPort
extends WSDDTargetedChain
implements WSDDTypeMappingContainer {
    private static Log log = LogFactory.getLog(WSDDPort.class.getName());
    private TypeMappingRegistry _tmr = null;
    private List _typeMappings = new Vector();
    private List _operations = new Vector();
    private final PortDesc _portDesc = new PortDesc();
    private Vector _wsddGens = new Vector();
    private LockableHashtable _objects = null;
    private Style _style = Style.DEFAULT;
    private Use _use = Use.DEFAULT;

    public WSDDPort(int n) {
        super(n);
        this._portDesc.setName(this.getName());
    }

    public WSDDPort(int n, Element element) throws WSDDException {
        super(n, element);
        Element element2;
        String string;
        Object object;
        String string2;
        String string3;
        this._portDesc.setName(this.getName());
        String string4 = element.getAttribute("style");
        if (string4 != null && !string4.equals("")) {
            this.setStyle(Style.getStyle(string4, Style.DEFAULT));
            this.setDispatcherQName(this.getStyle().getDispatcher());
        }
        if ((string3 = element.getAttribute("use")) != null && !string3.equals("")) {
            this.setUse(Use.getUse(string3, Use.DEFAULT));
        } else if (this.getStyle() != Style.RPC) {
            this.setUse(Use.LITERAL);
        }
        String string5 = element.getAttribute("streaming");
        if (string5 != null && !string5.equals("")) {
            this.setStreaming(!string5.equals("off"));
        }
        if ((string2 = element.getAttribute("attachment")) != null && !string2.equals("")) {
            this.setSendType(AttachmentsImpl.getSendType((String)string2));
        }
        Element[] elementArray = this.getChildElements(element, "operation");
        for (int i = 0; i < elementArray.length; ++i) {
            this.addOperation(new WSDDOperation(elementArray[i], this._portDesc));
        }
        Element[] elementArray2 = this.getChildElements(element, "typeMapping");
        for (int i = 0; i < elementArray2.length; ++i) {
            this._addTypeMapping(new WSDDTypeMapping(elementArray2[i]));
        }
        Element[] elementArray3 = this.getChildElements(element, "beanMapping");
        for (int i = 0; i < elementArray3.length; ++i) {
            this._addTypeMapping(new WSDDBeanMapping(elementArray3[i]));
        }
        Vector<String> vector = new Vector<String>();
        Element[] elementArray4 = this.getChildElements(element, "namespace");
        for (int i = 0; i < elementArray4.length; ++i) {
            object = XMLUtils.getChildCharacterData(elementArray4[i]);
            vector.add((String)object);
        }
        this.setNamespaceMappings(vector);
        Element element3 = this.getChildElement(element, "wsdlFile");
        if (element3 != null) {
            object = XMLUtils.getChildCharacterData(element3);
            this.setWSDLFile((String)object);
        }
        if ((object = this.getChildElement(element, "endpointURL")) != null) {
            string = XMLUtils.getChildCharacterData((Element)object);
            this.setEndpointURL(string);
        }
        if ((string = element.getAttribute("dispatcher")) != null && !string.equals("")) {
            this.setDispatcherQName(XMLUtils.getQNameFromString(string, element));
        }
        if ((element2 = this.getChildElement(element, "handlerInfoChain")) != null) {
            this.setHandlerInfoChain(new WSDDJAXRPCHandlerInfoChain(n == 1, element2));
        }
        this._initTMR();
        this.validateDescriptors();
        Element[] elementArray5 = this.getChildElements(element, "Gen");
        for (int i = 0; i < elementArray5.length; ++i) {
            WSDDGen wSDDGen = new WSDDGen(elementArray5[i]);
            this._wsddGens.add(wSDDGen);
        }
    }

    public void setQName(QName qName) {
        super.setQName(qName);
        if (this._portDesc != null) {
            this._portDesc.setName(this.getName());
        }
    }

    protected QName getElementName() {
        return QNAME_PORT;
    }

    public void _initTMR() throws WSDDException {
        int n;
        this.expand();
        if (this._tmr == null) {
            this._tmr = new TypeMappingRegistryImpl();
            for (int i = 0; i < this._typeMappings.size(); ++i) {
                this.deployTypeMapping((WSDDTypeMapping)this._typeMappings.get(i));
            }
        }
        String[] stringArray = Use.getUses();
        String[] stringArray2 = new String[stringArray.length];
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray2[n] = Use.getUse(stringArray[n]).getEncoding();
        }
        for (n = 0; n < stringArray2.length; ++n) {
            String string = stringArray2[n];
            TypeMapping typeMapping = (TypeMapping)this._tmr.getTypeMapping(string);
            TypeMapping typeMapping2 = (TypeMapping)this._tmr.getDefaultTypeMapping();
            if (typeMapping != null && typeMapping != typeMapping2) continue;
            typeMapping = (TypeMapping)this._tmr.createTypeMapping();
            typeMapping.setSupportedEncodings(stringArray2);
            this._tmr.register(string, typeMapping);
        }
    }

    public void validateDescriptors() throws WSDDException {
        if (this._tmr == null) {
            this._initTMR();
        }
        this._portDesc.setTypeMappingRegistry(this._tmr);
        this._portDesc.setTypeMapping(this.getTypeMapping(this.getUse().getEncoding()));
    }

    public void addTypeMapping(WSDDTypeMapping wSDDTypeMapping) {
        this.expand();
        this._addTypeMapping(wSDDTypeMapping);
    }

    public void _addTypeMapping(WSDDTypeMapping wSDDTypeMapping) {
        this._typeMappings.add(wSDDTypeMapping);
    }

    public void addOperation(WSDDOperation wSDDOperation) {
        this._operations.add(wSDDOperation);
        OperationDesc operationDesc = wSDDOperation.getOperationDesc();
        this.setStyle(operationDesc.getStyle());
        this.setUse(operationDesc.getUse());
        this._portDesc.addOperationDesc(operationDesc);
    }

    public void loadPortDescByIntrospection() {
        this._portDesc.loadPortDescByIntrospection();
    }

    public QName getDispatcherQName() {
        return this.getPivotQName();
    }

    public void setDispatcherQName(QName qName) {
        this.setPivotQName(qName);
    }

    private Style getStyle() {
        return this._style;
    }

    private void setStyle(Style style) {
        this._style = style;
    }

    private Use getUse() {
        return this._use;
    }

    private void setUse(Use use) {
        this._use = use;
    }

    public boolean getStreaming() {
        return !this._portDesc.needsHighFidelityRecording();
    }

    public void setStreaming(boolean bl) {
        this._portDesc.setHighFidelityRecording(!bl);
    }

    public int getSendType() {
        return this._portDesc.getSendType();
    }

    public void setSendType(int n) {
        this._portDesc.setSendType(n);
    }

    public List getAllowedMethods() {
        return this._portDesc.getAllowedMethods();
    }

    public void setAllowedMethods(List list) {
        this._portDesc.setAllowedMethods(list);
    }

    public String getEndpointURL() {
        return this._portDesc.getEndpointURL();
    }

    public void setEndpointURL(String string) {
        this._portDesc.setEndpointURL(string);
    }

    public String getWSDLFile() {
        return this._portDesc.getWSDLFile();
    }

    public void setWSDLFile(String string) {
        this._portDesc.setWSDLFile(string);
    }

    public QName getWSDLPort() {
        return this._portDesc.getWSDLPort();
    }

    public void setWSDLPort(QName qName) {
        this._portDesc.setWSDLPort(qName);
    }

    public void setWSDLPort(String string, String string2) {
        this.setWSDLPort(QNameTable.createQName(string, string2));
    }

    public void setNamespaceMappings(List list) {
        if (!list.isEmpty()) {
            this._portDesc.setNamespaceMappings(list);
        }
    }

    public List getNamespaceMappings() {
        return this._portDesc.getNamespaceMappings();
    }

    public void setImplClass(Class clazz) {
        this._portDesc.setImplClass(clazz);
    }

    public void addWSGen(WSDDGen wSDDGen) {
        this._wsddGens.add(wSDDGen);
    }

    private void expand() {
        for (int i = 0; i < this._wsddGens.size(); ++i) {
            WSDLQuery wSDLQuery = null;
            try {
                wSDLQuery = ((WSDDGen)this._wsddGens.get(i)).getWSDLQuery();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.axis.ext.deployment.wsdd.WSDDPort.expand", "117", this);
                log.warn(Messages.getMessage("internalError00"), exception);
                throw new InternalException(exception);
            }
            if (wSDLQuery == null) continue;
            String string = this.getWSDLPort().getLocalPart();
            if (log.isDebugEnabled()) {
                log.debug("portName = " + string);
            }
            Vector vector = wSDLQuery.getTypeMappings(string);
            if (log.isDebugEnabled()) {
                log.debug("TypeMapping vector = " + vector);
            }
            if (vector != null) {
                for (int j = 0; j < vector.size(); ++j) {
                    this._addTypeMapping((WSDDTypeMapping)vector.get(j));
                }
            }
            Vector vector2 = wSDLQuery.getOperationDescs(string);
            if (log.isDebugEnabled()) {
                log.debug("Operations vector = " + vector2);
            }
            if (vector2 == null) continue;
            for (int j = 0; j < vector2.size(); ++j) {
                this.addOperation(new WSDDOperation((OperationDesc)vector2.get(j)));
            }
        }
        this._wsddGens = new Vector();
    }

    protected Handler makeNewInstance(EngineConfiguration engineConfiguration) throws ConfigurationException {
        Map map;
        this.expand();
        if (this._cachedPort == null) {
            List list;
            JAXRPCHandler.ActorHeaderBindings actorHeaderBindings;
            ClientSOAPPort clientSOAPPort;
            Handler handler;
            this._initTMR();
            map = null;
            WSDDChain wSDDChain = this.getRequestFlow();
            if (wSDDChain != null) {
                map = wSDDChain.getInstance(engineConfiguration);
            }
            Handler handler2 = null;
            WSDDChain wSDDChain2 = this.getResponseFlow();
            if (wSDDChain2 != null) {
                handler2 = wSDDChain2.getInstance(engineConfiguration);
            }
            if (this.getModeClientServer() == 2) {
                handler = null;
                if (this.getDispatcherQName() != null) {
                    try {
                        handler = WSDDDispatcher.getInstance(this.getDispatcherQName(), this, engineConfiguration);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort.makeNewInstance", "450", this);
                        throw WSDDException.makeWSDDException(exception);
                    }
                    if (handler == null) {
                        throw new WSDDException(Messages.getMessage("couldntConstructProvider00"));
                    }
                }
                clientSOAPPort = new ServerSOAPPort((Handler)map, handler, handler2);
            } else if (this.getModeClientServer() == 1) {
                clientSOAPPort = new ClientSOAPPort((Handler)map, handler2);
            } else {
                throw new InternalException(Messages.getMessage("soapport.csmode.undefined"));
            }
            clientSOAPPort.setPortDesc(this._portDesc);
            if (this.getQName() != null) {
                clientSOAPPort.setName(this.getName());
            }
            clientSOAPPort.setOptions((Map)this.getParametersTable());
            if (this.getUse() != Use.ENCODED) {
                clientSOAPPort.setOption("sendMultiRefs", (Object)Boolean.FALSE);
                clientSOAPPort.setOption("sendXsiTypes", (Object)Boolean.FALSE);
            }
            if ((handler = this.getHandlerChain()) != null) {
                clientSOAPPort.setHandlerChain((HandlerChain)handler);
            }
            if ((actorHeaderBindings = this.getActorHeaderBinding()) != null) {
                clientSOAPPort.setActorHeaderBinding(actorHeaderBindings);
            }
            if (this.getHandlerInfoChain() != null && (list = this.getHandlerInfoChain().getGlobalHeaders()) != null) {
                clientSOAPPort.setGlobalHeaders((Collection)list);
            }
            try {
                clientSOAPPort.getInitializedPortDesc(MessageContext.getCurrentThreadsContext());
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort.makeNewInstance", "510", this);
                throw WSDDException.makeWSDDException(webServicesFault);
            }
            this._cachedPort = clientSOAPPort;
        }
        if (this._objects != null) {
            map = this._cachedPort.getOptions();
            if (map != null) {
                map.putAll(this._objects);
            } else {
                this._cachedPort.setOptions((Map)this._objects);
            }
        }
        return this._cachedPort;
    }

    public void writeParamsToContext(SerializationContext serializationContext) throws IOException {
        super.writeParamsToContext(serializationContext);
        if (this._objects == null) {
            return;
        }
        Set set = this._objects.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "name", "name", "CDATA", string);
            attributesImpl.addAttribute("", "value", "value", "CDATA", entry.getValue().toString());
            if (this._objects.isKeyLocked(string)) {
                attributesImpl.addAttribute("", "locked", "locked", "CDATA", "true");
            }
            serializationContext.getSerializationWriter().simpleElement(QNAME_PARAM, attributesImpl, null);
        }
    }

    public void deployTypeMapping(WSDDTypeMapping wSDDTypeMapping) throws WSDDException {
        this.expand();
        if (!this._typeMappings.contains(wSDDTypeMapping)) {
            this._addTypeMapping(wSDDTypeMapping);
        }
        if (this._tmr == null) {
            this._tmr = new TypeMappingRegistryImpl();
        }
        try {
            int n;
            String[] stringArray;
            String string = wSDDTypeMapping.getEncodingStyle();
            if (string == null || string.equals("")) {
                stringArray = Use.getUses();
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray[n] = Use.getUse(stringArray[n]).getEncoding();
                }
            } else {
                stringArray = new String[]{string};
            }
            for (n = 0; n < stringArray.length; ++n) {
                string = stringArray[n];
                TypeMapping typeMapping = (TypeMapping)this._tmr.getTypeMapping(string);
                TypeMapping typeMapping2 = (TypeMapping)this._tmr.getDefaultTypeMapping();
                if (typeMapping == null || typeMapping == typeMapping2) {
                    typeMapping = (TypeMapping)this._tmr.createTypeMapping();
                    typeMapping.setSupportedEncodings(stringArray);
                    this._tmr.register(string, typeMapping);
                }
                this._portDesc.setTypeMappingRegistry(this._tmr);
                this._portDesc.setTypeMapping(typeMapping);
                SerializerFactory serializerFactory = null;
                DeserializerFactory deserializerFactory = null;
                if (wSDDTypeMapping.getSerializerName() != null && !wSDDTypeMapping.getSerializerName().equals("")) {
                    serializerFactory = BaseSerializerFactory.createFactory(wSDDTypeMapping.getSerializer(), wSDDTypeMapping.getLanguageSpecificType(), wSDDTypeMapping.getQName(), wSDDTypeMapping.getBinderName(), wSDDTypeMapping.getComponentQName(), wSDDTypeMapping.getComponentTypeQName());
                }
                if (wSDDTypeMapping.getDeserializerName() != null && !wSDDTypeMapping.getDeserializerName().equals("")) {
                    deserializerFactory = BaseDeserializerFactory.createFactory(wSDDTypeMapping.getDeserializer(), wSDDTypeMapping.getLanguageSpecificType(), wSDDTypeMapping.getQName(), wSDDTypeMapping.getBinderName(), wSDDTypeMapping.getComponentQName(), wSDDTypeMapping.getComponentTypeQName());
                }
                typeMapping.register(wSDDTypeMapping.getLanguageSpecificType(), wSDDTypeMapping.getQName(), serializerFactory, deserializerFactory);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort.deployTypeMapping", "570", this);
            log.error(Messages.getMessage("unabletoDeployTypemapping00", wSDDTypeMapping.getQName().toString()), classNotFoundException);
            throw WSDDNonFatalException.makeWSDDNonFatalException(classNotFoundException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort.deployTypeMapping", "574", this);
            throw WSDDException.makeWSDDException(exception);
        }
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        int n;
        this.expand();
        AttributesImpl attributesImpl = new AttributesImpl();
        QName qName = this.getQName();
        if (qName != null) {
            attributesImpl.addAttribute("", "name", "name", "CDATA", serializationContext.getSerializationWriter().qName2String(qName));
        }
        if (this.getDispatcherQName() != null) {
            attributesImpl.addAttribute("", "dispatcher", "dispatcher", "CDATA", serializationContext.getSerializationWriter().qName2String(this.getDispatcherQName()));
        }
        if (this.getStyle() != Style.DEFAULT) {
            attributesImpl.addAttribute("", "style", "style", "CDATA", this.getStyle().getName());
        }
        if (this.getUse() != Use.DEFAULT) {
            attributesImpl.addAttribute("", "use", "use", "CDATA", this.getUse().getName());
        }
        if (this.getStreaming()) {
            attributesImpl.addAttribute("", "streaming", "streaming", "CDATA", "on");
        } else {
            attributesImpl.addAttribute("", "streaming", "streaming", "CDATA", "off");
        }
        if (this.getSendType() != 1) {
            attributesImpl.addAttribute("", "attachment", "attachment", "CDATA", AttachmentsImpl.getSendTypeString((int)this.getSendType()));
        }
        serializationContext.getSerializationWriter().startElement(WSDDConstants.QNAME_PORT, attributesImpl);
        if (this.getWSDLFile() != null) {
            serializationContext.getSerializationWriter().simpleElement(QNAME_WSDLFILE, null, this.getWSDLFile());
        }
        for (n = 0; n < this._operations.size(); ++n) {
            WSDDOperation wSDDOperation = (WSDDOperation)this._operations.get(n);
            wSDDOperation.writeToContext(serializationContext);
        }
        this.writeFlowsToContext(serializationContext);
        this.writeParamsToContext(serializationContext);
        for (n = 0; n < this._typeMappings.size(); ++n) {
            ((WSDDTypeMapping)this._typeMappings.get(n)).writeToContext(serializationContext);
        }
        List list = this.getNamespaceMappings();
        for (int i = 0; i < list.size(); ++i) {
            serializationContext.getSerializationWriter().simpleElement(QNAME_NAMESPACE, null, (String)list.get(i));
        }
        if (this.getEndpointURL() != null) {
            serializationContext.getSerializationWriter().simpleElement(QNAME_ENDPOINTURL, null, this.getEndpointURL());
        }
        if (this.getHandlerInfoChain() != null) {
            this.getHandlerInfoChain().writeToContext(serializationContext);
        }
        serializationContext.getSerializationWriter().endElement();
    }

    public List getTypeMappings() {
        return this._typeMappings;
    }

    public void setTypeMappings(Vector vector) {
        this._typeMappings = vector;
    }

    public TypeMapping getTypeMapping(String string) {
        if (this._tmr == null) {
            return null;
        }
        return (TypeMapping)this._tmr.getTypeMapping(string);
    }

    public void setObject(String string, Object object) {
        if (this._objects == null) {
            this._objects = new LockableHashtable();
        }
        this._objects.put(string, object);
    }

    public String getName() {
        return this.getQName() == null ? null : this.getQName().getLocalPart();
    }

    public String toString() {
        return "WSDDPort: Mode=" + (this.getModeClientServer() == 1 ? "Client" : "Server") + ", Name=" + this.getName() + ", PortDesc=" + this._portDesc;
    }
}

