/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.SimpleTargetedChain;
import com.ibm.ws.webservices.engine.WSDDEngineConfiguration;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDBeanMapping;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDElement;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDGlobalConfiguration;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDNonFatalException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTransport;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTypeMapping;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTypeMappingContainer;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistryImpl;
import com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleException;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleObject;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleOwner;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleSetImpl;
import com.ibm.ws.webservices.engine.lifecycle._LifeCycleObject;
import com.ibm.ws.webservices.engine.lifecycle._LifeCycleSet;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;

public class WSDDDeployment
extends WSDDElement
implements WSDDTypeMappingContainer,
WSDDEngineConfiguration,
_LifeCycleObject {
    protected static Log log = LogFactory.getLog(WSDDDeployment.class.getName());
    private HashMap ports = new HashMap();
    private HashMap transports = new HashMap();
    private Vector typeMappings = new Vector();
    private WSDDGlobalConfiguration globalConfig = null;
    private HashMap namespaceToPorts = new HashMap();
    private boolean _containerManaged = false;
    private _LifeCycleSet _lifeCycleSet;
    TypeMappingRegistry tmr = new TypeMappingRegistryImpl();
    private boolean tmrDeployed = false;

    public WSDDDeployment() {
        this._lifeCycleSet = this.lifeCycleSetFactory(this);
    }

    public WSDDDeployment(int n, Element element) throws WSDDException {
        super(element);
        WSDDTypeMapping wSDDTypeMapping;
        int n2;
        this._lifeCycleSet = this.lifeCycleSetFactory(this);
        Element[] elementArray = this.getChildElements(element, "transport");
        for (n2 = 0; n2 < elementArray.length; ++n2) {
            this.deployTransport(new WSDDTransport(n, elementArray[n2]));
        }
        elementArray = this.getChildElements(element, "port");
        for (n2 = 0; n2 < elementArray.length; ++n2) {
            try {
                this.deployPort(new WSDDPort(n, elementArray[n2]));
                continue;
            }
            catch (WSDDNonFatalException wSDDNonFatalException) {
                continue;
            }
            catch (WSDDException wSDDException) {
                FFDCFilter.processException((Throwable)((Object)wSDDException), "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment.WSDDDeployment", "187", this);
                throw wSDDException;
            }
        }
        elementArray = this.getChildElements(element, "typeMapping");
        for (n2 = 0; n2 < elementArray.length; ++n2) {
            try {
                wSDDTypeMapping = new WSDDTypeMapping(elementArray[n2]);
                this.deployTypeMapping(wSDDTypeMapping);
                continue;
            }
            catch (WSDDNonFatalException wSDDNonFatalException) {
                continue;
            }
            catch (WSDDException wSDDException) {
                FFDCFilter.processException((Throwable)((Object)wSDDException), "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment.WSDDDeployment", "202", this);
                throw wSDDException;
            }
        }
        elementArray = this.getChildElements(element, "beanMapping");
        for (n2 = 0; n2 < elementArray.length; ++n2) {
            wSDDTypeMapping = new WSDDBeanMapping(elementArray[n2]);
            this.deployTypeMapping(wSDDTypeMapping);
        }
        Element element2 = this.getChildElement(element, "globalConfiguration");
        if (element2 != null) {
            this.setGlobalConfiguration(new WSDDGlobalConfiguration(n, element2));
        }
    }

    protected _LifeCycleSet lifeCycleSetFactory(_LifeCycleObject _LifeCycleObject2) {
        return new LifeCycleSetImpl(_LifeCycleObject2);
    }

    public boolean isContainerManaged() {
        return this._containerManaged;
    }

    public void setContainerManaged(boolean bl) {
        this._containerManaged = bl;
    }

    public void deployTransport(WSDDTransport wSDDTransport) {
        this.undeployTransport(wSDDTransport.getQName());
        this.transports.put(wSDDTransport.getQName(), wSDDTransport);
        this.manageLifeCycleOf((LifeCycleObject)wSDDTransport);
    }

    public void undeployTransport(QName qName) {
        WSDDTransport wSDDTransport = (WSDDTransport)this.transports.get(qName);
        if (wSDDTransport != null) {
            this.transports.remove(qName);
            if (this.releaseLifeCycleManagementOf((LifeCycleObject)wSDDTransport) && wSDDTransport.isActive()) {
                wSDDTransport.destroy();
            }
        }
    }

    public void deployPort(WSDDPort wSDDPort) {
        this.undeployPort(wSDDPort.getQName());
        this.registerNamespaceForPort(wSDDPort.getQName().getLocalPart(), wSDDPort);
        List list = wSDDPort.getNamespaceMappings();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            this.registerNamespaceForPort(string, wSDDPort);
        }
        this.ports.put(wSDDPort.getQName(), wSDDPort);
        this.manageLifeCycleOf((LifeCycleObject)wSDDPort);
    }

    public void undeployPort(QName qName) {
        WSDDPort wSDDPort = (WSDDPort)this.ports.get(qName);
        if (wSDDPort != null) {
            List list = wSDDPort.getNamespaceMappings();
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                this.removeNamespaceMapping(string);
            }
            this.removeNamespaceMapping(wSDDPort.getQName().getLocalPart());
            this.ports.remove(qName);
            if (this.releaseLifeCycleManagementOf((LifeCycleObject)wSDDPort) && wSDDPort.isActive()) {
                wSDDPort.destroy();
            }
        }
    }

    public void deployTypeMapping(WSDDTypeMapping wSDDTypeMapping) throws WSDDException {
        if (!this.typeMappings.contains(wSDDTypeMapping)) {
            this.typeMappings.add(wSDDTypeMapping);
        }
        if (this.tmrDeployed) {
            this.deployMapping(wSDDTypeMapping);
        }
    }

    protected QName getElementName() {
        return QNAME_DEPLOY;
    }

    public void deployToRegistry(WSDDDeployment wSDDDeployment) throws ConfigurationException {
        WSDDGlobalConfiguration wSDDGlobalConfiguration = this.globalConfig;
        if (wSDDGlobalConfiguration != null) {
            wSDDDeployment.setGlobalConfiguration(wSDDGlobalConfiguration);
        }
        Iterator<Object> iterator = this.transports.values().iterator();
        while (iterator.hasNext()) {
            wSDDDeployment.deployTransport((WSDDTransport)iterator.next());
        }
        iterator = this.ports.values().iterator();
        while (iterator.hasNext()) {
            wSDDDeployment.deployPort((WSDDPort)iterator.next());
        }
        iterator = this.typeMappings.iterator();
        while (iterator.hasNext()) {
            wSDDDeployment.deployTypeMapping((WSDDTypeMapping)iterator.next());
        }
    }

    private void deployMapping(WSDDTypeMapping wSDDTypeMapping) throws WSDDException {
        try {
            String string = wSDDTypeMapping.getEncodingStyle();
            if (string == null) {
                string = Constants.URI_DEFAULT_SOAP_ENC;
            }
            TypeMapping typeMapping = (TypeMapping)this.tmr.getTypeMapping(string);
            TypeMapping typeMapping2 = (TypeMapping)this.tmr.getDefaultTypeMapping();
            if (typeMapping == null || typeMapping == typeMapping2) {
                typeMapping = (TypeMapping)this.tmr.createTypeMapping();
                typeMapping.setSupportedEncodings(new String[]{string});
                this.tmr.register(string, typeMapping);
            }
            SerializerFactory serializerFactory = null;
            DeserializerFactory deserializerFactory = null;
            if (wSDDTypeMapping.getSerializerName() != null && !wSDDTypeMapping.getSerializerName().equals("")) {
                serializerFactory = BaseSerializerFactory.createFactory(wSDDTypeMapping.getSerializer(), wSDDTypeMapping.getLanguageSpecificType(), wSDDTypeMapping.getQName(), wSDDTypeMapping.getComponentQName(), wSDDTypeMapping.getComponentTypeQName());
            }
            if (wSDDTypeMapping.getDeserializerName() != null && !wSDDTypeMapping.getDeserializerName().equals("")) {
                deserializerFactory = BaseDeserializerFactory.createFactory(wSDDTypeMapping.getDeserializer(), wSDDTypeMapping.getLanguageSpecificType(), wSDDTypeMapping.getQName(), wSDDTypeMapping.getComponentQName(), wSDDTypeMapping.getComponentTypeQName());
            }
            typeMapping.register(wSDDTypeMapping.getLanguageSpecificType(), wSDDTypeMapping.getQName(), serializerFactory, deserializerFactory);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment.deployMapping", "399", this);
            log.error(Messages.getMessage("unabletoDeployTypemapping00", wSDDTypeMapping.getQName().toString()), classNotFoundException);
            throw WSDDNonFatalException.makeWSDDNonFatalException(classNotFoundException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment.deployMapping", "403", this);
            throw WSDDException.makeWSDDException(exception);
        }
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        WSDDElement wSDDElement;
        serializationContext.getSerializationWriter().addMapping("", "http://websphere.ibm.com/webservices/wsdd/");
        serializationContext.getSerializationWriter().addMapping("java", "http://websphere.ibm.com/webservices/wsdd/dispatchers/java");
        serializationContext.getSerializationWriter().startElement(QNAME_DEPLOY, null);
        if (this.globalConfig != null) {
            this.globalConfig.writeToContext(serializationContext);
        }
        Iterator<Object> iterator = this.ports.values().iterator();
        while (iterator.hasNext()) {
            wSDDElement = (WSDDPort)iterator.next();
            ((WSDDPort)wSDDElement).writeToContext(serializationContext);
        }
        iterator = this.transports.values().iterator();
        while (iterator.hasNext()) {
            wSDDElement = (WSDDTransport)iterator.next();
            ((WSDDTransport)wSDDElement).writeToContext(serializationContext);
        }
        iterator = this.typeMappings.iterator();
        while (iterator.hasNext()) {
            wSDDElement = (WSDDTypeMapping)iterator.next();
            ((WSDDTypeMapping)wSDDElement).writeToContext(serializationContext);
        }
        serializationContext.getSerializationWriter().endElement();
    }

    public void setGlobalConfiguration(WSDDGlobalConfiguration wSDDGlobalConfiguration) {
        if (this.globalConfig != null && this.releaseLifeCycleManagementOf((LifeCycleObject)this.globalConfig) && this.globalConfig.isActive()) {
            this.globalConfig.destroy();
        }
        this.globalConfig = wSDDGlobalConfiguration;
        if (this.globalConfig != null) {
            this.manageLifeCycleOf((LifeCycleObject)this.globalConfig);
        }
    }

    public WSDDTypeMapping[] getTypeMappings() {
        WSDDTypeMapping[] wSDDTypeMappingArray = new WSDDTypeMapping[this.typeMappings.size()];
        this.typeMappings.toArray(wSDDTypeMappingArray);
        return wSDDTypeMappingArray;
    }

    public WSDDPort[] getPorts() {
        WSDDPort[] wSDDPortArray = new WSDDPort[this.ports.size()];
        this.ports.values().toArray(wSDDPortArray);
        return wSDDPortArray;
    }

    public WSDDPort getWSDDPort(QName qName) {
        return (WSDDPort)this.ports.get(qName);
    }

    public Handler getTransport(QName qName) throws ConfigurationException {
        WSDDTransport wSDDTransport = (WSDDTransport)this.transports.get(qName);
        if (wSDDTransport != null) {
            return wSDDTransport.getInstance((EngineConfiguration)this);
        }
        return null;
    }

    public SOAPPort getPort(QName qName) throws ConfigurationException {
        WSDDPort wSDDPort = (WSDDPort)this.ports.get(qName);
        if (wSDDPort != null) {
            return (SOAPPort)wSDDPort.getInstance((EngineConfiguration)this);
        }
        return null;
    }

    public SOAPPort getPortByNamespaceURI(String string) throws ConfigurationException {
        WSDDPort wSDDPort = (WSDDPort)this.namespaceToPorts.get(string);
        if (wSDDPort != null) {
            return (SOAPPort)wSDDPort.getInstance((EngineConfiguration)this);
        }
        return null;
    }

    public TypeMapping getTypeMapping(String string) throws ConfigurationException {
        return (TypeMapping)this.getTypeMappingRegistry().getTypeMapping(string);
    }

    public TypeMappingRegistry getTypeMappingRegistry() throws ConfigurationException {
        if (!this.tmrDeployed) {
            for (int i = 0; i < this.typeMappings.size(); ++i) {
                WSDDTypeMapping wSDDTypeMapping = (WSDDTypeMapping)this.typeMappings.get(i);
                this.deployMapping(wSDDTypeMapping);
            }
            this.tmrDeployed = true;
        }
        return this.tmr;
    }

    public SimpleTargetedChain getGlobalHandler() throws ConfigurationException {
        if (this.globalConfig != null) {
            return (SimpleTargetedChain)this.globalConfig.getInstance((EngineConfiguration)this);
        }
        return null;
    }

    public Map getGlobalOptions() {
        return this.globalConfig == null ? null : this.globalConfig.getParametersTable();
    }

    public WSDDGlobalConfiguration getGlobalConfig() {
        return this.globalConfig;
    }

    public Iterator getDeployedPorts() throws ConfigurationException {
        ArrayList<PortDesc> arrayList = new ArrayList<PortDesc>();
        Iterator iterator = this.ports.values().iterator();
        while (iterator.hasNext()) {
            WSDDPort wSDDPort = (WSDDPort)iterator.next();
            try {
                SOAPPort sOAPPort = (SOAPPort)wSDDPort.makeNewInstance((EngineConfiguration)this);
                arrayList.add(sOAPPort.getPortDesc());
            }
            catch (WSDDNonFatalException wSDDNonFatalException) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Ignoring non-fatal exception: ", (Throwable)((Object)wSDDNonFatalException));
            }
        }
        return arrayList.iterator();
    }

    private void registerNamespaceForPort(String string, WSDDPort wSDDPort) {
        this.namespaceToPorts.put(string, wSDDPort);
    }

    private void removeNamespaceMapping(String string) {
        this.namespaceToPorts.remove(string);
    }

    public void setOwner(LifeCycleOwner lifeCycleOwner) throws LifeCycleException {
        this._lifeCycleSet.setOwner(lifeCycleOwner);
    }

    public LifeCycleOwner getOwner() {
        return this._lifeCycleSet.getOwner();
    }

    public final void init() throws LifeCycleException {
        this._lifeCycleSet.init();
    }

    public void _init() throws LifeCycleException {
        this._lifeCycleSet._init();
    }

    public final void destroy() {
        this._lifeCycleSet.destroy();
    }

    public void _destroy() {
        this._lifeCycleSet._destroy();
    }

    public int getState() {
        return this._lifeCycleSet.getState();
    }

    public boolean isActive() {
        return this._lifeCycleSet.isActive();
    }

    public void verifyActive() throws LifeCycleException {
        this._lifeCycleSet.verifyActive();
    }

    public void verifyInactive() throws LifeCycleException {
        this._lifeCycleSet.verifyInactive();
    }

    protected boolean manageLifeCycleOf(LifeCycleObject lifeCycleObject) {
        return this._lifeCycleSet.manageLifeCycleOf(lifeCycleObject);
    }

    protected boolean releaseLifeCycleManagementOf(LifeCycleObject lifeCycleObject) throws LifeCycleException {
        return this._lifeCycleSet.releaseLifeCycleManagementOf(lifeCycleObject);
    }
}

