/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine;

import com.ibm.websphere.webservices.soap.SOAPException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleException;
import com.ibm.ws.webservices.engine.orderedset.OperationException;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MCUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.DetailEntry;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFault;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class WebServicesFault
extends SOAPException {
    private static final String LS = JavaUtils.LS;
    protected static Log log = LogFactory.getLog(WebServicesFault.class.getName());
    protected QName faultCode;
    protected String faultString = "";
    protected String faultActor;
    protected Vector faultDetails;
    private boolean soapPartFault = false;
    protected ArrayList faultHeaders = null;
    protected Exception userException;

    public static WebServicesFault makeFault(Throwable throwable) {
        if (throwable == null) {
            InternalException internalException = new InternalException("WebServicesFault.makeFault(Throwable) called with null argument.");
            log.error(Messages.getMessage("internalError00"), internalException);
            return new WebServicesFault(internalException);
        }
        if (throwable instanceof WebServicesFault) {
            return (WebServicesFault)throwable;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Throwable throwable2 = WebServicesFault.getRootCause(throwable, stringBuffer);
        if (throwable2 == null) {
            throwable2 = throwable;
        }
        if (log.isDebugEnabled() && throwable2 != throwable) {
            log.debug("Unwrapping Exception: " + stringBuffer.toString(), throwable);
        }
        if (throwable2 instanceof WebServicesFault) {
            return (WebServicesFault)throwable2;
        }
        if (throwable2 instanceof SOAPFaultException) {
            return new WebServicesFault((SOAPFaultException)throwable2);
        }
        return new WebServicesFault(throwable2.toString(), throwable2);
    }

    public static WebServicesFault makeFault(String string, Throwable throwable) {
        if (string == null || string.trim().length() == 0) {
            return WebServicesFault.makeFault(throwable);
        }
        StringBuffer stringBuffer = new StringBuffer();
        throwable = WebServicesFault.getRootCause(throwable, stringBuffer);
        return new WebServicesFault(throwable.toString() + " " + string, throwable);
    }

    public static WebServicesFault makeUserFault(Exception exception, QName qName) {
        if (log.isDebugEnabled()) {
            log.debug("MakeUserFault: ", exception);
        }
        if (exception instanceof SOAPFaultException) {
            return new WebServicesFault((SOAPFaultException)exception);
        }
        WebServicesFault webServicesFault = new WebServicesFault(exception.toString(), exception);
        webServicesFault.userException = exception;
        if (qName != null) {
            webServicesFault.setFaultCode(qName);
        }
        return webServicesFault;
    }

    public WebServicesFault(String string, String string2, String string3, Element[] elementArray) {
        super(string2);
        this.setFaultCodeAsString(string);
        this.setFaultString(string2);
        this.setFaultActor(string3);
        this.setFaultDetail(elementArray);
    }

    public WebServicesFault(QName qName, String string, String string2, Element[] elementArray) {
        super(string);
        this.setFaultCode(qName);
        this.setFaultString(string);
        this.setFaultActor(string2);
        this.setFaultDetail(elementArray);
    }

    protected WebServicesFault(Exception exception) {
        super("", exception);
        this.setFaultCode(QNameTable.createQName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException"));
        this.setFaultString(exception.toString());
        this.initFromException(exception);
    }

    public WebServicesFault(String string) {
        super(string);
        this.setFaultCode(QNameTable.createQName("http://schemas.xmlsoap.org/soap/envelope/", "Server.generalException"));
        this.setFaultString(string);
    }

    public WebServicesFault() {
        this.setFaultCode(QNameTable.createQName("http://schemas.xmlsoap.org/soap/envelope/", "Server.generalException"));
        this.setFaultString(this.toString());
        this.initFromException(this);
    }

    public WebServicesFault(String string, Throwable throwable) {
        super(string, throwable);
        this.setFaultCode(QNameTable.createQName("http://schemas.xmlsoap.org/soap/envelope/", "Server.generalException"));
        this.setFaultString(string);
        this.initFromException(throwable);
    }

    public WebServicesFault(SOAPFaultException sOAPFaultException) {
        super(sOAPFaultException.getFaultString(), sOAPFaultException);
        this.setFaultCode(sOAPFaultException.getFaultCode());
        this.setFaultString(sOAPFaultException.getFaultString());
        this.setFaultActor(sOAPFaultException.getFaultActor());
        Detail detail = sOAPFaultException.getDetail();
        if (detail != null) {
            this.userException = sOAPFaultException;
            Iterator iterator = detail.getDetailEntries();
            if (iterator != null) {
                this.faultDetails = new Vector();
                while (iterator.hasNext()) {
                    DetailEntry detailEntry = (DetailEntry)iterator.next();
                    this.faultDetails.add(detailEntry);
                }
            }
        }
    }

    private void initFromException(Throwable throwable) {
        for (int i = 0; this.faultDetails != null && i < this.faultDetails.size(); ++i) {
            Element element = (Element)this.faultDetails.elementAt(i);
            if (!"stackTrace".equals(element.getLocalName())) continue;
            return;
        }
    }

    public void dump() {
        if (log.isDebugEnabled()) {
            log.debug(this.dumpToString());
        }
    }

    public String dumpToString() {
        String string = new String();
        if (this.faultDetails != null) {
            for (int i = 0; i < this.faultDetails.size(); ++i) {
                Element element = (Element)this.faultDetails.get(i);
                string = string + JavaUtils.LS + "\t" + element.getLocalName() + ": " + XMLUtils.getInnerXMLString(element);
            }
        }
        return "WebServicesFault" + JavaUtils.LS + " faultCode: " + this.faultCode + JavaUtils.LS + " faultString: " + this.faultString + JavaUtils.LS + " faultActor: " + this.faultActor + JavaUtils.LS + " faultDetail: " + string + JavaUtils.LS;
    }

    public void setFaultCode(QName qName) {
        boolean bl = false;
        bl = MCUtils.isPropertyEnabled("com.ibm.websphere.webservices.disableSerializeAnonToken");
        if (log.isDebugEnabled()) {
            log.debug(MCUtils.getSettingMsg("com.ibm.websphere.webservices.disableSerializeAnonToken", bl));
            if (bl) {
                log.debug("Will remove the anonymous complexType token from " + qName);
            }
        }
        if (qName != null && qName.getLocalPart().startsWith(">") && bl) {
            String string = "";
            String string2 = "";
            String string3 = "";
            string2 = qName.getLocalPart().substring(1);
            string = qName.getNamespaceURI();
            string3 = qName.getPrefix();
            if (string.length() > 0 && string2.length() > 0) {
                qName = new QName(string, string2, string3);
            } else if (string.length() == 0 && string2.length() > 0) {
                qName = new QName(string2);
            }
        }
        this.faultCode = qName;
    }

    public void setFaultCodeAsString(String string) {
        int n;
        if (string != null && string.startsWith("{") && (n = string.indexOf("}")) > 0) {
            String string2 = string.substring(1, n);
            String string3 = string.substring(n + 1);
            this.faultCode = QNameTable.createQName(string2, string3);
            return;
        }
        this.faultCode = QNameTable.createQName("", string);
    }

    public QName getFaultCode() {
        return this.faultCode;
    }

    public void setFaultString(String string) {
        this.faultString = string != null ? string : "";
    }

    public String getFaultString() {
        return this.faultString;
    }

    public void setFaultActor(String string) {
        this.faultActor = string;
    }

    public String getFaultActor() {
        return this.faultActor;
    }

    public void setFaultDetail(Element[] elementArray) {
        if (elementArray == null) {
            return;
        }
        this.faultDetails = new Vector(elementArray.length);
        for (int i = 0; i < elementArray.length; ++i) {
            this.faultDetails.add(elementArray[i]);
        }
    }

    public void setFaultDetailString(String string) {
        this.faultDetails = new Vector();
        try {
            Document document = XMLUtils.newDocument();
            Element element = document.createElement("string");
            Text text = document.createTextNode(string);
            element.appendChild(text);
            this.faultDetails.add(element);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            FFDCFilter.processException((Throwable)parserConfigurationException, "com.ibm.ws.webservices.engine.WebServicesFault.setFaultDetailString", "346", this);
            throw new InternalException(parserConfigurationException);
        }
    }

    public void addFaultDetailString(String string) {
        if (this.faultDetails == null) {
            this.faultDetails = new Vector();
        }
        try {
            Document document = XMLUtils.newDocument();
            Element element = document.createElement("string");
            Text text = document.createTextNode(string);
            element.appendChild(text);
            this.faultDetails.add(element);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            FFDCFilter.processException((Throwable)parserConfigurationException, "com.ibm.ws.webservices.engine.WebServicesFault.addFaultDetailString", "362", this);
            throw new InternalException(parserConfigurationException);
        }
    }

    public Element[] getFaultDetails() {
        if (this.faultDetails == null) {
            return null;
        }
        Element[] elementArray = new Element[this.faultDetails.size()];
        for (int i = 0; i < elementArray.length; ++i) {
            elementArray[i] = (Element)this.faultDetails.elementAt(i);
        }
        return elementArray;
    }

    public void output(SerializationContext serializationContext) throws Exception {
        SOAPFactory sOAPFactory = new SOAPFactory();
        SOAPEnvelope sOAPEnvelope = sOAPFactory.createSOAPEnvelope(true);
        SOAPFault sOAPFault = sOAPFactory.createSOAPFault();
        sOAPFault.setFault(this);
        sOAPEnvelope.getBody().addChildElement(sOAPFault);
        if (this.faultHeaders != null) {
            Iterator iterator = this.faultHeaders.iterator();
            while (iterator.hasNext()) {
                SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)iterator.next();
                sOAPEnvelope.getHeader().addChildElement(sOAPHeaderElement);
            }
        }
        sOAPEnvelope.output(serializationContext);
    }

    public String toString() {
        return this.faultString;
    }

    public void printStackTrace(PrintStream printStream) {
        printStream.println(this.dumpToString());
        super.printStackTrace(printStream);
    }

    public void printStackTrace(PrintWriter printWriter) {
        printWriter.println(this.dumpToString());
        super.printStackTrace(printWriter);
    }

    public void addHeader(SOAPHeaderElement sOAPHeaderElement) {
        if (this.faultHeaders == null) {
            this.faultHeaders = new ArrayList();
        }
        this.faultHeaders.add(sOAPHeaderElement);
    }

    public void clearHeaders() {
        this.faultHeaders = null;
    }

    public Exception getUserException() {
        return this.userException;
    }

    public Exception getApplicationException() {
        return this.getUserException();
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable throwable2 = null;
        if (throwable != null && !(throwable instanceof WebServicesFault) && (throwable2 = WebServicesFault.unwrapCause(throwable)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Unwrapping Throwable: ", throwable2);
            }
            throwable = WebServicesFault.getRootCause(throwable2);
        }
        return throwable;
    }

    public static Throwable getRootCause(Throwable throwable, StringBuffer stringBuffer) {
        Throwable throwable2 = null;
        if (throwable != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(LS);
            }
            if (throwable instanceof WebServicesFault) {
                stringBuffer.append(((WebServicesFault)throwable).getFaultString());
            } else {
                stringBuffer.append(throwable.toString());
                throwable2 = WebServicesFault.unwrapCause(throwable);
                if (throwable2 != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Unwrapping Throwable: ", throwable2);
                    }
                    throwable = WebServicesFault.getRootCause(throwable2, stringBuffer);
                }
            }
        }
        return throwable;
    }

    private static Throwable unwrapCause(Throwable throwable) {
        Throwable throwable2 = throwable instanceof InvocationTargetException ? ((InvocationTargetException)throwable).getTargetException() : (throwable instanceof JAXRPCException ? ((JAXRPCException)throwable).getLinkedCause() : (throwable instanceof SAXException ? ((SAXException)throwable).getException() : (throwable instanceof LifeCycleException || throwable instanceof ConfigurationException || throwable instanceof OperationException || throwable instanceof InternalException ? throwable.getCause() : null)));
        if (throwable2 == null && throwable.getCause() instanceof WebServicesFault) {
            throwable2 = throwable.getCause();
        }
        return throwable2;
    }

    public void setSOAPPartFault(boolean bl) {
        this.soapPartFault = bl;
    }

    public boolean isSOAPPartFault() {
        return this.soapPartFault;
    }

    public boolean isUserException() {
        return this.userException != null;
    }

    public boolean isApplicationException() {
        return this.isUserException();
    }

    public String getFaultReturnCode() {
        String string = this.getFaultString();
        if (string == null) {
            return null;
        }
        String string2 = null;
        int n = string.indexOf("(");
        int n2 = string.indexOf(")");
        string2 = string.substring(n + 1, n2).trim();
        return string2;
    }

    public String getFaultReason() {
        String string = this.getFaultString();
        if (string == null) {
            return null;
        }
        String string2 = null;
        int n = string.indexOf(")");
        string2 = string.substring(n + 1).trim();
        return string2;
    }

    public String getMessage() {
        Element[] elementArray = this.getFaultDetails();
        if (elementArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < elementArray.length; ++i) {
            stringBuffer.append(elementArray[i]);
        }
        return stringBuffer.toString();
    }
}

