/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wsbnd.DefaultEndpointURIPrefix;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.etools.webservice.wsbnd.WsbndFactory;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.wsspi.webservices.models.WSModels;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.webapplication.WebApp;

class WSBindingsFileAccessor {
    private static TraceComponent tc = Tr.register(WSBindingsFileAccessor.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private final EObject theModuleBeingSearched;
    private final String moduleName;
    private final AppDeploymentInfo appDeploymentInfo;
    private final AppDeploymentTask task;
    private final String JMS_TRANSPORT_NAME = "jms";
    private final String HTTP_TRANSPORT_NAME = "http";
    private static final int MODTYPE_NOT_INITIIAZLIED = 1;
    private static final int MODTYPE_WEB = 2;
    private static final int MODTYPE_EJB = 3;
    private int moduleType = 1;
    private WSBinding wsb = null;
    private String pathToWebservicesBndXmiFile = null;

    public WSBindingsFileAccessor(EObject eObject, String string, AppDeploymentTask appDeploymentTask, AppDeploymentInfo appDeploymentInfo) {
        this.theModuleBeingSearched = eObject;
        this.moduleName = string;
        this.task = appDeploymentTask;
        this.appDeploymentInfo = appDeploymentInfo;
    }

    public WSBindingsFileAccessor(ModuleFile moduleFile, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        this.theModuleBeingSearched = moduleFile;
        this.moduleName = moduleFile.getName();
        this.task = appDeploymentTask;
        this.appDeploymentInfo = null;
        if (moduleFile.isWARFile()) {
            this.pathToWebservicesBndXmiFile = "WEB-INF/ibm-webservices-bnd.xmi";
        } else if (moduleFile.isEJBJarFile()) {
            this.pathToWebservicesBndXmiFile = "META-INF/ibm-webservices-bnd.xmi";
        } else {
            String string = "Constructor: SHOULD NOT HAPPEN, the module must either be an EJB or WAR module";
            Tr.error(tc, "WSWS0020E", string);
            throw new AppDeploymentException(string, null);
        }
        try {
            this.wsb = WSModels.getWSBinding(moduleFile.getLoadStrategy(), this.pathToWebservicesBndXmiFile);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.deploy.WSBindingsFileAccessor.getRouterModuleNames", "129", this);
            Object[] objectArray = new Object[]{this.pathToWebservicesBndXmiFile, moduleFile.getName(), exception};
            String string = MessageFormat.format(util.getMessage(appDeploymentTask, "WSWS0011E"), objectArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "constructor: " + string);
            }
            Tr.error(tc, "WSWS0011E", objectArray);
            throw new AppDeploymentException(string, exception);
        }
    }

    String[] getRouterModuleNames() throws AppDeploymentException {
        Object object;
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRouterModuleNames: moduleName=" + this.moduleName);
        }
        String[] stringArray = new String[]{null, null};
        Boolean bl2 = (Boolean)this.task.getAppDeploymentController().getAppOptions().get("enableEndpoint");
        boolean bl3 = bl2 == null ? true : (bl = bl2 == false);
        if (bl) {
            if (this.wsb != null) {
                object = this.wsb.getRouterModules();
                if (object.size() != 0) {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        RouterModule routerModule = (RouterModule)iterator.next();
                        String string = null;
                        if (routerModule != null && (string = routerModule.getName()) != null) {
                            if (routerModule.getTransport().equals("http")) {
                                stringArray[0] = string;
                            } else if (routerModule.getTransport().equals("jms")) {
                                stringArray[1] = string;
                            } else {
                                Object[] objectArray = new Object[]{this.moduleName, routerModule.getTransport()};
                                String string2 = MessageFormat.format(util.getMessage(this.task, "WSWS0042E"), objectArray);
                                Tr.error(tc, "WSWS0042E", objectArray);
                                throw new AppDeploymentException(string2, null);
                            }
                        }
                        if (routerModule != null && string != null && (stringArray[0] != null || stringArray[1] != null)) continue;
                        Object[] objectArray = new Object[]{this.pathToWebservicesBndXmiFile, this.moduleName};
                        String string3 = MessageFormat.format(util.getMessage(this.task, "WSWS0023E"), objectArray);
                        Tr.error(tc, "WSWS0023E", objectArray);
                        throw new AppDeploymentException(string3, null);
                    }
                }
            } else {
                Object[] objectArray = new Object[]{this.moduleName, this.pathToWebservicesBndXmiFile};
                String string = MessageFormat.format(util.getMessage(this.task, "WSWS0018E"), objectArray);
                Tr.error(tc, "WSWS0018E", objectArray);
                throw new AppDeploymentException(string, null);
            }
        }
        if (tc.isEntryEnabled()) {
            object = "";
            for (int i = 0; i < stringArray.length; ++i) {
                object = (String)object + stringArray[0] + " ";
            }
            Tr.exit(tc, "getRouterModuleNames: returning routerModuleNames=" + (String)object);
        }
        return stringArray;
    }

    public void setDefaultURLInfo(Map map) throws AppDeploymentException {
        Object object;
        Object object2;
        Object object3;
        if (tc.isDebugEnabled()) {
            object3 = new StringBuffer();
            ((StringBuffer)object3).append("setDefaultURLInfo(), the map being set contains:\n");
            object2 = map.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                ((StringBuffer)object3).append("\t protocol=").append((String)object);
                ((StringBuffer)object3).append(" url=").append(map.get(object));
            }
            object2 = ((StringBuffer)object3).toString();
            Tr.debug(tc, (String)object2);
        }
        if (this.wsb == null) {
            Tr.error(tc, "WSWS0018E", new Object[]{this.moduleName, "ibm-webservices-bnd.xmi"});
        } else {
            object3 = this.wsb.getWsdescBindings();
            if (object3.size() > 0) {
                Object object4;
                object2 = (WSDescBinding)object3.get(0);
                object = object2.getDefaultEndpointURIPrefixes();
                WsbndFactory wsbndFactory = WsbndFactory.eINSTANCE;
                while (object.size() < 3) {
                    object4 = wsbndFactory.createDefaultEndpointURIPrefix();
                    object4.setText("");
                    object.add(object4);
                }
                object4 = map.keySet().iterator();
                while (object4.hasNext()) {
                    DefaultEndpointURIPrefix defaultEndpointURIPrefix;
                    String string = (String)object4.next();
                    if (string.equals("HTTP")) {
                        defaultEndpointURIPrefix = (DefaultEndpointURIPrefix)object.get(0);
                        defaultEndpointURIPrefix.setText((String)map.get(string));
                        continue;
                    }
                    if (string.equals("JMS")) {
                        defaultEndpointURIPrefix = (DefaultEndpointURIPrefix)object.get(1);
                        defaultEndpointURIPrefix.setText((String)map.get(string));
                        continue;
                    }
                    if (!string.equals("EJB")) continue;
                    defaultEndpointURIPrefix = (DefaultEndpointURIPrefix)object.get(2);
                    defaultEndpointURIPrefix.setText((String)map.get(string));
                }
            }
        }
    }

    public Map getDefaultURLInfo() throws AppDeploymentException {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultURLInfo", this);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.wsb == null) {
            Tr.error(tc, "WSWS0018E", new Object[]{this.moduleName, "ibm-webservices-bnd.xmi"});
        } else {
            object3 = this.wsb.getWsdescBindings();
            if (object3.size() > 0) {
                String string;
                DefaultEndpointURIPrefix defaultEndpointURIPrefix;
                object2 = (WSDescBinding)object3.get(0);
                object = object2.getDefaultEndpointURIPrefixes();
                if (object.size() > 1) {
                    defaultEndpointURIPrefix = (DefaultEndpointURIPrefix)object.get(0);
                    string = defaultEndpointURIPrefix.getText();
                    hashMap.put("HTTP", string);
                } else {
                    hashMap.put("HTTP", "");
                }
                if (object.size() > 2) {
                    defaultEndpointURIPrefix = (DefaultEndpointURIPrefix)object.get(1);
                    string = defaultEndpointURIPrefix.getText();
                    hashMap.put("JMS", string);
                } else {
                    hashMap.put("JMS", "");
                }
                if (object.size() > 3) {
                    defaultEndpointURIPrefix = (DefaultEndpointURIPrefix)object.get(2);
                    string = defaultEndpointURIPrefix.getText();
                    hashMap.put("EJB", string);
                } else {
                    hashMap.put("EJB", "");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            object3 = new StringBuffer();
            ((StringBuffer)object3).append("getDefaultURLInfo(), the map being returned contains:\n");
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                ((StringBuffer)object3).append("\t protocol=").append((String)object);
                ((StringBuffer)object3).append(" url=").append(hashMap.get(object)).append("\n");
            }
            object2 = ((StringBuffer)object3).toString();
            Tr.debug(tc, (String)object2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultURLInfo");
        }
        return hashMap;
    }

    public ClientBinding getClientBinding() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientBinding: moduleName=" + this.moduleName);
        }
        if (this.appDeploymentInfo == null) {
            if (tc.isEntryEnabled()) {
                Tr.error(tc, "internal.error", null);
            }
            return null;
        }
        Vector vector = new Vector();
        EObject eObject = DeployUtils.convertURIToRefObject(this.moduleName, this.appDeploymentInfo);
        String string = null;
        string = this.isWebType(eObject) ? "WEB-INF/ibm-webservicesclient-bnd.xmi" : "META-INF/ibm-webservicesclient-bnd.xmi";
        ModuleFile moduleFile = this.appDeploymentInfo.getModuleFileForDD(this.theModuleBeingSearched);
        ClientBinding clientBinding = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "Open client binding for module=" + this.moduleName + ", using path: " + string);
            }
            clientBinding = WSModels.getWSClientBinding(moduleFile.getLoadStrategy(), string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.deploy.WSBindingsFileAccessor.getRouterModuleNames", "129", this);
            Object[] objectArray = new Object[]{string, util.formUriString(this.appDeploymentInfo, eObject), exception};
            String string2 = MessageFormat.format(util.getMessage(this.task, "WSWS0011E"), objectArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "constructor: " + string2);
            }
            Tr.error(tc, "WSWS0011E", objectArray);
            throw new AppDeploymentException(string2, exception);
        }
        if (clientBinding != null && tc.isEntryEnabled()) {
            Tr.debug(tc, "Opened client bind file: " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientBinding: moduleName=" + this.moduleName);
        }
        return clientBinding;
    }

    public Vector getServerBindServices() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerBindServices: moduleName=" + this.moduleName);
        }
        if (this.appDeploymentInfo == null) {
            if (tc.isEntryEnabled()) {
                Tr.error(tc, "internal.error", null);
            }
            return null;
        }
        Vector vector = new Vector();
        EObject eObject = DeployUtils.convertURIToRefObject(this.moduleName, this.appDeploymentInfo);
        String string = null;
        string = this.isWebType(eObject) ? "WEB-INF/ibm-webservices-bnd.xmi" : "META-INF/ibm-webservices-bnd.xmi";
        ModuleFile moduleFile = this.appDeploymentInfo.getModuleFileForDD(this.theModuleBeingSearched);
        WSBinding wSBinding = null;
        try {
            wSBinding = WSModels.getWSBinding(moduleFile.getLoadStrategy(), string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.deploy.WSBindingsFileAccessor.getClientBinding", "318", this);
            Object[] objectArray = new Object[]{string, util.formUriString(this.appDeploymentInfo, eObject), exception};
            String string2 = MessageFormat.format(util.getMessage(this.task, "WSWS0011E"), objectArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "constructor: " + string2);
            }
            Tr.error(tc, "WSWS0011E", objectArray);
            throw new AppDeploymentException(string2, exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerBindServices: moduleName=" + this.moduleName);
        }
        return vector;
    }

    public boolean isWebType(EObject eObject) throws AppDeploymentException {
        if (this.moduleType == 1) {
            if (this.appDeploymentInfo == null) {
                String string = "isWebType: appDeploymentInfo is null";
                if (tc.isEntryEnabled()) {
                    Tr.error(tc, "WSWS0020E", string);
                }
                throw new AppDeploymentException(string, null);
            }
            if (eObject == null) {
                eObject = DeployUtils.convertURIToRefObject(this.moduleName, this.appDeploymentInfo);
            }
            if (eObject instanceof WebApp) {
                this.moduleType = 2;
            } else if (eObject instanceof EJBJar) {
                this.moduleType = 3;
            } else {
                String string = "Constructor: SHOULD NOT HAPPEN, the module must either be an EJB or WAR module";
                Tr.error(tc, "WSWS0020E", string);
                throw new AppDeploymentException(string, null);
            }
        }
        return this.moduleType == 2;
    }

    public WSBinding getServerBinding() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerBinding: moduleName=" + this.moduleName);
        }
        if (this.appDeploymentInfo == null) {
            if (tc.isEntryEnabled()) {
                Tr.error(tc, "internal.error", null);
            }
            return null;
        }
        Vector vector = new Vector();
        EObject eObject = DeployUtils.convertURIToRefObject(this.moduleName, this.appDeploymentInfo);
        String string = null;
        string = this.isWebType(eObject) ? "WEB-INF/ibm-webservices-bnd.xmi" : "META-INF/ibm-webservices-bnd.xmi";
        ModuleFile moduleFile = this.appDeploymentInfo.getModuleFileForDD(this.theModuleBeingSearched);
        WSBinding wSBinding = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "Open server binding for module=" + this.moduleName + ", using path: " + string);
            }
            wSBinding = WSModels.getWSBinding(moduleFile.getLoadStrategy(), string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.deploy.WSBindingsFileAccessor.getServerBinding", "405", this);
            Object[] objectArray = new Object[]{string, util.formUriString(this.appDeploymentInfo, eObject), exception};
            String string2 = MessageFormat.format(util.getMessage(this.task, "WSWS0011E"), objectArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "constructor: " + string2);
            }
            Tr.error(tc, "WSWS0011E", objectArray);
            throw new AppDeploymentException(string2, exception);
        }
        if (wSBinding != null && tc.isEntryEnabled()) {
            Tr.debug(tc, "Opened server bind file: " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerBinding: moduleName=" + this.moduleName);
        }
        return wSBinding;
    }
}

