/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ThreadPool;
import java.io.Serializable;

public class WSThreadLocal
extends ThreadLocal {
    private static TraceComponent tc = Tr.register(WSThreadLocal.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private static int count = 0;
    private int index;
    private static final int SUSPECTED_MISUSAGE_THRESHOLD = 200;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSThreadLocal() {
        Serializable serializable = this.getClass();
        synchronized (serializable) {
            this.index = count++;
        }
        if (count % 200 == 0) {
            serializable = new Exception("WSThreadLocal: instance count = " + count + " ; potential memory leak; verify usage.");
            FFDCFilter.processException(serializable, this.getClass().getName(), "50", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSThreadLocal", serializable);
            }
        }
    }

    public Object get() {
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof ThreadPool.Worker) {
            Object[] objectArray = this.getThreadLocals((ThreadPool.Worker)thread2);
            if (objectArray[this.index] == null) {
                objectArray[this.index] = this.initialValue();
            }
            return objectArray[this.index];
        }
        return super.get();
    }

    public void set(Object object) {
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof ThreadPool.Worker) {
            Object[] objectArray = this.getThreadLocals((ThreadPool.Worker)thread2);
            objectArray[this.index] = object;
        } else {
            super.set(object);
        }
    }

    private Object[] getThreadLocals(ThreadPool.Worker worker) {
        Object[] objectArray = worker.wsThreadLocals;
        int n = count;
        if (objectArray.length != n) {
            Object[] objectArray2 = new Object[n];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray = objectArray2;
            worker.wsThreadLocals = objectArray;
        }
        return objectArray;
    }
}

