/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import javax.management.AttributeList;

public class SchedulerCommandHelper {
    private static final TraceComponent tc = Tr.register(SchedulerCommandHelper.class, "SSL", "com.ibm.ws.ssl.resources.ssl");

    public Date getNextStartDate(String string) throws KeyException {
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getNextStartDate", string);
            }
            if (string == null) {
                throw new KeyException("Schedule name parameter is null.");
            }
            try {
                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                Session session = new Session();
                AdminCommand adminCommand = commandMgr.createCommand("getWSSchedule");
                adminCommand.setConfigSession(session);
                adminCommand.setParameter(CommandConstants.NAME, string);
                adminCommand.execute();
                CommandResult commandResult = adminCommand.getCommandResult();
                if (commandResult.isSuccessful()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found schedule name: " + string);
                    }
                    AttributeList attributeList = (AttributeList)commandResult.getResult();
                    Long l = null;
                    if (attributeList != null) {
                        l = (Long)ConfigServiceHelper.getAttributeValue(attributeList, CommandConstants.NEXT_START_DATE);
                        if (l != null && l > 0L) {
                            Date date = new Date(l);
                            if (tc.isEntryEnabled()) {
                                Tr.entry(tc, "getNextStartDate (success) -> ", date);
                            }
                            return date;
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "getNextStartDate (failure) -> null");
                        }
                        return null;
                    }
                    break block13;
                }
                throw new KeyException(commandResult.getException().getMessage(), (Exception)commandResult.getException());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.ssl.utils.SchedulerCommandHelper.getNextStartDate", "108");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getNextStartDate did not execute.", new Object[]{exception});
                }
                if (exception instanceof KeyException) {
                    throw (KeyException)exception;
                }
                throw new KeyException(exception.getMessage(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextStartDate");
        }
        return null;
    }

    public void updateNextStartDate(String string, Long l) throws KeyException {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "updateNextStartDate", new Object[]{string, l});
            }
            if (string == null) {
                throw new KeyException("Schedule name parameter is null.");
            }
            if (l == null) {
                throw new KeyException("New start date parameter is null.");
            }
            try {
                StartCommand startCommand = new StartCommand(string, l);
                Class<?> clazz = Class.forName("com.ibm.ws.security.core.ContextManagerFactory");
                Method method2 = clazz.getMethod("getInstance", null);
                Object object = method2.invoke(null, null);
                Class<?> clazz2 = Class.forName("com.ibm.ws.security.core.ContextManager");
                Method method3 = clazz2.getMethod("runAsSystem", PrivilegedExceptionAction.class);
                method3.invoke(object, startCommand);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.utils.SchedulerCommandHelper.updateNextStartDate", "162", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "updateNextStartDate did not execute.", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateNextStartDate");
        }
    }

    static /* synthetic */ TraceComponent access$000() {
        return tc;
    }

    private class StartCommand
    implements PrivilegedExceptionAction {
        private String name = null;
        private Long date = null;

        public StartCommand(String string, Long l) {
            this.name = string;
            this.date = l;
        }

        /*
         * Unable to fully structure code
         */
        public Object run() throws Exception {
            var1_1 = null;
            var2_2 = null;
            try {
                var3_3 = CommandMgr.getCommandMgr();
                var2_2 = new Session();
                var4_5 = var3_3.createCommand("getWSSchedule");
                var4_5.setConfigSession(var2_2);
                var4_5.setParameter(CommandConstants.NAME, this.name);
                var4_5.execute();
                var5_6 = var4_5.getCommandResult();
                if (!var5_6.isSuccessful()) ** GOTO lbl45
                if (SchedulerCommandHelper.access$000().isDebugEnabled()) {
                    Tr.debug(SchedulerCommandHelper.access$000(), "Found schedule name: " + this.name);
                }
                if ((var6_7 = (AttributeList)var5_6.getResult()) == null) ** GOTO lbl42
                var7_8 = (String)ConfigServiceHelper.getAttributeValue(var6_7, CommandConstants.NAME);
                var8_9 = (Integer)ConfigServiceHelper.getAttributeValue(var6_7, CommandConstants.FREQUENCY);
                var9_10 = (Integer)ConfigServiceHelper.getAttributeValue(var6_7, CommandConstants.DAY_OF_WEEK);
                var10_11 = (Integer)ConfigServiceHelper.getAttributeValue(var6_7, CommandConstants.HOUR);
                var11_12 = (Integer)ConfigServiceHelper.getAttributeValue(var6_7, CommandConstants.MINUTE);
                var12_13 = var3_3.createCommand("modifyWSSchedule");
                var12_13.setConfigSession(var2_2);
                var12_13.setParameter(CommandConstants.NAME, var7_8);
                var12_13.setParameter(CommandConstants.FREQUENCY, var8_9);
                if (var9_10 > 0) {
                    var12_13.setParameter(CommandConstants.DAY_OF_WEEK, var9_10);
                }
                var12_13.setParameter(CommandConstants.HOUR, var10_11);
                var12_13.setParameter(CommandConstants.MINUTE, var11_12);
                var12_13.setParameter(CommandConstants.NEXT_START_DATE, this.date);
                var12_13.execute();
                var13_14 = var12_13.getCommandResult();
                if (var13_14.isSuccessful()) {
                    var1_1 = ConfigServiceFactory.getConfigService();
                    var1_1.save(var2_2, true);
                    if (SchedulerCommandHelper.access$000().isEntryEnabled()) {
                        Tr.exit(SchedulerCommandHelper.access$000(), "updateNextStartDate (success)");
                    }
                    var14_15 = null;
                    return var14_15;
                }
                try {
                    if (SchedulerCommandHelper.access$000().isEntryEnabled()) {
                        Tr.exit(SchedulerCommandHelper.access$000(), "updateNextStartDate (exception)");
                    }
                    throw new KeyException(var13_14.getException().getMessage(), (Exception)var13_14.getException());
lbl42:
                    // 1 sources

                    if (SchedulerCommandHelper.access$000().isEntryEnabled()) {
                        Tr.exit(SchedulerCommandHelper.access$000(), "updateNextStartDate (exception)");
                    }
                    throw new KeyException("Could not get wsSchedule from schedule name: " + this.name);
lbl45:
                    // 1 sources

                    if (SchedulerCommandHelper.access$000().isEntryEnabled()) {
                        Tr.exit(SchedulerCommandHelper.access$000(), "updateNextStartDate (exception)");
                    }
                    throw new KeyException(var5_6.getException().getMessage(), (Exception)var5_6.getException());
                }
                catch (Exception var3_4) {
                    FFDCFilter.processException(var3_4, "com.ibm.ws.ssl.utils.SchedulerCommandHelper.updateNextStartDate", "247");
                    if (SchedulerCommandHelper.access$000().isDebugEnabled()) {
                        Tr.debug(SchedulerCommandHelper.access$000(), "updateNextStartDate did not execute.", new Object[]{var3_4});
                    }
                    if (var3_4 instanceof KeyException) {
                        throw (KeyException)var3_4;
                    }
                    throw new KeyException(var3_4.getMessage(), var3_4);
                }
            }
            finally {
                if (var1_1 != null && var2_2 != null) {
                    var1_1.discard(var2_2);
                }
            }
        }
    }
}

