/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.utils;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ThreadManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.wsspi.profile.WSProfile;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class RetrieveSigners {
    private static final String DEFAULT_TRACE_FILE = "retrieveSigners.log";
    private static final String DEFAULT_CONNECTOR_TYPE_PROP = "com.ibm.ws.scripting.connectionType";
    private static final String DEFAULT_SCRIPTING_PORT_PROP = "com.ibm.ws.scripting.port";
    private static final String DEFAULT_SCRIPTING_HOST_PROP = "com.ibm.ws.scripting.host";
    private static final String[] ARG_LIST = new String[]{"-profileName", "-help", "-replacelog", "-logfile", "-quiet", "-trace", "-password", "-user", "-username", "-conntype", "-port", "-host", "-localAlias", "-remoteAlias", "-upload", "-listLocalKeyStoreNames", "-listRemoteKeyStoreNames", "-autoAcceptBootstrapSigner", "-uploadSigners"};
    private static final String DEFAULT_APPCLIENT_CONNECTOR_TYPE_PROP = "SOAP";
    public static final int MAX_MSG_LEN = 79;
    public static final String INDENT = "           ";
    boolean trace = false;
    boolean replacelog = false;
    boolean quiet = false;
    boolean help = false;
    boolean upload = false;
    String remoteKeyStoreName = null;
    String remoteAlias = null;
    String localAlias = null;
    String localKeyStoreName = null;
    boolean listRemoteKeyStoreNames = false;
    boolean listLocalKeyStoreNames = false;
    Properties props = new Properties();
    String logfile = null;
    boolean isDoubleByteSystem = false;
    String profileName = null;
    String userRoot = null;
    private static final TraceComponent tc = Tr.register(RetrieveSigners.class, "SSL", "com.ibm.ws.ssl.resources.ssl");

    public static int mainForInProcess(String[] stringArray) {
        return new RetrieveSigners().retrieveSigners(stringArray);
    }

    public static void main(String[] stringArray) {
        System.exit(new RetrieveSigners().retrieveSigners(stringArray));
    }

    private int retrieveSigners(String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveSigners");
        }
        AdminClient adminClient = null;
        ObjectName objectName = null;
        try {
            adminClient = this.createAdminClient(stringArray);
            if (this.upload) {
                return this.uploadSigners(adminClient);
            }
            if (adminClient != null) {
                String string = this.getProcessName(adminClient);
                ObjectName objectName2 = new ObjectName("WebSphere:type=SSLAdmin,process=" + string + ",*");
                Set set = adminClient.queryNames(objectName2, null);
                if (set.isEmpty()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "retrieveSigners (can't get SSLAdmin)");
                    }
                    return 1;
                }
                objectName = (ObjectName)set.iterator().next();
                HashMap hashMap = null;
                if (this.listRemoteKeyStoreNames || this.listLocalKeyStoreNames) {
                    int n;
                    StringBuffer stringBuffer;
                    String[] stringArray2;
                    if (this.listRemoteKeyStoreNames) {
                        hashMap = (HashMap)adminClient.invoke(objectName, "retrieveSigners", new Object[]{null, null}, new String[]{"java.lang.String", "java.lang.String"});
                        stringArray2 = (String[])hashMap.get("remoteAliases");
                        stringBuffer = new StringBuffer();
                        if (stringArray2 != null) {
                            for (n = 0; n < stringArray2.length; ++n) {
                                stringBuffer.append(stringArray2[n]);
                                if (n >= stringArray2.length - 1) continue;
                                stringBuffer.append(", ");
                            }
                        }
                        this.issueMessage("ssl.signer.remote.truststore.list.CWPKI0306I", new Object[]{stringBuffer.toString()}, "The following remote keystores exist on the specified server: " + stringBuffer.toString());
                    }
                    if (this.listLocalKeyStoreNames && (stringArray2 = KeyStoreManager.getInstance().getKeyStoreAliases()) != null) {
                        stringBuffer = new StringBuffer();
                        for (n = 0; n < stringArray2.length; ++n) {
                            stringBuffer.append(stringArray2[n]);
                            stringBuffer.append(", ");
                        }
                        String string2 = stringBuffer.toString();
                        if (string2.endsWith(", ")) {
                            string2 = string2.substring(0, string2.length() - 2);
                        }
                        this.issueMessage("ssl.signer.local.truststore.list.CWPKI0307I", new Object[]{string2}, "The following local keystores exist on the client: " + string2);
                    }
                    return 0;
                }
                hashMap = (HashMap)adminClient.invoke(objectName, "retrieveSigners", new Object[]{this.remoteKeyStoreName, this.remoteAlias}, new String[]{"java.lang.String", "java.lang.String"});
                if (hashMap != null) {
                    WSKeyStore wSKeyStore = KeyStoreManager.getInstance().getKeyStore(this.localKeyStoreName);
                    if (wSKeyStore != null) {
                        boolean bl = false;
                        String string3 = wSKeyStore.getProperty("com.ibm.ssl.keyStore");
                        KeyStore keyStore = wSKeyStore.getKeyStore(false, false);
                        if (keyStore != null) {
                            Iterator iterator = hashMap.keySet().iterator();
                            while (iterator.hasNext()) {
                                String string4 = (String)iterator.next();
                                Certificate certificate = (Certificate)hashMap.get(string4);
                                if (certificate == null) continue;
                                boolean bl2 = KeyStoreManager.getInstance().checkIfSignerAlreadyExistsInTrustStore((X509Certificate)certificate, keyStore);
                                if (!bl2 && !keyStore.containsAlias(string4)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding alias \"" + string4 + "\" to keystore \"" + string3 + "\".");
                                    }
                                    keyStore.setCertificateEntry(string4, certificate);
                                    String string5 = KeyStoreManager.getInstance().generateDigest("SHA", (X509Certificate)certificate);
                                    this.issueMessage("ssl.signer.add.to.local.truststore.CWPKI0308I", new Object[]{string4, this.localKeyStoreName, string5}, "CWPKI0308I: Adding signer alias \"" + string4 + "\" to local keystore \"" + this.localKeyStoreName + "\" with the following SHA digest: " + string5);
                                    bl = true;
                                    continue;
                                }
                                if (bl2) continue;
                                int n = 1;
                                String string6 = null;
                                while (keyStore.containsAlias(string6 = string4 + "_" + n++)) {
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Adding alias \"" + string6 + "\" to keystore \"" + string3 + "\".");
                                }
                                if (keyStore.containsAlias(string6)) continue;
                                keyStore.setCertificateEntry(string6, certificate);
                                String string7 = KeyStoreManager.getInstance().generateDigest("SHA", (X509Certificate)certificate);
                                this.issueMessage("ssl.signer.add.to.local.truststore.CWPKI0308I", new Object[]{string6, this.localKeyStoreName, string7}, "CWPKI0308I: Adding signer alias \"" + string6 + "\" to local keystore \"" + this.localKeyStoreName + "\" with the following SHA digest: " + string7);
                                bl = true;
                            }
                            if (bl) {
                                wSKeyStore.store();
                            } else {
                                this.issueMessage("ssl.signer.no.signers.added.CWPKI0309I", "CWPKI0309I: All signers from remote keystore already exist in local keystore.");
                            }
                        }
                    } else {
                        this.issueMessage("ssl.signer.local.truststore.not.found.CWPKI0310E", new Object[]{this.localKeyStoreName}, "CWPKI0310E: The <localKeyStoreName> specified as \"" + this.localKeyStoreName + "\" was not found on the client.");
                    }
                    return 0;
                }
            }
            return 0;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting admin client connection.", new Object[]{malformedObjectNameException});
            }
            FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.ssl.utils.RetrieveSigners.retrieveSigners", "280", this);
            this.issueMessage("ssl.signer.general.error.CWPKI0314E", new Object[]{malformedObjectNameException.getMessage()}, "CWPKI0314E: The following error is returned from an exception: " + malformedObjectNameException.getMessage());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting admin client connection.", new Object[]{instanceNotFoundException});
            }
            FFDCFilter.processException((Throwable)instanceNotFoundException, "com.ibm.ws.ssl.utils.RetrieveSigners.retrieveSigners", "286", this);
            this.issueMessage("ssl.signer.general.error.CWPKI0314E", new Object[]{instanceNotFoundException.getMessage()}, "CWPKI0314E: The following error is returned from an exception: " + instanceNotFoundException.getMessage());
        }
        catch (MBeanException mBeanException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting admin client connection.", new Object[]{mBeanException});
            }
            FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.ssl.utils.RetrieveSigners.retrieveSigners", "287", this);
            String string = mBeanException.getCause().toString();
            this.issueMessage("ssl.signer.general.error.CWPKI0314E", new Object[]{mBeanException.getMessage() + "\n" + string.substring(string.indexOf("CWP"))}, "CWPKI0314E: The following error is returned from an exception: " + mBeanException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting admin client connection.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.utils.RetrieveSigners.retrieveSigners", "292", this);
            this.issueMessage("ssl.signer.general.error.CWPKI0314E", new Object[]{exception.getMessage()}, "CWPKI0314E: The following error is returned from an exception: " + exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveSigners");
        }
        return 3;
    }

    private int uploadSigners(AdminClient adminClient) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uploadSigners");
        }
        ObjectName objectName = null;
        try {
            if (adminClient != null) {
                KeyStore keyStore;
                String string = this.getProcessName(adminClient);
                ObjectName objectName2 = new ObjectName("WebSphere:type=SSLAdmin,process=" + string + ",*");
                Set set = adminClient.queryNames(objectName2, null);
                if (set.isEmpty()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "uploadSigners (can't get SSLAdmin)");
                    }
                    return 1;
                }
                objectName = (ObjectName)set.iterator().next();
                WSKeyStore wSKeyStore = KeyStoreManager.getInstance().getKeyStore(this.localKeyStoreName);
                if (wSKeyStore != null && (keyStore = wSKeyStore.getKeyStore(false, false)) != null) {
                    Enumeration<String> enumeration = keyStore.aliases();
                    while (enumeration.hasMoreElements()) {
                        String string2 = enumeration.nextElement();
                        Certificate certificate = keyStore.getCertificate(string2);
                        if (certificate == null) continue;
                        Object[] objectArray = new Object[]{string2, certificate};
                        adminClient.invoke(objectName, "invokeRemoteKeyStoreCommand", new Object[]{this.remoteKeyStoreName, "setCertificateEntry", objectArray}, new String[]{"java.lang.String", "java.lang.String", "[Ljava.lang.Object;"});
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "uploadSigners (success)");
                    }
                    return 0;
                }
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting admin client connection.", new Object[]{malformedObjectNameException});
            }
            FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.ssl.utils.RetrieveSigners.retrieveSigners", "372", this);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting admin client connection.", new Object[]{instanceNotFoundException});
            }
            FFDCFilter.processException((Throwable)instanceNotFoundException, "com.ibm.ws.ssl.utils.RetrieveSigners.retrieveSigners", "377", this);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting admin client connection.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.utils.RetrieveSigners.retrieveSigners", "382", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uploadSigners");
        }
        return 3;
    }

    private AdminClient createAdminClient(String[] stringArray) throws Exception {
        int n;
        List<String> list = Arrays.asList(ARG_LIST);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] != null && (!stringArray[n].startsWith("-") || list.contains(stringArray[n]) && (n + 1 == stringArray.length || n + 1 < stringArray.length && stringArray[n + 1] != null))) {
                arrayList.add(stringArray[n]);
                continue;
            }
            if (stringArray[n] == null || list.contains(stringArray[n])) continue;
            bl = true;
            this.issueMessage("ssl.signer.invalid.option.CWPKI0313W", new Object[]{stringArray[n]}, "CWPKI0313W: The following option is not valid: " + stringArray[n]);
        }
        if (bl) {
            this.issueMessage("ssl.signer.retrieval.usage.CWPKI0300I", null, "Usage: retrieveSigners <remoteKeyStoreName> <localKeyStoreName> [options]\n        options: [-profileName <profileName>] [-remoteAlias <aliasFromRemoteStore>] [-localAlias <storeAsAlias>] [-host <host>] [-port <port>] [-connType <RMI|SOAP>] [-user <user>] [-password <password>] [-trace] [-logfile <filename>] [-replacelog] [-quiet] [-help]\n");
        }
        if (arrayList != null) {
            n = 0;
            n = arrayList.indexOf("-profileName");
            if (n != -1) {
                this.profileName = (String)arrayList.get(n + 1);
                this.userRoot = this.getConfigRootForProfileName(this.profileName);
                if (this.userRoot == null) {
                    this.userRoot = System.getProperty("user.install.root");
                }
            } else {
                this.userRoot = System.getProperty("user.install.root");
            }
            if ((n = arrayList.indexOf("-autoAcceptBootstrapSigner")) != -1) {
                ThreadManager.getInstance().setAutoAcceptBootstrapSigner(true);
            }
            if ((n = arrayList.indexOf("-listRemoteKeyStoreNames")) != -1) {
                this.listRemoteKeyStoreNames = true;
            }
            if ((n = arrayList.indexOf("-listLocalKeyStoreNames")) != -1) {
                this.listLocalKeyStoreNames = true;
            }
            if ((n = arrayList.indexOf("-uploadSigners")) != -1) {
                this.upload = true;
            }
            if ((n = arrayList.indexOf("-upload")) != -1) {
                this.upload = true;
            }
            if ((n = arrayList.indexOf("-remoteAlias")) != -1) {
                this.remoteAlias = (String)arrayList.get(n + 1);
            }
            if ((n = arrayList.indexOf("-localAlias")) != -1) {
                this.localAlias = (String)arrayList.get(n + 1);
            }
            String string = "file:" + this.userRoot + "/properties/wsadmin.properties";
            Properties properties = null;
            properties = this.loadPropertiesFile(string);
            String string2 = "";
            String string3 = "";
            String string4 = "";
            if (properties != null) {
                string2 = properties.getProperty(DEFAULT_CONNECTOR_TYPE_PROP);
                string3 = properties.getProperty(DEFAULT_SCRIPTING_PORT_PROP);
                string4 = properties.getProperty(DEFAULT_SCRIPTING_HOST_PROP);
            }
            if ((n = arrayList.indexOf("-host")) != -1) {
                this.props.setProperty("host", (String)arrayList.get(n + 1));
            } else if (string4 != null && !string4.equals("")) {
                this.props.setProperty("host", string4);
            }
            n = arrayList.indexOf("-port");
            if (n != -1) {
                this.props.setProperty("port", (String)arrayList.get(n + 1));
            } else if (string3 != null && !string3.equals("")) {
                this.props.setProperty("port", string3);
            }
            n = arrayList.indexOf("-conntype");
            if (n != -1) {
                this.props.setProperty("type", (String)arrayList.get(n + 1));
            } else if (string2 != null && !string2.equals("")) {
                this.props.setProperty("type", string2);
            } else {
                this.props.setProperty("type", DEFAULT_APPCLIENT_CONNECTOR_TYPE_PROP);
            }
            n = arrayList.indexOf("-username");
            if (n != -1) {
                this.props.setProperty("username", (String)arrayList.get(n + 1));
            }
            if ((n = arrayList.indexOf("-user")) != -1) {
                this.props.setProperty("username", (String)arrayList.get(n + 1));
            }
            if ((n = arrayList.indexOf("-password")) != -1) {
                this.props.setProperty("password", (String)arrayList.get(n + 1));
            }
            if ((n = arrayList.indexOf("-trace")) != -1) {
                this.props.setProperty("-trace", "true");
                this.trace = true;
            }
            if ((n = arrayList.indexOf("-quiet")) != -1) {
                this.props.setProperty("-quiet", "true");
                this.quiet = true;
            }
            if ((n = arrayList.indexOf("-logfile")) != -1) {
                this.props.setProperty("-logfile", (String)arrayList.get(n + 1));
                this.logfile = (String)arrayList.get(n + 1);
            }
            if ((n = arrayList.indexOf("-replacelog")) != -1) {
                this.props.setProperty("-replacelog", "true");
                this.replacelog = true;
            }
            if ((n = arrayList.indexOf("-help")) != -1) {
                this.props.setProperty("help", "true");
                this.help = true;
            }
        }
        if (this.help) {
            this.issueMessage("ssl.signer.retrieval.usage.CWPKI0300I", null, "Usage: retrieveSigners <remoteKeyStoreName> <localKeyStoreName> [options]\n        options: [-profileName <profileName>] [-remoteAlias <aliasFromRemoteStore>] [-localAlias <storeAsAlias>] [-host <host>] [-port <port>] [-connType <RMI|SOAP>] [-user <user>] [-password <password>] [-trace] [-logfile <filename>] [-replacelog] [-quiet] [-help]\n");
            return null;
        }
        if (this.props.getProperty("-trace") != null && (n = (int)(this.setTrace() ? 1 : 0)) != 0) {
            this.issueMessage("ssl.signer.retrieval.tracemodeon.CWPKI0301I", null, "Trace mode is on.");
        }
        if (stringArray.length >= 2 || this.help || this.listRemoteKeyStoreNames || this.listLocalKeyStoreNames) {
            if (this.help) {
                this.issueMessage("ssl.signer.retrieval.usage.CWPKI0300I", null, "Usage: retrieveSigners <remoteKeyStoreName> <localKeyStoreName> [options]\n        options: [-profileName <profileName] [-remoteAlias <aliasFromRemoteStore>] [-localAlias <storeAsAlias>] [-host <host>] [-port <port>] [-connType <RMI|SOAP>] [-user <user>] [-password <password>] [-trace] [-logfile <filename>] [-replacelog] [-quiet] [-help]\n");
                return null;
            }
            if (stringArray.length >= 2 && stringArray[0] != null && !stringArray[0].startsWith("-")) {
                this.remoteKeyStoreName = stringArray[0];
                this.localKeyStoreName = stringArray[1];
            } else {
                this.remoteKeyStoreName = "CellDefaultTrustStore";
                this.localKeyStoreName = "ClientDefaultTrustStore";
            }
        } else {
            this.issueMessage("ssl.signer.retrieval.usage.CWPKI0300I", null, "Usage: retrieveSigners <remoteKeyStoreName> <localKeyStoreName> [options]\n        options: [-profileName <profileName>] [-remoteAlias <aliasFromRemoteStore>] [-localAlias <storeAsAlias>] [-host <host>] [-port <port>] [-connType <RMI|SOAP>] [-user <user>] [-password <password>] [-trace] [-logfile <filename>] [-replacelog] [-quiet] [-help]\n");
            return null;
        }
        return AdminClientFactory.createAdminClient(this.props);
    }

    private String getProcessName(AdminClient adminClient) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessName");
        }
        ObjectName objectName = null;
        String string = null;
        try {
            objectName = adminClient.getServerMBean();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.utils.RetrieveSigners.getProcessName", "607", this);
        }
        if (objectName != null) {
            string = ObjectNameHelper.getProcessName(objectName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessName -> " + string);
        }
        return string;
    }

    private boolean setTrace() {
        String string = null;
        if (this.trace) {
            string = "com.ibm.ws.management.*=all=enabled:com.ibm.websphere.management.*=all=enabled:com.ibm.ws.ssl.*=all=enabled:SSL=all=enabled:com.ibm.ws.security.*=all=enabled:SASRas=all=enabled";
            Tr.info(tc, "ssl.signer.retrieval.tracemodeon.CWPKI0301I");
        } else {
            string = "";
        }
        if (this.logfile == null) {
            this.logfile = this.getDefaultTraceFile();
        }
        boolean bl = true;
        if (!ManagerAdmin.isLogFileWriteable(this.logfile)) {
            this.issueMessage("ssl.signer.retrieval.logfile.error.CWPKI0302E", new Object[]{new File(this.logfile).getAbsolutePath()}, "Cannot write to the trace logfile at the following location: " + new File(this.logfile).getAbsolutePath());
            bl = false;
        }
        if (bl) {
            this.issueMessage("ssl.signer.retrieval.logfile.location.CWPKI0303I", new Object[]{new File(this.logfile).getAbsolutePath()}, "Trace is being logged to the following location: " + new File(this.logfile).getAbsolutePath());
            ManagerAdmin.configureClientTrace(string, "named file", this.logfile, this.replacelog, "basic", false);
        }
        return true;
    }

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        string = string + File.separator + DEFAULT_TRACE_FILE;
        return string;
    }

    protected void issueMessage(String string, Object[] objectArray, String string2) {
        String string3 = TraceNLSHelper.getInstance().getFormattedMessage(string, objectArray, string2);
        if (!this.quiet) {
            this.printMessage(string3);
        }
    }

    protected void issueMessage(String string, String string2) {
        String string3 = TraceNLSHelper.getInstance().getString(string, string2);
        if (!this.quiet) {
            this.printMessage(string3);
        }
    }

    protected void printMessage(String string) {
        int n = 79;
        if (this.isDoubleByteSystem(string)) {
            n /= 2;
        }
        this.printMessage(string, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDoubleByteSystem(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(string);
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                dataOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.isDoubleByteSystem = (double)byArray.length > (double)string.length() + (double)string.length() * 0.1;
        return this.isDoubleByteSystem;
    }

    private void printMessage(String string, int n, boolean bl) {
        int n2 = n;
        if (bl) {
            System.out.print(INDENT);
            n2 -= INDENT.length();
        }
        if (string.length() <= n2) {
            System.out.println(string);
        } else {
            int n3 = string.lastIndexOf(32, n2);
            if (n3 == -1 && (n3 = string.indexOf(32)) == -1) {
                System.out.println(string);
                return;
            }
            this.printMessage(string.substring(0, n3), n, false);
            this.printMessage(string.substring(n3 + 1), n, true);
        }
    }

    private Properties loadPropertiesFile(final String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadPropertiesFile", new Object[]{string});
        }
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "loadPropertiesFile (null URL)");
            }
            return null;
        }
        try {
            Properties properties = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Properties properties = new Properties();
                    InputStream inputStream = null;
                    try {
                        URL uRL = new URL(string);
                        inputStream = uRL.openStream();
                        properties.load(inputStream);
                    }
                    catch (Exception exception) {
                        throw exception;
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    return properties;
                }
            });
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "loadPropertiesFile", new Object[]{properties});
            }
            return properties;
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.ssl.utils.RetrieveSigners.loadPropertiesFile", "801", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadPropertiesFile exception: ", new Object[]{privilegedActionException.getException()});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "loadPropertiesFile (null)");
            }
            return null;
        }
    }

    private String getConfigRootForProfileName(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigRootForProfileName", new Object[]{string});
        }
        String string2 = null;
        File file = WSProfile.getRegistryFile();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using profile registry: " + file);
        }
        List list = WSProfile.listProfileNames((File)file);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (string3 == null || !string3.equals(string)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found profile: " + string3);
            }
            File file2 = WSProfile.getProfileLocation((String)string3, (File)file);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "   Profile location: " + file2);
            }
            string2 = file2.getAbsolutePath();
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigRootForProfileName", new Object[]{string2});
        }
        return string2;
    }
}

