/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.ws.crypto.config.WSKeySet;
import com.ibm.ws.crypto.config.WSKeySetGroup;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.config.WSKeyStore;

public class KeySetGroupCommandActivator {
    private static final TraceComponent tc = Tr.register(KeySetGroupCommandActivator.class, "SSL", "com.ibm.ws.ssl.resources.ssl");

    public void invokeCreateKeyReferenceCommand(WSKeySetGroup wSKeySetGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeCreateKeyReferenceCommand", wSKeySetGroup);
        }
        try {
            if (wSKeySetGroup != null) {
                WSKeySet[] wSKeySetArray = wSKeySetGroup.getAllKeySets();
                for (int i = 0; i < wSKeySetArray.length; ++i) {
                    String string = wSKeySetArray[i].getName();
                    String string2 = wSKeySetArray[i].getManagementScopeName();
                    boolean bl = wSKeySetArray[i].getIsKeyPair();
                    WSKeyStore wSKeyStore = wSKeySetArray[i].getWSKeyStore();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating new KeyReference for KeySet: " + string);
                    }
                    CommandMgr commandMgr = CommandMgr.getCommandMgr();
                    Session session = new Session();
                    AdminCommand adminCommand = commandMgr.createCommand("generateKeyForKeySet");
                    adminCommand.setConfigSession(session);
                    adminCommand.setParameter(CommandConstants.KEY_SET_NAME, string);
                    adminCommand.setParameter(CommandConstants.KEY_SET_SCOPE, string2);
                    adminCommand.setParameter(CommandConstants.KEY_SET_SAVE_CONFIG, Boolean.TRUE);
                    adminCommand.execute();
                    CommandResult commandResult = adminCommand.getCommandResult();
                    if (commandResult.isSuccessful()) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "New keys generated for KeySet: " + string);
                        continue;
                    }
                    throw new KeyException(commandResult.getException().getMessage(), (Exception)commandResult.getException());
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.utils.KeySetGroupCommandActivator.invokeCreateKeyReferenceCommand", "96", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "invokeCreateKeyReferenceCommand did not execute.", new Object[]{exception});
            }
            Tr.error(tc, "crypto.key.auto.generate.error.CWPKI0204E", new Object[]{wSKeySetGroup.getName(), exception.getMessage()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeCreateKeyReferenceCommand");
        }
    }
}

